/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fpl.FpCommonException;
import com.kingdee.eas.fm.fpl.FpDataTypeEnum;
import com.kingdee.eas.fm.fpl.FpExtCell;
import com.kingdee.eas.fm.fpl.FpItemFormulaParser;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.util.client.EASResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class CheckItemFormulaDup {
    private static Logger logger = Logger.getLogger((String)CheckItemFormulaDup.class.getName());
    FpDataTypeEnum dataType = null;

    public String checkItemFormulaDup(IObjectValue info) throws FpCommonException {
        if (info == null) {
            return null;
        }
        Map map = this.getFormulaAndCellMap(info);
        return this.getMsg(map, true);
    }

    public String checkItemFormulaDup(IObjectValue info, IObjectCollection coll) throws FpCommonException, ParserException {
        if (coll == null || coll.size() <= 0) {
            return null;
        }
        Map map = this.getFormulaAndCellMap(info, coll);
        return this.getMsg(map, false);
    }

    private String getMsg(Map formulaAndCellMap, boolean isSingle) {
        StringBuffer msg = new StringBuffer();
        Object obj2 = null;
        List tempList = null;
        FpExtCell fpExtCell = null;
        ICell cell = null;
        String range = null;
        String msgPrefix = this.getMsgPrefix(isSingle);
        for (Object obj2 : formulaAndCellMap.values()) {
            if (obj2 == null || !(obj2 instanceof List) || (tempList = (List)obj2).size() <= 1) continue;
            msg.append(msgPrefix);
            int count = tempList.size();
            for (int j = 0; j < count; ++j) {
                fpExtCell = (FpExtCell)tempList.get(j);
                cell = fpExtCell.getCell();
                range = TableToolkit.xy2range((int)cell.getColumnIndex(), (int)cell.getRowIndex());
                msg.append(this.getMsgMiddle(isSingle, fpExtCell.getTemOrFormNumber(), range));
            }
            msg.deleteCharAt(msg.length() - 1);
            msg.append(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"10_CheckItemFormulaDup")).append(fpExtCell.getFormula()).append(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"11_CheckItemFormulaDup"));
        }
        if (msg != null && msg.toString().trim().length() > 0) {
            msg = new StringBuffer(FMHelper.getAdjustMsg((String)msg.toString()));
            msg.append(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"12_CheckItemFormulaDup"));
        }
        return msg.toString();
    }

    private String getMsgPrefix(boolean isSingle) {
        if (isSingle) {
            return EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"13_CheckItemFormulaDup");
        }
        return "";
    }

    private String getMsgMiddle(boolean isSingle, String number, String range) {
        if (isSingle) {
            return "(" + range + ")\u3001";
        }
        return this.getTitle() + "(" + number + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"14_CheckItemFormulaDup") + range + ")\u3001";
    }

    private Map getFormulaAndCellMap(IObjectValue info, IObjectCollection coll) throws FpCommonException, ParserException {
        Map otherFormulaMap = new LinkedHashMap();
        IObjectValue otherInfo = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            otherInfo = coll.getObject(i);
            otherFormulaMap = this.getFormulaAndCellMap(otherFormulaMap, otherInfo);
        }
        Map thisFormulaMap = this.getFormulaAndCellMap(null, info);
        String thisKey2 = null;
        FpItemFormulaParser parser = null;
        for (String thisKey2 : thisFormulaMap.keySet()) {
            if (!otherFormulaMap.containsKey(thisKey2)) continue;
            parser = new FpItemFormulaParser(thisKey2);
            parser.parse();
            if (!parser.isFull()) continue;
            ((List)thisFormulaMap.get(thisKey2)).addAll((List)otherFormulaMap.get(thisKey2));
        }
        return thisFormulaMap;
    }

    private Map getFormulaAndCellMap(IObjectValue info) throws FpCommonException {
        return this.getFormulaAndCellMap(null, info);
    }

    private Map getFormulaAndCellMap(Map formulaMap, IObjectValue info) throws FpCommonException {
        if (formulaMap == null) {
            formulaMap = new LinkedHashMap();
        }
        if (info == null) {
            return formulaMap;
        }
        String temOrFormNumber = null;
        BgPeriodEnum period = null;
        KDTable table = null;
        KDF kdf = null;
        try {
            kdf = this.getKDF(info);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        catch (KDFException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        if (kdf == null) {
            return formulaMap;
        }
        Collection tableColl = kdf.getAllTable();
        if (tableColl != null && tableColl.size() > 0) {
            int count = tableColl.size();
            for (int j = 0; j < count; ++j) {
                table = (KDTable)kdf.getTableByIndex(j);
                if (table == null) continue;
                temOrFormNumber = this.getTemOrFormNumber(info);
                period = this.getPeriodEnum(info);
                this.getFormulaAndCellMap(formulaMap, table, period, temOrFormNumber);
            }
        }
        return formulaMap;
    }

    private Map getFormulaAndCellMap(Map formulaMap, KDTable table, BgPeriodEnum period, String temOrFormNumber) {
        int rowCount = table.getBody().size();
        int colCount = table.getColumnCount();
        ICell cell = null;
        String itemFormula = null;
        RptCell rptCell = null;
        if (formulaMap == null) {
            formulaMap = new LinkedHashMap<String, List<FpExtCell>>();
        }
        FpExtCell fpExtCell = null;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                List<FpExtCell> cellList;
                cell = table.getCell(i, j);
                if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell) || (itemFormula = (rptCell = (RptCell)cell.getUserObject()).getItemFormulaLine()) == null) continue;
                itemFormula = this.replaceItemFormula(itemFormula, this.dataType);
                fpExtCell = new FpExtCell();
                fpExtCell.setTemOrFormNumber(temOrFormNumber);
                fpExtCell.setCell(cell);
                fpExtCell.setFormula(itemFormula);
                fpExtCell.setPeriod(period);
                if (formulaMap.containsKey(itemFormula)) {
                    cellList = (List)formulaMap.get(itemFormula);
                    if (cellList.contains(fpExtCell)) continue;
                    cellList.add(fpExtCell);
                    continue;
                }
                cellList = new ArrayList();
                cellList.add(fpExtCell);
                formulaMap.put(itemFormula, cellList);
            }
        }
        return formulaMap;
    }

    protected abstract String getTitle();

    protected abstract byte[] getData(IObjectValue var1);

    protected abstract KDF getKDF(IObjectValue var1) throws IOException, KDFException;

    protected abstract String getTemOrFormNumber(IObjectValue var1);

    protected abstract BgPeriodEnum getPeriodEnum(IObjectValue var1);

    protected abstract String replaceItemFormula(String var1, FpDataTypeEnum var2);
}

