/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fm.fpl.FPCtrlBillTypeEnum;
import com.kingdee.eas.fm.fpl.FPItemDirectionEnum;
import com.kingdee.eas.fm.fpl.FpCtrlLevelCollection;
import com.kingdee.eas.fm.fpl.FpCtrlLevelInfo;
import com.kingdee.eas.fm.fpl.FpCtrlObjectCollection;
import com.kingdee.eas.fm.fpl.FpCtrlObjectInfo;
import com.kingdee.eas.fm.fpl.FpCtrlPeriodCollection;
import com.kingdee.eas.fm.fpl.FpCtrlPeriodInfo;
import com.kingdee.eas.fm.fpl.FpCtrlStrategyInfo;
import com.kingdee.eas.fm.fpl.FpItemCollection;
import com.kingdee.eas.fm.fpl.FpItemFactory;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fpl.FpItemShowTypeEnum;
import com.kingdee.eas.fm.fpl.IFpItem;
import com.kingdee.eas.fm.fpl.PeriodCtrlTypeEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;

public class FpCtrlClientHelper {
    private static final Logger logger = CoreUIObject.getLogger(FpCtrlClientHelper.class);
    private static final String COL_FP_ITEM = "fpItem";
    private static final String COL_FP_ITEM_NUMBER = "fpItemNumber";
    private FpItemCollection itemColl = null;

    public FpCtrlObjectCollection fillObjectColl() {
        FpCtrlObjectCollection coll = new FpCtrlObjectCollection();
        FpCtrlObjectInfo info = null;
        FPCtrlBillTypeEnum ctrlBillTypeEnum = null;
        List list = FPCtrlBillTypeEnum.getEnumList();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            info = new FpCtrlObjectInfo();
            ctrlBillTypeEnum = (FPCtrlBillTypeEnum)((Object)list.get(i));
            info.setCtrlBillType(ctrlBillTypeEnum);
            info.setCtrlSystem(this.getSystemEnum(ctrlBillTypeEnum.getValue()));
            info.setIsEnabled(false);
            coll.add(info);
        }
        return coll;
    }

    private SystemEnum getSystemEnum(int billType) {
        switch (billType) {
            case 1: {
                return SystemEnum.GENERALLEDGER;
            }
            case 5: 
            case 6: {
                return SystemEnum.CASHMANAGEMENT;
            }
            case 2: 
            case 3: 
            case 4: {
                return SystemEnum.FINANCESETTLE;
            }
        }
        return SystemEnum.GENERALLEDGER;
    }

    public FpCtrlLevelCollection fillLevelColl() {
        FpItemCollection itemColl = this.getFpItemColl();
        return this.fillLevelColl(itemColl);
    }

    public FpCtrlLevelCollection fillLevelColl(FpItemCollection itemColl) {
        FpCtrlLevelCollection coll = new FpCtrlLevelCollection();
        FpCtrlLevelInfo info = null;
        int size = itemColl.size();
        for (int i = 0; i < size; ++i) {
            info = new FpCtrlLevelInfo();
            info.setFpItem(itemColl.get(i));
            if (itemColl.get(i).getDirection().equals((Object)FPItemDirectionEnum.OUTWARD_MOVEMENT)) {
                info.setIsNeedCtrl(true);
                info.setCtrlLevel(true);
            } else {
                info.setIsNeedCtrl(false);
                info.setCtrlLevel(false);
            }
            coll.add(info);
        }
        return coll;
    }

    public FpCtrlPeriodCollection fillPeriodColl() {
        FpItemCollection itemColl = this.getFpItemColl();
        return this.fillPeriodColl(itemColl);
    }

    public FpCtrlPeriodCollection fillPeriodColl(FpItemCollection itemColl) {
        FpCtrlPeriodCollection coll = new FpCtrlPeriodCollection();
        FpCtrlPeriodInfo info = null;
        int size = itemColl.size();
        for (int i = 0; i < size; ++i) {
            info = new FpCtrlPeriodInfo();
            info.setFpItem(itemColl.get(i));
            info.setCtrlPeriod(BgPeriodEnum.MONTH);
            info.setPeriodCtrl(PeriodCtrlTypeEnum.CURRENT_PERIOD);
            coll.add(info);
        }
        return coll;
    }

    public FpItemCollection getNewFpItemColl(FpCtrlLevelCollection levelColl) {
        FpItemCollection itemColl = this.getFpItemColl();
        FpItemInfo itemInfo = null;
        boolean isInclude = false;
        for (int i = itemColl.size() - 1; i >= 0; --i) {
            itemInfo = itemColl.get(i);
            isInclude = false;
            int size2 = levelColl.size();
            for (int j = 0; j < size2; ++j) {
                if (!itemInfo.getId().equals((Object)levelColl.get(j).getFpItem().getId())) continue;
                isInclude = true;
                break;
            }
            if (!isInclude) continue;
            itemColl.removeObject(i);
        }
        return itemColl;
    }

    public FpItemCollection getFpItemColl() {
        if (this.itemColl != null && !this.itemColl.isEmpty()) {
            return this.itemColl;
        }
        EntityViewInfo evi = new EntityViewInfo();
        SorterItemCollection sorters = evi.getSorter();
        sorters.add(new SorterItemInfo("group"));
        sorters.add(new SorterItemInfo("longnumber"));
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longnumber"));
        sic.add(new SelectorItemInfo("group.*"));
        try {
            IFpItem iFpItem = FpItemFactory.getRemoteInstance();
            this.itemColl = iFpItem.getFpItemCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        int size = this.itemColl.size();
        for (int i = 0; i < size; ++i) {
            this.itemColl.get(i).setShowType(FpItemShowTypeEnum.NUMBERANDNAME);
        }
        return this.itemColl;
    }

    public void sortFpCtrlRelatePropColl(FpCtrlStrategyInfo info) {
    }

    public void sortFpCtrlLevelColl(FpCtrlLevelCollection levelColl) {
        Object[] collAry = levelColl.toArray();
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                FpCtrlLevelInfo obj1 = (FpCtrlLevelInfo)o1;
                FpCtrlLevelInfo obj2 = (FpCtrlLevelInfo)o2;
                if (obj1.getFpItem().getGroup().getNumber().compareTo(obj2.getFpItem().getGroup().getNumber()) != 0) {
                    return obj1.getFpItem().getGroup().getNumber().compareTo(obj2.getFpItem().getGroup().getNumber());
                }
                return obj1.getFpItem().getLongNumber().compareTo(obj2.getFpItem().getLongNumber());
            }
        };
        Arrays.sort(collAry, c);
        levelColl.clear();
        FpCtrlLevelInfo info = null;
        for (int i = 0; i < collAry.length; ++i) {
            info = (FpCtrlLevelInfo)collAry[i];
            info.getFpItem().setShowType(FpItemShowTypeEnum.NUMBERANDNAME);
            levelColl.add(info);
        }
    }

    public void sortFpCtrlPeriodColl(FpCtrlPeriodCollection periodColl) {
        Object[] collAry = periodColl.toArray();
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                FpCtrlPeriodInfo obj1 = (FpCtrlPeriodInfo)o1;
                FpCtrlPeriodInfo obj2 = (FpCtrlPeriodInfo)o2;
                if (obj1.getFpItem().getGroup().getNumber().compareTo(obj2.getFpItem().getGroup().getNumber()) != 0) {
                    return obj1.getFpItem().getGroup().getNumber().compareTo(obj2.getFpItem().getGroup().getNumber());
                }
                return obj1.getFpItem().getLongNumber().compareTo(obj2.getFpItem().getLongNumber());
            }
        };
        Arrays.sort(collAry, c);
        periodColl.clear();
        FpCtrlPeriodInfo info = null;
        for (int i = 0; i < collAry.length; ++i) {
            info = (FpCtrlPeriodInfo)collAry[i];
            info.getFpItem().setShowType(FpItemShowTypeEnum.NUMBERANDNAME);
            periodColl.add(info);
        }
    }

    public void handleIndent(KDTable kdTable) {
        int rowCount = kdTable.getRowCount();
        ICell cell = null;
        int indent = 1;
        block0: for (int i = 0; i < rowCount - 1; ++i) {
            String number = (String)kdTable.getRow(i).getCell(COL_FP_ITEM_NUMBER).getValue();
            for (int j = i + 1; j < rowCount; ++j) {
                cell = kdTable.getRow(j).getCell(COL_FP_ITEM);
                String tempNumber = (String)kdTable.getRow(j).getCell(COL_FP_ITEM_NUMBER).getValue();
                String value = cell.getValue().toString();
                if (!tempNumber.startsWith(number + ".")) continue block0;
                cell.setValue((Object)(this.getBlank(indent) + value));
            }
        }
    }

    public String getBlank(int len) {
        String blank = "";
        for (int i = 0; i < len; ++i) {
            blank = blank + " ";
        }
        return blank;
    }
}

