/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fpl.FPCtrlBillTypeEnum;
import com.kingdee.eas.fm.fpl.FPCtrlParamCollection;
import com.kingdee.eas.fm.fpl.FPCtrlParamInfo;
import com.kingdee.eas.fm.fpl.FPItemFormulaFormat;
import com.kingdee.eas.fm.fpl.FpCommonException;
import com.kingdee.eas.fm.fpl.FpCtrlLevelCollection;
import com.kingdee.eas.fm.fpl.FpCtrlLevelInfo;
import com.kingdee.eas.fm.fpl.FpCtrlPeriodCollection;
import com.kingdee.eas.fm.fpl.FpCtrlPeriodInfo;
import com.kingdee.eas.fm.fpl.FpCtrlStrategyCollection;
import com.kingdee.eas.fm.fpl.FpCtrlStrategyFactory;
import com.kingdee.eas.fm.fpl.FpCtrlStrategyInfo;
import com.kingdee.eas.fm.fpl.FpDataInfo;
import com.kingdee.eas.fm.fpl.FpItemCollection;
import com.kingdee.eas.fm.fpl.FpItemFactory;
import com.kingdee.eas.fm.fpl.FpItemFormulaInfo;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fpl.IFpCtrlStrategy;
import com.kingdee.eas.fm.fpl.IFpItem;
import com.kingdee.eas.fm.fpl.PeriodCtrlTypeEnum;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FpCtrlHelper {
    private static Logger logger = Logger.getLogger((String)FpCtrlHelper.class.getName());
    private Map itemMap = null;

    public static boolean hasExecutingStrategy(Context ctx, String companyId, FPCtrlBillTypeEnum billType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT a.FID FROM T_FPL_FpCtrlStrategy a \n").append(" \tLEFT JOIN T_FPL_FpCtrlObject b ON a.FID = b.FParentId \n").append(" WHERE a.FOrgId = '").append(companyId).append("'").append("\tAND a.FIsEnable = 1 \n").append("\tAND b.FCtrlBillType = ").append(billType.getValue()).append("\tAND b.FIsEnabled = 1 \n");
        logger.info((Object)("FpCtrlHelper hasExecutingStrategy sql = " + sql.toString()));
        ISQLExecutor sqlExe = null;
        sqlExe = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sql.toString()) : SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
        IRowSet rs = sqlExe.executeSQL();
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return false;
    }

    public static FpCtrlStrategyInfo getFpCtrlStrategyInfo(Context ctx, String ouId, FPCtrlBillTypeEnum billType) throws BOSException {
        if (FMHelper.isEmpty((String)ouId) || FMHelper.isEmpty((Object)((Object)billType))) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgId", (Object)ouId));
        filter.getFilterItems().add(new FilterItemInfo("enabled", (Object)Boolean.TRUE));
        if (billType != null) {
            String sql = " SELECT FParentId FROM T_FPL_FPCtrlObject WHERE FCtrlBillType = " + billType.getValue() + " AND FIsEnabled = 1 ";
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("ctrlObjects.*"));
        sic.add(new SelectorItemInfo("ctrlLevels.*"));
        sic.add(new SelectorItemInfo("ctrlPeriods.*"));
        IFpCtrlStrategy strategy = null;
        strategy = ctx == null ? FpCtrlStrategyFactory.getRemoteInstance() : FpCtrlStrategyFactory.getLocalInstance(ctx);
        FpCtrlStrategyCollection coll = strategy.getFpCtrlStrategyCollection(evi);
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        return coll.get(0);
    }

    public static FpCtrlStrategyInfo getFpCtrlStrategyInfo(Context ctx, String ouId) throws BOSException {
        return FpCtrlHelper.getFpCtrlStrategyInfo(ctx, ouId, null);
    }

    public static FpCtrlLevelInfo getCtrlLevelInfo(Context ctx, FpCtrlStrategyInfo strategyInfo, FpItemInfo itemInfo) {
        if (strategyInfo == null || strategyInfo.getCtrlLevels() == null || strategyInfo.getCtrlLevels().isEmpty()) {
            return null;
        }
        FpCtrlLevelCollection coll = strategyInfo.getCtrlLevels();
        FpCtrlLevelInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!info.getFpItem().getId().equals((Object)itemInfo.getId())) continue;
            return info;
        }
        return null;
    }

    public static FpCtrlPeriodInfo getCtrlPeriodInfo(Context ctx, FpCtrlStrategyInfo strategyInfo, FpItemInfo itemInfo) {
        if (strategyInfo == null || strategyInfo.getCtrlLevels() == null || strategyInfo.getCtrlLevels().isEmpty()) {
            return null;
        }
        FpCtrlPeriodCollection coll = strategyInfo.getCtrlPeriods();
        FpCtrlPeriodInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!info.getFpItem().getId().equals((Object)itemInfo.getId())) continue;
            return info;
        }
        return null;
    }

    public static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("ctrlObjects.*"));
        sic.add(new SelectorItemInfo("ctrlPeriods.*"));
        sic.add(new SelectorItemInfo("ctrlPeriods.id"));
        sic.add(new SelectorItemInfo("ctrlPeriods.ctrlPeriod"));
        sic.add(new SelectorItemInfo("ctrlPeriods.periodCtrl"));
        sic.add(new SelectorItemInfo("ctrlPeriods.fpItem.*"));
        sic.add(new SelectorItemInfo("ctrlPeriods.fpItem.id"));
        sic.add(new SelectorItemInfo("ctrlPeriods.fpItem.number"));
        sic.add(new SelectorItemInfo("ctrlPeriods.fpItem.group.number"));
        sic.add(new SelectorItemInfo("ctrlLevels.*"));
        sic.add(new SelectorItemInfo("ctrlLevels.id"));
        sic.add(new SelectorItemInfo("ctrlLevels.isNeedCtrl"));
        sic.add(new SelectorItemInfo("ctrlLevels.ctrlLevel"));
        sic.add(new SelectorItemInfo("ctrlLevels.fpItem.*"));
        sic.add(new SelectorItemInfo("ctrlLevels.fpItem.id"));
        sic.add(new SelectorItemInfo("ctrlLevels.fpItem.number"));
        sic.add(new SelectorItemInfo("ctrlLevels.fpItem.group.number"));
        return sic;
    }

    public FpCtrlPeriodInfo findSuperFpItemIsNeedCtrl(Context ctx, String ouId, String itemNumber) throws BOSException {
        if (FMHelper.isEmpty((String)ouId) || FMHelper.isEmpty((String)itemNumber)) {
            throw new BOSException("findSuperFpItemIsNeedCtrl param is null");
        }
        FpCtrlStrategyInfo strategyInfo = FpCtrlHelper.getFpCtrlStrategyInfo(ctx, ouId);
        if (strategyInfo == null) {
            return null;
        }
        FpItemInfo itemInfo1 = (FpItemInfo)this.getFpItemMap(ctx).get(itemNumber);
        FpItemCollection itemColl = this.getSuperFpItemColl(ctx, itemInfo1.getLongNumber());
        FpCtrlLevelCollection levelColl = strategyInfo.getCtrlLevels();
        FpCtrlLevelInfo levelInfo = null;
        FpItemInfo itemInfo = null;
        boolean isMatch = false;
        int size = levelColl.size();
        for (int i = 0; i < size; ++i) {
            levelInfo = levelColl.get(i);
            for (int j = itemColl.size() - 1; j >= 0; --j) {
                itemInfo = itemColl.get(j);
                if (!levelInfo.getFpItem().getId().equals((Object)itemInfo.getId()) || !levelInfo.isIsNeedCtrl() || !levelInfo.isCtrlLevel()) continue;
                isMatch = true;
                break;
            }
            if (isMatch) break;
        }
        if (!isMatch) {
            return null;
        }
        FpCtrlPeriodCollection periodColl = strategyInfo.getCtrlPeriods();
        FpCtrlPeriodInfo periodInfo = null;
        int size2 = periodColl.size();
        for (int i = 0; i < size2; ++i) {
            periodInfo = periodColl.get(i);
            if (!periodInfo.getFpItem().getId().equals((Object)itemInfo.getId())) continue;
            return periodInfo;
        }
        return null;
    }

    public FpItemInfo findValidSuperFpItem(Context ctx, FpCtrlStrategyInfo strategyInfo, String itemNumber) throws BOSException {
        if (FMHelper.isEmpty((String)itemNumber)) {
            throw new BOSException("findSuperFpItemIsNeedCtrl param is null");
        }
        FpItemInfo itemInfo1 = (FpItemInfo)this.getFpItemMap(ctx).get(itemNumber);
        FpItemCollection itemColl = this.getSuperFpItemColl(ctx, itemInfo1.getLongNumber());
        FpCtrlLevelCollection levelColl = strategyInfo.getCtrlLevels();
        FpCtrlLevelInfo levelInfo = null;
        FpItemInfo superItemInfo = null;
        int size = levelColl.size();
        for (int i = 0; i < size; ++i) {
            levelInfo = levelColl.get(i);
            for (int j = itemColl.size() - 1; j >= 0; --j) {
                superItemInfo = itemColl.get(j);
                if (!levelInfo.getFpItem().getId().equals((Object)superItemInfo.getId()) || !levelInfo.isIsNeedCtrl() || !levelInfo.isCtrlLevel()) continue;
                return superItemInfo;
            }
        }
        return null;
    }

    private FpItemCollection getSuperFpItemColl(Context ctx, String longNumber) throws BOSException {
        String[] strs = longNumber.split("!");
        Map map = this.getFpItemMap(ctx);
        FpItemCollection coll = new FpItemCollection();
        FpItemInfo superInfo = null;
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            superInfo = (FpItemInfo)map.get(strs[i]);
            coll.add(superInfo);
        }
        return coll;
    }

    private Map getFpItemMap(Context ctx) throws BOSException {
        if (this.itemMap != null && !this.itemMap.isEmpty()) {
            return this.itemMap;
        }
        this.itemMap = new HashMap();
        IFpItem iFpItem = null;
        iFpItem = ctx == null ? FpItemFactory.getRemoteInstance() : FpItemFactory.getLocalInstance((Context)ctx);
        FpItemCollection coll = iFpItem.getFpItemCollection();
        FpItemInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            this.itemMap.put(info.getNumber(), info);
        }
        return this.itemMap;
    }

    public static String getItemFormula(String item, String assistItem, String period, String currency) {
        FpItemFormulaInfo info = new FpItemFormulaInfo();
        info.setItemNum(item);
        info.setAsstItemCombine(assistItem);
        info.setPeriodNum(period);
        info.setCurrencyNum(currency);
        info.setDataType(null);
        FPItemFormulaFormat fmt = FPItemFormulaFormat.getInstance();
        return fmt.format(info);
    }

    public static FpItemFormulaInfo getItemFormulaObject(String itemFormula) throws BOSException {
        FPItemFormulaFormat fmt = FPItemFormulaFormat.getInstance();
        try {
            return (FpItemFormulaInfo)fmt.parseObject(itemFormula);
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public BigDecimal getBalance(Context ctx, FPCtrlParamInfo paramInfo) throws EASBizException, BOSException {
        if (paramInfo == null) {
            return null;
        }
        String ouId = paramInfo.getOrgUnitId();
        String itemId = paramInfo.getCtrlItemId();
        String periodId = paramInfo.getPeriodId();
        String currencyId = paramInfo.getCurrencyId();
        PeriodCtrlTypeEnum ctrlType = paramInfo.getPeriodCtrl();
        if (ctrlType.equals((Object)PeriodCtrlTypeEnum.CURRENT_PERIOD)) {
            BgPeriodInfo periodInfo = new BgPeriodInfo();
            periodInfo.setId(BOSUuid.read((String)periodId));
            BgPeriodCollection periodColl = new BgPeriodCollection();
            periodColl.add(periodInfo);
            return this.getSumBalance(ctx, ouId, itemId, currencyId, periodColl);
        }
        if (ctrlType.equals((Object)PeriodCtrlTypeEnum.ACCUMULATIVE)) {
            BgPeriodCollection periodColl = this.getAccumulativePeriodColl(ctx, periodId);
            return this.getSumBalance(ctx, ouId, itemId, currencyId, periodColl);
        }
        if (ctrlType.equals((Object)PeriodCtrlTypeEnum.CURRENT_YEAR)) {
            BgPeriodCollection periodColl = this.getCurrYearPeriodColl(ctx, paramInfo.getPeriodId());
            return this.getSumBalance(ctx, ouId, itemId, currencyId, periodColl);
        }
        return null;
    }

    private BigDecimal getSumBalance(Context ctx, String ouId, String itemId, String currencyId, BgPeriodCollection periodColl) throws BOSException {
        String periodIds = FpCtrlHelper.coll2String(periodColl);
        String state = "executing";
        StringBuffer sql0 = new StringBuffer();
        sql0.append(" SELECT count(a.FFpValue) cnt FROM T_FPL_FpData a \n").append(" \tJOIN T_FPL_FpForm b ON a.FFpFormId = b.FID \n").append(" WHERE b.FOrgUnitId = ? AND b.FState = ? AND a.FFpItemId = ? AND a.FCurrencyId = ? \n").append("\tAND (a.FFpAssistItemCombId IS NULL or  a.FFpAssistItemCombId='')\n").append("\tAND a.FFpPeriodId IN ").append(periodIds);
        logger.info((Object)("getSumBalance sql = " + sql0.toString() + "\n orgUnitId = " + ouId + "\n state = " + state + "\n itemId = " + itemId + "\n currencyId = " + currencyId));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql0.toString(), (Object[])new Object[]{ouId, state, itemId, currencyId});
        try {
            int count;
            if (rs.next() && (count = rs.getInt(1)) <= 0) {
                return null;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT sum(a.FFpValue) FpValue, sum(a.FBizActual) BizActual FROM T_FPL_FpData a \n").append(" \tJOIN T_FPL_FpForm b ON a.FFpFormId = b.FID \n").append(" WHERE b.FOrgUnitId = ? AND b.FState = ? AND a.FFpItemId = ? AND a.FCurrencyId = ? \n").append("\tAND (a.FFpAssistItemCombId IS NULL or  a.FFpAssistItemCombId='')\n").append("\tAND a.FFpPeriodId IN ").append(periodIds);
        logger.info((Object)("getSumBalance sql = " + sql.toString() + "\n orgUnitId = " + ouId + "\n state = " + state + "\n itemId = " + itemId + "\n currencyId = " + currencyId));
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{ouId, state, itemId, currencyId});
        try {
            if (rs.next()) {
                if (rs.getBigDecimal(1) != null && rs.getBigDecimal(2) != null) {
                    return rs.getBigDecimal(1).add(rs.getBigDecimal(2).negate());
                }
                return Constants.ZERO;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private BgPeriodCollection getAccumulativePeriodColl(Context ctx, String periodId) throws BOSException, EASBizException {
        IBgPeriod iBgPeriod = BgPeriodFactory.getLocalInstance((Context)ctx);
        BgPeriodInfo info = iBgPeriod.getBgPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(info.getPeriodType().getValue())));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(info.getYear())));
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)info.getLongNumber(), CompareType.LESS_EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return iBgPeriod.getBgPeriodCollection(evi);
    }

    private BgPeriodCollection getCurrYearPeriodColl(Context ctx, String periodId) throws BOSException, EASBizException {
        IBgPeriod iBgPeriod = BgPeriodFactory.getLocalInstance((Context)ctx);
        BgPeriodInfo info = iBgPeriod.getBgPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(info.getPeriodType().getValue())));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(info.getYear())));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return iBgPeriod.getBgPeriodCollection(evi);
    }

    public static String coll2String(BgPeriodCollection coll) {
        if (coll == null || coll.size() < 1) {
            return null;
        }
        String ids = null;
        int size = coll.size();
        for (int i = 0; i < size && i < 999; ++i) {
            ids = ids == null ? "('" + coll.get(i).getId().toString() + "'" : ids + ", '" + coll.get(i).getId().toString() + "'";
        }
        ids = ids + ")";
        return ids;
    }

    public Map getFpDataInfoMap(Context ctx, FPCtrlParamCollection paramColl) throws BOSException, EASBizException {
        HashMap<String, FpDataInfo> map = new HashMap<String, FpDataInfo>();
        if (paramColl == null || paramColl.size() <= 0) {
            return map;
        }
        FPCtrlParamInfo info = paramColl.get(0);
        String ouId = info.getOrgUnitId();
        String formulas = this.getFormulas(paramColl);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT a.FFormula, a.FID, a.FFpValue, a.FBizActual, a.FFpBalance FROM T_FPL_FpData a \n").append(" \tJOIN T_FPL_FpForm b ON a.FFpFormId = b.FID \n").append("\tWHERE a.FFormula IN " + formulas + " AND b.FOrgUnitId = ? AND b.FState = ? ");
        String state = "executing";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{ouId, state});
        try {
            FpDataInfo dataInfo = null;
            while (rs.next()) {
                dataInfo = new FpDataInfo();
                dataInfo.setId(rs.getString("FID"));
                dataInfo.setFpFormula(rs.getString("FFormula"));
                dataInfo.setFpValue(rs.getBigDecimal("FFpValue"));
                dataInfo.setBizActual(rs.getBigDecimal("FBizActual"));
                map.put(dataInfo.getFpFormula(), dataInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("FpCtrlFacadeControllerBean getFpData error:" + e));
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private String getFormulas(FPCtrlParamCollection paramColl) {
        String formulas = "";
        FPCtrlParamInfo info = null;
        int size = paramColl.size();
        for (int i = 0; i < size; ++i) {
            info = paramColl.get(i);
            formulas = FMHelper.isEmpty((String)formulas) ? "('" + info.getItemFormula() + "'" : formulas + ", '" + info.getItemFormula() + "'";
        }
        if (!FMHelper.isEmpty((String)formulas)) {
            formulas = formulas + ")";
        }
        return formulas;
    }

    public static BgPeriodInfo getPeriod(Context ctx, BgPeriodEnum periodType, java.util.Date bookedDate) throws BOSException, EASBizException {
        bookedDate = DateTimeUtils.truncateDate((java.util.Date)bookedDate);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(periodType.getValue())));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)bookedDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)bookedDate, CompareType.GREATER_EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IBgPeriod iBgPeriod = FpCtrlHelper.getBgPeriodCtrl(ctx);
        BgPeriodCollection periodColl = iBgPeriod.getBgPeriodCollection(evi);
        if (periodColl == null || periodColl.size() <= 0) {
            throw new FpCommonException(FpCommonException.DATENOPERIOD, new Object[]{new Date(bookedDate.getTime())});
        }
        return periodColl.get(0);
    }

    private static IBgPeriod getBgPeriodCtrl(Context ctx) throws BOSException {
        if (ctx == null) {
            return BgPeriodFactory.getRemoteInstance();
        }
        return BgPeriodFactory.getLocalInstance((Context)ctx);
    }

    public static CurrencyInfo getCurrency(Context ctx, CurrencyInfo currency) throws BOSException {
        if (currency == null) {
            return null;
        }
        if (currency.getId() != null && !FMHelper.isEmpty((String)currency.getNumber())) {
            return currency;
        }
        return currency;
    }
}

