/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.eas.fm.fpl.FpFormulaValidator;
import com.kingdee.eas.fm.fpl.FpHelper;
import com.kingdee.eas.fm.fpl.FpItemFormulaHelper;
import com.kingdee.eas.fm.fpl.FpItemFormulaParser;
import com.kingdee.eas.fm.fpl.FpValueTypeEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.util.client.EASResource;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class FpDataFormulaValidator
extends FpFormulaValidator {
    private static Logger logger = Logger.getLogger((String)FpDataFormulaValidator.class.getName());
    Map periodInfoMap;

    public static FpDataFormulaValidator getInstance(Context ctx) {
        return new FpDataFormulaValidator(ctx);
    }

    public FpDataFormulaValidator() {
    }

    private FpDataFormulaValidator(Context ctx) {
        super(ctx);
        try {
            this.periodInfoMap = FpItemFormulaHelper.getPeriodInfoMap(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
    }

    public boolean validateFormula(String formula) {
        if (this.isEmpty(formula)) {
            this.results.addValidateResult(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"25_FpDataFormulaValidator"));
            return false;
        }
        String msg = "=FpAcct(\"" + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"57_FpDataFormulaValidator") + ", \"" + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"58_FpDataFormulaValidator") + ", \"" + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"59_FpDataFormulaValidator") + ", \"" + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"60_FpDataFormulaValidator") + ", \"" + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"61_FpDataFormulaValidator") + ", \"" + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"62_FpDataFormulaValidator") + ", \"" + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"63_FpDataFormulaValidator") + ")";
        if (!formula.startsWith("=FpItem(") || !formula.endsWith(")")) {
            this.results.addValidateResult(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"26_FpDataFormulaValidator") + formula + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"27_FpDataFormulaValidator") + msg);
            return false;
        }
        FpItemFormulaParser parser = new FpItemFormulaParser(formula);
        try {
            parser.parse();
        }
        catch (ParserException e) {
            logger.error((Object)e);
            this.results.addValidateResult(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"26_FpDataFormulaValidator") + formula + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"27_FpDataFormulaValidator") + msg);
            return false;
        }
        String[] params = parser.getParams();
        if (params == null || params.length != 7) {
            this.results.addValidateResult(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"26_FpDataFormulaValidator") + formula + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"27_FpDataFormulaValidator") + msg);
            return false;
        }
        boolean item = this.validateItem(params[0]);
        boolean asstItemComb = this.validateAsstItemComb(params[1]);
        boolean bPeriod = this.validatePeriod(params[2]);
        boolean ePeriod = this.validatePeriod(params[3]);
        boolean dataType = this.validateDataType(params[3]);
        boolean currency = this.validateCurrency(params[4]);
        return item && asstItemComb && bPeriod && ePeriod && dataType && currency;
    }

    public boolean validateOrgUnit(String orgUnit) {
        return true;
    }

    public boolean validatePeriods(String bPeriod, String ePeriod) {
        boolean isSameType;
        if (!this.validatePeriod(bPeriod) || !this.validatePeriod(ePeriod)) {
            return false;
        }
        if (this.isEmpty(bPeriod) && this.isEmpty(ePeriod)) {
            return true;
        }
        if (this.periodInfoMap == null) {
            try {
                this.periodInfoMap = FpItemFormulaHelper.getPeriodInfoMap(this.ctx);
            }
            catch (BOSException e) {
                e.printStackTrace();
                logger.error((Object)e);
            }
        }
        BgPeriodInfo bPeriodInfo = (BgPeriodInfo)this.periodInfoMap.get(bPeriod);
        BgPeriodInfo ePeriodInfo = (BgPeriodInfo)this.periodInfoMap.get(ePeriod);
        BgPeriodInfo tempInfo = null;
        if ((ePeriodInfo == null || bPeriodInfo == null) && this.periodInfoMap != null) {
            Iterator it = this.periodInfoMap.keySet().iterator();
            while (it.hasNext()) {
                tempInfo = (BgPeriodInfo)this.periodInfoMap.get(it.next());
                if (bPeriodInfo == null && tempInfo.getName().equals(bPeriod)) {
                    bPeriodInfo = tempInfo;
                }
                if (ePeriodInfo != null || !tempInfo.getName().equals(ePeriod)) continue;
                ePeriodInfo = tempInfo;
            }
        }
        if (!(isSameType = FpHelper.isSamePeriodType(bPeriodInfo, ePeriodInfo))) {
            this.results.addValidateResult(bPeriod + "," + ePeriod + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"28_FpDataFormulaValidator"));
            return false;
        }
        boolean isBeginLargerEnd = FpHelper.isBeginLargerEnd(bPeriodInfo, ePeriodInfo);
        if (isBeginLargerEnd) {
            this.results.addValidateResult(bPeriod + "," + ePeriod + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"29_FpDataFormulaValidator"));
            return false;
        }
        return true;
    }

    public boolean validateValueType(String valueType) {
        if (this.isEmpty(valueType)) {
            this.results.addValidateResult(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"30_FpDataFormulaValidator"));
            return false;
        }
        if (!valueType.equals("C") && !valueType.equals(FpValueTypeEnum.C.toString())) {
            this.results.addValidateResult(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"31_FpDataFormulaValidator") + valueType + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"32_FpDataFormulaValidator"));
            return false;
        }
        return true;
    }
}

