/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fpl.FPItemFormulaFormat;
import com.kingdee.eas.fm.fpl.FpDataInfo;
import com.kingdee.eas.fm.fpl.FpDataTypeEnum;
import com.kingdee.eas.fm.fpl.FpFormException;
import com.kingdee.eas.fm.fpl.FpFormHelper;
import com.kingdee.eas.fm.fpl.FpHelper;
import com.kingdee.eas.fm.fpl.FpItemFormulaHelper;
import com.kingdee.eas.fm.fpl.FpItemFormulaInfo;
import com.kingdee.eas.fm.fpl.FpItemFormulaParser;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FpDataGenerator {
    private static Logger logger = Logger.getLogger((String)FpDataGenerator.class.getName());
    Map formulaAndValueMap;
    Map fpDataMap = new HashMap();
    Context ctx = null;
    String formId = null;
    Map itemMap = null;
    Map asstItemCombMap = null;
    Map periodMap = null;
    Map currencyMap = null;
    private FpDataTypeEnum dataType = null;

    public FpDataGenerator(Context ctx, Map map, String formId, FpDataTypeEnum dataType) {
        this.ctx = ctx;
        this.formulaAndValueMap = map;
        this.formId = formId;
        this.dataType = dataType;
    }

    public void parse() throws FpFormException, BOSException {
        String formula2 = null;
        String commonFormula = null;
        BigDecimal value = null;
        for (String formula2 : this.formulaAndValueMap.keySet()) {
            FpDataInfo info;
            value = (BigDecimal)this.formulaAndValueMap.get(formula2);
            commonFormula = this.bulidCommonFormula(formula2);
            if (!this.fpDataMap.containsKey(commonFormula)) {
                info = this.bulidFpDataInfo(formula2, value);
                this.fpDataMap.put(commonFormula, info);
                continue;
            }
            info = (FpDataInfo)this.fpDataMap.get(commonFormula);
            if (this.getDataType(formula2).equals((Object)FpDataTypeEnum.P)) {
                info.setFpValue(value);
                continue;
            }
            info.setBizActual(value);
        }
    }

    private String bulidCommonFormula(String formula) throws ParserException {
        String[] params = FpHelper.getItemParams(formula);
        if (params == null || params.length != 5) {
            return null;
        }
        FpItemFormulaInfo info = new FpItemFormulaInfo();
        info.setItemNum(params[0]);
        info.setAsstItemCombine(params[1]);
        info.setPeriodNum(params[2]);
        info.setCurrencyNum(params[4]);
        FPItemFormulaFormat formulaFmt = FPItemFormulaFormat.getInstance();
        return formulaFmt.format(info);
    }

    private FpDataInfo bulidFpDataInfo(String formula, BigDecimal value) throws BOSException, FpFormException {
        if (this.itemMap == null) {
            this.itemMap = FpItemFormulaHelper.getItemMap(this.ctx);
        }
        if (this.asstItemCombMap == null) {
            this.asstItemCombMap = FpItemFormulaHelper.getAsstItemCombMap(this.ctx);
        }
        if (this.periodMap == null) {
            this.periodMap = FpItemFormulaHelper.getPeriodMap(this.ctx);
        }
        if (this.currencyMap == null) {
            this.currencyMap = FpItemFormulaHelper.getCurrencyMap(this.ctx);
        }
        String itemId = null;
        String asstItemCombId = null;
        String periodId = null;
        String currencyId = null;
        String[] params = FpHelper.getItemParams(formula);
        if (params == null || params.length != 5 || !formula.startsWith("=FpItem")) {
            throw new FpFormException(FpFormException.ITEMFORMULAERROR, new Object[]{formula});
        }
        FpDataInfo fpDataInfo = new FpDataInfo();
        fpDataInfo.setId(Uuid.create().toString() + "ASDFGHJK");
        fpDataInfo.setFpFormId(this.formId);
        if (this.dataType.equals((Object)FpDataTypeEnum.P)) {
            fpDataInfo.setFpValue(value);
            fpDataInfo.setAdjustValue(value);
            fpDataInfo.setBizActual(Constants.ZERO);
        } else if (this.dataType.equals((Object)FpDataTypeEnum.ADJ)) {
            fpDataInfo.setAdjustValue(value);
        } else if (this.dataType.equals((Object)FpDataTypeEnum.A)) {
            fpDataInfo.setFpValue(Constants.ZERO);
            fpDataInfo.setBizActual(value);
        }
        fpDataInfo.setFpFormula(this.bulidCommonFormula(formula));
        if (FMHelper.isEmpty((String)params[0])) {
            throw new FpFormException(FpFormException.SUBMITNOITEM, new String[]{formula});
        }
        itemId = (String)this.itemMap.get(params[0]);
        if (FMHelper.isEmpty((String)itemId)) {
            logger.info((Object)"FpDataGenerator Item is invalid!");
            throw new FpFormException(FpFormException.SUBMITERRORITEM, new String[]{formula, params[0]});
        }
        fpDataInfo.setFpItemId(itemId);
        if (params[1] != null && params[1].trim().length() > 0) {
            asstItemCombId = (String)this.asstItemCombMap.get(params[1]);
            if (asstItemCombId == null) {
                logger.info((Object)"FpDataGenerator asstItemCombId is invalid!");
                throw new FpFormException(FpFormException.SUBMITERRORASSTITEM, new String[]{formula, params[1]});
            }
            fpDataInfo.setFpAssistItemId(asstItemCombId);
        }
        if (FMHelper.isEmpty((String)params[2])) {
            throw new FpFormException(FpFormException.SUBMITNOPERIOD, new String[]{formula});
        }
        periodId = (String)this.periodMap.get(params[2]);
        if (FMHelper.isEmpty((String)periodId)) {
            logger.info((Object)"FpDataGenerator periodId is invalid!");
            throw new FpFormException(FpFormException.SUBMITERRORPERIOD, new String[]{formula, params[2]});
        }
        fpDataInfo.setFpPeriodId(periodId);
        if (FMHelper.isEmpty((String)params[4])) {
            throw new FpFormException(FpFormException.SUBMITNOCURRENCY, new String[]{formula});
        }
        currencyId = (String)this.currencyMap.get(params[4]);
        if (currencyId == null) {
            logger.info((Object)"FpDataGenerator currencyId is invalid!");
            throw new FpFormException(FpFormException.SUBMITERRORCURRENCY, new String[]{formula, params[4]});
        }
        fpDataInfo.setCurrencyId(currencyId);
        return fpDataInfo;
    }

    private FpDataTypeEnum getDataType(String formula) throws ParserException {
        FpItemFormulaParser parser = new FpItemFormulaParser(formula);
        parser.parse();
        return parser.getDataType();
    }

    public void save() throws FpFormException {
        if (this.fpDataMap == null || this.fpDataMap.size() <= 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            SQLUtils.execute((Connection)conn, (String)("DELETE FROM T_FPL_FpData WHERE FFpFormId = '" + this.formId + "'"));
            StringBuffer sql = new StringBuffer();
            sql.append(" INSERT INTO T_FPL_FpData ").append(" (FID, FFpFormId, FFpValue, FBizActual, FFpBalance, FAdjustValue, FFormula, ").append(" \tFFpItemId, FFpAssistItemCombId, FFpPeriodId, FCurrencyId) ").append(" VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            pstmt = conn.prepareStatement(sql.toString());
            FpDataInfo info2 = null;
            int index = 0;
            Collection coll = this.fpDataMap.values();
            for (FpDataInfo info2 : coll) {
                index = 0;
                pstmt.setString(++index, info2.getId());
                pstmt.setString(++index, info2.getFpFormId());
                pstmt.setBigDecimal(++index, info2.getFpValue());
                pstmt.setBigDecimal(++index, info2.getBizActual());
                pstmt.setBigDecimal(++index, info2.getFpBalance());
                pstmt.setBigDecimal(++index, info2.getAdjustValue());
                pstmt.setString(++index, info2.getFpFormula());
                pstmt.setString(++index, info2.getFpItemId());
                pstmt.setString(++index, info2.getFpAssistItemId());
                pstmt.setString(++index, info2.getFpPeriodId());
                pstmt.setString(++index, info2.getCurrencyId());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                logger.error((Object)("FpDataGenerator save() error:" + e));
                throw new FpFormException(FpFormException.DRAWOUTBUDGETERROR);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void saveFpData(Map fpDataMap) throws FpFormException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            StringBuffer sql = new StringBuffer();
            sql.append(" INSERT INTO T_FPL_FpData ").append(" (FID, FFpFormId, FFpValue, FBizActual, FFpBalance, FAdjustValue, FFormula, ").append(" \tFFpItemId, FFpAssistItemCombId, FFpPeriodId, FCurrencyId) ").append(" VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            pstmt = conn.prepareStatement(sql.toString());
            FpDataInfo info2 = null;
            int index = 0;
            Collection coll = fpDataMap.values();
            for (FpDataInfo info2 : coll) {
                index = 0;
                pstmt.setString(++index, info2.getId());
                pstmt.setString(++index, info2.getFpFormId());
                pstmt.setBigDecimal(++index, info2.getFpValue());
                pstmt.setBigDecimal(++index, info2.getBizActual());
                pstmt.setBigDecimal(++index, info2.getFpBalance());
                pstmt.setBigDecimal(++index, info2.getAdjustValue());
                pstmt.setString(++index, info2.getFpFormula());
                pstmt.setString(++index, info2.getFpItemId());
                pstmt.setString(++index, info2.getFpAssistItemId());
                pstmt.setString(++index, info2.getFpPeriodId());
                pstmt.setString(++index, info2.getCurrencyId());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                logger.error((Object)("FpDataGenerator save() error:" + e));
                throw new FpFormException(FpFormException.DRAWOUTBUDGETERROR);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public void saveAdjustData() throws FpFormException {
        if (this.fpDataMap == null || this.fpDataMap.isEmpty()) {
            return;
        }
        Map rootMap = null;
        try {
            rootMap = FpFormHelper.getFpDataMap(this.ctx, this.formId);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        HashMap addNewMap = new HashMap();
        if (rootMap != null && !rootMap.isEmpty()) {
            String formula2 = null;
            for (String formula2 : this.fpDataMap.keySet()) {
                if (rootMap.containsKey(formula2)) continue;
                addNewMap.put(formula2, this.fpDataMap.get(formula2));
            }
        }
        this.saveFpData(addNewMap);
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            StringBuffer sql = new StringBuffer();
            sql.append(" UPDATE T_FPL_FpData ").append(" SET FAdjustValue = ? WHERE FFpFormId = ? AND FFormula = ? ");
            pstmt = conn.prepareStatement(sql.toString());
            FpDataInfo info2 = null;
            int index = 0;
            Collection coll = this.fpDataMap.values();
            for (FpDataInfo info2 : coll) {
                index = 0;
                pstmt.setBigDecimal(++index, info2.getAdjustValue());
                pstmt.setString(++index, info2.getFpFormId());
                pstmt.setString(++index, info2.getFpFormula());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage());
                throw new FpFormException(FpFormException.DRAWOUTADJUSTERROR);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveActualData() throws FpFormException {
        if (this.fpDataMap == null) return;
        if (this.fpDataMap.size() <= 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            Map dbFpDataMap = FpFormHelper.getFpDataMap(this.ctx, this.formId);
            conn = EJBFactory.getConnection((Context)this.ctx);
            StringBuffer sql = new StringBuffer();
            sql.append(" UPDATE T_FPL_FpData ").append(" SET FBizActual = ?, FFpBalance = ? WHERE FFpFormId = ? AND FFormula = ? ");
            pstmt = conn.prepareStatement(sql.toString());
            FpDataInfo info2222222 = null;
            int index = 0;
            Collection coll = this.fpDataMap.values();
            BigDecimal fpBalance = Constants.ZERO;
            for (FpDataInfo info2222222 : coll) {
                index = 0;
                fpBalance = ((FpDataInfo)dbFpDataMap.get(info2222222.getFpFormula())).getFpValue().add(info2222222.getBizActual().negate());
                pstmt.setBigDecimal(++index, info2222222.getBizActual());
                pstmt.setBigDecimal(++index, fpBalance);
                pstmt.setString(++index, info2222222.getFpFormId());
                pstmt.setString(++index, info2222222.getFpFormula());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage());
                throw new FpFormException(FpFormException.DRAWOUTACTUALERROR);
                catch (EASBizException e2) {
                    logger.error((Object)e2.getMessage());
                    throw new FpFormException(FpFormException.DRAWOUTACTUALERROR);
                }
                catch (BOSException e3) {
                    logger.error((Object)e3.getMessage());
                    throw new FpFormException(FpFormException.DRAWOUTACTUALERROR);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public Map getFpDataMap() {
        return this.fpDataMap;
    }
}

