/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.ICashflowRecord;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fpl.FPCtrlBillTypeEnum;
import com.kingdee.eas.fm.fpl.FPCtrlParamCollection;
import com.kingdee.eas.fm.fpl.FPCtrlParamInfo;
import com.kingdee.eas.fm.fpl.FpCtrlException;
import com.kingdee.eas.fm.fpl.FpCtrlHelper;
import com.kingdee.eas.fm.fpl.FpCtrlLevelInfo;
import com.kingdee.eas.fm.fpl.FpCtrlPeriodInfo;
import com.kingdee.eas.fm.fpl.FpCtrlStrategyInfo;
import com.kingdee.eas.fm.fpl.FpItemCollection;
import com.kingdee.eas.fm.fpl.FpItemFactory;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fpl.IFPLCtrlHandler;
import com.kingdee.eas.fm.fpl.IFpItem;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class VoucherFPLCtrlHandler
implements IFPLCtrlHandler {
    public static final String GL09 = "GL09";
    FpCtrlHelper helper = new FpCtrlHelper();
    private Map fpItemMap = new HashMap();

    public FPCtrlParamCollection getParameters(Context ctx, String billId) throws BOSException, EASBizException {
        String companyId = this.getCompanyId(ctx, billId);
        if (FMHelper.isEmpty((String)companyId)) {
            return new FPCtrlParamCollection();
        }
        IContextHelper ctxLocal = this.getContextCtrl(ctx);
        boolean needFPCtrl = ctxLocal.getBooleanParam(GL09, (IObjectPK)new ObjectUuidPK(companyId));
        boolean hasStrategy = FpCtrlHelper.hasExecutingStrategy(ctx, companyId, FPCtrlBillTypeEnum.VOUCHER);
        if (!needFPCtrl || !hasStrategy) {
            return new FPCtrlParamCollection();
        }
        HashSet<String> ids = new HashSet<String>();
        ids.add(billId);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)CashflowRecordInfo.getDefaultSelector());
        sic.add("voucher.*");
        sic.add("entry.*");
        sic.add("entry.currency.id");
        sic.add("entry.currency.number");
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("seq"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("voucher.id", ids, CompareType.INCLUDE));
        fic.add(new FilterItemInfo("primaryItem.id", null, CompareType.NOTEQUALS));
        CashflowRecordCollection cfCol = null;
        ICashflowRecord recCtrl = this.getCashflowRctrl(ctx);
        cfCol = recCtrl.getCashflowRecordCollection(view);
        FPCtrlParamCollection paramColl = this.buildParams(ctx, companyId, cfCol);
        return paramColl;
    }

    private String getCompanyId(Context ctx, String billId) throws BOSException {
        String sql = "select a.fcompanyid from t_gl_voucher a where fid=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billId});
        try {
            if (rs.next()) {
                return rs.getString(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public FPCtrlParamCollection buildParams(Context ctx, String companyId, CashflowRecordCollection cfCol) throws BOSException, EASBizException {
        FPCtrlParamCollection paramColl = new FPCtrlParamCollection();
        if (cfCol == null || cfCol.isEmpty()) {
            return paramColl;
        }
        FpCtrlStrategyInfo strategyInfo = FpCtrlHelper.getFpCtrlStrategyInfo(ctx, companyId, FPCtrlBillTypeEnum.VOUCHER);
        if (strategyInfo == null) {
            return paramColl;
        }
        for (int i = 0; i < cfCol.size(); ++i) {
            CashflowRecordInfo cashflowInfo = cfCol.get(i);
            FPCtrlParamInfo paramInfo = new FPCtrlParamInfo();
            BOSUuid voucherId = cashflowInfo.getVoucher().getId();
            if (voucherId != null) {
                paramInfo.setBillId(voucherId.toString());
            }
            paramInfo.setBillNumber(cashflowInfo.getVoucher().getNumber());
            paramInfo.setBizDate(cashflowInfo.getVoucher().getBookedDate());
            paramInfo.setOrgUnitId(cashflowInfo.getVoucher().getCompany().getId().toString());
            paramInfo.setReqAmount(cashflowInfo.getOriginalAmount());
            FpItemInfo item = this.getItem(ctx, cashflowInfo);
            if (item == null) continue;
            BgPeriodEnum periodEnum = BgPeriodEnum.MONTH;
            FpCtrlLevelInfo levelInfo = FpCtrlHelper.getCtrlLevelInfo(ctx, strategyInfo, item);
            FpCtrlPeriodInfo periodInfo = FpCtrlHelper.getCtrlPeriodInfo(ctx, strategyInfo, item);
            if (levelInfo == null || periodInfo == null) {
                throw new FpCtrlException(FpCtrlException.HASNOTLEVELORPERIOD, new Object[]{item.getName(), strategyInfo.getName()});
            }
            paramInfo.setIsNeedCtrl(levelInfo.isIsNeedCtrl());
            paramInfo.setCtrlLevel(levelInfo.isCtrlLevel());
            paramInfo.setCtrlPeriod(periodInfo.getCtrlPeriod());
            paramInfo.setPeriodCtrl(periodInfo.getPeriodCtrl());
            paramInfo.setCtrlItemId(item.getId().toString());
            paramInfo.setCtrlItemNumber(item.getNumber());
            if (levelInfo.isIsNeedCtrl() && !levelInfo.isCtrlLevel()) {
                FpItemInfo superItemInfo = this.helper.findValidSuperFpItem(ctx, strategyInfo, item.getNumber());
                if (superItemInfo == null) {
                    paramInfo.setIsNeedCtrl(false);
                } else {
                    paramInfo.setCtrlItemId(superItemInfo.getId().toString());
                    paramInfo.setCtrlItemNumber(superItemInfo.getNumber());
                    paramInfo.setIsNeedCtrl(true);
                    paramInfo.setCtrlLevel(true);
                    periodInfo = FpCtrlHelper.getCtrlPeriodInfo(ctx, strategyInfo, superItemInfo);
                    paramInfo.setCtrlPeriod(periodInfo.getCtrlPeriod());
                    paramInfo.setPeriodCtrl(periodInfo.getPeriodCtrl());
                }
            }
            periodEnum = periodInfo.getCtrlPeriod();
            String assistItem = null;
            BgPeriodInfo period = FpCtrlHelper.getPeriod(ctx, periodEnum, cashflowInfo.getVoucher().getBookedDate());
            CurrencyInfo currency = FpCtrlHelper.getCurrency(ctx, cashflowInfo.getEntry().getCurrency());
            String itemFormula = FpCtrlHelper.getItemFormula(item.getNumber(), assistItem, period.getNumber(), currency.getNumber());
            paramInfo.setItemFormula(itemFormula);
            paramInfo.setItemId(item.getId().toString());
            paramInfo.setItemNumber(item.getNumber());
            paramInfo.setPeriodId(period.getId().toString());
            paramInfo.setPeriodNumber(period.getNumber());
            paramInfo.setCurrencyId(currency.getId().toString());
            paramInfo.setCurrencyNumber(currency.getNumber());
            paramColl.add(paramInfo);
        }
        return paramColl;
    }

    private FpItemInfo getItem(Context ctx, CashflowRecordInfo cashflow) throws BOSException {
        String id = cashflow.getPrimaryItem().getId().toString();
        if (this.fpItemMap.containsKey(id)) {
            return (FpItemInfo)this.fpItemMap.get(id);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cashflowitem.id", (Object)id));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SorterItemCollection sorterColl = evi.getSorter();
        SorterItemInfo sorter = new SorterItemInfo("number");
        sorter.setSortType(SortType.ASCEND);
        sorterColl.add(sorter);
        IFpItem iFpItem = this.getFPItemCtrl(ctx);
        FpItemCollection itemColl = iFpItem.getFpItemCollection(evi);
        if (itemColl == null || itemColl.size() <= 0) {
            return null;
        }
        return itemColl.get(0);
    }

    private IFpItem getFPItemCtrl(Context ctx) throws BOSException {
        if (ctx == null) {
            return FpItemFactory.getRemoteInstance();
        }
        return FpItemFactory.getLocalInstance((Context)ctx);
    }

    private IContextHelper getContextCtrl(Context ctx) {
        if (ctx == null) {
            return ContextHelperFactory.getRemoteInstance();
        }
        return ContextHelperFactory.getLocalInstance((Context)ctx);
    }

    private ICashflowRecord getCashflowRctrl(Context ctx) throws BOSException {
        if (ctx == null) {
            return CashflowRecordFactory.getRemoteInstance();
        }
        return CashflowRecordFactory.getLocalInstance((Context)ctx);
    }
}

