/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fpl.FPPastDataFactory;
import com.kingdee.eas.fm.fpl.FPPastDataInfo;
import com.kingdee.eas.fm.fpl.FpDataInfo;
import com.kingdee.eas.fm.fpl.FpItemFormulaParser;
import com.kingdee.eas.fm.fpl.IFPPastData;
import com.kingdee.eas.fm.fpl.client.AbstractCellDiffUI;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CellDiffUI
extends AbstractCellDiffUI {
    private static final Logger logger = CoreUIObject.getLogger(CellDiffUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtFpItemName.setEnabled(false);
        this.txtAssItemName.setEnabled(false);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.fillData();
    }

    public static void showDialog(UIContext uiContext) throws UIException {
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CellDiffUI.class.getName(), (Map)uiContext);
        window.show();
    }

    private void fillData() throws BOSException, EASBizException {
        Map map = this.getUIContext();
        String formId = (String)map.get("ID");
        String formula = (String)map.get("itemFormula");
        IFPPastData iFpPastData = FPPastDataFactory.getRemoteInstance();
        List dataList = iFpPastData.getFpPastData(formId, formula);
        FpItemFormulaParser parser = new FpItemFormulaParser(formula);
        parser.parse();
        String fpItem = parser.getItem();
        String asstItemComb = parser.getAsstItemComb();
        this.txtFpItemName.setText(fpItem);
        this.txtAssItemName.setText(asstItemComb);
        this.tblMain.checkParsed();
        FPPastDataInfo info2 = null;
        String numberFmt = null;
        IRow row = null;
        for (FPPastDataInfo info2 : dataList) {
            if (info2.getAdjustDate() == null) continue;
            row = this.tblMain.addRow();
            row.getCell("adjTime").setValue((Object)info2.getAdjustDate());
            row.getCell("oldValue").setValue((Object)info2.getOldValue());
            row.getCell("changeValue").setValue((Object)info2.getChangeValue());
            row.getCell("adjustValue").setValue((Object)info2.getAdjustValue());
            row.getCell("adjUser").setValue((Object)info2.getAdjustUser());
            numberFmt = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)info2.getCurrencyId()));
            row.getCell("oldValue").getStyleAttributes().setNumberFormat(numberFmt);
            row.getCell("changeValue").getStyleAttributes().setNumberFormat(numberFmt);
            row.getCell("adjustValue").getStyleAttributes().setNumberFormat(numberFmt);
        }
        FpDataInfo dataInfo = (FpDataInfo)map.get("fpData");
        if (dataInfo != null && dataInfo.getFpValue().compareTo(dataInfo.getAdjustValue()) != 0) {
            row = this.tblMain.addRow();
            BigDecimal changeValue = dataInfo.getAdjustValue().add(dataInfo.getFpValue().negate());
            row.getCell("oldValue").setValue((Object)dataInfo.getFpValue());
            row.getCell("changeValue").setValue((Object)changeValue);
            row.getCell("adjustValue").setValue((Object)dataInfo.getAdjustValue());
            numberFmt = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)dataInfo.getCurrencyId()));
            row.getCell("oldValue").getStyleAttributes().setNumberFormat(numberFmt);
            row.getCell("changeValue").getStyleAttributes().setNumberFormat(numberFmt);
            row.getCell("adjustValue").getStyleAttributes().setNumberFormat(numberFmt);
        }
    }
}

