/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fpl.FPPastDataFactory;
import com.kingdee.eas.fm.fpl.FPPastDataInfo;
import com.kingdee.eas.fm.fpl.FpFormHelper;
import com.kingdee.eas.fm.fpl.IFPPastData;
import com.kingdee.eas.fm.fpl.client.AbstractFormAdjDiffUI;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FormAdjDiffUI
extends AbstractFormAdjDiffUI {
    private static final Logger logger = CoreUIObject.getLogger(FormAdjDiffUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.fillData();
    }

    private void fillData() throws BOSException, EASBizException {
        Map map = this.getUIContext();
        String formId = (String)map.get("ID");
        IFPPastData iFpPastData = FPPastDataFactory.getRemoteInstance();
        List dataList = iFpPastData.getFpPastData(formId, null);
        if (dataList == null || dataList.size() < 1) {
            return;
        }
        this.tblMain.checkParsed();
        this.tblMain.getColumn("fpItem").setMergeable(true);
        this.tblMain.getColumn("assistItem").setMergeable(false);
        this.tblMain.getColumn(2).setMergeable(false);
        this.tblMain.getColumn(3).setMergeable(false);
        this.tblMain.getColumn(4).setMergeable(false);
        this.tblMain.getColumn(5).setMergeable(false);
        this.tblMain.getColumn(6).setMergeable(false);
        this.tblMain.getMergeManager().setMergeMode(1);
        FPPastDataInfo info2 = null;
        String numberFmt = null;
        IRow row = null;
        int i = 0;
        int top = 0;
        int bottom = 0;
        String item = "";
        for (FPPastDataInfo info2 : dataList) {
            row = this.tblMain.addRow();
            row.getCell("fpItem").setValue((Object)info2.getFpItem());
            row.getCell("assistItem").setValue((Object)info2.getFpAsstItemComb());
            row.getCell("adjTime").setValue((Object)info2.getAdjustDate());
            row.getCell("oldValue").setValue((Object)info2.getOldValue());
            row.getCell("changeValue").setValue((Object)info2.getChangeValue());
            row.getCell("adjustValue").setValue((Object)info2.getAdjustValue());
            row.getCell("adjUser").setValue((Object)info2.getAdjustUser());
            numberFmt = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)info2.getCurrencyId()));
            row.getCell("oldValue").getStyleAttributes().setNumberFormat(numberFmt);
            row.getCell("changeValue").getStyleAttributes().setNumberFormat(numberFmt);
            row.getCell("adjustValue").getStyleAttributes().setNumberFormat(numberFmt);
            if (bottom == 0) {
                item = info2.getFpItem().getNumber();
            }
            if (!item.equals(info2.getFpItem().getNumber())) {
                item = info2.getFpItem().getNumber();
                this.tblMain.getMergeManager().mergeBlock(top, 1, bottom - 1, 1);
                top = bottom;
                ++i;
            }
            ++bottom;
            row.getStyleAttributes().setBackground(this.getColor(i));
        }
    }

    private Color getColor(int i) {
        if (i % 2 == 0) {
            return FpFormHelper.WHITE_COLOR;
        }
        return FpFormHelper.ADJUST_COLOR;
    }

    public static void showDialog(UIContext uiContext) throws Exception {
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FormAdjDiffUI.class.getName(), (Map)uiContext);
        window.show();
    }
}

