/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.Zero2EmptyStrCellDisplayParser;
import com.kingdee.eas.fm.fpl.FPItemDirectionEnum;
import com.kingdee.eas.fm.fpl.FpFormFacadeFactory;
import com.kingdee.eas.fm.fpl.FpItemGroupCollection;
import com.kingdee.eas.fm.fpl.FpItemGroupFactory;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fpl.FpRptFilterParam;
import com.kingdee.eas.fm.fpl.FpTemplateCollection;
import com.kingdee.eas.fm.fpl.FpTemplateFactory;
import com.kingdee.eas.fm.fpl.client.NumberExpandInfo;
import com.kingdee.eas.fm.fpl.client.TreeRender;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FpAnalyseUIHander {
    public static final String ITEM = "item";
    public static final String TOTAL = "total";
    private TreeRender treeRender;

    public void initTable(KDTable table, FpRptFilterParam param) throws Exception {
        FMClientHelper.clearTable((KDTable)table);
        table.checkParsed(true);
        IRow header = table.getHeadRow(0);
        BgPeriodCollection periodColl = BgPeriodFactory.getRemoteInstance().getPeriodCollection(BOSUuid.read((String)param.getBeginPeriodId()), BOSUuid.read((String)param.getEndPeriodId()));
        for (BgPeriodInfo periodInfo : periodColl) {
            String number = periodInfo.getNumber();
            table.addColumn().setKey(number);
            header.getCell(number).setValue((Object)periodInfo.getName());
        }
        table.addColumn().setKey(TOTAL);
        header.getCell(TOTAL).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)TOTAL));
        table.setUserCellDisplayParser((IUserCellDisplayParser)new Zero2EmptyStrCellDisplayParser());
        table.getViewManager().freeze(-1, table.getColumn(ITEM).getColumnIndex());
        table.reLayoutAndPaint();
    }

    public void fillFpItemByDirect(KDTable table, FPItemDirectionEnum direction, Map map, FilterParam param) throws BOSException, EASBizException, SQLException {
    }

    public void fillExpendData(KDTable table, IRow currRow, FilterParam param, String parentID) throws Exception {
    }

    public void fillTableWithItem(KDTable table, Map map, List lstItem) throws SQLException {
    }

    public Map fillFpItemsByTemplate(KDTable table, FilterParam param) throws Exception {
        HashMap map = new HashMap();
        FpRptFilterParam myParam = (FpRptFilterParam)param;
        String orgUnitID = myParam.getCurrentOrgUnitId();
        String fpTemplateID = myParam.getFpTemplateID();
        String currOrgUnitId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        if (!myParam.getCurrentOrgUnitId().equals(currOrgUnitId)) {
            if (myParam.isSum()) {
                orgUnitID = currOrgUnitId;
            } else {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)fpTemplateID));
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitID));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filter);
                FpTemplateCollection coll = FpTemplateFactory.getRemoteInstance().getFpTemplateCollection(evi);
                if (coll != null && coll.size() > 0) {
                    fpTemplateID = coll.get(0).getId().toString();
                }
            }
        }
        List lstItem = FpFormFacadeFactory.getRemoteInstance().getFpFormStyle(orgUnitID, fpTemplateID, myParam.getCurrencyId(), myParam.getBeginPeriodId(), myParam.getEndPeriodId());
        this.fillTableWithItem(table, map, lstItem);
        return map;
    }

    public Map fillFpItems(KDTable table, FilterParam param) throws Exception {
        HashMap map = new HashMap();
        this.fillFpItemByDirect(table, FPItemDirectionEnum.INWARD_MOVEMENT, map, param);
        this.fillFpItemByDirect(table, FPItemDirectionEnum.OUTWARD_MOVEMENT, map, param);
        IRow netRow = table.addRow();
        netRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        netRow.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpRptResource", (String)"netValue"));
        int colCount = table.getColumnCount();
        int inRowIndex = this.getInOutRowIndex(map, FPItemDirectionEnum.INWARD_MOVEMENT);
        int outRowIndex = this.getInOutRowIndex(map, FPItemDirectionEnum.OUTWARD_MOVEMENT);
        for (int i = 1; i < colCount; ++i) {
            netRow.getCell(i).setExpressions("=" + TableToolkit.xy2range((int)i, (int)inRowIndex) + "-" + TableToolkit.xy2range((int)i, (int)outRowIndex));
            netRow.getCell(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        return map;
    }

    public void setNumberFormat(KDTable table, String currencyId) {
        int colCount = table.getColumnCount();
        int rowCount = table.getRowCount();
        BOSUuid currencyUuid = BOSUuid.read((String)currencyId);
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 1; j < colCount; ++j) {
                FMClientHelper.currencyFormat((BOSUuid)currencyUuid, (ICell)table.getCell(i, j));
            }
        }
    }

    protected String getItemGroupName(String direction) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("direction", (Object)direction));
        view.setFilter(filter);
        FpItemGroupCollection inItemGroups = FpItemGroupFactory.getRemoteInstance().getFpItemGroupCollection(view);
        if (inItemGroups != null && inItemGroups.size() > 0) {
            return inItemGroups.get(0).getName();
        }
        return "";
    }

    private int getInOutRowIndex(Map map, FPItemDirectionEnum direct) {
        String key = direct.getValue() + "RowIndex";
        int rowIndex = (Integer)map.get(key);
        map.remove(key);
        return rowIndex;
    }

    public void initRender(KDTable table, FilterParam param) throws Exception {
        this.treeRender = new TreeRender();
        table.getColumn(ITEM).setRenderer((IBasicRender)this.treeRender);
        this.setExpendDisplayStyle(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandFpItem(KDTable table, IRow currRow, FilterParam param) {
        NumberExpandInfo expandInfo = (NumberExpandInfo)currRow.getCell(ITEM).getValue();
        FpRptFilterParam myParam = (FpRptFilterParam)param;
        String rootNumber = expandInfo.getAdjustRootId();
        String rootId = expandInfo.getId();
        boolean isExpandStatus = expandInfo.isExpandStatus();
        if (isExpandStatus) {
            expandInfo.setExpandStatus(false);
            int i = currRow.getRowIndex() + 1;
            table.setRefresh(false);
            this.setChildHided(table, expandInfo, i);
            table.setRefresh(true);
            table.reLayoutAndPaint();
        } else {
            FpItemInfo itemInfo;
            IRow next;
            expandInfo.setExpandStatus(true);
            int i = currRow.getRowIndex() + 1;
            boolean hasChildrenDataGotten = false;
            if (i < table.getRowCount() && (next = table.getRow(i)).getUserObject() != null && (itemInfo = (FpItemInfo)next.getUserObject()).getNumber().startsWith(rootNumber)) {
                hasChildrenDataGotten = true;
                this.setChildExpend(table, expandInfo, i);
            }
            if (!hasChildrenDataGotten) {
                try {
                    this.fillExpendData(table, currRow, myParam, rootId);
                    this.setNumberFormat(table, myParam.getCurrencyId());
                }
                catch (Exception e) {
                    SysUtil.abort();
                }
            }
        }
        if (!myParam.isShowZeroRec()) {
            this.hideZeroValueRow(table);
        }
    }

    public void hideZeroValueRow(KDTable table) {
        for (int rowIndex = 1; rowIndex < table.getRowCount(); ++rowIndex) {
            FpItemInfo itemInfo;
            IRow row = table.getRow(rowIndex);
            if (row.getStyleAttributes().getBackground() == FMClientHelper.KDTABLE_TOTAL_BG_COLOR || (itemInfo = (FpItemInfo)row.getUserObject()) != null && !itemInfo.isIsLeaf() || this.hasData(table, rowIndex)) continue;
            row.getStyleAttributes().setHided(true);
        }
    }

    private boolean hasData(KDTable table, int rowIndex) {
        for (int colIndex = 1; colIndex < table.getColumnCount() - 1; ++colIndex) {
            Object obj = table.getCell(rowIndex, colIndex).getValue();
            if (obj == null || obj.toString().equals("0") || obj.equals("")) continue;
            return true;
        }
        return false;
    }

    public void clickToExpand(KDTable table, KDTMouseEvent e, FilterParam param) {
        int columnIndex = e.getColIndex();
        if (columnIndex == 0) {
            int rowIndex = e.getRowIndex();
            IRow row = table.getRow(rowIndex);
            if (row == null) {
                return;
            }
            if (row.getCell(ITEM).getValue() instanceof NumberExpandInfo) {
                NumberExpandInfo numberExpandInfo = (NumberExpandInfo)row.getCell(ITEM).getValue();
                if (this.treeRender.inRect(numberExpandInfo, e.getX(), e.getY())) {
                    this.expandFpItem(table, row, param);
                }
                return;
            }
        }
    }

    private void setChildHided(KDTable table, NumberExpandInfo expandInfo, int i) {
        int count = table.getRowCount();
        while (i < count) {
            FpItemInfo itemInfo;
            IRow child = table.getRow(i);
            if (child.getUserObject() != null && (itemInfo = (FpItemInfo)child.getUserObject()).getNumber().startsWith(expandInfo.getAdjustRootId())) {
                child.getStyleAttributes().setHided(true);
            }
            ++i;
        }
    }

    private void setChildExpend(KDTable table, NumberExpandInfo expandInfo, int i) {
        IRow parent = table.getRow(i - 1);
        FpItemInfo parentInfo = (FpItemInfo)parent.getUserObject();
        int count = table.getRowCount();
        while (i < count) {
            FpItemInfo itemInfo;
            IRow child = table.getRow(i);
            if (child.getUserObject() != null && (itemInfo = (FpItemInfo)child.getUserObject()).getString("parent") != null && itemInfo.getString("parent").equals(parentInfo.getId().toString())) {
                this.expandChild(table, child);
            }
            ++i;
        }
    }

    private void expandChild(KDTable table, IRow row) {
        NumberExpandInfo expandInfo = (NumberExpandInfo)row.getCell(ITEM).getValue();
        boolean isExpandStatus = expandInfo.isExpandStatus();
        row.getStyleAttributes().setHided(false);
        if (isExpandStatus) {
            String parentId;
            IRow child;
            String fpItemId = "";
            if (row.getUserObject() != null) {
                fpItemId = ((FpItemInfo)row.getUserObject()).getId().toString();
            }
            if ((child = table.getRow(row.getRowIndex() + 1)).getUserObject() == null) {
                return;
            }
            FpItemInfo itemInfo = (FpItemInfo)child.getUserObject();
            if (itemInfo.getNumber().startsWith(expandInfo.getAdjustRootId()) && (parentId = itemInfo.getString("parent")).equals(fpItemId)) {
                this.expandChild(table, child);
            }
        }
    }

    public void setExpendDisplayStyle(KDTable table) {
        int count = table.getRowCount() - 1;
        for (int i = 1; i < count; ++i) {
            IRow row = table.getRow(i);
            Object itemObj = row.getUserObject();
            if (!(itemObj instanceof FpItemInfo)) continue;
            FpItemInfo itemInfo = (FpItemInfo)itemObj;
            Object obj = row.getCell(ITEM).getValue();
            if (obj instanceof NumberExpandInfo) continue;
            String acctName = (String)obj;
            NumberExpandInfo fpItemNumberExpandInfo = new NumberExpandInfo();
            fpItemNumberExpandInfo.setNumber(acctName);
            fpItemNumberExpandInfo.setAdjustRootId(itemInfo.getNumber());
            fpItemNumberExpandInfo.setExpandStatus(false);
            fpItemNumberExpandInfo.setLeaf(itemInfo.isIsLeaf());
            fpItemNumberExpandInfo.setLevel(itemInfo.getLevel());
            fpItemNumberExpandInfo.setId(itemInfo.getId().toString());
            row.getCell(ITEM).setValue((Object)fpItemNumberExpandInfo);
        }
    }

    public int getLevelByNumber(String sNumber) {
        String s = sNumber;
        int i = 0;
        while (s.indexOf(".") > 0) {
            s = s.substring(s.indexOf(".") + 1);
            ++i;
        }
        return i;
    }

    public FpItemInfo getFpItemInfo(List lst) {
        for (int i = 0; i < lst.size(); ++i) {
            Object obj = lst.get(i);
            if (obj == null || !(obj instanceof FpItemInfo)) continue;
            return (FpItemInfo)obj;
        }
        return null;
    }
}

