/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fpl.FPItemDirectionEnum;
import com.kingdee.eas.fm.fpl.FpAssistItemGroupCollection;
import com.kingdee.eas.fm.fpl.FpAssistItemGroupFactory;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fpl.FpRptAssistItemFilterParam;
import com.kingdee.eas.fm.fpl.FpRptFacadeFactory;
import com.kingdee.eas.fm.fpl.FpRptFilterParam;
import com.kingdee.eas.fm.fpl.IFpAssistItemGroup;
import com.kingdee.eas.fm.fpl.client.FpAnalyseUIHander;
import com.kingdee.eas.fm.fpl.client.FpRptClientHelper;
import com.kingdee.eas.fm.fpl.client.NumberExpandInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class FpAssistInOutAnalyseUIHander
extends FpAnalyseUIHander {
    private static FpAssistInOutAnalyseUIHander instance;

    private FpAssistInOutAnalyseUIHander() throws Exception {
    }

    public static FpAssistInOutAnalyseUIHander getInstance() throws Exception {
        if (instance == null) {
            instance = new FpAssistInOutAnalyseUIHander();
        }
        return instance;
    }

    public IRowSet getExpendData(FpRptFilterParam param, String parentID) throws Exception {
        FpRptAssistItemFilterParam myParam = (FpRptAssistItemFilterParam)param;
        myParam.setAssistAndItemNumber(parentID);
        return FpRptFacadeFactory.getRemoteInstance().getAssistItemDataGroupByOrgi(myParam);
    }

    public void fillFpItemByDirect(KDTable table, FPItemDirectionEnum direction, Map map, FilterParam param) throws BOSException, EASBizException, SQLException {
        String inGroupName = this.getItemGroupName(direction.getValue());
        IRow inOutRow = table.addRow();
        inOutRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        int inOutRowIndex = inOutRow.getRowIndex();
        inOutRow.getCell("item").setValue((Object)inGroupName);
        IRowSet rs = FpRptFacadeFactory.getRemoteInstance().getFpAssistItems(direction, param);
        int colCount = table.getColumnCount();
        HashMap expMap = new HashMap();
        HashMap<String, String> itemMap = new HashMap<String, String>();
        int ItemRowIndex = 0;
        while (rs.next()) {
            IRow row;
            String itemname = rs.getString("fitemname");
            String itemnumber = rs.getString("fitemnumber");
            String name = rs.getString("fname");
            String number = rs.getString("fitemassistnumber");
            if (!itemMap.containsKey(itemnumber)) {
                itemMap.put(itemnumber, itemname);
                itemname = FpRptClientHelper.getGoodFormatName(itemname, 1);
                row = table.addRow();
                row.getCell("item").setValue((Object)itemname);
                ItemRowIndex = row.getRowIndex();
            }
            name = FpRptClientHelper.getGoodFormatName(name, 2);
            row = table.addRow();
            int rowIndex = row.getRowIndex();
            row.getCell("item").setValue((Object)name);
            FpItemInfo iteminfo = new FpItemInfo();
            iteminfo.setNumber(number);
            iteminfo.setIsLeaf(rs.getBoolean("fisleaf"));
            iteminfo.setLevel(rs.getInt("flevel"));
            iteminfo.setId(BOSUuid.read((String)rs.getString("fid")));
            iteminfo.setString("parent", rs.getString("fparentid"));
            row.setUserObject((Object)iteminfo);
            map.put(number, new Integer(rowIndex));
            for (int i = 1; i < colCount; ++i) {
                String exp = table.getCell(inOutRowIndex, i).getExpressions();
                String exp2 = TableToolkit.xy2range((int)i, (int)rowIndex);
                if (FMHelper.isEmpty((String)exp)) {
                    table.getCell(inOutRowIndex, i).setExpressions("=" + exp2);
                } else {
                    table.getCell(inOutRowIndex, i).setExpressions(exp + "+" + exp2);
                }
                String exp1 = table.getCell(ItemRowIndex, i).getExpressions();
                if (FMHelper.isEmpty((String)exp1)) {
                    table.getCell(ItemRowIndex, i).setExpressions("=" + exp2);
                } else {
                    table.getCell(ItemRowIndex, i).setExpressions(exp1 + "+" + exp2);
                }
                table.getCell(inOutRowIndex, i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                table.getCell(ItemRowIndex, i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
            row.getCell("total").setExpressions("=sum(" + TableToolkit.xy2range((int)1, (int)rowIndex) + ":" + TableToolkit.xy2range((int)(colCount - 2), (int)rowIndex) + ")");
            row.getCell("total").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        expMap.clear();
        map.put(direction.getValue() + "RowIndex", new Integer(inOutRowIndex));
    }

    public void fillData(KDTable table, FilterParam param, Map map) throws Exception {
        IRowSet rs = FpRptFacadeFactory.getRemoteInstance().getFpAssistInOutAnalyse(param);
        if (rs == null) {
            return;
        }
        while (rs.next()) {
            String item = rs.getString("fitemassistnumber");
            String periodNumber = rs.getString("periodnumber");
            BigDecimal fpValue = rs.getBigDecimal("FFpValue");
            int itemRowIndex = (Integer)map.get(item);
            ICell cell = table.getCell(itemRowIndex, periodNumber);
            cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            cell.setValue((Object)fpValue);
        }
    }

    public void setExpendDisplayStyle(KDTable table) {
        int count = table.getRowCount() - 1;
        for (int i = 1; i < count; ++i) {
            IRow row = table.getRow(i);
            Object itemObj = row.getUserObject();
            if (!(itemObj instanceof FpItemInfo)) continue;
            FpItemInfo itemInfo = (FpItemInfo)itemObj;
            String acctName = (String)row.getCell("item").getValue();
            NumberExpandInfo fpItemNumberExpandInfo = new NumberExpandInfo();
            fpItemNumberExpandInfo.setNumber(acctName);
            fpItemNumberExpandInfo.setAdjustRootId(itemInfo.getNumber());
            fpItemNumberExpandInfo.setExpandStatus(false);
            row.getCell("item").setValue((Object)fpItemNumberExpandInfo);
        }
    }

    public void initComboItemGroup(KDComboBox comboItemGroup) throws EASBizException, BOSException {
        IFpAssistItemGroup iFpAssistItemGroup = FpAssistItemGroupFactory.getRemoteInstance();
        FpAssistItemGroupCollection itemGroupCol = iFpAssistItemGroup.getFpAssistItemGroupCollection("");
        comboItemGroup.addItems(itemGroupCol.toArray());
    }

    public void fillExpendData(KDTable table, IRow currRow, FilterParam param, String parentID) throws Exception {
    }
}

