/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fpl.FpAssistItemCollection;
import com.kingdee.eas.fm.fpl.FpAssistItemFactory;
import com.kingdee.eas.fm.fpl.FpAssistItemGroupInfo;
import com.kingdee.eas.fm.fpl.FpAssistItemInfo;
import com.kingdee.eas.fm.fpl.FpTemplateException;
import com.kingdee.eas.fm.fpl.IFpAssistItem;
import com.kingdee.eas.fm.fpl.client.AbstractFpAssistItemGroupF7UI;
import com.kingdee.eas.fm.fpl.client.FpAssistItemGroupInDialog;
import com.kingdee.eas.fm.fpl.client.FpTemFormatImportUI;
import com.kingdee.eas.fm.fpl.client.FpTemFormatImportUIHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FpAssistItemGroupF7UI
extends AbstractFpAssistItemGroupF7UI {
    private static final Logger logger = CoreUIObject.getLogger(FpAssistItemGroupF7UI.class);
    private static final String ITEM_RES = "com.kingdee.eas.fm.fpl.client.FpItemResource";
    private static final String ITEM_IMPORT_RES = "com.kingdee.eas.fm.fpl.client.FpItemImportResource";
    private FpAssistItemInfo result = null;
    private FpTemFormatImportUI importUI = null;
    private static final String REGEX = "|";
    private boolean isBatchFill = false;

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("isBatchFill") != null) {
            this.isBatchFill = (Boolean)this.getUIContext().get("isBatchFill");
        }
        this.importUI = (FpTemFormatImportUI)((Object)this.getUIContext().get("Owner"));
        this.btnFastFind.setEnabled(true);
        FpAssistItemGroupInDialog dialog = new FpAssistItemGroupInDialog();
        this.prmtItemGroup.setSelector((KDPromptSelector)dialog);
        this.btnHelp.setVisible(false);
        this.initTable();
        this.actionFastFind_actionPerformed(null);
    }

    public static void showF7UI(IUIObject ui, boolean isBatchFill) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"isBatchFill", (Object)isBatchFill);
        String uiMode = FMClientHelper.getEditUIMode((CoreUIObject)((CoreUIObject)ui));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)uiMode).create(FpAssistItemGroupF7UI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    private void initTable() {
        this.kdtAssistItem.checkParsed();
        this.kdtAssistItem.getSelectManager().setSelectMode(10);
    }

    public void actionFastFind_actionPerformed(ActionEvent e) throws Exception {
        super.actionFastFind_actionPerformed(e);
        String selectName = this.comboSelectName.getSelectedItem().toString();
        String compare = this.comboCompare.getSelectedItem().toString();
        String compareValue = this.txtCompareValue.getText();
        String sql = this.buildFastFindSql(selectName, compare, compareValue);
        IFpAssistItem iFpAssistItem = FpAssistItemFactory.getRemoteInstance();
        FpAssistItemCollection assistItemColl = iFpAssistItem.getFpAssistItemCollection(sql);
        this.buildTable(assistItemColl);
    }

    private String buildFastFindSql(String selectName, String compare, String compareValue) {
        String name = null;
        String compareName = null;
        String inputField = null;
        String itemName = EASResource.getString((String)ITEM_RES, (String)"itemNumber");
        String compareKey = EASResource.getString((String)ITEM_RES, (String)"compare");
        name = selectName.equals(itemName) ? "number" : "name";
        if (compare.equals(compareKey)) {
            compareName = " LIKE ";
            inputField = "%" + compareValue + "%";
        } else {
            compareName = " = ";
            inputField = compareValue;
        }
        String sql = "SELECT group.id, group.name, group.number, group.longNumber, * WHERE " + name + compareName + " '" + inputField + "' ORDER BY group.LongNumber, LongNumber";
        return sql;
    }

    private void buildTable(FpAssistItemCollection itemColl) {
        this.kdtAssistItem.refresh();
        if (itemColl == null || itemColl.size() <= 0) {
            return;
        }
        int j = 0;
        IRow row = null;
        ICell cell = null;
        for (int i = 0; i < itemColl.size(); ++i) {
            j = 0;
            row = this.kdtAssistItem.addRow();
            row.setUserObject((Object)itemColl.get(i));
            cell = row.getCell(j++);
            cell.setValue((Object)itemColl.get(i).getGroup());
            cell = row.getCell(j++);
            cell.setValue((Object)itemColl.get(i).getNumber());
            cell = row.getCell(j++);
            cell.setValue((Object)itemColl.get(i).getName());
            cell = row.getCell(j++);
            cell.setValue((Object)itemColl.get(i).getDescription());
        }
        this.kdtAssistItem.getStyleAttributes().setLocked(true);
    }

    protected void prmtItemGroup_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtItemGroup_dataChanged(e);
        FpAssistItemGroupInfo info = (FpAssistItemGroupInfo)this.prmtItemGroup.getData();
        if (info == null) {
            return;
        }
        String groupID = info.getId().toString();
        String sql = this.buildGroupSql(groupID);
        IFpAssistItem iFpAssistItem = FpAssistItemFactory.getRemoteInstance();
        FpAssistItemCollection assistItemColl = iFpAssistItem.getFpAssistItemCollection(sql);
        this.buildTable(assistItemColl);
    }

    private String buildGroupSql(String groupID) {
        String sql = "SELECT *, group.* WHERE group.ID = '" + groupID + "' ORDER BY group.LongNumber, LongNumber";
        return sql;
    }

    protected void kdtAssistItem_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        this.confirmAction();
    }

    private void confirmAction() throws EASBizException {
        this.result = null;
        int size = this.kdtAssistItem.getSelectManager().size();
        if (size == 0 || this.kdtAssistItem.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        int itemCount = 0;
        FpAssistItemInfo info = null;
        ArrayList<FpAssistItemInfo> itemList = new ArrayList<FpAssistItemInfo>();
        StringBuffer tempNum = new StringBuffer();
        StringBuffer tempName = new StringBuffer();
        IRow row = null;
        KDTSelectBlock selectBlock = null;
        for (int i = 0; i < size; ++i) {
            selectBlock = this.kdtAssistItem.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                row = this.kdtAssistItem.getRow(j);
                if (row == null || !(row.getUserObject() instanceof FpAssistItemInfo)) {
                    return;
                }
                info = (FpAssistItemInfo)row.getUserObject();
                itemList.add(info);
                if (itemCount > 0) {
                    tempNum.append(REGEX);
                }
                tempNum.append(info.getGroup().getNumber()).append(REGEX).append(info.getNumber());
                if (itemCount > 0) {
                    tempName.append(REGEX);
                }
                tempName.append(info.getGroup().getName()).append(REGEX).append(info.getName());
                ++itemCount;
            }
        }
        if (!this.isBatchFill) {
            this.checkSameGroup(itemList);
            this.result = new FpAssistItemInfo();
            this.result.setNumber(tempNum.toString());
            this.result.setName(tempName.toString());
        } else {
            this.importUI.fillAssistItemTable(itemList);
        }
        if (itemCount <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)ITEM_RES, (String)"asstItemIsNull"));
        }
        this.getUIWindow().close();
    }

    private void checkSameGroup(List itemList) throws EASBizException {
        Map groupAndItemMap = FpTemFormatImportUIHelper.getGroupAndItemMap(itemList);
        String msg = "";
        String group = "";
        Object obj2 = null;
        List tempList = null;
        for (Object obj2 : groupAndItemMap.values()) {
            if (obj2 == null || !(obj2 instanceof List) || (tempList = (List)obj2).size() <= 1) continue;
            group = ((FpAssistItemInfo)tempList.get(0)).getGroup().getName();
            int count = tempList.size();
            for (int j = 0; j < count; ++j) {
                msg = msg + ((FpAssistItemInfo)tempList.get(j)).getName() + "\u3001";
            }
            msg = msg.substring(0, msg.length() - 1);
            msg = msg + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"16_FpAssistItemGroupF7UI") + group + "\uff0c";
        }
        if (msg != null && msg.trim().length() > 0) {
            throw new FpTemplateException(FpTemplateException.ITEMGROUP_ISSAME, new String[]{msg});
        }
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    public Object getResult() {
        return this.result;
    }
}

