/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.ExcelFileFilter;
import com.kingdee.eas.fm.fpl.FpHelper;
import com.kingdee.eas.fm.fpl.FpItemGroupFactory;
import com.kingdee.eas.fm.fpl.FpItemGroupInfo;
import com.kingdee.eas.fm.fpl.IFpItemGroup;
import com.kingdee.eas.fm.fpl.client.FpFormActualListUI;
import com.kingdee.eas.fm.fpl.client.FpFormAuditListUI;
import com.kingdee.eas.fm.fpl.client.FpFormListUI;
import com.kingdee.eas.fm.fpl.client.FpTemplateTreeListUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public final class FpClientHelper {
    public static final HashMap mapPrecOfCurrency = new HashMap(32);
    public static final String ITEM_RES = "com.kingdee.eas.fm.fpl.client.FpItemResource";
    public static final String FORM_RES = "com.kingdee.eas.fm.fpl.client.FpFormResource";
    public static final String REPORT_RES = "com.kingdee.eas.fm.fpl.client.FpRptResource";
    public static final String TEMPLATE_RES = "com.kingdee.eas.fm.fpl.client.FpTemplateResource";
    public static final String TEM_FORMAT_RES = "com.kingdee.eas.fm.fpl.client.FpTemFormatResource";
    public static final String ITEM_IMPORT_RES = "com.kingdee.eas.fm.fpl.client.FpItemImportResource";
    public static final String CLIENT_HELPER_RES = "com.kingdee.eas.fm.fpl.client.FpClientHelperResource";
    public static final String TEM_PROCESS_RES = "com.kingdee.eas.fm.fpl.client.FpTemplateProcessUIResource";
    public static final String IS_MULTI_SELECT = "isMultiSelect";
    public static final String IS_DUP_GROUP = "isDupGroup";
    public static final String IS_BATCH_FILL = "isBatchFill";
    public static final String DATA_FILL = "dataFormula";
    public static final String ITEM_FILL = "itemFormula";
    public static final String FILL_TYPE = "fillType";
    public static final Color TOTAL_COLOR = new Color(0xF6F6B6);
    public static final String ORG_UNIT = "orgUnit";
    public static final String IS_OPEN_REPORT = "isOpenReport";
    public static final String OPEN_REPORT_STATE = "OpenReportState";

    public static void verifyDateFromTo(CoreUIObject ui, Date dateFrom, Date dateTo, String resourcePath, String msg) {
        if ((dateFrom = DateTimeUtils.truncateDate((Date)dateFrom)).compareTo(dateTo = DateTimeUtils.truncateDate((Date)dateTo)) == 0) {
            dateTo = DateUtil.getNextDay((Date)dateTo);
        }
        if (dateFrom.compareTo(dateTo) > 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static Frame getFrameAncestor(Component c) {
        for (Component p = c; p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            return (Frame)p;
        }
        return null;
    }

    public static void setSelectObject(KDComboBox cbo, Object anObject) {
        if (CoreBaseInfo.class.isInstance(anObject)) {
            CoreBaseInfo newObject = (CoreBaseInfo)anObject;
            boolean found = false;
            for (int i = 0; i < cbo.getItemCount(); ++i) {
                CoreBaseInfo obj = (CoreBaseInfo)cbo.getItemAt(i);
                if (obj == null || !newObject.getId().equals((Object)obj.getId())) continue;
                cbo.setSelectedIndex(i);
                break;
            }
        } else {
            cbo.setSelectedItem(anObject);
        }
    }

    public static void checkIsOnCU(CoreUI ui, FullOrgUnitInfo org, CtrlUnitInfo orgCtrl) throws BOSException, EASBizException {
        if (org == null) {
            return;
        }
        IFullOrgUnit iFull = FullOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("CU.id"));
        org = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(org.getId()), sic);
        if (!org.getCU().getId().toString().equals(orgCtrl.getId().toString())) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)CLIENT_HELPER_RES, (String)"pleaseHandleInCurrentCU"));
            SysUtil.abort();
        }
    }

    public static boolean isCreator(String bizObjectId) throws Exception {
        boolean iscreator = true;
        IFpItemGroup io = FpItemGroupFactory.getRemoteInstance();
        FpItemGroupInfo info = io.getFpItemGroupInfo("select creator where id ='" + bizObjectId + "'");
        String creatorId = info.getCreator().getId().toString();
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (!userId.equals(creatorId)) {
            iscreator = false;
        }
        return iscreator;
    }

    public static void verifyFpPeriodBegin2End(CoreUIObject ui, KDBizPromptBox prmtBeginPeriod, KDBizPromptBox prmtEndPeriod) {
        boolean bln;
        if (prmtBeginPeriod.getData() == null) {
            prmtBeginPeriod.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"17_FpClientHelper"));
            SysUtil.abort();
        }
        if (prmtEndPeriod.getData() == null) {
            prmtEndPeriod.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"18_FpClientHelper"));
            SysUtil.abort();
        }
        BgPeriodInfo beginPeriod = (BgPeriodInfo)prmtBeginPeriod.getData();
        BgPeriodInfo endPeriod = (BgPeriodInfo)prmtEndPeriod.getData();
        if (!beginPeriod.getPeriodType().equals((Object)endPeriod.getPeriodType())) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"19_FpClientHelper"));
            SysUtil.abort();
        }
        if (!(bln = FpHelper.compareFpPeriodBegin2End(beginPeriod, endPeriod))) {
            prmtBeginPeriod.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"20_FpClientHelper"));
            SysUtil.abort();
        }
    }

    public static String getNumberFtm(BOSUuid currencyId) {
        return "%r-[ ]0." + FpClientHelper.getPrecOfCurrency(currencyId) + "n";
    }

    public static String getNumberFtm(int precision) {
        return "%r-[ ]0." + precision + "n";
    }

    public static String getNumberFtm() {
        return "%r-[ ]{###,###,###.##}15.2n";
    }

    public static int getPrecOfCurrency(BOSUuid currencyId) {
        if (mapPrecOfCurrency.size() == 0) {
            FpClientHelper.setPrecOfCurrenty(mapPrecOfCurrency);
        }
        if (!mapPrecOfCurrency.containsKey(currencyId)) {
            return 10;
        }
        return (Integer)mapPrecOfCurrency.get(currencyId);
    }

    private static void setPrecOfCurrenty(HashMap map) {
        String str = "select fid,fprecision from t_bd_currency";
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)str);
        IRowSet rs = null;
        try {
            rs = sqlExe.executeSQL();
            while (rs.next()) {
                map.put(BOSUuid.read((String)rs.getString(1)), new Integer(rs.getInt(2)));
            }
        }
        catch (BOSException bose) {
            return;
        }
        catch (SQLException sqle) {
            return;
        }
    }

    public static void exportTableToExcel(Component ui, KDTable table) throws Exception {
        FpClientHelper.exportTableToExcel(ui, table, false);
    }

    public static void exportTableToExcel(Component ui, KDTable table, boolean flag) throws Exception {
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
        String fileName = null;
        File fileDir = null;
        String totalFileName = null;
        if (fileChooser.showSaveDialog(ui) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            fileDir = new File(filePath.substring(0, filePath.lastIndexOf("\\")));
            totalFileName = fileName = fileChooser.getSelectedFile().getName();
            if (!fileName.toLowerCase().endsWith(".xls")) {
                totalFileName = fileName + ".xls";
            }
            if (!filePath.toLowerCase().endsWith(".xls")) {
                filePath = filePath + ".xls";
            }
        } else {
            return;
        }
        if (filePath == null) {
            return;
        }
        if (fileName.lastIndexOf(".") != -1) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        File[] files = null;
        int status = -1;
        if (fileDir != null && fileDir.isDirectory()) {
            files = fileDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile() || !files[i].getName().equals(totalFileName) || (status = MsgBox.showConfirm2((Component)ui, (String)EASResource.getString((String)REPORT_RES, (String)"FileExisted"))) != 2) continue;
                return;
            }
        }
        KDSBook kdsBook = new KDSBook(fileName);
        String sheetName = fileName;
        KDSSheet kdsSheet = flag ? table.getIOManager().saveToKDSSheet(kdsBook, true, false, sheetName) : table.getIOManager().saveToKDSSheet(kdsBook, true, false, false, sheetName);
        kdsBook.addSheet(null, kdsSheet);
        ExportManager export = new ExportManager();
        try {
            export.exportToExcel(kdsBook, filePath);
        }
        catch (RuntimeException e1) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)REPORT_RES, (String)"CheckFileOpen"));
        }
    }

    public static List kdt2List(KDTable table) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (table == null || table.getRowCount() <= 0) {
            return list;
        }
        for (int i = 0; i < table.getRowCount(); ++i) {
            list.add(table.getRow(i).getUserObject());
        }
        return list;
    }

    public static void refreshFpFormList(CoreUI ui) throws Exception {
        Container parent;
        CoreUI listUI = null;
        if (ui instanceof EditUI) {
            listUI = (CoreUI)ui.getUIContext().get("Owner");
        } else if (ui instanceof ListUI) {
            listUI = ui;
        }
        if (listUI != null && listUI instanceof ListUI && (parent = ((ListUI)listUI).getParent()) != null && parent instanceof KDTabbedPane) {
            KDTabbedPane tabb = (KDTabbedPane)parent;
            int n = tabb.getTabCount();
            for (int i = 0; i < n; ++i) {
                Component component = tabb.getComponentAt(i);
                if (!(component instanceof FpTemplateTreeListUI) && !(component instanceof FpFormListUI) && !(component instanceof FpFormAuditListUI) && !(component instanceof FpFormActualListUI)) continue;
                ((ListUI)component).refreshList();
            }
        }
    }
}

