/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fpl.FpCtrlException;
import com.kingdee.eas.fm.fpl.FpCtrlStrategyFactory;
import com.kingdee.eas.fm.fpl.IFpCtrlStrategy;
import com.kingdee.eas.fm.fpl.client.AbstractFpCtrlStrategyListUI;
import com.kingdee.eas.fm.fpl.client.FpClientHelper;
import com.kingdee.eas.fm.fpl.client.FpCtrlStrategyUI;
import com.kingdee.eas.fm.fpl.client.FpSubOrgUnitSelectUIForForm;
import com.kingdee.eas.fm.fpl.client.FpTemplateHandler;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;

public class FpCtrlStrategyListUI
extends AbstractFpCtrlStrategyListUI {
    public static final String CUR_RESPONSE_ORG_UNIT_ID = "CurResponseOrgUnitId";
    private static final String resPath = "com.kingdee.eas.fm.fpl.client.FpCtrlResource";
    private CtrlUnitInfo currCuInfo = null;

    public void onLoad() throws Exception {
        if (this.currCuInfo == null) {
            this.currCuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        super.onLoad();
        FMClientHelper.addSqlMenu((CoreUIObject)this, (KDMenu)this.menuEdit);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionPageSetup.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.btnEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnAssign.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.itemEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.itemDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.itemAssign.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.menuWorkFlow.setVisible(false);
    }

    protected String getEditUIName() {
        return FpCtrlStrategyUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FpCtrlStrategyFactory.getRemoteInstance();
    }

    protected boolean initDefaultFilter() {
        return false;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgId", (Object)this.getOuId()));
        viewInfo.setFilter(filter);
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkIsCanEdit();
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        super.actionEdit_actionPerformed(e);
    }

    private void checkIsCanEdit() {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        IRow row = this.tblMain.getRow(rowIndex);
        boolean isEnabled = (Boolean)row.getCell("enabled").getValue();
        if (isEnabled) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resPath, (String)"CanNotEdit"));
            SysUtil.abort();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        IRow row = this.tblMain.getRow(rowIndex);
        boolean isEnabled = (Boolean)row.getCell("enabled").getValue();
        if (isEnabled) {
            throw new FpCtrlException(FpCtrlException.CANNOTDELETEBYENABLED);
        }
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        super.actionRemove_actionPerformed(e);
    }

    public void actionEnable_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ((IFpCtrlStrategy)this.getBizInterface()).enable(id);
        this.showMsg("enableOK");
        this.refresh(e);
    }

    private void showMsg(String resName) {
        this.setMessageText(EASResource.getString((String)resPath, (String)resName));
        this.showMessage();
    }

    public void actionDisable_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ((IFpCtrlStrategy)this.getBizInterface()).disable(id);
        this.showMsg("disableOK");
        this.refresh(e);
    }

    public void actionAssign_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        FullOrgUnitInfo ouInfo = this.getFullOuInfo();
        OrgUnitCollection subOuColl = FpTemplateHandler.getDirectSubOuInfo(ouInfo);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"CUID", (Object)ouInfo.getId().toString());
        uiContext.put((Object)"EditOrg", (Object)subOuColl);
        IUIWindow subOuSelectUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FpSubOrgUnitSelectUIForForm.class.getName(), (Map)uiContext, null, null);
        subOuSelectUI.getUIObject().setUITitle(EASResource.getString((String)resPath, (String)"orgSelectUITitle"));
        subOuSelectUI.show();
        ArrayList subOuInfos = ((FpSubOrgUnitSelectUIForForm)subOuSelectUI.getUIObject()).getReturnValue();
        ArrayList<String> subOuIdList = new ArrayList<String>();
        if (subOuInfos == null) {
            return;
        }
        int n = subOuInfos.size();
        for (int i = 0; i < n; ++i) {
            FullOrgUnitInfo orgInfo = (FullOrgUnitInfo)subOuInfos.get(i);
            subOuIdList.add(orgInfo.getId().toString());
        }
        if (subOuIdList != null && !subOuIdList.isEmpty()) {
            ((IFpCtrlStrategy)this.getBizInterface()).assign(this.getSelectedIdValues(), subOuInfos);
            this.showMsg("assignOK");
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)CUR_RESPONSE_ORG_UNIT_ID, (Object)this.getFullOuInfo().getId().toString());
    }
}

