/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fpl.FpCtrlClientHelper;
import com.kingdee.eas.fm.fpl.FpCtrlLevelCollection;
import com.kingdee.eas.fm.fpl.FpCtrlObjectCollection;
import com.kingdee.eas.fm.fpl.FpCtrlObjectInfo;
import com.kingdee.eas.fm.fpl.FpCtrlPeriodCollection;
import com.kingdee.eas.fm.fpl.FpCtrlStrategyFactory;
import com.kingdee.eas.fm.fpl.FpCtrlStrategyInfo;
import com.kingdee.eas.fm.fpl.FpItemCollection;
import com.kingdee.eas.fm.fpl.FpTemplateSourceEnum;
import com.kingdee.eas.fm.fpl.PeriodCtrlTypeEnum;
import com.kingdee.eas.fm.fpl.client.AbstractFpCtrlStrategyUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class FpCtrlStrategyUI
extends AbstractFpCtrlStrategyUI {
    private static final String COL_PERIOD_CTRL_TYPE = "periodCtrlType";
    private static final String COL_CTRL_PERIOD = "ctrlPeriod";
    private static final String COL_CTRL_LEVEL = "ctrlLevel";
    private static final String COL_IS_NEED_CTRL = "isNeedCtrl";
    private static final String resPath = "com.kingdee.eas.fm.fpl.client.FpCtrlResource";
    private static final Logger logger = CoreUIObject.getLogger(FpCtrlStrategyUI.class);
    private FpCtrlClientHelper helper = new FpCtrlClientHelper();
    KdtCtrlLevelFillListener kdtCtrlLevelListener = new KdtCtrlLevelFillListener();
    KdtPeriodCtrlFillListener kdtPeriodCtrlListener = new KdtPeriodCtrlFillListener();

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if (this.getOprtState().equalsIgnoreCase(OprtState.EDIT)) {
            this.txtNumber.setEditable(false);
        }
        this.actionAddNew.setEnabled(false);
        this.actionAddNew.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.actionEdit.setVisible(false);
    }

    protected void initListener() {
        super.initListener();
        this.kdtCtrlLevel.addKDTDataFillListener((KDTDataFillListener)this.kdtCtrlLevelListener);
        this.kdtPeriodCtrl.addKDTDataFillListener((KDTDataFillListener)this.kdtPeriodCtrlListener);
    }

    private void initUI() throws BOSException {
        this.initPnlCtrlLevel();
        this.initPnlCtrlPeriod();
    }

    private void initPnlCtrlLevel() throws BOSException {
        this.kdtCtrlLevel.checkParsed();
        KDCheckBox cbx = new KDCheckBox();
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JCheckBox)cbx);
        this.kdtCtrlLevel.getColumn(COL_IS_NEED_CTRL).setEditor((ICellEditor)cellEditor);
        this.kdtCtrlLevel.getColumn(COL_CTRL_LEVEL).setEditor((ICellEditor)cellEditor);
    }

    private void initPnlCtrlPeriod() throws BOSException {
        this.kdtPeriodCtrl.checkParsed();
        KDComboBox combo1 = new KDComboBox();
        combo1.addItems(BgPeriodEnum.getEnumList().toArray());
        this.kdtPeriodCtrl.getColumn(COL_CTRL_PERIOD).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)combo1));
        KDComboBox combo2 = new KDComboBox();
        combo2.addItems(PeriodCtrlTypeEnum.getEnumList().toArray());
        this.kdtPeriodCtrl.getColumn(COL_PERIOD_CTRL_TYPE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)combo2));
    }

    public void loadFields() {
        this.kdtCtrlLevel.checkParsed();
        this.kdtPeriodCtrl.checkParsed();
        super.loadFields();
        this.initPnlCtrlObject();
        this.helper.handleIndent(this.kdtCtrlLevel);
        this.helper.handleIndent(this.kdtPeriodCtrl);
    }

    private void initPnlCtrlObject() {
        FpCtrlObjectCollection coll = this.editData.getCtrlObjects();
        FpCtrlObjectInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            this.initCbxCtrlObject(info.getCtrlBillType().getValue(), info.isIsEnabled());
        }
    }

    private void initCbxCtrlObject(int billType, boolean isEnabled) {
        switch (billType) {
            case 1: {
                this.cbxVoucher.setSelected(isEnabled);
                break;
            }
            case 6: {
                this.cbxReceivingBill.setSelected(isEnabled);
                break;
            }
            case 5: {
                this.cbxPaymentBill.setSelected(isEnabled);
                break;
            }
            case 2: {
                this.cbxPayOutBill.setSelected(isEnabled);
                break;
            }
            case 3: {
                this.cbxPayInBill.setSelected(isEnabled);
                break;
            }
            case 4: {
                this.cbxTranse.setSelected(isEnabled);
                break;
            }
        }
    }

    public void storeFields() {
        super.storeFields();
        this.storeFpCtrlObjects();
    }

    private void storeFpCtrlObjects() {
        FpCtrlObjectCollection coll = this.editData.getCtrlObjects();
        FpCtrlObjectInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            info.setIsEnabled(this.isEnabled(info.getCtrlBillType().getValue()));
        }
    }

    private boolean isEnabled(int billType) {
        switch (billType) {
            case 1: {
                return this.cbxVoucher.isSelected();
            }
            case 6: {
                return this.cbxReceivingBill.isSelected();
            }
            case 5: {
                return this.cbxPaymentBill.isSelected();
            }
            case 2: {
                return this.cbxPayOutBill.isSelected();
            }
            case 3: {
                return this.cbxPayInBill.isSelected();
            }
            case 4: {
                return this.cbxTranse.isSelected();
            }
        }
        return false;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtName);
        this.verifyCtrlObject();
    }

    private void verifyCtrlObject() {
        if (!(this.cbxVoucher.isSelected() || this.cbxPaymentBill.isSelected() || this.cbxReceivingBill.isSelected() || this.cbxPayOutBill.isSelected() || this.cbxPayInBill.isSelected() || this.cbxTranse.isSelected())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resPath, (String)"ctrlObjectAtLeastOne"));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        FpCtrlStrategyInfo info = new FpCtrlStrategyInfo();
        info.setEnabled(false);
        info.setOrgId((String)this.getUIContext().get("CurResponseOrgUnitId"));
        info.setCU(ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit());
        info.setSource(FpTemplateSourceEnum.LOCAL);
        info.getCtrlObjects().addCollection(this.helper.fillObjectColl());
        info.getCtrlLevels().addCollection(this.helper.fillLevelColl());
        info.getCtrlPeriods().addCollection(this.helper.fillPeriodColl());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FpCtrlStrategyFactory.getRemoteInstance();
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        FpCtrlStrategyInfo info = (FpCtrlStrategyInfo)super.getValue(pk);
        FpCtrlLevelCollection levelColl = info.getCtrlLevels();
        FpCtrlPeriodCollection periodColl = info.getCtrlPeriods();
        FpItemCollection newItemColl = this.helper.getNewFpItemColl(levelColl);
        if (newItemColl != null && !newItemColl.isEmpty()) {
            FpCtrlLevelCollection newlevelColl = this.helper.fillLevelColl(newItemColl);
            FpCtrlPeriodCollection newPeriodColl = this.helper.fillPeriodColl(newItemColl);
            levelColl.addCollection(newlevelColl);
            periodColl.addCollection(newPeriodColl);
        }
        this.helper.sortFpCtrlLevelColl(levelColl);
        this.helper.sortFpCtrlPeriodColl(periodColl);
        return info;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("ctrlObjects.*"));
        sic.add(new SelectorItemInfo("ctrlLevels.fpItem.group.*"));
        sic.add(new SelectorItemInfo("ctrlLevels.fpItem.group.number"));
        sic.add(new SelectorItemInfo("ctrlPeriods.fpItem.group.*"));
        sic.add(new SelectorItemInfo("ctrlPeriods.fpItem.group.number"));
        return sic;
    }

    protected void kdtCtrlLevel_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void kdtCtrlLevel_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.kdtCtrlLevel_tableSelectChanged(e);
    }

    protected void kdtCtrlLevel_editValueChanged(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String key = this.kdtCtrlLevel.getColumn(colIndex).getKey();
        ICell cell = null;
        if (e.getType() == 0) {
            if (key.equals(COL_IS_NEED_CTRL)) {
                int count = this.kdtCtrlLevel.getRowCount();
                for (int i = 0; i < count; ++i) {
                    cell = this.kdtCtrlLevel.getRow(i).getCell(key);
                    cell.setValue((Object)Boolean.TRUE);
                }
            }
        } else if (e.getType() == 1 && key.equals(COL_IS_NEED_CTRL)) {
            Boolean value = (Boolean)e.getValue();
            if (!value.booleanValue()) {
                this.kdtCtrlLevel.getRow(rowIndex).getCell(COL_CTRL_LEVEL).setValue((Object)value);
            }
            this.kdtCtrlLevel.getRow(rowIndex).getCell(COL_CTRL_LEVEL).getStyleAttributes().setLocked(value == false);
        }
    }

    protected void kdtCtrlLevel_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        super.kdtCtrlLevel_activeCellChanged(e);
    }

    public final class KdtPeriodCtrlFillListener
    implements KDTDataFillListener {
        public void afterDataFill(KDTDataRequestEvent e) {
            int rowCount = FpCtrlStrategyUI.this.kdtPeriodCtrl.getRowCount();
            ICell cell = null;
            int colIndex = 3;
            int indent = 1;
            block0: for (int j = 0; j < rowCount - 1; ++j) {
                cell = FpCtrlStrategyUI.this.kdtPeriodCtrl.getCell(j, colIndex);
                String number = (String)FpCtrlStrategyUI.this.kdtPeriodCtrl.getCell(j, 2).getValue();
                for (int k = j + 1; k < rowCount; ++k) {
                    cell = FpCtrlStrategyUI.this.kdtPeriodCtrl.getCell(k, colIndex);
                    String tempNumber = (String)FpCtrlStrategyUI.this.kdtPeriodCtrl.getCell(k, 2).getValue();
                    String value = cell.getValue().toString();
                    if (!tempNumber.startsWith(number + ".")) continue block0;
                    cell.setValue((Object)(FpCtrlStrategyUI.this.helper.getBlank(indent) + value));
                }
            }
        }
    }

    public final class KdtCtrlLevelFillListener
    implements KDTDataFillListener {
        public void afterDataFill(KDTDataRequestEvent e) {
            int rowCount = FpCtrlStrategyUI.this.kdtCtrlLevel.getRowCount();
            ICell cell = null;
            int colIndex = 3;
            int indent = 1;
            block0: for (int j = 0; j < rowCount - 1; ++j) {
                cell = FpCtrlStrategyUI.this.kdtCtrlLevel.getCell(j, colIndex);
                String number = (String)FpCtrlStrategyUI.this.kdtCtrlLevel.getCell(j, 2).getValue();
                for (int k = j + 1; k < rowCount; ++k) {
                    cell = FpCtrlStrategyUI.this.kdtCtrlLevel.getCell(k, colIndex);
                    String tempNumber = (String)FpCtrlStrategyUI.this.kdtCtrlLevel.getCell(k, 2).getValue();
                    String value = cell.getValue().toString();
                    if (!tempNumber.startsWith(number + ".")) continue block0;
                    cell.setValue((Object)(FpCtrlStrategyUI.this.helper.getBlank(indent) + value));
                }
            }
        }
    }
}

