/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.MutexUtils;
import com.kingdee.eas.fm.fpl.FpFormException;
import com.kingdee.eas.fm.fpl.FpFormFactory;
import com.kingdee.eas.fm.fpl.FpFormInfo;
import com.kingdee.eas.fm.fpl.FpFormStateEnum;
import com.kingdee.eas.fm.fpl.IFpForm;
import com.kingdee.eas.fm.fpl.client.AbstractFpFormActualListUI;
import com.kingdee.eas.fm.fpl.client.FpClientHelper;
import com.kingdee.eas.fm.fpl.client.FpFormEditUI;
import com.kingdee.eas.fm.fpl.client.FpSubOrgUnitSelectUI;
import com.kingdee.eas.fm.fpl.client.FpTemplateHandler;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FpFormActualListUI
extends AbstractFpFormActualListUI {
    private static final Logger logger = CoreUIObject.getLogger(FpFormActualListUI.class);
    private CtrlUnitInfo currCuInfo = null;

    public void onLoad() throws Exception {
        if (this.currCuInfo == null) {
            this.currCuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        super.onLoad();
        this.initDataStatus();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemEditActual.setIcon(EASResource.getIcon((String)"imgTbtn_getparms"));
        this.menuItemOrgColl.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.menuItemGetActual.setIcon(EASResource.getIcon((String)"imgTbtn_dispose"));
        this.btnEditActual.setIcon(EASResource.getIcon((String)"imgTbtn_getparms"));
        this.btnOrgCollect.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnGetActual.setIcon(EASResource.getIcon((String)"imgTbtn_dispose"));
        this.separator2.setVisible(false);
        this.comboxOrgType.setSelectedItem((Object)OrgViewType.COSTCENTER);
        this.comboxOrgType.setEnabled(false);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
    }

    private void initDataStatus() {
        this.menuWorkFlow.setVisible(false);
        this.actionGetActual.setVisible(false);
        this.actionAttachment.setEnabled(true);
        this.actionAttachment.setVisible(true);
        this.btnAttachment.setEnabled(true);
    }

    protected String getEditUIName() {
        return FpFormEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FpFormFactory.getRemoteInstance();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        HashSet<String> state = new HashSet<String>();
        state.add("approved");
        state.add("executing");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", state, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getOuId()));
        viewInfo.setFilter(filter);
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        return filter;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        this.checkSelected();
        this.openReport(e, OprtState.VIEW);
    }

    public void actionEditActual_actionPerformed(ActionEvent e) throws Exception {
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        this.checkSelected();
        this.checkIsCanEditActual();
        this.openReport(e, OprtState.EDIT);
    }

    private void checkIsCanEditActual() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return;
            }
            String number = (String)row.getCell("number").getValue();
            BizEnumValueInfo bizEnum = (BizEnumValueInfo)row.getCell("state").getValue();
            String value = (String)bizEnum.getValue();
            if (value.equals("executing")) {
                String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"canNotEditActualByExecute"), number);
                MsgBox.showWarning((Component)((Object)this), (String)msg);
                SysUtil.abort();
            }
        }
    }

    private void openReport(ActionEvent e, String reportState) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"isOpenReport", (Object)Boolean.TRUE);
        uiContext.put((Object)"OpenReportState", (Object)reportState);
        uiContext.put((Object)"isBizActual", (Object)Boolean.TRUE);
        uiContext.put((Object)"dataType", (Object)"A");
        uiContext.put((Object)"fpFormType", (Object)"ActualEditType");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.hide();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"orgUnitInfo", (Object)this.getFullOuInfo());
    }

    private void showWarning(String key) {
        if (key == null) {
            return;
        }
        MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)key));
        SysUtil.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionOrgCollect_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String key = this.getSelectedKeyValue();
        this.checkIsOrgColl(key);
        MutexUtils.requestMutex((CoreUI)this, (String)key);
        try {
            FullOrgUnitInfo ouInfo = this.getFullOuInfo();
            OrgUnitCollection subOuColl = FpTemplateHandler.getAllSubOuInfo(ouInfo);
            String cuId = ouInfo.getId().toString();
            UIContext uiContextOrg = new UIContext((Object)this);
            uiContextOrg.put((Object)"CUID", (Object)cuId);
            uiContextOrg.put((Object)"EditOrg", (Object)subOuColl);
            IUIWindow orgSelectorUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FpSubOrgUnitSelectUI.class.getName(), (Map)uiContextOrg, null, null);
            String title = EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"actualOrgCollTitle");
            orgSelectorUI.getUIObject().setUITitle(title);
            orgSelectorUI.show();
            List subOrgs = ((FpSubOrgUnitSelectUI)orgSelectorUI.getUIObject()).getReturnValue();
            if (subOrgs != null && subOrgs.size() > 0) {
                UIContext uiContext = new UIContext((Object)this);
                this.prepareUIContext(uiContext, e);
                uiContext.put((Object)"ID", (Object)key);
                uiContext.put((Object)"isOpenReport", (Object)Boolean.TRUE);
                uiContext.put((Object)"OpenReportState", (Object)OprtState.EDIT);
                uiContext.put((Object)"isBizActual", (Object)Boolean.TRUE);
                uiContext.put((Object)"subOrgIdList", (Object)subOrgs);
                uiContext.put((Object)"fpFormCollectType", (Object)"fpOrgActualCollect");
                uiContext.put((Object)"dataType", (Object)"A");
                uiContext.put((Object)"fpFormType", (Object)"ActualEditType");
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
                uiWindow.hide();
                if (this.isDoRefresh(uiWindow)) {
                    this.refresh(e);
                }
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        finally {
            MutexUtils.releaseMutex((String)key);
        }
    }

    private void checkIsOrgColl(String id) throws Exception {
        FpFormInfo info = ((IFpForm)this.getBizInterface()).getFpFormInfo((IObjectPK)new ObjectUuidPK(id));
        if (info.getState().equals((Object)FpFormStateEnum.EXECUTING)) {
            throw new FpFormException(FpFormException.CANNOTCOLLEXEFORM);
        }
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        List selectedList = this.getSelectedActiveRows();
        if (selectedList.size() > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"IsNotSupportMulti"));
        }
        super.actionAttachment_actionPerformed(e);
    }

    private List getSelectedActiveRows() {
        ArrayList<Integer> aryList = new ArrayList<Integer>();
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range != null) {
            int rowCount = range.size();
            for (int i = 0; i < rowCount; ++i) {
                int rowEnd;
                KDTSelectBlock block = (KDTSelectBlock)range.get(i);
                int rowBegin = block.getBeginRow();
                if (rowBegin != (rowEnd = block.getEndRow())) {
                    for (int j = 0; j < rowEnd - rowBegin + 1; ++j) {
                        int tempVal = rowBegin + j;
                        aryList.add(new Integer(tempVal));
                    }
                    continue;
                }
                aryList.add(new Integer(rowBegin));
            }
        }
        return aryList;
    }

    public void actionGetActual_actionPerformed(ActionEvent e) throws Exception {
    }
}

