/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.MutexUtils;
import com.kingdee.eas.fm.fpl.FpFormFacadeFactory;
import com.kingdee.eas.fm.fpl.FpFormFactory;
import com.kingdee.eas.fm.fpl.FpFormInfo;
import com.kingdee.eas.fm.fpl.IFpForm;
import com.kingdee.eas.fm.fpl.IFpFormFacade;
import com.kingdee.eas.fm.fpl.client.AbstractFpFormAdjListUI;
import com.kingdee.eas.fm.fpl.client.FormAdjDiffUI;
import com.kingdee.eas.fm.fpl.client.FpClientHelper;
import com.kingdee.eas.fm.fpl.client.FpFormClientHelper;
import com.kingdee.eas.fm.fpl.client.FpFormEditUI;
import com.kingdee.eas.fm.fpl.client.FpSubOrgUnitSelectUIForAdjustForm;
import com.kingdee.eas.fm.fpl.client.FpTemplateHandler;
import com.kingdee.eas.fm.fpl.client.NumberExpandInfo;
import com.kingdee.eas.fm.fpl.client.TreeRender;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FpFormAdjListUI
extends AbstractFpFormAdjListUI {
    private static final Logger logger = CoreUIObject.getLogger(FpFormAdjListUI.class);
    private CtrlUnitInfo currCuInfo = null;
    private TreeRender treeRender;
    IFpFormFacade iFpFormFacade = null;

    public FpFormAdjListUI() throws Exception {
        if (this.iFpFormFacade == null) {
            this.iFpFormFacade = FpFormFacadeFactory.getRemoteInstance();
        }
    }

    public void onLoad() throws Exception {
        if (this.currCuInfo == null) {
            this.currCuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        super.onLoad();
        this.treeRender = new TreeRender();
        this.tblMain.getColumn("number").setRenderer((IBasicRender)this.treeRender);
        this.actionAttachment.setEnabled(true);
        this.actionAttachment.setVisible(true);
        this.btnAttachment.setEnabled(true);
        this.btnAttachment.setVisible(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddNew.setEnabled(false);
        this.btnAddNew.setVisible(false);
        this.menuItemAddNew.setEnabled(false);
        this.menuItemAddNew.setVisible(false);
        this.actionAddNew.setEnabled(false);
        this.btnFormSubmit.setIsControlByParent(false);
        this.btnFormSubmit.setTextIconDisStyle(this.btnAddNew.getTextIconDisStyle());
        this.btnFormEdit.setIcon(EASResource.getIcon((String)"imgTbtn_pagesetting"));
        this.btnFormSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnFormGroupSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_referbatch"));
        this.btnFormCollect.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnViewDiff.setIcon(EASResource.getIcon((String)"imgTbtn_differentia"));
        this.menuItemFormSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.menuItemFormGroupSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_referbatch"));
        this.menuItemFormEdit.setIcon(EASResource.getIcon((String)"imgTbtn_pagesetting"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.menuItemAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.menuItemFormCollect.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.menuItemDataAccredit.setIcon(EASResource.getIcon((String)"imgTbtn_dataaccredit"));
        this.menuItemViewDoProccess.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
        this.menuItemAuditResult.setIcon(EASResource.getIcon((String)"imgTbtn_multapproveresult"));
        this.menuItemFormCollect.setMnemonic(79);
        this.menuItemViewDoProccess.setMnemonic(71);
    }

    protected String getEditUIName() {
        return FpFormEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FpFormFactory.getRemoteInstance();
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        HashSet<String> state = new HashSet<String>();
        state.add("approved");
        state.add("executing");
        state.add("adjusting");
        state.add("adjustSubmited");
        state.add("history");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", state, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getOuId()));
        viewInfo.setFilter(filter);
        SorterItemInfo sorter1 = new SorterItemInfo("adjustRootId");
        sorter1.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorter1);
        SorterItemInfo sorter2 = new SorterItemInfo("number");
        sorter2.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sorter2);
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int columnIndex;
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 1 && (columnIndex = e.getColIndex()) == 1) {
            int rowIndex = e.getRowIndex();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return;
            }
            NumberExpandInfo numberExpandInfo = (NumberExpandInfo)row.getCell("number").getValue();
            if (this.treeRender.inRect(numberExpandInfo, e.getX(), e.getY())) {
                this.setTreeDisplayStyle(row);
            }
            return;
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.setButtonState();
    }

    private void setButtonState() {
        this.setInitActionEnable(false);
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null) {
            BizEnumValueInfo enumValueInfo = (BizEnumValueInfo)row.getCell("state").getValue();
            String enumValue = enumValueInfo.getString();
            if (enumValue.equals("editing") || enumValue.equals("adjusting")) {
                this.setInitActionEnable(true);
                this.actionFormCollect.setEnabled(false);
            } else if (enumValue.equals("adjustSubmited")) {
                this.actionView.setEnabled(true);
                this.actionFormEdit.setEnabled(true);
                this.actionRemove.setEnabled(true);
            } else if (enumValue.equals("approved")) {
                this.actionView.setEnabled(true);
                this.actionFormEdit.setEnabled(true);
                this.actionFormCollect.setEnabled(true);
            } else if (enumValue.equals("executing")) {
                this.actionView.setEnabled(true);
                this.actionFormEdit.setEnabled(true);
            } else if (enumValue.equals("history")) {
                this.actionView.setEnabled(true);
            }
        }
    }

    public void setInitActionEnable(boolean isEnable) {
        this.actionView.setEnabled(isEnable);
        this.actionEdit.setEnabled(isEnable);
        this.actionRemove.setEnabled(isEnable);
        this.actionFormEdit.setEnabled(isEnable);
        this.actionAudit.setEnabled(isEnable);
        this.actionAntiAudit.setEnabled(isEnable);
        this.actionFormSubmit.setEnabled(isEnable);
        this.actionFormGroupSubmit.setEnabled(isEnable);
        this.actionFormCollect.setEnabled(isEnable);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        String id = this.getSelectedKeyValue();
        this.openReport(e, OprtState.VIEW, id);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        List selectedList = this.getSelectedActiveRows();
        if (selectedList.size() > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"IsNotSupportMulti"));
        }
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String boID = this.getSelectedKeyValue();
        if (boID == null) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)boID));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("adjustRootID"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        FpFormInfo fpFormInfo = FpFormFactory.getRemoteInstance().getFpFormCollection(viewInfo).get(0);
        String orgBillID = fpFormInfo.getAdjustRootID();
        acm.showAttachmentListUIByBoID(orgBillID, (Object)this);
    }

    private List getSelectedActiveRows() {
        ArrayList<Integer> aryList = new ArrayList<Integer>();
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range != null) {
            int rowCount = range.size();
            for (int i = 0; i < rowCount; ++i) {
                int rowEnd;
                KDTSelectBlock block = (KDTSelectBlock)range.get(i);
                int rowBegin = block.getBeginRow();
                if (rowBegin != (rowEnd = block.getEndRow())) {
                    for (int j = 0; j < rowEnd - rowBegin + 1; ++j) {
                        int tempVal = rowBegin + j;
                        aryList.add(new Integer(tempVal));
                    }
                    continue;
                }
                aryList.add(new Integer(rowBegin));
            }
        }
        return aryList;
    }

    public void actionFormEdit_actionPerformed(ActionEvent e) throws Exception {
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        this.checkSelected();
        BgClientHelper.applyMutexService((Component)((Object)this), (String)this.getSelectedKeyValue(), (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowNumber);
        String state = ((BizEnumValueInfo)row.getCell("state").getValue()).getString();
        String id = null;
        id = state.equals("adjusting") || state.equals("adjustSubmited") ? this.getSelectedKeyValue() : ((IFpForm)this.getBizInterface()).adjust(this.getSelectedKeyValue());
        this.openReport(e, OprtState.EDIT, id);
    }

    public void actionFormCollect_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String key = this.getSelectedKeyValue();
        try {
            FullOrgUnitInfo ouInfo = this.getFullOuInfo();
            OrgUnitCollection subOuColl = FpTemplateHandler.getAllSubOuInfo(ouInfo);
            String cuId = ouInfo.getId().toString();
            IFpFormFacade facade = FpFormFacadeFactory.getRemoteInstance();
            List ouIdList = facade.getCollectOuIds(key);
            UIContext uiContextOrg = new UIContext((Object)this);
            uiContextOrg.put((Object)"CUID", (Object)cuId);
            uiContextOrg.put((Object)"EditOrg", (Object)subOuColl);
            uiContextOrg.put((Object)"hasCollectedOuIdList", (Object)ouIdList);
            IUIWindow orgSelectorUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FpSubOrgUnitSelectUIForAdjustForm.class.getName(), (Map)uiContextOrg, null, null);
            String title = EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"adjustOrgCollTitle");
            orgSelectorUI.getUIObject().setUITitle(title);
            orgSelectorUI.show();
            List subOrgs = ((FpSubOrgUnitSelectUIForAdjustForm)orgSelectorUI.getUIObject()).getReturnValue();
            if (subOrgs != null && subOrgs.size() > 0) {
                String id = FpFormFactory.getRemoteInstance().adjust(key);
                UIContext uiContext = new UIContext((Object)this);
                this.prepareUIContext(uiContext, e);
                uiContext.put((Object)"ID", (Object)id);
                uiContext.put((Object)"isOpenReport", (Object)Boolean.TRUE);
                uiContext.put((Object)"OpenReportState", (Object)OprtState.EDIT);
                uiContext.put((Object)"isBizActual", (Object)Boolean.FALSE);
                uiContext.put((Object)"subOrgIdList", (Object)subOrgs);
                uiContext.put((Object)"fpFormCollectType", (Object)"fpOrgAdjustCollect");
                uiContext.put((Object)"dataType", (Object)"ADJ");
                uiContext.put((Object)"fpFormType", (Object)"fpAdjustType");
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
                uiWindow.hide();
                if (this.isDoRefresh(uiWindow)) {
                    this.refresh(e);
                }
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null) {
            String id = row.getCell("id").getValue().toString();
            String number = row.getCell("number").getValue().toString();
            if (!this.isConfirmAction("deleteForm", new String[]{number})) {
                return;
            }
            IFpFormFacade ifpFormFacade = FpFormFacadeFactory.getRemoteInstance();
            ifpFormFacade.delete(id);
            this.refresh(e);
        }
    }

    private boolean isConfirmAction(String resName, Object[] objects) {
        String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)resName), objects);
        int re = MsgBox.showConfirm3((Component)((Object)this), (String)msg);
        return re != 1 && re != 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionFormSubmit_actionPerformed(ActionEvent e) throws Exception {
        String id;
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        String number = null;
        if (row != null) {
            number = row.getCell("number").getValue().toString();
        }
        if (!this.isConfirmAction("submitFormWork", new String[]{number})) {
            return;
        }
        if (this.iFpFormFacade == null) {
            this.iFpFormFacade = FpFormFacadeFactory.getRemoteInstance();
        }
        if (row != null && this.iFpFormFacade != null && (id = row.getCell("id").getValue().toString()) != null && id.trim().length() > 0) {
            MutexUtils.requestMutex((CoreUI)this, (String)id);
            try {
                String msg = null;
                String formName = row.getCell("name").getValue().toString();
                if (this.iFpFormFacade.submit(id)) {
                    msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"submitFormSucceed"), formName);
                    this.setMessageText(msg);
                } else {
                    msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"submitFormDefeat"), formName);
                    this.setMessageText(msg);
                }
                this.showMessage();
                this.tblMain.refresh();
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
            finally {
                MutexUtils.releaseMutex((String)id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionFormGroupSubmit_actionPerformed(ActionEvent e) throws Exception {
        int n;
        StringBuffer numbers;
        int i;
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        this.checkSelected();
        if (!this.isConfirmAction("submitFormGroup", null)) {
            return;
        }
        if (!this.checkSelectForms()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"canNotSumbitFormGroup"));
            SysUtil.abort();
        }
        String id = null;
        String number = null;
        IRow row = null;
        ArrayList<String> billId = null;
        ArrayList<String> auditSuccess = null;
        ArrayList<String> auditDefeat = null;
        billId = new ArrayList<String>();
        auditSuccess = new ArrayList<String>();
        auditDefeat = new ArrayList<String>();
        HashMap<String, String> billIdMap = new HashMap<String, String>();
        int rowCount = 0;
        int rowBegin = 0;
        int rowEnd = 0;
        KDTSelectBlock block = null;
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range != null) {
            rowCount = range.size();
            for (i = 0; i < rowCount; ++i) {
                block = (KDTSelectBlock)range.get(i);
                rowBegin = block.getBeginRow();
                rowEnd = block.getEndRow();
                for (int j = rowBegin; j <= rowEnd; ++j) {
                    row = this.tblMain.getRow(j);
                    if (row == null) continue;
                    id = row.getCell("id").getValue().toString();
                    number = row.getCell("number").getValue().toString();
                    if (billIdMap.containsKey(id)) continue;
                    billId.add(id);
                    billIdMap.put(id, number);
                }
            }
        }
        if (this.iFpFormFacade == null) {
            this.iFpFormFacade = FpFormFacadeFactory.getRemoteInstance();
        }
        MutexUtils.requestMutex((CoreUI)this, billId);
        try {
            int n2 = billId.size();
            for (i = 0; i < n2; ++i) {
                id = billId.get(i).toString();
                number = billIdMap.get(id).toString();
                try {
                    if (this.iFpFormFacade.submit(id)) {
                        auditSuccess.add(number);
                        continue;
                    }
                    auditDefeat.add(number);
                    continue;
                }
                catch (BOSException ex) {
                    logger.error((Object)ex.getMessage());
                    continue;
                }
                catch (EASBizException ex) {
                    billId.clear();
                    billIdMap.clear();
                    this.tblMain.refresh();
                    this.handUIExceptionAndAbort((Exception)((Object)ex));
                }
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        finally {
            MutexUtils.releaseMutex(billId);
        }
        StringBuffer content = new StringBuffer(128);
        String and = EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"and");
        if (auditDefeat.size() > 0) {
            numbers = new StringBuffer(64);
            n = auditDefeat.size();
            for (int i2 = 0; i2 < n; ++i2) {
                numbers.append(auditDefeat.get(i2));
                if (i2 >= 0 && i2 < n - 2) {
                    numbers.append("\u3001");
                    continue;
                }
                if (i2 != n - 2) continue;
                numbers.append(and);
            }
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"submitFormDefeat"), numbers.toString());
            content.append(msg).append("\r\n");
        }
        if (auditSuccess.size() > 0) {
            numbers = new StringBuffer(64);
            n = auditSuccess.size();
            for (int i3 = 0; i3 < n; ++i3) {
                numbers.append(auditSuccess.get(i3));
                if (i3 >= 0 && i3 < n - 2) {
                    numbers.append("\u3001");
                    continue;
                }
                if (i3 != n - 2) continue;
                numbers.append(and);
            }
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"submitFormSucceed"), numbers.toString());
            content.append(msg.toString());
        }
        MsgBox.showInfo((Component)((Object)this), (String)content.toString());
        billId.clear();
        billIdMap.clear();
        auditSuccess.clear();
        auditDefeat.clear();
        this.tblMain.refresh();
    }

    private boolean checkSelectForms() {
        KDTSelectBlock block = null;
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range != null) {
            for (int i = 0; i < range.size(); ++i) {
                block = (KDTSelectBlock)range.get(i);
                for (int j = block.getBeginRow(); j <= block.getEndRow(); ++j) {
                    if (this.checkSelectForm(j)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkSelectForm(int rowIndex) {
        BizEnumValueInfo enumValueInfo;
        if (rowIndex == -1) {
            return false;
        }
        IRow row = this.tblMain.getRow(rowIndex);
        return row != null && ((enumValueInfo = (BizEnumValueInfo)row.getCell("state").getValue()).getString().equals("editing") || enumValueInfo.getString().equals("adjusting"));
    }

    private void openReport(ActionEvent e, String reportState, String formID) throws UIException {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"ID", (Object)formID);
        uiContext.put((Object)"isOpenReport", (Object)Boolean.TRUE);
        uiContext.put((Object)"OpenReportState", (Object)reportState);
        uiContext.put((Object)"isBizActual", (Object)Boolean.FALSE);
        uiContext.put((Object)"dataType", (Object)"ADJ");
        uiContext.put((Object)"fpFormType", (Object)"fpAdjustType");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.hide();
    }

    public void actionViewDiff_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        FormAdjDiffUI.showDialog(uiContext);
    }

    private void setTreeDisplayStyle(IRow row) {
        boolean isLeaf = this.isLeaf(row);
        if (isLeaf) {
            return;
        }
        this.expandFpItem(row);
    }

    private boolean isLeaf(IRow row) {
        if (row.getCell("isLeaf").getValue() != null && row.getCell("isLeaf").getValue() instanceof Boolean) {
            Boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
            return isLeaf;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandFpItem(IRow row) {
        NumberExpandInfo expandInfo = (NumberExpandInfo)row.getCell("number").getValue();
        String adjustRootId = expandInfo.getAdjustRootId();
        boolean isExpandStatus = expandInfo.isExpandStatus();
        if (isExpandStatus) {
            IRow child;
            NumberExpandInfo childExpandInfo;
            String childAdjustRootId;
            expandInfo.setExpandStatus(false);
            this.tblMain.setRefresh(false);
            int count = this.tblMain.getRowCount();
            for (int i = row.getRowIndex() + 1; i < count && adjustRootId.equals(childAdjustRootId = (childExpandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(i)).getCell("number").getValue()).getAdjustRootId()); ++i) {
                child.getStyleAttributes().setHided(true);
            }
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        } else {
            IRow next;
            NumberExpandInfo nextExpandInfo;
            String nextAdjustRootId;
            expandInfo.setExpandStatus(true);
            int i = row.getRowIndex() + 1;
            boolean hasChildrenDataGotten = false;
            if (i < this.tblMain.getRowCount() && adjustRootId.equals(nextAdjustRootId = (nextExpandInfo = (NumberExpandInfo)(next = this.tblMain.getRow(i)).getCell("number").getValue()).getAdjustRootId())) {
                hasChildrenDataGotten = true;
            }
            if (!hasChildrenDataGotten) {
                this.setCursorOfWair();
                EntityViewInfo childQuery = new EntityViewInfo();
                FilterInfo childFilter = new FilterInfo();
                childQuery.setFilter(childFilter);
                childFilter.getFilterItems().add(new FilterItemInfo("adjustRootId", (Object)adjustRootId));
                childFilter.setMaskString("#0");
                IRowSet rowset = null;
                try {
                    rowset = this.getQueryExecutor(this.mainQueryPK, childQuery).executeQuery();
                    if (rowset != null && rowset.size() > 0) {
                        int start = row.getRowIndex() + 1;
                        while (rowset.next()) {
                            IRow child = this.tblMain.addRow(start);
                            ++start;
                            int colcount = this.tblMain.getColumnCount();
                            for (int col = 0; col < colcount; ++col) {
                                IColumn column = this.tblMain.getColumn(col);
                                String field = column.getFieldName();
                                if (field == null || field.length() < 1) continue;
                                Object value = rowset.getObject(field);
                                if (field.equals("number")) {
                                    NumberExpandInfo childExpandInfo = new NumberExpandInfo();
                                    childExpandInfo.setId(rowset.getString("id"));
                                    childExpandInfo.setAdjustRootId(rowset.getString("adjustRootId"));
                                    childExpandInfo.setNumber(rowset.getString("number"));
                                    childExpandInfo.setExpandStatus(false);
                                    value = childExpandInfo;
                                }
                                child.getCell(col).setValue(value);
                            }
                        }
                        this.tblMain.setRowCount(this.tblMain.getRowCount() + rowset.size());
                    }
                }
                catch (BOSException e) {
                    this.handleException((Exception)((Object)e));
                }
                catch (SQLException e) {
                    this.handleException(e);
                }
                finally {
                    this.setCursorOfDefault();
                }
            }
            int count = this.tblMain.getRowCount();
            while (i < count) {
                IRow child = this.tblMain.getRow(i);
                NumberExpandInfo childExpandInfo = (NumberExpandInfo)child.getCell("number").getValue();
                String childAdjustRootId = childExpandInfo.getAdjustRootId();
                if (adjustRootId.equals(childAdjustRootId)) {
                    this.expandChildFpItem(child);
                }
                ++i;
            }
        }
    }

    private void expandChildFpItem(IRow row) {
        NumberExpandInfo acctNumberExpandInfo = (NumberExpandInfo)row.getCell("number").getValue();
        String adjustRootId = acctNumberExpandInfo.getAdjustRootId();
        boolean isExpandStatus = acctNumberExpandInfo.isExpandStatus();
        row.getStyleAttributes().setHided(false);
        if (isExpandStatus) {
            int count = this.tblMain.getRowCount();
            for (int i = row.getRowIndex() + 1; i < count; ++i) {
                IRow child = this.tblMain.getRow(i);
                NumberExpandInfo childExpandInfo = (NumberExpandInfo)child.getCell("number").getValue();
                String childAdjustRootId = childExpandInfo.getAdjustRootId();
                if (!adjustRootId.equals(childAdjustRootId)) continue;
                this.expandChildFpItem(child);
            }
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int start = e.getFirstRow();
                int end = e.getLastRow();
                FpFormAdjListUI.this.setTreeDisplayStyle(start, end + 1);
            }
        });
    }

    private void setTreeDisplayStyle(int start, int end) {
        Map countMap = FpFormClientHelper.getAdjustRootCount();
        String tempAdjustRootId = "";
        int index = 0;
        IRow row = null;
        int level = 1;
        boolean isLeaf = true;
        int count = end;
        for (int i = start; i < count; ++i) {
            row = this.tblMain.getRow(i);
            String id = (String)row.getCell("id").getValue();
            String adjustRootId = (String)row.getCell("adjustRootId").getValue();
            if (!tempAdjustRootId.equals(adjustRootId)) {
                tempAdjustRootId = adjustRootId;
                index = 0;
                level = 0;
            } else {
                ++index;
                ++level;
            }
            if (!(row.getCell("number").getValue() instanceof String)) continue;
            String number = (String)row.getCell("number").getValue();
            isLeaf = index != 0 || !countMap.containsKey(adjustRootId) || (Integer)countMap.get(adjustRootId) <= 1;
            row.getCell("isLeaf").setValue((Object)isLeaf);
            NumberExpandInfo expandInfo = new NumberExpandInfo();
            expandInfo.setId(id);
            expandInfo.setNumber(number);
            expandInfo.setLevel(level);
            expandInfo.setLeaf(isLeaf);
            expandInfo.setAdjustRootId(adjustRootId);
            expandInfo.setExpandStatus(true);
            row.getCell("number").setValue((Object)expandInfo);
        }
    }
}

