/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.file.ZipKDF;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.CurrencyUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.IReportProcess;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.RptSheet;
import com.kingdee.eas.fi.rpt.client.RptTablePane;
import com.kingdee.eas.fm.fpl.FormulaExpressionCalc;
import com.kingdee.eas.fm.fpl.FpDataTypeEnum;
import com.kingdee.eas.fm.fpl.FpFormInfo;
import com.kingdee.eas.fm.fpl.FpFormulaObject;
import com.kingdee.eas.fm.fpl.FpHelper;
import com.kingdee.eas.fm.fpl.FpItemCollection;
import com.kingdee.eas.fm.fpl.FpItemFactory;
import com.kingdee.eas.fm.fpl.FpItemFormulaParser;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fpl.IFpItem;
import com.kingdee.eas.fm.fpl.client.KDTReportTableAgent;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FpFormClientHelper {
    private static Logger logger = Logger.getLogger((String)FpFormClientHelper.class.getName());

    public static RptSheet genActualSheet(RptSheet fpSheet, RptTablePane pnlTables, IReportProcess editDataUI) {
        RptSheet actualSheet = pnlTables.duplicate(fpSheet);
        String fpSheetId = fpSheet.getId();
        String actualSheetId = fpSheetId.replaceAll("RPTSHEET", "ACTSHEET");
        actualSheet.setId(actualSheetId);
        actualSheet.setName(EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"actual") + fpSheet.getName());
        actualSheet.getTable().getScriptManager().setAutoRun(true);
        RptSheetParamInfo newSheetParam = editDataUI.processCreat(actualSheetId);
        actualSheet.setParams(newSheetParam);
        return actualSheet;
    }

    public static void showSheets(RptTablePane pnlTables, boolean isActual) {
        RptSheet sheet = null;
        pnlTables.unHideTabs(pnlTables.getHidedTabs());
        ArrayList sheets = pnlTables.getSheets();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            sheet = (RptSheet)sheets.get(i);
            if (sheet.getId().indexOf("RPTSHEET") >= 0 && isActual || sheet.getId().indexOf("ACTSHEET") < 0 || !isActual) {
                // empty if block
            }
            FpFormClientHelper.initTableKeyboardListener(pnlTables, sheet.getTable());
        }
        sheets.clear();
    }

    private static void initTableKeyboardListener(RptTablePane pnlTables, KDTable table) {
        if (table == null) {
            return;
        }
        ActionMap map = table.getActionMap();
        map.put("Paste", (Action)((Object)new KDTReportTableAgent(table, 1, pnlTables)));
        map.put("Cut", (Action)((Object)new KDTReportTableAgent(table, 3, pnlTables)));
        map.put("Delete", (Action)((Object)new KDTReportTableAgent(table, 2, pnlTables)));
        map.put("CancelEdit", (Action)((Object)new KDTReportTableAgent(table, 4, pnlTables)));
    }

    public static void setTableCellEditor(RptTablePane pnlTables, String currencyNum, boolean isActual) throws BOSException {
        RptSheet sheet = null;
        ArrayList sheets = pnlTables.getSheets();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            sheet = (RptSheet)sheets.get(i);
            if (sheet.getId().indexOf("RPTSHEET") >= 0 && !isActual) {
                FpFormClientHelper.setCellEditor(sheet.getTable(), currencyNum);
                continue;
            }
            if (sheet.getId().indexOf("ACTSHEET") < 0 || !isActual) continue;
            FpFormClientHelper.setCellEditor(sheet.getTable(), currencyNum);
        }
        sheets.clear();
    }

    private static void setCellEditor(KDTable table, String currencyNum) throws BOSException {
        if (table == null || currencyNum == null) {
            return;
        }
        Map currencyMap = FpFormClientHelper.getCurrencyInfoMap();
        HashMap<String, String> formatMap = new HashMap<String, String>();
        String currencyNumber = null;
        String[] params = null;
        KDFormattedTextField txtField = null;
        KDTDefaultCellEditor editor = null;
        CurrencyInfo currencyInfo = null;
        int precision = 2;
        String format = null;
        ICell cell = null;
        int rowCount = table.getBody().size();
        for (int i = 0; i < rowCount; ++i) {
            int colCount = table.getColumnCount();
            for (int j = 0; j < colCount; ++j) {
                cell = table.getCell(i, j);
                if (!FpFormClientHelper.hasItemFormula(cell) || (params = FpHelper.getItemParams(cell)) == null) continue;
                currencyNumber = params[4] != null || params[4].trim().length() > 0 ? params[4] : currencyNum;
                txtField = new KDFormattedTextField();
                txtField.setDataType(1);
                txtField.setDataVerifierType(12);
                if (currencyMap.containsKey(currencyNumber)) {
                    currencyInfo = (CurrencyInfo)currencyMap.get(currencyNumber);
                    precision = currencyInfo.getPrecision();
                } else {
                    precision = 2;
                }
                txtField.setPrecision(precision);
                txtField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
                editor = new KDTDefaultCellEditor((JTextField)txtField);
                cell.setEditor((ICellEditor)editor);
                if (formatMap.containsKey(currencyNumber)) {
                    format = (String)formatMap.get(currencyNumber);
                } else {
                    format = CurrencyUtil.getNumberFtm((int)precision);
                    formatMap.put(currencyNumber, format);
                }
                cell.getStyleAttributes().setNumberFormat(format);
            }
        }
    }

    private static Map getCurrencyInfoMap() throws BOSException {
        HashMap<String, CurrencyInfo> map = new HashMap<String, CurrencyInfo>();
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        CurrencyCollection coll = iCurrency.getCurrencyCollection();
        CurrencyInfo info2 = null;
        for (CurrencyInfo info2 : coll) {
            map.put(info2.getNumber(), info2);
        }
        return map;
    }

    private static Map getFpItemInfoMap() throws BOSException {
        HashMap<String, FpItemInfo> map = new HashMap<String, FpItemInfo>();
        IFpItem iFpItem = FpItemFactory.getRemoteInstance();
        FpItemCollection coll = iFpItem.getFpItemCollection();
        FpItemInfo info2 = null;
        for (FpItemInfo info2 : coll) {
            map.put(info2.getNumber(), info2);
        }
        return map;
    }

    public static void initProcessUI(FpFormInfo info, String oprtState) throws BOSException, IOException, KDFException {
        if (info == null || info.getKDF() == null) {
            return;
        }
        boolean isActual = FpDataTypeEnum.A.equals((Object)info.getDataType());
        String currNum = info.getCurrency().getNumber();
        String periodNum = info.getBgPeriod().getNumber();
        Map currInfoMap = FpFormClientHelper.getCurrencyInfoMap();
        HashMap numFmtMap = new HashMap();
        KDTable table2 = null;
        ICell cell = null;
        KDF kdf = null;
        try {
            kdf = info.getKDF();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        catch (KDFException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        if (kdf == null) {
            return;
        }
        Collection coll = kdf.getAllTable();
        for (KDTable table2 : coll) {
            int rowCount = table2.getBody().size();
            for (int i = 0; i < rowCount; ++i) {
                int colCount = table2.getColumnCount();
                for (int j = 0; j < colCount; ++j) {
                    cell = table2.getCell(i, j);
                    FpFormClientHelper.setItemFormula(cell, periodNum, currNum);
                    FpFormClientHelper.setDataFormula(cell, isActual);
                    FpFormClientHelper.setCellEditor(cell, currNum, currInfoMap, numFmtMap);
                }
            }
        }
        try {
            info.setZipData(ZipKDF.pack((KDF)kdf));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public static void initProcessUI(IReportProcess editDataUI, RptTablePane pnlTables, FpFormInfo info, String oprtState) throws BOSException {
        if (pnlTables == null || info == null) {
            return;
        }
        boolean isAddNew = oprtState.equals(OprtState.ADDNEW);
        boolean isActual = FpDataTypeEnum.A.equals((Object)info.getDataType());
        String currNum = info.getCurrency().getNumber();
        String periodNum = info.getBgPeriod().getNumber();
        Map currInfoMap = FpFormClientHelper.getCurrencyInfoMap();
        HashMap numFmtMap = new HashMap();
        RptSheet sheet = null;
        RptSheetParamInfo sheetParam = null;
        KDTable table = null;
        ICell cell = null;
        ArrayList sheets = pnlTables.getSheets();
        for (int index = sheets.size() - 1; index >= 0; --index) {
            sheet = (RptSheet)sheets.get(index);
            table = sheet.getTable();
            if (isAddNew) {
                sheetParam = editDataUI.processCreat(sheet.getId());
                sheet.setParams(sheetParam);
                info.getSheetParam().add(sheetParam);
            }
            int rowCount = table.getBody().size();
            for (int i = 0; i < rowCount; ++i) {
                int colCount = table.getColumnCount();
                for (int j = 0; j < colCount; ++j) {
                    cell = table.getCell(i, j);
                    FpFormClientHelper.setItemFormula(cell, periodNum, currNum);
                    FpFormClientHelper.setDataFormula(cell, isActual);
                    FpFormClientHelper.setCellEditor(cell, currNum, currInfoMap, numFmtMap);
                }
            }
        }
    }

    private static boolean hasItemFormula(ICell cell) {
        return cell != null && cell.getUserObject() != null && cell.getUserObject() instanceof RptCell && ((RptCell)cell.getUserObject()).getItemFormula() != null;
    }

    private static void setItemFormula(ICell cell, String periodNum, String currNum) throws ParserException {
        if (FpFormClientHelper.hasItemFormula(cell)) {
            RptCell rptCell = (RptCell)cell.getUserObject();
            ItemFormula itemFormula = rptCell.getItemFormula();
            String formula = itemFormula.getFormula();
            if (EmptyUtil.isEmpty((String)formula)) {
                return;
            }
            String isTemplateItemFormula = itemFormula.getExt("isTemplateItemFormula");
            if (EmptyUtil.isEmpty((String)isTemplateItemFormula) || !Boolean.valueOf(isTemplateItemFormula).booleanValue()) {
                return;
            }
            FpItemFormulaParser parser = new FpItemFormulaParser(formula);
            parser.parse();
            String[] params = parser.getParams();
            if (params == null || params.length != 5) {
                return;
            }
            boolean isNotFull = false;
            if (EmptyUtil.isEmpty((String)parser.getPeriod())) {
                params[2] = periodNum;
                isNotFull = true;
            }
            if (EmptyUtil.isEmpty((String)parser.getCurrency())) {
                params[4] = currNum;
                isNotFull = true;
            }
            if (isNotFull) {
                formula = new StringBuffer("=FpItem(\"" + params[0] + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + params[3] + "\",\"" + params[4] + "\")").toString();
                rptCell.setItemFormula(formula);
            }
        }
    }

    private static void setCellEditor(ICell cell, String currencyNum, Map currInfoMap, Map numFmtMap) {
        if (cell == null) {
            return;
        }
        if (!FpFormClientHelper.hasItemFormula(cell)) {
            return;
        }
        String itemFormula = FpHelper.getItemFormula(cell);
        if (!EmptyUtil.isEmpty((String)itemFormula)) {
            FpItemFormulaParser parser = new FpItemFormulaParser(itemFormula);
            currencyNum = parser.getCurrency();
        }
        KDFormattedTextField txtField = new KDFormattedTextField();
        txtField.setDataType(1);
        txtField.setDataVerifierType(12);
        int precision = 2;
        if (currInfoMap.containsKey(currencyNum)) {
            CurrencyInfo currencyInfo = (CurrencyInfo)currInfoMap.get(currencyNum);
            precision = currencyInfo.getPrecision();
        }
        txtField.setPrecision(precision);
        txtField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)txtField);
        cell.setEditor((ICellEditor)editor);
        String numFmt = null;
        if (numFmtMap.containsKey(currencyNum)) {
            numFmt = (String)numFmtMap.get(currencyNum);
        } else {
            numFmt = CurrencyUtil.getNumberFtm((int)precision);
            numFmtMap.put(currencyNum, numFmt);
        }
        cell.getStyleAttributes().setNumberFormat(numFmt);
    }

    private static void setDataFormula(ICell cell, boolean isActual) {
        if (cell == null) {
            return;
        }
        if (FpFormClientHelper.hasItemFormula(cell)) {
            RptCell rptCell = (RptCell)cell.getUserObject();
            ItemFormula itemFormula = rptCell.getItemFormula();
            String fpDataFormula = itemFormula.getExt("FpDataFormula");
            String fpActualFormula = itemFormula.getExt("FpActualFormula");
            if (isActual) {
                if (EmptyUtil.isEmpty((String)fpActualFormula)) {
                    cell.setExpressions(null);
                } else {
                    cell.setExpressions(fpActualFormula);
                }
            } else if (EmptyUtil.isEmpty((String)fpDataFormula)) {
                cell.setExpressions(null);
            } else {
                cell.setExpressions(fpDataFormula);
            }
        } else if (cell.getValue() != null && cell.getValue() instanceof FpFormulaObject) {
            FpFormulaObject formula = (FpFormulaObject)cell.getValue();
            cell.setExpressions(formula.getFpDataFormula());
            cell.setValue(null);
        }
    }

    public static boolean setTableFormula(RptSheet sheet, FpFormInfo info) throws BOSException, EASBizException {
        if (sheet == null || info == null) {
            return false;
        }
        boolean isFormula = false;
        ICell cell = null;
        RptCell rptCell = null;
        String formula = null;
        String[] params = null;
        FpFormulaObject fpFormula = null;
        KDTable fpTable = sheet.getTable();
        int rowCount = fpTable.getBody().size();
        for (int i = 0; i < rowCount; ++i) {
            int colCount = fpTable.getColumnCount();
            for (int j = 0; j < colCount; ++j) {
                cell = fpTable.getCell(i, j);
                if (FpFormClientHelper.hasItemFormula(cell)) {
                    rptCell = (RptCell)cell.getUserObject();
                    isFormula = false;
                    params = FpHelper.getItemParams(cell);
                    if (params == null) continue;
                    if (params[2] == null || params[2].trim().length() == 0) {
                        params[2] = info.getBgPeriod().getNumber();
                        isFormula = true;
                    }
                    if (params[4] == null || params[4].trim().length() == 0) {
                        params[4] = info.getCurrency().getNumber();
                        isFormula = true;
                    }
                    if (isFormula) {
                        formula = new StringBuffer("=FpItem(\"" + params[0] + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + params[3] + "\",\"" + params[4] + "\")").toString();
                        rptCell.setItemFormula(formula);
                    }
                }
                if (cell.getExpressions() != null && cell.getValue() != null && cell.getValue() instanceof FpFormulaObject) {
                    fpFormula = (FpFormulaObject)cell.getValue();
                    fpTable.getCell(i, j).setExpressions(fpFormula.getFpDataFormula());
                    fpTable.getCell(i, j).setValue((Object)Constants.ZERO);
                    continue;
                }
                fpTable.getCell(i, j).setExpressions(null);
            }
        }
        return true;
    }

    public static void setCalculateExpression(RptTablePane pnlTables) throws BOSException {
        RptSheet sheet = null;
        KDTable table = null;
        int count = pnlTables.getSheetCount();
        for (int i = 0; i < count; ++i) {
            sheet = pnlTables.getSheet(i);
            table = sheet.getTable();
            FpFormClientHelper.setCalculateExpression(table);
        }
    }

    private static void setCalculateExpression(KDTable table) throws BOSException {
        Map map = FpFormClientHelper.getMainItemAndCellMap(table);
        FormulaExpressionCalc cacl = new FormulaExpressionCalc((TreeMap)map);
        cacl.run();
        FpFormClientHelper.setCalculateExpression(table, cacl.getResult());
        table.getScriptManager().setAutoRun(true);
    }

    private static Map getMainItemAndCellMap(KDTable table) throws ParserException {
        TreeMap<String, String> map = new TreeMap<String, String>();
        int rowCount = table.getBody().size();
        int colCount = table.getColumnCount();
        ICell cell = null;
        String fpFormula = null;
        String range = null;
        FpItemFormulaParser parser = null;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                cell = table.getCell(i, j);
                if (cell == null || cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell) || (fpFormula = FpHelper.getItemFormula(cell)) == null) continue;
                range = TableToolkit.xy2range((int)cell.getColumnIndex(), (int)cell.getRowIndex());
                parser = new FpItemFormulaParser(fpFormula);
                parser.parse();
                if (!parser.isOnlyHasItem() || map.containsKey(fpFormula)) continue;
                map.put(fpFormula, range);
            }
        }
        return map;
    }

    private static void setCalculateExpression(KDTable table, Map expMap) throws BOSException {
        if (table == null || expMap == null || expMap.size() <= 0) {
            return;
        }
        Map itemMap = FpFormClientHelper.getFpItemInfoMap();
        int rowCount = table.getBody().size();
        int colCount = table.getColumnCount();
        ICell cell = null;
        String fpFormula = null;
        FpItemFormulaParser parse = null;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                cell = table.getCell(i, j);
                if (cell == null || cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell) || (fpFormula = FpHelper.getItemFormula(cell)) == null) continue;
                parse = new FpItemFormulaParser(fpFormula);
                parse.parse();
                if (!parse.isOnlyHasItem()) continue;
                String fpItem = parse.getItem();
                if (itemMap.containsKey(fpItem) && !((FpItemInfo)itemMap.get(fpItem)).isIsLeaf()) {
                    cell.getStyleAttributes().setLocked(true);
                }
                if (TableToolkit.xy2range((int)cell.getColumnIndex(), (int)cell.getRowIndex()).equals((String)expMap.get(fpFormula))) continue;
                cell.getStyleAttributes().setLocked(true);
                if (!expMap.containsKey(fpFormula)) continue;
                cell.setExpressions("=" + (String)expMap.get(fpFormula));
            }
        }
    }

    public static void initCurrency(KDComboBox comboCurrency, String ouId, boolean isSelBaseCurrency) throws EASBizException, BOSException {
        if (comboCurrency == null) {
            return;
        }
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        if (iCurrency != null) {
            CurrencyCollection col = iCurrency.getCurrencyCollection(true);
            comboCurrency.removeAllItems();
            if (col != null && col.size() > 0) {
                comboCurrency.addItems(col.toArray());
            }
            if (isSelBaseCurrency && ouId != null) {
                CurrencyInfo currency = FpFormClientHelper.getBaseCurrency(ouId);
                if (currency != null) {
                    UIUtil.setSelectObject((KDComboBox)comboCurrency, (Object)currency);
                } else {
                    comboCurrency.setSelectedIndex(-1);
                }
            }
        }
    }

    private static CurrencyInfo getBaseCurrency(String id) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        FullOrgUnitInfo orgUnitInfo;
        if (id == null) {
            return null;
        }
        CurrencyInfo currency = null;
        IFullOrgUnit fullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        if (fullOrgUnit != null && (orgUnitInfo = fullOrgUnit.getFullOrgUnitInfo((IObjectPK)(pk = new ObjectUuidPK(id)))) != null && orgUnitInfo.isIsCompanyOrgUnit()) {
            currency = FpFormClientHelper.getOrgBaseCurrency(orgUnitInfo.getId().toString());
        }
        return currency;
    }

    private static CurrencyInfo getOrgBaseCurrency(String id) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        CompanyOrgUnitInfo company;
        if (id == null) {
            return null;
        }
        CurrencyInfo currency = null;
        ICompanyOrgUnit icompany = CompanyOrgUnitFactory.getRemoteInstance();
        if (icompany != null && (company = icompany.getCompanyOrgUnitInfo((IObjectPK)(pk = new ObjectUuidPK(id)))) != null) {
            currency = company.getBaseCurrency();
        }
        return currency;
    }

    public static Map getAdjustRootCount() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String sql = "SELECT FAdjustRootID adjustRootId, COUNT(FAdjustRootID) cnt FROM T_FPL_FpForm GROUP BY FAdjustRootID";
        try {
            ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
            IRowSet rs = exec.executeSQL();
            while (rs.next()) {
                map.put(rs.getString("adjustRootId"), new Integer(rs.getInt("cnt")));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return map;
    }
}

