/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUI;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckStatusEnum;
import com.kingdee.eas.fi.rpt.PostilCollection;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.client.RptCoreMenuStrategy;
import com.kingdee.eas.fi.rpt.client.RptMenuStrategy;
import com.kingdee.eas.fi.rpt.client.RptMuliReportModel;
import com.kingdee.eas.fi.rpt.client.RptStrategyManager;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fpl.FpConstants;
import com.kingdee.eas.fm.fpl.FpDataTypeEnum;
import com.kingdee.eas.fm.fpl.FpFormDataSourceEnum;
import com.kingdee.eas.fm.fpl.FpFormException;
import com.kingdee.eas.fm.fpl.FpFormFacadeFactory;
import com.kingdee.eas.fm.fpl.FpFormFactory;
import com.kingdee.eas.fm.fpl.FpFormHelper;
import com.kingdee.eas.fm.fpl.FpFormInfo;
import com.kingdee.eas.fm.fpl.FpFormStateEnum;
import com.kingdee.eas.fm.fpl.FpTemplateCollection;
import com.kingdee.eas.fm.fpl.FpTemplateFactory;
import com.kingdee.eas.fm.fpl.FpTemplateInfo;
import com.kingdee.eas.fm.fpl.IFpForm;
import com.kingdee.eas.fm.fpl.IFpFormFacade;
import com.kingdee.eas.fm.fpl.IFpTemplate;
import com.kingdee.eas.fm.fpl.client.AbstractFpFormEditUI;
import com.kingdee.eas.fm.fpl.client.ActualMenuStrategy;
import com.kingdee.eas.fm.fpl.client.FpAccreditMenuStrategy;
import com.kingdee.eas.fm.fpl.client.FpAdjustMenuStrategy;
import com.kingdee.eas.fm.fpl.client.FpAntiAuditMenuStrategy;
import com.kingdee.eas.fm.fpl.client.FpAuditMenuStrategy;
import com.kingdee.eas.fm.fpl.client.FpAuditViewStrategy;
import com.kingdee.eas.fm.fpl.client.FpClientHelper;
import com.kingdee.eas.fm.fpl.client.FpEditMenuStrategy;
import com.kingdee.eas.fm.fpl.client.FpFormClientHelper;
import com.kingdee.eas.fm.fpl.client.FpFormProcessUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FpFormEditUI
extends AbstractFpFormEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FpFormEditUI.class);
    private FullOrgUnitInfo ouInfo = null;
    private RptStrategyManager rptStrategyManager = null;
    private String rptMenuType = "fpEditType";
    private RptMuliReportModel rptMuliReportModel = new RptMuliReportModel();
    private BgPeriodDialog periodF7 = null;
    private boolean isLoad = true;

    public void onLoad() throws Exception {
        if (this.getUIContext().get("orgUnitInfo") != null) {
            this.ouInfo = (FullOrgUnitInfo)this.getUIContext().get("orgUnitInfo");
        }
        if (this.getUIContext().get("fpFormType") != null) {
            this.rptMenuType = (String)this.getUIContext().get("fpFormType");
        }
        super.onLoad();
        this.setUIProp();
        boolean openReport = false;
        if (this.getUIContext().get("isOpenReport") != null) {
            openReport = (Boolean)this.getUIContext().get("isOpenReport");
        }
        if (openReport) {
            String openReportState = this.getUIContext().get("OpenReportState").toString();
            boolean isActual = (Boolean)this.getUIContext().get("isBizActual");
            this.openReportUI(openReportState, isActual, this.rptMenuType);
        } else if (this.getUIContext().get("Owner") instanceof MultiApproveUI && this.getUIContext().get("isNewWindow") != null && ((Boolean)this.getUIContext().get("isNewWindow")).booleanValue()) {
            this.openReportWorkUI(OprtState.VIEW);
        }
    }

    private void setUIProp() throws BOSException, EASBizException {
    }

    public void setUITitle(String title) {
        if (this.rptMenuType != null) {
            if (this.rptMenuType.equals("fpAuditType")) {
                title = EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"isAudit");
            } else if (this.rptMenuType.equals("fpAntiAuditType")) {
                title = EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"isUnAudit");
            } else if (this.rptMenuType.equals("ActualEditType")) {
                title = EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"isActual");
            }
        }
        super.setUITitle(title);
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionCancel.setVisible(false);
        this.comboFpCycle.setEnabled(false);
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.comboFpTemplate.setEnabled(false);
            this.comboCurrency.setEnabled(false);
            this.prmtFpPeriod.setEnabled(false);
            this.txtAreaRemark.setEnabled(false);
        }
    }

    public IObjectValue getEditDataObject() {
        return this.editData;
    }

    public FpFormInfo getReportInfo() {
        return this.editData;
    }

    public void setReportInfo(FpFormInfo info) {
        this.setDataObject((IObjectValue)info);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FpFormFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        FpFormInfo info = new FpFormInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setOrgUnit(this.ouInfo);
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setPeriodType(RptPeriodTypeEnum.DAILY);
        info.setCompany(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        info.setState(FpFormStateEnum.EDITING);
        info.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        info.setCheckedStatus(CheckStatusEnum.UNCHECKED);
        info.setSource(FpFormDataSourceEnum.LOCAL_CREATE);
        info.setSourceType(RptSrcTypeEnum.NORMAL);
        info.setVersionNo(String.valueOf(FpConstants.ONE));
        info.setAdjustRootID(info.getId().toString());
        info.setStartDate(new Date());
        info.setEndDate(new Date());
        return info;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("fpTemplate.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("fpCycle"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("source"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("sheetParam.currency.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.*"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.creator.*"));
        return sic;
    }

    public boolean getIsCacl() {
        return false;
    }

    public void loadFields() {
        if (this.periodF7 == null) {
            this.periodF7 = new BgPeriodDialog((CoreUIObject)this);
        }
        this.prmtFpPeriod.setSelector((KDPromptSelector)this.periodF7);
        try {
            FullOrgUnitInfo ouInfo1 = this.editData.getOrgUnit();
            this.fillComboFpTemplate(ouInfo1.getId().toString());
            FpFormClientHelper.initCurrency(this.comboCurrency, ouInfo1.getId().toString(), true);
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.handUIException(e);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.handUIException(e);
        }
        this.isLoad = true;
        super.loadFields();
        FpClientHelper.setSelectObject(this.comboFpTemplate, this.getReportInfo().getFpTemplate());
        FpClientHelper.setSelectObject(this.comboFpCycle, this.getReportInfo().getFpCycle());
        FpClientHelper.setSelectObject(this.comboCurrency, this.getReportInfo().getCurrency());
        this.isLoad = false;
        if (this.getParent() != null && this.getParent() instanceof KDPanel) {
            KDToolBar toolBar = this.getUIToolBar();
            toolBar.setVisible(false);
        }
    }

    private void fillComboFpTemplate(String ouId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)ouId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("number"));
        IFpTemplate iFpTemplate = FpTemplateFactory.getRemoteInstance();
        FpTemplateCollection coll = iFpTemplate.getFpTemplateCollection(evi);
        this.comboFpTemplate.addItems(coll.toArray());
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtName);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboFpTemplate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboFpCycle);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtFpPeriod);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboCurrency);
    }

    protected void comboFpTemplate_itemStateChanged(ItemEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.VIEW) || this.isLoad) {
            return;
        }
        if (e.getStateChange() == 2) {
            return;
        }
        FpTemplateInfo info = (FpTemplateInfo)this.comboFpTemplate.getSelectedItem();
        if (info != null && info.getFpCycle() != null) {
            this.comboFpCycle.setSelectedItem((Object)info.getFpCycle());
            this.prmtFpPeriod.setValue(null);
            this.periodF7.setBgPeriodEnum(info.getFpCycle());
            this.prmtFpPeriod.setSelector((KDPromptSelector)this.periodF7);
        }
    }

    private void openReportUI(String reportState, boolean isActual, String formType) throws Exception {
        String reportID = (String)this.getUIContext().get("ID");
        UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
        uiContext.put((Object)"ID", (Object)reportID);
        uiContext.put((Object)"self", (Object)this);
        uiContext.put((Object)"saveUI", (Object)this.getMetaDataPK().getFullName());
        uiContext.put((Object)"SYSTEMTIME", (Object)String.valueOf(System.currentTimeMillis()));
        uiContext.put((Object)"isBizActual", (Object)isActual);
        uiContext.put((Object)"fpFormType", (Object)formType);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getProcessUI(), (Map)uiContext, null, reportState);
        uiWindow.show();
    }

    private void openReportWorkUI(String reportState) throws UIException {
        UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
        String reportID = (String)this.getUIContext().get("ID");
        uiContext.put((Object)"ID", (Object)reportID);
        uiContext.put((Object)"self", (Object)this);
        uiContext.put((Object)"saveUI", (Object)this.getMetaDataPK().getFullName());
        uiContext.put((Object)"isMultiApprove", this.getUIContext().get("isMultiApprove"));
        uiContext.put((Object)"isNewWindow", this.getUIContext().get("isNewWindow"));
        uiContext.put((Object)"isBizActual", (Object)Boolean.FALSE);
        MultiApproveUI multiApproveUI = (MultiApproveUI)this.getUIContext().get("Owner");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getProcessUI(), (Map)uiContext, null, reportState);
        multiApproveUI.billUIChanged((CoreUIObject)uiWindow.getUIObject());
        multiApproveUI.setNewWindowShow(false);
        uiWindow.show();
    }

    public String getProcessUI() {
        return FpFormProcessUI.class.getName();
    }

    public RptStrategyManager getRptStrategyManager() {
        if (this.rptStrategyManager == null) {
            this.rptStrategyManager = new RptStrategyManager();
            RptCoreMenuStrategy rptReportMenuStrategy = this.getRptMenuStrategy();
            this.rptStrategyManager.setRptMenuStartegy((RptMenuStrategy)rptReportMenuStrategy);
            this.rptStrategyManager.setRptMuliReportModel(this.rptMuliReportModel);
            this.rptStrategyManager.setCslParamStartegy(false);
        }
        return this.rptStrategyManager;
    }

    private RptCoreMenuStrategy getRptMenuStrategy() {
        boolean isShowAudit = true;
        if (this.getUIContext().get("fpFormShowAudit") != null) {
            isShowAudit = (Boolean)this.getUIContext().get("fpFormShowAudit");
        }
        Object rptMenuStrategy = null;
        rptMenuStrategy = this.rptMenuType == null ? new RptCoreMenuStrategy() : (this.rptMenuType.equals("fpEditType") ? new FpEditMenuStrategy() : (this.rptMenuType.equals("fpAuditType") ? (isShowAudit ? new FpAuditMenuStrategy() : new FpAuditViewStrategy()) : (this.rptMenuType.equals("fpAntiAuditType") ? (isShowAudit ? new FpAntiAuditMenuStrategy() : new FpAuditViewStrategy()) : (this.rptMenuType.equals("fpAdjustType") ? new FpAdjustMenuStrategy() : (this.rptMenuType.equals("ActualEditType") ? new ActualMenuStrategy() : (this.rptMenuType.equals("fpAccreditType") ? new FpAccreditMenuStrategy() : new RptCoreMenuStrategy()))))));
        return rptMenuStrategy;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            this.storeFields();
            this.verifyInput(null);
            this.setOprtState(OprtState.VIEW);
            this.uiWindow.hide();
            String templateId = this.editData.getFpTemplate().getId().toString();
            IFpTemplate iFpTemplate = FpTemplateFactory.getRemoteInstance();
            FpTemplateInfo templateInfo = iFpTemplate.getFpTemplateInfo((IObjectPK)new ObjectUuidPK(templateId));
            this.editData.setZipData(templateInfo.getKdtData());
            this.openReportUI(OprtState.ADDNEW, false, this.rptMenuType);
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            this.storeFields();
            this.verifyInput(null);
            IFpForm iFpForm = (IFpForm)this.getBizInterface();
            iFpForm.saveSimpleInfo(this.editData);
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            this.setDataObject(this.getValue((IObjectPK)pk));
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
        }
        FpClientHelper.refreshFpFormList((CoreUI)this);
    }

    public void setData(byte[] data) {
        this.getReportInfo().setZipData(data);
    }

    public byte[] getData() {
        return this.getReportInfo().getZipData();
    }

    private boolean verifyProcessData() throws EASBizException, BOSException, Exception {
        String msg = ((IFpForm)this.getBizInterface()).checkFormulaDup(this.editData);
        if (msg != null && msg.trim().length() > 0) {
            String title = EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpItemResource", (String)"msgTitle");
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"Title", (Object)title);
            SimpleNotePad.showMessageByModel((UIContext)ctx, (String)msg);
            SysUtil.abort();
        }
        return true;
    }

    public VirtualSheetParamInfo save() throws Exception {
        FpDataTypeEnum dataType = this.getDataType();
        this.editData.setDataType(dataType);
        this.verifyProcessData();
        ObjectUuidPK pk = new ObjectUuidPK(this.getReportInfo().getId());
        IFpForm iFpForm = (IFpForm)this.getBizInterface();
        iFpForm.submit((IObjectPK)pk, (CoreBaseInfo)this.getReportInfo());
        this.setReportInfo(iFpForm.getFpFormInfo((IObjectPK)pk, this.getSelectors()));
        FpClientHelper.refreshFpFormList((CoreUI)this);
        return this.getReportInfo();
    }

    private FpDataTypeEnum getDataType() {
        String fpFormDataType = (String)this.getUIContext().get("dataType");
        FpDataTypeEnum dataType = FpDataTypeEnum.getEnum(fpFormDataType);
        if (dataType == null) {
            dataType = FpDataTypeEnum.P;
        }
        return dataType;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        Object obj = this.getUIContext().get("fpFormCollectType");
        if (obj != null && obj instanceof String) {
            String collType = (String)obj;
            return this.getCollectValue(pk, collType);
        }
        FpFormInfo info = (FpFormInfo)super.getValue(pk);
        BgPeriodEnum periodEnum = info.getFpCycle();
        BgPeriodInfo periodInfo = info.getBgPeriod();
        info.setPeriodType(this.tran2RptPeriodTypeEnum(periodEnum));
        info.setYear(periodInfo.getYear());
        info.setPeriod(this.tran2RptPeriod(periodEnum, periodInfo));
        info.setDataType(this.getDataType());
        info.setStartDate(new Date());
        info.setEndDate(new Date());
        FpDataTypeEnum dataType = this.getDataType();
        if (dataType.equals((Object)FpDataTypeEnum.ADJ) && (info.getState().equals((Object)FpFormStateEnum.APPROVED) || info.getState().equals((Object)FpFormStateEnum.EXECUTING))) {
            dataType = FpDataTypeEnum.P;
        }
        if (!info.getState().equals((Object)FpFormStateEnum.HISTORY)) {
            FpFormHelper.setFpData(null, info, dataType);
        }
        return info;
    }

    private IObjectValue getCollectValue(IObjectPK pk, String collType) throws BOSException, EASBizException {
        if (collType.equals("fpOrgNormalCollect") || collType.equals("fpOrgAdjustCollect") || collType.equals("fpOrgActualCollect")) {
            List orgList = (List)this.getUIContext().get("subOrgIdList");
            IFpFormFacade facade = FpFormFacadeFactory.getRemoteInstance();
            return facade.getFormOrgCollectValue(pk, orgList, collType);
        }
        if (collType.equals("fpPeriodNormalCollect")) {
            List periodList = (List)this.getUIContext().get("subPeriodIdList");
            IFpFormFacade facade = FpFormFacadeFactory.getRemoteInstance();
            return facade.getFormPeriodCollectValue(pk, periodList);
        }
        throw new FpFormException(FpFormException.COLLECTTYPEERROR, new Object[]{collType});
    }

    private short tran2RptPeriod(BgPeriodEnum periodEnum, BgPeriodInfo period) {
        if (periodEnum == null) {
            return Short.valueOf("0");
        }
        switch (periodEnum.getValue()) {
            case 1: {
                return new Integer(period.getYear()).shortValue();
            }
            case 2: {
                return new Integer(period.getHalfYear()).shortValue();
            }
            case 3: {
                return new Integer(period.getQuarter()).shortValue();
            }
            case 4: {
                return new Integer(period.getMonth()).shortValue();
            }
            case 5: 
            case 6: {
                return new Integer(period.getWeek()).shortValue();
            }
            case 7: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(period.getEndDate());
                int day = calendar.get(6);
                return new Integer(day).shortValue();
            }
        }
        return Short.valueOf("0");
    }

    private RptPeriodTypeEnum tran2RptPeriodTypeEnum(BgPeriodEnum bgPeriodEnum) {
        if (bgPeriodEnum == null) {
            return null;
        }
        switch (bgPeriodEnum.getValue()) {
            case 1: {
                return RptPeriodTypeEnum.YEARLY;
            }
            case 2: {
                return RptPeriodTypeEnum.SEMIYEARLY;
            }
            case 3: {
                return RptPeriodTypeEnum.QUARTERLY;
            }
            case 4: {
                return RptPeriodTypeEnum.MONTHLY;
            }
            case 5: 
            case 6: {
                return RptPeriodTypeEnum.WEEKLY;
            }
            case 7: {
                return RptPeriodTypeEnum.DAILY;
            }
        }
        return RptPeriodTypeEnum.YEARLY;
    }

    public Object getSheetparam(String sheetId) {
        RptSheetParamCollection params = this.editData.getSheetParam();
        if (params != null && params.size() > 0) {
            int paramsSize = params.size();
            for (int i = 0; i < paramsSize; ++i) {
                if (!params.get(i).getSheetID().trim().equals(sheetId)) continue;
                return params.get(i);
            }
        }
        return null;
    }

    public PostilCollection getRptPostilColl() {
        for (int i = 0; i < this.editData.getPostils().size(); ++i) {
            if (this.editData.getPostils().get(i).getPostilType().getValue() == 1) continue;
            this.editData.getPostils().removeObject(i);
            --i;
        }
        return this.editData.getPostils();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null) {
            throw new FpFormException(FpFormException.NOFPFORMINFO);
        }
        int re = MsgBox.showConfirm3((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"deleteForm") + this.editData.getNumber() + EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"deleteFormInfo")));
        if (re == 1 || re == 2) {
            return;
        }
        IFpFormFacade ifpFormfacade = FpFormFacadeFactory.getRemoteInstance();
        if (ifpFormfacade != null && this.editData == null) {
            if (ifpFormfacade.delete(this.editData.getId().toString())) {
                this.getUIWindow().close();
            }
        } else {
            throw new FpFormException(FpFormException.NOINSTANCE);
        }
    }

    public RptSheetParamInfo processCreat(String sheetId) {
        RptSheetParamInfo newSheetParam = new RptSheetParamInfo();
        newSheetParam.setReport((VirtualSheetParamInfo)this.editData);
        newSheetParam.setSheetID(sheetId);
        newSheetParam.setCurrency(this.editData.getCurrency());
        newSheetParam.setRelaType(ReportTypeEnum.TEMPLATE);
        newSheetParam.setStartYear(0);
        newSheetParam.setEndYear(0);
        newSheetParam.setStartPeriod(0);
        newSheetParam.setEndPeriod(0);
        newSheetParam.setStatus(1);
        return newSheetParam;
    }
}

