/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fpl.FPItemDirectionEnum;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fpl.FpRptFacadeFactory;
import com.kingdee.eas.fm.fpl.FpRptItemFilterParam;
import com.kingdee.eas.fm.fpl.IFpRptFacade;
import com.kingdee.eas.fm.fpl.client.FpAnalyseUIHander;
import com.kingdee.eas.fm.fpl.client.FpRptClientHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FpFormInOutAnlysUIHandler
extends FpAnalyseUIHander {
    private static FpFormInOutAnlysUIHandler instance;

    private FpFormInOutAnlysUIHandler() throws Exception {
    }

    public static FpFormInOutAnlysUIHandler getInstatnce() throws Exception {
        if (instance == null) {
            instance = new FpFormInOutAnlysUIHandler();
        }
        return instance;
    }

    public void fillFpItemByDirect(KDTable table, FPItemDirectionEnum direction, Map map, FilterParam param) throws BOSException, EASBizException, SQLException {
        String inGroupName = this.getItemGroupName(direction.getValue());
        IRow inOutRow = table.addRow();
        inOutRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        inOutRow.getCell("item").setValue((Object)inGroupName);
        IRowSet rs = FpRptFacadeFactory.getRemoteInstance().getFpItems(direction);
        this.fillTableWithRs(table, map, inOutRow, rs);
        map.put(direction.getValue() + "RowIndex", new Integer(inOutRow.getRowIndex()));
    }

    private void fillTableWithRs(KDTable table, Map map, IRow currRow, IRowSet rs) throws SQLException {
        int colCount = table.getColumnCount();
        int inOutRowIndex = currRow.getRowIndex();
        int start = inOutRowIndex + 1;
        while (rs.next()) {
            String name = rs.getString("fname");
            String number = rs.getString("fnumber");
            String fid = rs.getString("fid");
            String parentId = rs.getString("fparentid");
            int level = rs.getInt("flevel");
            name = FpRptClientHelper.getGoodFormatName(name, level);
            IRow row = table.addRow(start++);
            int rowIndex = row.getRowIndex();
            row.getCell("item").setValue((Object)name);
            FpItemInfo iteminfo = new FpItemInfo();
            iteminfo.setNumber(number);
            iteminfo.setIsLeaf(rs.getBoolean("fisleaf"));
            iteminfo.setLevel(level);
            iteminfo.setId(BOSUuid.read((String)fid));
            iteminfo.setString("parent", parentId);
            row.setUserObject((Object)iteminfo);
            map.put(number, new Integer(rowIndex));
            for (int i = 1; i < colCount; ++i) {
                String exp = table.getCell(inOutRowIndex, i).getExpressions();
                String exp2 = TableToolkit.xy2range((int)i, (int)rowIndex);
                if (level > 1) continue;
                if (FMHelper.isEmpty((String)exp)) {
                    table.getCell(inOutRowIndex, i).setExpressions("=" + exp2);
                } else {
                    table.getCell(inOutRowIndex, i).setExpressions(exp + "+" + exp2);
                }
                table.getCell(inOutRowIndex, i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
            row.getCell("total").setExpressions("=sum(" + TableToolkit.xy2range((int)1, (int)rowIndex) + ":" + TableToolkit.xy2range((int)(colCount - 2), (int)rowIndex) + ")");
            row.getCell("total").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    public void fillData(KDTable table, FilterParam param, Map map) throws Exception {
        IRowSet rs = FpRptFacadeFactory.getRemoteInstance().getFpFormInOutAnlys(param);
        if (rs == null) {
            return;
        }
        this.fillDataByMap(table, rs, map);
    }

    private void fillDataByMap(KDTable table, IRowSet rs, Map map) throws Exception {
        while (rs.next()) {
            String item = rs.getString("fnumber");
            String periodNumber = rs.getString("fperiodnumber");
            BigDecimal fpValue = rs.getBigDecimal("FFpValue");
            if (map.get(item) == null || periodNumber == null) continue;
            int itemRowIndex = (Integer)map.get(item);
            ICell cell = table.getCell(itemRowIndex, periodNumber);
            cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            cell.setValue((Object)fpValue);
        }
    }

    public void setNumberFormat(KDTable table, String currencyId) {
        int colCount = table.getColumnCount();
        int rowCount = table.getRowCount();
        BOSUuid currencyUuid = BOSUuid.read((String)currencyId);
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 1; j < colCount; ++j) {
                FMClientHelper.currencyFormat((BOSUuid)currencyUuid, (ICell)table.getCell(i, j));
            }
        }
    }

    public void fillExpendData(KDTable table, IRow currRow, FilterParam param, String parentID) throws Exception {
        FpRptItemFilterParam myParam = (FpRptItemFilterParam)param;
        myParam.setItemID(parentID);
        IFpRptFacade fpRptFacade = FpRptFacadeFactory.getRemoteInstance();
        IRowSet rsItem = fpRptFacade.getFpItemsByParent(parentID);
        IRowSet rsData = fpRptFacade.getFpFormInOutAnlysByParent(myParam, parentID);
        HashMap map = new HashMap();
        this.fillTableWithRs(table, map, currRow, rsItem);
        this.fillDataByMap(table, rsData, map);
        this.setExpendDisplayStyle(table);
    }

    public void fillTableWithItem(KDTable table, Map map, List lstItem) throws SQLException {
        int colCount = table.getColumnCount();
        for (int i = 0; i < lstItem.size(); ++i) {
            FpItemInfo iteminfo = this.getFpItemInfo((List)lstItem.get(i));
            if (iteminfo == null) continue;
            String name = FpRptClientHelper.getGoodFormatName(iteminfo.getName(), this.getLevelByNumber(iteminfo.getNumber()));
            IRow row = table.addRow();
            int rowIndex = row.getRowIndex();
            row.getCell("item").setValue((Object)name);
            row.setUserObject((Object)iteminfo);
            map.put(iteminfo.getNumber(), new Integer(rowIndex));
            row.getCell("total").setExpressions("=sum(" + TableToolkit.xy2range((int)1, (int)rowIndex) + ":" + TableToolkit.xy2range((int)(colCount - 2), (int)rowIndex) + ")");
            row.getCell("total").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }
}

