/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.MutexUtils;
import com.kingdee.eas.fm.fpl.FpFormException;
import com.kingdee.eas.fm.fpl.FpFormFacadeFactory;
import com.kingdee.eas.fm.fpl.FpFormFactory;
import com.kingdee.eas.fm.fpl.FpFormHelper;
import com.kingdee.eas.fm.fpl.IFpFormFacade;
import com.kingdee.eas.fm.fpl.client.AbstractFpFormListUI;
import com.kingdee.eas.fm.fpl.client.FpClientHelper;
import com.kingdee.eas.fm.fpl.client.FpFormEditUI;
import com.kingdee.eas.fm.fpl.client.FpOrgDisassembleWizardUI;
import com.kingdee.eas.fm.fpl.client.FpPeriodCollSelectorUI;
import com.kingdee.eas.fm.fpl.client.FpPeriodDisassembleWizardUI;
import com.kingdee.eas.fm.fpl.client.FpSubOrgUnitSelectUI;
import com.kingdee.eas.fm.fpl.client.FpTemplateHandler;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class FpFormListUI
extends AbstractFpFormListUI {
    private static final Logger logger = CoreUIObject.getLogger(FpFormListUI.class);
    IFpFormFacade iFpFormFacade = null;
    private CtrlUnitInfo currCuInfo = null;

    public FpFormListUI() throws Exception {
        if (this.iFpFormFacade == null) {
            this.iFpFormFacade = FpFormFacadeFactory.getRemoteInstance();
        }
    }

    public void onLoad() throws Exception {
        if (this.currCuInfo == null) {
            this.currCuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        super.onLoad();
        this.initDataStatus();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.comboxOrgType.setSelectedItem((Object)OrgViewType.COSTCENTER);
        this.comboxOrgType.setEnabled(false);
        this.menuItemFormEdit.setIcon(EASResource.getIcon((String)"imgTbtn_modifyformat"));
        this.menuItemFormSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.menuItemFormGroupSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_referbatch"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.menuItemAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.menuItemOrgCollect.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.menuItemPeriodColl.setIcon(EASResource.getIcon((String)"imgTbtn_collect1"));
        this.menuItemOrgDisassemble.setIcon(EASResource.getIcon((String)"imgTbtn_sortstandard"));
        this.menuItemPeriodDisassemble.setIcon(EASResource.getIcon((String)"imgTbtn_disassemble"));
        this.menuItemExecute.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
        this.menuItemAntiExecute.setIcon(EASResource.getIcon((String)"imgTbtn_faffirm"));
        this.btnFormEdit.setIcon(EASResource.getIcon((String)"imgTbtn_modifyformat"));
        this.btnFormSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnFormGroupSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_referbatch"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.btnFormDataAccredit.setIcon(EASResource.getIcon((String)"imgTbtn_dataaccredit"));
        this.btnOrgCollect.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnPeriodCollect.setIcon(EASResource.getIcon((String)"imgTbtn_collect1"));
        this.btnOrgDisassemble.setIcon(EASResource.getIcon((String)"imgTbtn_sortstandard"));
        this.btnPeriodDisassemble.setIcon(EASResource.getIcon((String)"imgTbtn_disassemble"));
        this.btnExecute.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
        this.btnAntiExecute.setIcon(EASResource.getIcon((String)"imgTbtn_faffirm"));
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
    }

    private void initDataStatus() {
        this.actionAudit.setVisible(false);
        this.actionAntiAudit.setVisible(false);
        this.actionFormDataAccredit.setVisible(false);
        this.separator1.setVisible(false);
        this.actionAttachment.setEnabled(true);
        this.actionAttachment.setVisible(true);
        this.btnAttachment.setEnabled(true);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"orgUnitInfo", (Object)this.getFullOuInfo());
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        HashSet<String> state = new HashSet<String>();
        state.add("approved");
        state.add("executing");
        state.add("editing");
        state.add("submited");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", state, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getOuId()));
        viewInfo.setFilter(filter);
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        return filter;
    }

    protected void execQuery() {
        super.execQuery();
    }

    protected String getEditUIName() {
        return FpFormEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FpFormFactory.getRemoteInstance();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        super.actionAddNew_actionPerformed(e);
    }

    private List getSelectedActiveRows() {
        ArrayList<Integer> aryList = new ArrayList<Integer>();
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range != null) {
            int rowCount = range.size();
            for (int i = 0; i < rowCount; ++i) {
                int rowEnd;
                KDTSelectBlock block = (KDTSelectBlock)range.get(i);
                int rowBegin = block.getBeginRow();
                if (rowBegin != (rowEnd = block.getEndRow())) {
                    for (int j = 0; j < rowEnd - rowBegin + 1; ++j) {
                        int tempVal = rowBegin + j;
                        aryList.add(new Integer(tempVal));
                    }
                    continue;
                }
                aryList.add(new Integer(rowBegin));
            }
        }
        return aryList;
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        List selectedList = this.getSelectedActiveRows();
        if (selectedList.size() > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"IsNotSupportMulti"));
        }
        super.actionAttachment_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        this.openReport(e, OprtState.VIEW);
    }

    public void actionFormEdit_actionPerformed(ActionEvent e) throws Exception {
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (FpFormHelper.hasCtrlRecord(null, id)) {
            throw new FpFormException(FpFormException.CANNOTDELETEHASCTRLRECORD);
        }
        this.openReport(e, OprtState.EDIT);
    }

    private void openReport(ActionEvent e, String reportState) throws UIException {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"isOpenReport", (Object)Boolean.TRUE);
        uiContext.put((Object)"OpenReportState", (Object)reportState);
        uiContext.put((Object)"isBizActual", (Object)Boolean.FALSE);
        uiContext.put((Object)"dataType", (Object)"P");
        uiContext.put((Object)"fpFormType", (Object)"fpEditType");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.hide();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = FpFormListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName()) && !this.isFirstDefaultQuery()) {
            CommonQueryDialog dlg = new CommonQueryDialog();
            dlg.setOwner((Component)((Object)this));
            dlg.setEntityViewInfo(this.mainQuery);
            dlg.setQueryObjectPK(this.mainQueryPK);
            dlg.setParentUIClassName(this.getMetaDataPK().getFullName());
            dlg.setShowFilter(true);
            dlg.setShowSorter(true);
            dlg.setShowToolbar(true);
            if (dlg.show()) {
                this.mainQuery = dlg.getEntityViewInfoResult();
                this.tblMain.refresh();
            }
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        super.actionEdit_actionPerformed(e);
    }

    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeOrgUnit_valueChanged(e);
        this.setButtonState();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.setButtonState();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.setButtonState();
    }

    private void setButtonState() {
        this.setInitActionEnable(false);
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null) {
            BizEnumValueInfo enumValueInfo = (BizEnumValueInfo)row.getCell("state").getValue();
            String enumValue = enumValueInfo.getString();
            if (enumValue.equals("editing") || enumValue.equals("adjusting")) {
                this.setInitActionEnable(true);
                this.actionAudit.setEnabled(false);
                this.actionAntiAudit.setEnabled(false);
                this.actionExecute.setEnabled(false);
                this.actionAntiExecute.setEnabled(false);
            } else if (enumValue.equals("submited")) {
                this.actionView.setEnabled(true);
                this.actionEdit.setEnabled(true);
                this.actionFormEdit.setEnabled(true);
                this.actionRemove.setEnabled(true);
                this.actionAudit.setEnabled(true);
                this.actionOrgDisassemble.setEnabled(true);
                this.actionPeriodDisassemble.setEnabled(true);
            } else if (enumValue.equals("approved")) {
                this.actionView.setEnabled(true);
                this.actionAntiAudit.setEnabled(true);
                this.actionExecute.setEnabled(true);
                this.actionOrgDisassemble.setEnabled(true);
                this.actionPeriodDisassemble.setEnabled(true);
            } else if (enumValue.equals("executing")) {
                this.actionView.setEnabled(true);
                this.actionAntiExecute.setEnabled(true);
                this.actionOrgDisassemble.setEnabled(true);
                this.actionPeriodDisassemble.setEnabled(true);
            } else if (enumValue.equals("history")) {
                this.actionView.setEnabled(true);
            }
        }
    }

    public void setInitActionEnable(boolean isEnable) {
        this.actionView.setEnabled(isEnable);
        this.actionEdit.setEnabled(isEnable);
        this.actionRemove.setEnabled(isEnable);
        this.actionFormEdit.setEnabled(isEnable);
        this.actionAudit.setEnabled(isEnable);
        this.actionAntiAudit.setEnabled(isEnable);
        this.actionFormSubmit.setEnabled(isEnable);
        this.actionFormGroupSubmit.setEnabled(isEnable);
        this.actionOrgCollect.setEnabled(isEnable);
        this.actionPeriodCollect.setEnabled(isEnable);
        this.actionOrgDisassemble.setEnabled(isEnable);
        this.actionPeriodDisassemble.setEnabled(isEnable);
        this.actionExecute.setEnabled(isEnable);
        this.actionAntiExecute.setEnabled(isEnable);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        this.checkSelected();
        BgClientHelper.isMutex((Component)((Object)this), (String)this.getSelectedKeyValue(), (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null) {
            String id = row.getCell("id").getValue().toString();
            String number = row.getCell("number").getValue().toString();
            if (!this.isConfirmAction("deleteForm", new String[]{number})) {
                return;
            }
            IFpFormFacade ifpFormFacade = FpFormFacadeFactory.getRemoteInstance();
            ifpFormFacade.delete(id);
            this.refresh(e);
        }
    }

    private boolean isConfirmAction(String resName, Object[] objects) {
        String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)resName), objects);
        int re = MsgBox.showConfirm3((Component)((Object)this), (String)msg);
        return re != 1 && re != 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionFormSubmit_actionPerformed(ActionEvent e) throws Exception {
        String id;
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        String number = null;
        if (row != null) {
            number = row.getCell("number").getValue().toString();
        }
        if (!this.isConfirmAction("submitFormWork", new String[]{number})) {
            return;
        }
        if (this.iFpFormFacade == null) {
            this.iFpFormFacade = FpFormFacadeFactory.getRemoteInstance();
        }
        if (row != null && this.iFpFormFacade != null && (id = row.getCell("id").getValue().toString()) != null && id.trim().length() > 0) {
            MutexUtils.requestMutex((CoreUI)this, (String)id);
            try {
                String msg = null;
                String formName = row.getCell("name").getValue().toString();
                if (this.iFpFormFacade.submit(id)) {
                    msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"submitFormSucceed"), formName);
                    this.setMessageText(msg);
                } else {
                    msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"submitFormDefeat"), formName);
                    this.setMessageText(msg);
                }
                this.showMessage();
                this.tblMain.refresh();
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
            finally {
                MutexUtils.releaseMutex((String)id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionFormGroupSubmit_actionPerformed(ActionEvent e) throws Exception {
        int n;
        StringBuffer numbers;
        int i;
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        this.checkSelected();
        if (!this.isConfirmAction("submitFormGroup", null)) {
            return;
        }
        if (!this.checkSelectForms()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"canNotSumbitFormGroup"));
            SysUtil.abort();
        }
        String id = null;
        String number = null;
        IRow row = null;
        ArrayList<String> billId = null;
        ArrayList<String> auditSuccess = null;
        ArrayList<String> auditDefeat = null;
        billId = new ArrayList<String>();
        auditSuccess = new ArrayList<String>();
        auditDefeat = new ArrayList<String>();
        HashMap<String, String> billIdMap = new HashMap<String, String>();
        int rowCount = 0;
        int rowBegin = 0;
        int rowEnd = 0;
        KDTSelectBlock block = null;
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range != null) {
            rowCount = range.size();
            for (i = 0; i < rowCount; ++i) {
                block = (KDTSelectBlock)range.get(i);
                rowBegin = block.getBeginRow();
                rowEnd = block.getEndRow();
                for (int j = rowBegin; j <= rowEnd; ++j) {
                    row = this.tblMain.getRow(j);
                    if (row == null) continue;
                    id = row.getCell("id").getValue().toString();
                    number = row.getCell("number").getValue().toString();
                    if (billIdMap.containsKey(id)) continue;
                    billId.add(id);
                    billIdMap.put(id, number);
                }
            }
        }
        if (this.iFpFormFacade == null) {
            this.iFpFormFacade = FpFormFacadeFactory.getRemoteInstance();
        }
        MutexUtils.requestMutex((CoreUI)this, billId);
        try {
            int n2 = billId.size();
            for (i = 0; i < n2; ++i) {
                id = billId.get(i).toString();
                number = billIdMap.get(id).toString();
                try {
                    if (this.iFpFormFacade.submit(id)) {
                        auditSuccess.add(number);
                        continue;
                    }
                    auditDefeat.add(number);
                    continue;
                }
                catch (BOSException ex) {
                    logger.error((Object)ex.getMessage());
                    continue;
                }
                catch (EASBizException ex) {
                    billId.clear();
                    billIdMap.clear();
                    this.tblMain.refresh();
                    this.handUIExceptionAndAbort((Exception)((Object)ex));
                }
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        finally {
            MutexUtils.releaseMutex(billId);
        }
        StringBuffer content = new StringBuffer(128);
        String and = EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"and");
        if (auditDefeat.size() > 0) {
            numbers = new StringBuffer(64);
            n = auditDefeat.size();
            for (int i2 = 0; i2 < n; ++i2) {
                numbers.append(auditDefeat.get(i2));
                if (i2 >= 0 && i2 < n - 2) {
                    numbers.append("\u3001");
                    continue;
                }
                if (i2 != n - 2) continue;
                numbers.append(and);
            }
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"submitFormDefeat"), numbers.toString());
            content.append(msg).append("\r\n");
        }
        if (auditSuccess.size() > 0) {
            numbers = new StringBuffer(64);
            n = auditSuccess.size();
            for (int i3 = 0; i3 < n; ++i3) {
                numbers.append(auditSuccess.get(i3));
                if (i3 >= 0 && i3 < n - 2) {
                    numbers.append("\u3001");
                    continue;
                }
                if (i3 != n - 2) continue;
                numbers.append(and);
            }
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"submitFormSucceed"), numbers.toString());
            content.append(msg.toString());
        }
        MsgBox.showInfo((Component)((Object)this), (String)content.toString());
        billId.clear();
        billIdMap.clear();
        auditSuccess.clear();
        auditDefeat.clear();
        this.tblMain.refresh();
    }

    private boolean checkSelectForms() {
        KDTSelectBlock block = null;
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range != null) {
            for (int i = 0; i < range.size(); ++i) {
                block = (KDTSelectBlock)range.get(i);
                for (int j = block.getBeginRow(); j <= block.getEndRow(); ++j) {
                    if (this.checkSelectForm(j)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkSelectForm(int rowIndex) {
        BizEnumValueInfo enumValueInfo;
        if (rowIndex == -1) {
            return false;
        }
        IRow row = this.tblMain.getRow(rowIndex);
        return row != null && ((enumValueInfo = (BizEnumValueInfo)row.getCell("state").getValue()).getString().equals("editing") || enumValueInfo.getString().equals("adjusting"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionOrgCollect_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String key = this.getSelectedKeyValue();
        MutexUtils.requestMutex((CoreUI)this, (String)key);
        try {
            UIContext uiCtx = this.getOrgUICtx();
            IUIWindow orgSelectorUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FpSubOrgUnitSelectUI.class.getName(), (Map)uiCtx, null, null);
            String title = EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"fpValueOrgCollTitle");
            orgSelectorUI.getUIObject().setUITitle(title);
            orgSelectorUI.show();
            List subOrgs = ((FpSubOrgUnitSelectUI)orgSelectorUI.getUIObject()).getReturnValue();
            if (subOrgs != null && subOrgs.size() > 0) {
                UIContext uiContext = new UIContext((Object)this);
                this.prepareUIContext(uiContext, e);
                uiContext.put((Object)"ID", (Object)key);
                uiContext.put((Object)"isOpenReport", (Object)Boolean.TRUE);
                uiContext.put((Object)"OpenReportState", (Object)OprtState.EDIT);
                uiContext.put((Object)"isBizActual", (Object)Boolean.FALSE);
                uiContext.put((Object)"subOrgIdList", (Object)subOrgs);
                uiContext.put((Object)"fpFormCollectType", (Object)"fpOrgNormalCollect");
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
                uiWindow.hide();
                if (this.isDoRefresh(uiWindow)) {
                    this.refresh(e);
                }
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        finally {
            MutexUtils.releaseMutex((String)key);
        }
    }

    private UIContext getOrgUICtx() throws BOSException, EASBizException {
        FullOrgUnitInfo ouInfo = this.getFullOuInfo();
        String cuId = ouInfo.getId().toString();
        OrgUnitCollection subOuColl = FpTemplateHandler.getAllSubOuInfo(ouInfo);
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"CUID", (Object)cuId);
        uiCtx.put((Object)"EditOrg", (Object)subOuColl);
        return uiCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionOrgDisassemble_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String key = this.getSelectedKeyValue();
        MutexUtils.requestMutex((CoreUI)this, (String)key);
        try {
            FullOrgUnitInfo ouInfo = this.getFullOuInfo();
            String ouId = ouInfo.getId().toString();
            OrgUnitCollection subOuColl = FpTemplateHandler.getAllSubOuInfo(ouInfo);
            this.showConfirm("orgDisassembleMsg");
            IUIWindow wizardUI = FpOrgDisassembleWizardUI.showUI((IUIObject)this, ouId, (IObjectCollection)subOuColl);
            Map orgPropMap = ((FpOrgDisassembleWizardUI)wizardUI.getUIObject()).getReturnMap();
            if (orgPropMap != null && !orgPropMap.isEmpty()) {
                this.iFpFormFacade.disassembleByOrg(key, orgPropMap);
                this.showMsg("orgDisassembleSuccess");
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        finally {
            MutexUtils.releaseMutex((String)key);
        }
    }

    private void showConfirm(String resName) {
        String msg = EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)resName);
        int result = MsgBox.showConfirm2((String)msg);
        if (result == 2) {
            SysUtil.abort();
        }
    }

    private void showMsg(String resName) {
        String msg = EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)resName);
        this.setMessageText(msg);
        this.showMessage();
    }

    private void showInfo(String resName) {
        String msg = EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)resName);
        MsgBox.showInfo((Component)((Object)this), (String)msg);
        SysUtil.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPeriodCollect_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String key = this.getSelectedKeyValue();
        MutexUtils.requestMutex((CoreUI)this, (String)key);
        try {
            IUIWindow wizardUI;
            List periodList;
            int rowIndex = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
            IRow row = this.tblMain.getRow(rowIndex);
            String periodId = (String)row.getCell("period.id").getValue();
            IBgPeriod iBgPeriod = BgPeriodFactory.getRemoteInstance();
            BgPeriodInfo periodInfo = iBgPeriod.getBgPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
            if (periodInfo.getPeriodType().equals((Object)BgPeriodEnum.DAY)) {
                this.showInfo("hasNoSubPeriod");
            }
            if ((periodList = ((FpPeriodCollSelectorUI)(wizardUI = FpPeriodCollSelectorUI.showUI((IUIObject)this, periodInfo)).getUIObject()).getReturnList()) != null && !periodList.isEmpty()) {
                UIContext uiContext = new UIContext((Object)this);
                this.prepareUIContext(uiContext, e);
                uiContext.put((Object)"ID", (Object)key);
                uiContext.put((Object)"isOpenReport", (Object)Boolean.TRUE);
                uiContext.put((Object)"OpenReportState", (Object)OprtState.EDIT);
                uiContext.put((Object)"isBizActual", (Object)Boolean.FALSE);
                uiContext.put((Object)"subPeriodIdList", (Object)periodList);
                uiContext.put((Object)"fpFormCollectType", (Object)"fpPeriodNormalCollect");
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
                uiWindow.hide();
                if (this.isDoRefresh(uiWindow)) {
                    this.refresh(e);
                }
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        finally {
            MutexUtils.releaseMutex((String)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPeriodDisassemble_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String key = this.getSelectedKeyValue();
        MutexUtils.requestMutex((CoreUI)this, (String)key);
        try {
            int rowIndex = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
            IRow row = this.tblMain.getRow(rowIndex);
            String periodId = (String)row.getCell("period.id").getValue();
            IBgPeriod iBgPeriod = BgPeriodFactory.getRemoteInstance();
            BgPeriodInfo periodInfo = iBgPeriod.getBgPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
            if (periodInfo.getPeriodType().equals((Object)BgPeriodEnum.DAY)) {
                this.showInfo("hasNoSubPeriod");
            }
            this.showConfirm("periodDisassembleMsg");
            IUIWindow wizardUI = FpPeriodDisassembleWizardUI.showUI((IUIObject)this, periodInfo);
            Map periodPropMap = ((FpPeriodDisassembleWizardUI)wizardUI.getUIObject()).getReturnMap();
            if (periodPropMap != null && !periodPropMap.isEmpty()) {
                this.iFpFormFacade.disassembleByPeriod(key, periodPropMap);
                this.showMsg("periodDisassembleSuccess");
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        finally {
            MutexUtils.releaseMutex((String)key);
        }
    }

    public void actionExecute_actionPerformed(ActionEvent e) throws Exception {
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null) {
            String id = row.getCell("id").getValue().toString();
            String number = row.getCell("number").getValue().toString();
            if (!this.isConfirmAction("executeForm", new String[]{number})) {
                return;
            }
            if (this.iFpFormFacade == null) {
                this.iFpFormFacade = FpFormFacadeFactory.getRemoteInstance();
            }
            this.iFpFormFacade.execute(id);
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"executeFormSuccess"), number);
            this.setMessageText(msg);
            this.showMessage();
            this.refresh(e);
        }
    }

    public void actionAntiExecute_actionPerformed(ActionEvent e) throws Exception {
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null) {
            String id = row.getCell("id").getValue().toString();
            String number = row.getCell("number").getValue().toString();
            if (!this.isConfirmAction("antiExecuteForm", new String[]{number})) {
                return;
            }
            if (this.iFpFormFacade == null) {
                this.iFpFormFacade = FpFormFacadeFactory.getRemoteInstance();
            }
            this.iFpFormFacade.antiExecute(id);
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"antiExecuteFormSuccess"), number);
            this.setMessageText(msg);
            this.showMessage();
            this.refresh(e);
        }
    }
}

