/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.client.RptSheet;
import com.kingdee.eas.fi.rpt.client.RptTablePane;
import com.kingdee.eas.fm.common.client.ExcelFileFilter;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.MutexUtils;
import com.kingdee.eas.fm.fpl.FPPastDataFactory;
import com.kingdee.eas.fm.fpl.FpDataInfo;
import com.kingdee.eas.fm.fpl.FpFormException;
import com.kingdee.eas.fm.fpl.FpFormFacadeFactory;
import com.kingdee.eas.fm.fpl.FpFormHelper;
import com.kingdee.eas.fm.fpl.FpFormInfo;
import com.kingdee.eas.fm.fpl.FpFormStateEnum;
import com.kingdee.eas.fm.fpl.FpItemFormulaParser;
import com.kingdee.eas.fm.fpl.IFPPastData;
import com.kingdee.eas.fm.fpl.IFpFormFacade;
import com.kingdee.eas.fm.fpl.client.AbstractFpFormProcessUI;
import com.kingdee.eas.fm.fpl.client.CellDiffUI;
import com.kingdee.eas.fm.fpl.client.FinQuantityUI;
import com.kingdee.eas.fm.fpl.client.FormTableBeforeAction;
import com.kingdee.eas.fm.fpl.client.FpClientHelper;
import com.kingdee.eas.fm.fpl.client.FpFormClientHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class FpFormProcessUI
extends AbstractFpFormProcessUI {
    private static final Logger logger = CoreUIObject.getLogger(FpFormProcessUI.class);
    private boolean isActual = false;
    private FpFormInfo fpFormInfo = null;
    private IFpFormFacade iFpFormFacade = null;
    private Map fpDataMap = null;
    private Map fpPastDataMap = null;
    boolean isNeedMutex = false;
    String formType = null;

    public FpFormProcessUI() throws Exception {
        if (this.iFpFormFacade == null) {
            this.iFpFormFacade = FpFormFacadeFactory.getRemoteInstance();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.formType == null || this.formType.equals("")) {
            this.formType = (String)this.getUIContext().get("fpFormType");
        }
        boolean bl = this.isNeedMutex = OprtState.EDIT.equals(this.getOprtState()) || "fpAuditType".equals(this.formType) || "fpAntiAuditType".equals(this.formType);
        if (this.isNeedMutex) {
            String id = (String)this.getUIContext().get("ID");
            MutexUtils.requestMutex((CoreUI)this, (String)id);
        }
        if (this.editDataUI != null) {
            this.setDataObject((IObjectValue)((VirtualSheetParamInfo)this.editDataUI.getEditDataObject()));
            this.setEditData((VirtualSheetParamInfo)this.editDataUI.getEditDataObject());
            this.fpFormInfo = (FpFormInfo)this.getEditData();
        }
        String adjustRootId = this.fpFormInfo.getAdjustRootID();
        if (this.fpDataMap == null) {
            this.fpDataMap = this.iFpFormFacade.getFpDataMap(adjustRootId);
        }
        if (this.fpPastDataMap == null) {
            IFPPastData iFpPastData = FPPastDataFactory.getRemoteInstance();
            this.fpPastDataMap = iFpPastData.getFpPastDataMap(adjustRootId);
        }
        this.initActiveCellListener();
        if (this.getUIContext().get("isBizActual") != null) {
            this.isActual = (Boolean)this.getUIContext().get("isBizActual");
        }
        FpFormClientHelper.initProcessUI(this.editDataUI, this.pnlTables, this.fpFormInfo, this.getOprtState());
        FpFormClientHelper.showSheets(this.pnlTables, this.isActual);
        int n = this.pnlTables.getTabCount();
        for (int i = 0; i < n; ++i) {
            this.pnlTables.getPageAt(i).setBeforeAction((BeforeActionListener)new FormTableBeforeAction());
            this.pnlTables.getPageAt(i).setAfterAction(null);
        }
        if (this.pnlTables.getCurrentSheet().getParams() == null) {
            this.pnlTables.getCurrentSheet().setParams(new RptSheetParamInfo());
        }
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            this.actionDataRptAutoCalculate_actionPerformed(null);
        }
    }

    public void actionFileOpen_actionPerformed(ActionEvent e) throws Exception {
        super.actionFileOpen_actionPerformed(e);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnFileImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnFileExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnGetActual.setIcon(EASResource.getIcon((String)"imgTbtn_dispose"));
        this.btnRefCalculate.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.btnViewHistory.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.btnAuditView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnViewDiff.setIcon(EASResource.getIcon((String)"imgTbtn_differentia"));
        this.kDButtonGroupDV.add((AbstractButton)this.itemItemFormula);
    }

    private void initActiveCellListener() {
        KDTable table = null;
        RptSheet fpSheet = null;
        ArrayList sheets = this.pnlTables.getSheets();
        int size = sheets.size();
        for (int i = 0; i < size; ++i) {
            fpSheet = (RptSheet)sheets.get(i);
            table = fpSheet.getTable();
            table.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

                public void propertyChange(KDTPropertyChangeEvent evt) {
                    Object newObj = evt.getNewValue();
                    int rowIndex = evt.getRowIndex();
                    int colIndex = evt.getColIndex();
                    ICell cell = FpFormProcessUI.this.pnlTables.getCurrentPage().getCell(rowIndex, colIndex);
                    FpFormProcessUI.this.checkValueAdjust(cell, newObj);
                }
            });
            table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                }
            });
            table.addKDTActiveCellListener(new KDTActiveCellListener(){

                public void activeCellChanged(KDTActiveCellEvent e) {
                    ICell cell = FpFormProcessUI.this.pnlTables.getFoucusCell();
                    if (cell == null) {
                        return;
                    }
                    if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell)) {
                        FpFormProcessUI.this.barFormula.setItemEnabled(true);
                        return;
                    }
                    RptCell rptCell = (RptCell)cell.getUserObject();
                    ItemFormula formula = rptCell.getItemFormula();
                    if (formula == null) {
                        return;
                    }
                    String isTemplateItemFormula = formula.getExt("isTemplateItemFormula");
                    if (Boolean.valueOf(isTemplateItemFormula).booleanValue()) {
                        FpFormProcessUI.this.barFormula.setItemEnabled(false);
                    } else {
                        FpFormProcessUI.this.barFormula.setItemEnabled(true);
                    }
                    if (FpFormProcessUI.this.isActual) {
                        FpFormProcessUI.this.barFormula.setItemLine(null);
                    }
                }
            });
        }
        sheets.clear();
    }

    private void checkValueAdjust(ICell cell, Object newObj) {
        if (!this.formType.equals("fpAdjustType") || !this.getOprtState().equals(OprtState.EDIT)) {
            return;
        }
        if (cell == null || cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell)) {
            return;
        }
        ItemFormula formula = ((RptCell)cell.getUserObject()).getItemFormula();
        if (formula == null) {
            return;
        }
        BigDecimal newValue = this.tran2BigDecimal(newObj);
        if (newValue == null) {
            return;
        }
        FpDataInfo info = this.getFpDataInfo(formula.toString());
        if (info == null) {
            return;
        }
        BigDecimal oldValue = info.getFpValue();
        info.setAdjustValue(newValue);
        if (oldValue.compareTo(newValue) != 0) {
            cell.getStyleAttributes().setBackground(FpFormHelper.ADJUST_COLOR);
        } else if (!this.fpPastDataMap.containsKey(this.getCommonFormula(formula.toString()))) {
            cell.getStyleAttributes().setBackground(FpFormHelper.WHITE_COLOR);
        }
    }

    private BigDecimal tran2BigDecimal(ICell cell) {
        if (cell == null || cell.getValue() == null) {
            return null;
        }
        if (cell.getValue() instanceof BigDecimal) {
            return (BigDecimal)cell.getValue();
        }
        if (cell.getValue() instanceof String) {
            String value = (String)cell.getValue();
            BigDecimal num = null;
            try {
                num = new BigDecimal(value);
            }
            catch (NumberFormatException e) {
                logger.error((Object)e);
            }
            return num;
        }
        return null;
    }

    private BigDecimal tran2BigDecimal(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Long) {
            BigInteger inte = BigInteger.valueOf((Long)obj);
            return new BigDecimal(inte);
        }
        if (obj instanceof String) {
            String value = (String)obj;
            BigDecimal num = null;
            try {
                num = new BigDecimal(value);
            }
            catch (NumberFormatException e) {
                logger.error((Object)e);
            }
            return num;
        }
        return null;
    }

    private FpDataInfo getFpDataInfo(String itemFormula) {
        return (FpDataInfo)this.fpDataMap.get(this.getCommonFormula(itemFormula));
    }

    private String getCommonFormula(String itemFormula) {
        FpItemFormulaParser parser = new FpItemFormulaParser(itemFormula);
        String commonFormula = "";
        try {
            parser.parse();
            commonFormula = parser.getCommonFormula();
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        return commonFormula;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("fpPeriod.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("fpScheme.*"));
        sic.add(new SelectorItemInfo("fpTemplate.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("dataSource"));
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }

    public void actionViewItemFormula_actionPerformed(ActionEvent e) throws Exception {
        this.pnlTables.repaint();
    }

    protected Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object value) {
        if (this.itemItemFormula.isSelected()) {
            Object o = cell.getUserObject();
            if (o != null && o instanceof RptCell && ((RptCell)o).getItemFormula() != null && ((RptCell)o).getItemFormula().getFormula() != null) {
                return ((RptCell)o).getItemFormula().getFormula();
            }
            return cell.getValue();
        }
        return super.formatCellDisplay(rowIndex, colIndex, cell, value);
    }

    public void actionFileImport_actionPerformed(ActionEvent e) throws Exception {
        File file;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"ReportProcessUI_Import"));
        fileChooser.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog((Component)((Object)this)) == 0 && (file = fileChooser.getSelectedFile()) != null && file.isFile()) {
            KDSSheet sheet;
            String fileName = file.getPath();
            KDSBook books = POIXlsReader.parse((String)fileName);
            if (books == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"openFileError"));
                SysUtil.abort();
            }
            if ((sheet = books.getSheet((Object)new Integer(0))) == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"badFileError"));
                SysUtil.abort();
            }
            this.writeToSheet(sheet, this.pnlTables.getCurrentPage());
        }
    }

    public void actionEditClearContent_actionPerformed(ActionEvent e) throws Exception {
        super.actionEditClearContent_actionPerformed(e);
    }

    private boolean writeToSheet(KDSSheet from, KDTable to) {
        if (from == null || to == null) {
            return false;
        }
        ICell cellTo = null;
        int rowCount = from.getRowCount();
        int colCount = from.getColumnCount();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                cellTo = to.getCell(i, j);
                if (cellTo == null) continue;
                cellTo.setValue(from.getCell(i, j, false).getValue());
            }
        }
        return true;
    }

    public void actionSheetCalculate_actionPerformed(ActionEvent e) throws Exception {
        super.actionBackCalcCurrPage_actionPerformed(e);
    }

    protected void backCalcCurrPage() {
        if (this.pnlTables.getCurrentSheet().getParams() == null) {
            this.pnlTables.getCurrentSheet().setParams(new RptSheetParamInfo());
        }
        super.backCalcCurrPage();
    }

    protected void rptBackCalculate(int[] calIndex) throws Exception {
        if (this.pnlTables.getCurrentSheet().getParams() == null) {
            this.pnlTables.getCurrentSheet().setParams(new RptSheetParamInfo());
        }
        super.rptBackCalculate(calIndex);
    }

    private void checkValueAdjust(RptTablePane pnlTables) {
        ArrayList sheets = pnlTables.getSheets();
        RptSheet sheet = null;
        KDTable table = null;
        ICell cell = null;
        for (int index = sheets.size() - 1; index >= 0; --index) {
            sheet = (RptSheet)sheets.get(index);
            table = sheet.getTable();
            int rowCount = table.getBody().size();
            for (int i = 0; i < rowCount; ++i) {
                int colCount = table.getColumnCount();
                for (int j = 0; j < colCount; ++j) {
                    cell = table.getCell(i, j);
                }
            }
        }
    }

    protected void afterBackCalCurrPage() {
        super.afterBackCalCurrPage();
        try {
            FpFormClientHelper.setTableCellEditor(this.pnlTables, this.fpFormInfo.getCurrency().getNumber(), this.isActual);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        RptSheet sheet = null;
        KDTable table = null;
        int count = this.pnlTables.getSheetCount();
        for (int i = 0; i < count; ++i) {
            sheet = this.pnlTables.getSheet(i);
            table = sheet.getTable();
            table.getScriptManager().setAutoRun(true);
        }
    }

    public void actionGetActual_actionPerformed(ActionEvent e) throws Exception {
        super.actionGetActual_actionPerformed(e);
        this.actionFileSave_actionPerformed(e);
    }

    public void actionInsertItem_actionPerformed(ActionEvent e) throws Exception {
        this.barFormula.pickItemFormula("FpItem", (CoreUIObject)this);
    }

    public boolean isModify() {
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            return true;
        }
        return super.isModify();
    }

    public void actionFileSave_actionPerformed(ActionEvent e) throws Exception {
        FpFormStateEnum state = ((FpFormInfo)this.editData).getState();
        if (!(state.equals((Object)FpFormStateEnum.EDITING) || state.equals((Object)FpFormStateEnum.ADJUSTING) || state.equals((Object)FpFormStateEnum.SUBMITED) || state.equals((Object)FpFormStateEnum.ADJUSTSUBMITED) || state.equals((Object)FpFormStateEnum.APPROVED) && this.formType.equals("ActualEditType"))) {
            throw new FpFormException(FpFormException.CANNOTEDIT);
        }
        super.actionFileSave_actionPerformed(e);
        if (this.isActual) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"actualSubmitPass");
            this.setMessageText(msg);
            this.showMessage();
        }
    }

    public void actionFormSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null) {
            throw new FpFormException(FpFormException.NOFPFORMINFO);
        }
        if (!(((FpFormInfo)this.editData).getState().equals((Object)FpFormStateEnum.EDITING) || ((FpFormInfo)this.editData).getState().equals((Object)FpFormStateEnum.ADJUSTING) || ((FpFormInfo)this.editData).getState().equals((Object)FpFormStateEnum.SUBMITED))) {
            throw new FpFormException(FpFormException.CANNOTSUBMIT);
        }
        if (!this.isConfirmAction("submitFormWork", new String[]{this.editData.getNumber()})) {
            return;
        }
        this.actionFileSave_actionPerformed(e);
        IFpFormFacade iFpFormFacade = FpFormFacadeFactory.getRemoteInstance();
        String id = this.editData.getId().toString();
        if (id == null) {
            throw new FpFormException(FpFormException.NOFPFORMINFO);
        }
        if (iFpFormFacade.submit(id)) {
            this.setMessageText(new StringBuffer(this.editData.getName() + EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"submitFormSucceed")).toString());
        } else {
            this.setMessageText(new StringBuffer(this.editData.getName() + EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"submitFormDefeat")).toString());
        }
        FpClientHelper.refreshFpFormList((CoreUI)this.editDataUI);
        this.showMessage();
        this.getUIWindow().close();
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null) {
            throw new FpFormException(FpFormException.NOFPFORMINFO);
        }
        if (!this.isConfirmAction("auditFpForm", new String[]{this.editData.getNumber()})) {
            return;
        }
        String id = this.editData.getId().toString();
        if (this.iFpFormFacade.audit(id)) {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"auditSuccess"));
        } else {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"auditDefeat"));
        }
        this.showMessage();
        this.actionAudit.setEnabled(false);
        FpClientHelper.refreshFpFormList((CoreUI)this.editDataUI);
    }

    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiAudit_actionPerformed(e);
        if (this.editData == null) {
            throw new FpFormException(FpFormException.NOFPFORMINFO);
        }
        if (!this.isConfirmAction("antiAuditFpForm", new String[]{this.editData.getNumber()})) {
            return;
        }
        String id = this.editData.getId().toString();
        this.iFpFormFacade.antiAudit(id);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)"antiAuditSuccess"));
        this.showMessage();
        this.actionAntiAudit.setEnabled(false);
        FpClientHelper.refreshFpFormList((CoreUI)this.editDataUI);
    }

    private void showMessage(String resPath, String resName) {
        String msg = EASResource.getString((String)resPath, (String)resName);
        this.setMessageText(msg);
        this.showMessage();
    }

    public void actionAuditView_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getId().toString();
        FMClientHelper.viewAuditResult((CoreUIObject)this, (String)id);
    }

    private boolean isConfirmAction(String resName, Object[] objects) {
        String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)resName), objects);
        int re = MsgBox.showConfirm3((Component)((Object)this), (String)msg);
        return re != 1 && re != 2;
    }

    public boolean destroyWindow() {
        if (this.isNeedMutex) {
            String id = (String)this.getUIContext().get("ID");
            MutexUtils.releaseMutex((String)id);
        }
        return super.destroyWindow();
    }

    public void actionViewDiff_actionPerformed(ActionEvent e) throws Exception {
        ICell cell = this.pnlTables.getFoucusCell();
        if (cell == null || cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell)) {
            return;
        }
        RptCell rptCell = (RptCell)cell.getUserObject();
        ItemFormula formula = rptCell.getItemFormula();
        if (formula == null) {
            return;
        }
        FpDataInfo dataInfo = this.getFpDataInfo(formula.toString());
        String formId = this.editData.getId().toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)formId);
        uiContext.put((Object)"itemFormula", (Object)formula.toString());
        FpFormStateEnum state = this.fpFormInfo.getState();
        if (this.formType.equals("fpAdjustType") && (state.equals((Object)FpFormStateEnum.ADJUSTING) || state.equals((Object)FpFormStateEnum.ADJUSTSUBMITED))) {
            uiContext.put((Object)"fpData", (Object)dataInfo);
        }
        CellDiffUI.showDialog(uiContext);
    }

    public void actionFinBalance_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiCtx = new UIContext((Object)this);
        IUIWindow win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FinQuantityUI.class.getName(), (Map)uiCtx);
        win.show();
        super.actionFinBalance_actionPerformed(e);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.FINANCEPLAN;
    }
}

