/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fpl.FpItemCollection;
import com.kingdee.eas.fm.fpl.FpItemFactory;
import com.kingdee.eas.fm.fpl.FpItemGroupFactory;
import com.kingdee.eas.fm.fpl.FpItemGroupInfo;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fpl.IFpItem;
import com.kingdee.eas.fm.fpl.IFpItemGroup;
import com.kingdee.eas.fm.fpl.client.AbstractFpItemGroupF7UI;
import com.kingdee.eas.fm.fpl.client.FpTemFormatImportUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class FpItemGroupF7UI
extends AbstractFpItemGroupF7UI {
    private static final Logger logger = CoreUIObject.getLogger(FpItemGroupF7UI.class);
    private static final String ITEM_RES = "com.kingdee.eas.fm.fpl.client.FpItemResource";
    private FpItemInfo result = null;
    private FpTemFormatImportUI importUI = null;
    private boolean isBatchFill = false;

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("isBatchFill") != null) {
            this.isBatchFill = (Boolean)this.getUIContext().get("isBatchFill");
        }
        this.importUI = this.getUIContext().get("Owner") == null ? null : (this.getUIContext().get("Owner") instanceof FpTemFormatImportUI ? (FpTemFormatImportUI)((Object)this.getUIContext().get("Owner")) : null);
        this.btnFastFind.setEnabled(true);
        this.btnHelp.setVisible(false);
        this.initTable();
        this.fillComboItemGroup();
    }

    private void fillComboItemGroup() throws BOSException {
        IFpItemGroup iFpItemGroup = FpItemGroupFactory.getRemoteInstance();
        CoreBaseCollection coll = iFpItemGroup.getCollection();
        this.comboItemGroup.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.comboItemGroup.addItems(coll.toArray());
        this.comboItemGroup.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    public static void showF7UI(IUIObject ui, boolean isBatchFill) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"isBatchFill", (Object)isBatchFill);
        String uiMode = FMClientHelper.getEditUIMode((CoreUIObject)((CoreUIObject)ui));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)uiMode).create(FpItemGroupF7UI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    private void initTable() {
        this.kdtItem.checkParsed();
        if (!this.isBatchFill) {
            this.kdtItem.getSelectManager().setSelectMode(2);
        } else {
            this.kdtItem.getSelectManager().setSelectMode(10);
        }
    }

    public void actionFastFind_actionPerformed(ActionEvent e) throws Exception {
        super.actionFastFind_actionPerformed(e);
        String selectName = this.comboSelectName.getSelectedItem().toString();
        String compare = this.comboCompare.getSelectedItem().toString();
        String compareValue = this.txtCompareValue.getText();
        String sql = this.buildFastFindSql(selectName, compare, compareValue);
        IFpItem iFpItem = FpItemFactory.getRemoteInstance();
        FpItemCollection fpItemColl = iFpItem.getFpItemCollection(sql);
        this.buildTable(fpItemColl);
    }

    private String buildFastFindSql(String selectName, String compare, String compareValue) {
        String name = null;
        String compareName = null;
        String inputField = null;
        String itemName = EASResource.getString((String)ITEM_RES, (String)"itemNumber");
        String compareKey = EASResource.getString((String)ITEM_RES, (String)"compare");
        name = selectName.equals(itemName) ? "number" : "name";
        if (compare.equals(compareKey)) {
            compareName = " LIKE ";
            inputField = "%" + compareValue + "%";
        } else {
            compareName = " = ";
            inputField = compareValue;
        }
        String sql = "SELECT group.id, group.name, group.number, group.longNumber, * WHERE " + name + compareName + " '" + inputField + "' ORDER BY group.LongNumber, LongNumber";
        return sql;
    }

    private void buildTable(FpItemCollection itemColl) {
        this.kdtItem.refresh();
        if (itemColl == null || itemColl.size() <= 0) {
            return;
        }
        IRow row = null;
        ICell cell = null;
        for (int i = 0; i < itemColl.size(); ++i) {
            row = this.kdtItem.addRow();
            row.setUserObject((Object)itemColl.get(i));
            cell = row.getCell(0);
            cell.setValue((Object)itemColl.get(i).getGroup());
            cell = row.getCell(1);
            cell.setValue((Object)itemColl.get(i).getNumber());
            cell = row.getCell(2);
            cell.setValue((Object)itemColl.get(i).getName());
            cell = row.getCell(3);
            cell.setValue((Object)itemColl.get(i).getDescription());
        }
        this.kdtItem.getStyleAttributes().setLocked(true);
    }

    protected void comboItemGroup_actionPerformed(ActionEvent e) throws Exception {
        super.comboItemGroup_actionPerformed(e);
        if (this.comboItemGroup.getSelectedItem() == null) {
            return;
        }
        String groupID = null;
        if (this.comboItemGroup.getSelectedItem() instanceof FpItemGroupInfo) {
            FpItemGroupInfo info = (FpItemGroupInfo)this.comboItemGroup.getSelectedItem();
            groupID = info.getId().toString();
        } else {
            groupID = null;
        }
        String sql = this.bulidGroupSql(groupID);
        IFpItem iFpItem = FpItemFactory.getRemoteInstance();
        FpItemCollection fpItemCollection = iFpItem.getFpItemCollection(sql);
        this.buildTable(fpItemCollection);
    }

    private String bulidGroupSql(String groupID) {
        String sql = null;
        sql = groupID == null ? "SELECT *, group.* ORDER BY group.LongNumber, LongNumber" : "SELECT *, group.*  WHERE Group.ID = '" + groupID + "' ORDER BY LongNumber";
        return sql;
    }

    protected void kdtItem_tableClicked(KDTMouseEvent e) throws Exception {
        if (!this.isBatchFill && e.getClickCount() == 2) {
            this.confirmAction();
        }
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        this.confirmAction();
    }

    private void confirmAction() {
        this.result = null;
        int size = this.kdtItem.getSelectManager().size();
        if (size == 0 || this.kdtItem.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        int itemCount = 0;
        FpItemInfo info = null;
        IRow row = null;
        if (!this.isBatchFill) {
            int rowIndex = this.kdtItem.getSelectManager().getActiveRowIndex();
            row = this.kdtItem.getRow(rowIndex);
            if (row == null || !(row.getUserObject() instanceof FpItemInfo)) {
                return;
            }
            this.result = info = (FpItemInfo)row.getUserObject();
            ++itemCount;
        } else {
            ArrayList<FpItemInfo> itemList = new ArrayList<FpItemInfo>();
            KDTSelectBlock selectBlock = null;
            for (int i = 0; i < size; ++i) {
                selectBlock = this.kdtItem.getSelectManager().get(i);
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    row = this.kdtItem.getRow(j);
                    if (row == null || !(row.getUserObject() instanceof FpItemInfo)) continue;
                    info = (FpItemInfo)row.getUserObject();
                    itemList.add(info);
                    ++itemCount;
                }
            }
            this.importUI.fillItemTable(itemList);
        }
        if (itemCount <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)ITEM_RES, (String)"itemIsNull"));
        }
        this.getUIWindow().close();
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    public FpItemInfo getResult() {
        return this.result;
    }
}

