/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgUtils;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fpl.client.AbstractFpOrgBasedListUI;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public abstract class FpOrgBasedListUI
extends AbstractFpOrgBasedListUI {
    private static final Logger logger = CoreUIObject.getLogger(FpOrgBasedListUI.class);
    protected boolean isInit = false;
    protected FullOrgUnitInfo currOrg = null;

    public void onLoad() throws Exception {
        this.initComboxOrgType();
        super.onLoad();
        this.tblMain.checkParsed();
        this.splitPaneMain.setResizeWeight(0.2);
        this.treeOrgUnit.setModel(null);
        this.treeOrgUnit.setEnabled(false);
        this.refreshOrgUnitTree();
        this.locateCurrentOrg();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        boolean isPerimess = true;
        if (node != null) {
            isPerimess = !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node);
        }
        this.actionAddNew.setEnabled(isPerimess);
        this.treeOrgUnit.setEnabled(true);
        this.treeOrgUnit_valueChanged(null);
        this.isInit = true;
        this.actionNextPerson.setVisible(false);
        this.actionMultiapprove.setVisible(false);
    }

    private void refreshOrgUnitTree() throws EASBizException, BOSException, SQLException {
        this.treeOrgUnit.setModel(null);
        OrgViewType orgViewType = (OrgViewType)this.comboxOrgType.getSelectedItem();
        if (orgViewType == null) {
            return;
        }
        TreeModel treeModel = null;
        try {
            String rootUnitID = null;
            rootUnitID = SysContext.getSysContext().getCurrentCostUnit() != null ? SysContext.getSysContext().getCurrentCostUnit().getId().toString() : SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            treeModel = NewOrgUtils.getTreeModel((OrgViewType)orgViewType, null, (boolean)false, (boolean)false, (boolean)false, (String)rootUnitID, (boolean)false, null, (int)0, null, null);
            this.treeOrgUnit.setModel(treeModel);
        }
        catch (Exception err) {
            this.handUIException(err);
        }
        if (this.treeOrgUnit.getModel() != null) {
            this.treeOrgUnit.expandAllNodes(true, (TreeNode)this.treeOrgUnit.getModel().getRoot());
        }
    }

    protected IObjectPK getOrgPK() {
        CompanyOrgUnitInfo info;
        if (this.treeOrgUnit == null) {
            return super.getOrgPK();
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node == null) {
            CompanyOrgUnitInfo info2;
            CompanyOrgUnitInfo companyOrgUnitInfo = info2 = SysContext.getSysContext().getCurrentFIUnit() instanceof CompanyOrgUnitInfo ? SysContext.getSysContext().getCurrentFIUnit() : null;
            if (info2 == null) {
                return null;
            }
            ObjectUuidPK orgPk = new ObjectUuidPK(info2.getId());
            return orgPk;
        }
        OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
        FullOrgUnitInfo org = oui.getUnit();
        org.setLongNumber(oui.getLongNumber());
        if (org.isIsCompanyOrgUnit()) {
            ObjectUuidPK orgPk = new ObjectUuidPK(org.getId());
            return orgPk;
        }
        CompanyOrgUnitInfo companyOrgUnitInfo = info = SysContext.getSysContext().getCurrentFIUnit() instanceof CompanyOrgUnitInfo ? SysContext.getSysContext().getCurrentFIUnit() : null;
        if (info == null) {
            return null;
        }
        ObjectUuidPK orgPk = new ObjectUuidPK(info.getId());
        return orgPk;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.getFullOuInfo() == null) {
            return new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
        }
        return new ObjectUuidPK(this.getFullOuInfo().getId().toString());
    }

    public void isolateOrg(DefaultKingdeeTreeNode node, String orgRangeStr) throws BOSException, SQLException {
        int size = node.getChildCount();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            String orgId = ((OrgUnitInfo)childNode.getUserObject()).getId().toString();
            if (childNode.getChildCount() > 0) {
                this.isolateOrg(childNode, orgRangeStr);
            }
            if (orgRangeStr.indexOf(orgId) != -1 || childNode.getChildCount() > 0) continue;
            this.treeOrgUnit.removeNodeFromParent((MutableTreeNode)childNode);
            --i;
            --size;
        }
    }

    public String getOrgRange(String userId) throws BOSException, SQLException {
        String result = "";
        String sqlForm = "SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID='" + userId + "'";
        ISQLExecutor iExecutor = SQLExecutorFactory.getRemoteInstance((String)sqlForm);
        IRowSet irs = iExecutor.executeSQL();
        while (irs.next()) {
            result = result.equals("") ? irs.getString(1) : result + "," + irs.getString(1);
        }
        return result;
    }

    protected void initComboxOrgType() {
        this.comboxOrgType.setEnabled(false);
        this.comboxOrgType.addItem((Object)OrgViewType.COSTCENTER);
        this.comboxOrgType.setSelectedItem((Object)OrgViewType.COSTCENTER);
        this.treeViewOrgUnit.setTitle(OrgViewType.COSTCENTER.getAlias());
    }

    protected FullOrgUnitInfo getFullOuInfo() {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        if (OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            return null;
        }
        OrgStructureInfo osInfo = (OrgStructureInfo)node.getUserObject();
        FullOrgUnitInfo info = osInfo.getUnit();
        String id = info.getId().toString();
        try {
            FullOrgUnitInfo info1 = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo("select CU.id where id='" + id + "'");
            info.setCU(info1.getCU());
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        info.setLongNumber(osInfo.getLongNumber());
        return info;
    }

    protected FullOrgUnitInfo getFullOuInfo(DefaultKingdeeTreeNode node) {
        OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
        FullOrgUnitInfo info = oui.getUnit();
        info.setLongNumber(oui.getLongNumber());
        return info;
    }

    protected String getOuId() {
        FullOrgUnitInfo oui = this.getFullOuInfo();
        if (oui == null) {
            return "";
        }
        return oui.getId().toString();
    }

    protected OrgViewType getOrgViewType() {
        return (OrgViewType)this.comboxOrgType.getSelectedItem();
    }

    protected Vector getOrgIDPath() throws EASBizException, BOSException {
        TreePath path = this.treeOrgUnit.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object[] pathObj = path.getPath();
        if (pathObj == null) {
            return null;
        }
        int length = pathObj.length;
        Vector<String> result = new Vector<String>(length);
        int treeType = -1;
        String firstOrgId = "";
        for (int i = length - 1; i >= 0; --i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)pathObj[i];
            Object obj = node.getUserObject();
            if (obj == null || !(obj instanceof OrgStructureInfo)) continue;
            OrgStructureInfo oui = (OrgStructureInfo)obj;
            FullOrgUnitInfo orgUnitInfo = oui.getUnit();
            if (treeType == -1) {
                treeType = (Integer)orgUnitInfo.get("treeType");
            }
            firstOrgId = orgUnitInfo.getId().toString();
            result.add(orgUnitInfo.getId().toString());
        }
        INewOrgViewFacade iNew = NewOrgViewFacadeFactory.getRemoteInstance();
        this.getParentId(iNew, firstOrgId, treeType, result);
        return result;
    }

    private void getParentId(INewOrgViewFacade iNew, String firstOrgId, int treeType, Vector result) throws EASBizException, BOSException {
        OrgUnitInfo org = iNew.getParent(firstOrgId, OrgViewType.getEnum((int)treeType));
        if (org == null) {
            return;
        }
        result.add(org.getId().toString());
        firstOrgId = org.getId().toString();
        this.getParentId(iNew, firstOrgId, treeType, result);
    }

    protected void comboxOrgType_actionPerformed(ActionEvent e) throws Exception {
        if (!this.comboxOrgType.isEnabled()) {
            return;
        }
        this.treeOrgUnit.setEnabled(false);
        this.refreshOrgUnitTree();
        this.treeOrgUnit.setEnabled(true);
        this.locateCurrentOrg();
    }

    private void locateCurrentOrg() {
        block6: {
            CompanyOrgUnitInfo companyInfo;
            block5: {
                companyInfo = SysContext.getSysContext().getCurrentFIUnit();
                if (companyInfo != null && companyInfo.getId() != null) break block5;
                if (this.treeOrgUnit.getRowCount() <= 0) break block6;
                this.treeOrgUnit.setSelectionRow(0);
                break block6;
            }
            if (this.treeOrgUnit.getRowCount() == 0) {
                this.tblMain.removeRows();
            }
            int height = this.treeOrgUnit.getRowCount();
            for (int i = 0; i < height; ++i) {
                TreePath tp = this.treeOrgUnit.getPathForRow(i);
                if (tp == null) continue;
                DefaultKingdeeTreeNode tn = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
                if (tn == null) {
                    return;
                }
                OrgStructureInfo oui = (OrgStructureInfo)tn.getUserObject();
                if (oui == null) {
                    return;
                }
                FullOrgUnitInfo info = oui.getUnit();
                info.setLongNumber(oui.getLongNumber());
                if (!info.getId().toString().equals(companyInfo.getId().toString())) continue;
                this.treeOrgUnit.setSelectionRow(i);
                break;
            }
        }
        if (this.treeOrgUnit.getSelectionPath() == null && this.treeOrgUnit.getRowCount() > 0) {
            this.treeOrgUnit.setSelectionRow(0);
        }
    }

    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        if (!this.treeOrgUnit.isEnabled()) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node != null && OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            this.setActionEnable(false);
            this.tblMain.removeRows();
            if (this.isInit) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpSchemeResource", (String)"SelectPermiUnit"));
                SysUtil.abort();
            }
        } else {
            FullOrgUnitInfo orgUnitInfo = this.getFullOuInfo();
            this.setActionEnable(true);
            if (orgUnitInfo == null) {
                return;
            }
            this.execQuery();
        }
    }

    protected void setActionEnable(boolean flag) {
        this.actionAddNew.setEnabled(flag);
        this.actionView.setEnabled(flag);
        this.actionEdit.setEnabled(flag);
        this.actionRemove.setEnabled(flag);
        this.actionRefresh.setEnabled(flag);
    }

    public boolean checkPermissionByOrg(OrgUnitInfo orgUnitInfo) throws BOSException {
        boolean isPermiss = false;
        if (orgUnitInfo == null) {
            return isPermiss;
        }
        SysContext sys = SysContext.getSysContext();
        UserInfo userInfo = sys.getCurrentUserInfo();
        if (userInfo == null) {
            return isPermiss;
        }
        String strUserId = userInfo.getId().toString();
        String strOrgId = orgUnitInfo.getId().toString();
        IOrgRange iOrgRange = OrgRangeFactory.getRemoteInstance();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user", (Object)strUserId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("org", (Object)strOrgId, CompareType.EQUALS));
        filterInfo.setMaskString("#0 and #1");
        entityViewInfo.setFilter(filterInfo);
        OrgRangeCollection orgRangeCollection = iOrgRange.getOrgRangeCollection(entityViewInfo);
        if (orgRangeCollection.size() > 0) {
            isPermiss = true;
        }
        return isPermiss;
    }

    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        FMClientHelper.viewDoProccess((CoreUIObject)this, (String)id);
    }

    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        FMClientHelper.viewAuditResult((CoreUIObject)this, (String)id);
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
    }

    public void actionNextPerson_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        FMClientHelper.viewNextPerson((CoreUIObject)this, (String)id);
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.FINANCEPLAN;
    }
}

