/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fpl.client.AbstractFpOrgDisassembleWizardPage2UI;
import com.kingdee.eas.fm.fpl.client.FpOrgDisassembleWizard;
import com.kingdee.eas.fm.fpl.client.FpWizardHelper;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FpOrgDisassembleWizardPage2UI
extends AbstractFpOrgDisassembleWizardPage2UI {
    private static final Logger logger = CoreUIObject.getLogger(FpOrgDisassembleWizardPage2UI.class);

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void loadPage() {
        super.loadPage();
        Map orgInfoMap = this.getMyWizard().getOrgInfoMap();
        Map orgMap = this.getMyWizard().getHasSelectedOuMap();
        this.fillData(this.tblMain, orgInfoMap, orgMap);
    }

    private void fillData(KDTable table, Map orgInfoMap, Map orgMap) {
        table.checkParsed();
        table.removeRows();
        this.setTableEditor(table, "prop", 2);
        IRow row = null;
        FullOrgUnitInfo info = null;
        String orgId = null;
        BigDecimal prop = null;
        for (Map.Entry entry : orgMap.entrySet()) {
            orgId = (String)entry.getKey();
            info = (FullOrgUnitInfo)orgInfoMap.get(orgId);
            prop = (BigDecimal)entry.getValue();
            row = table.addRow();
            row.getCell("orgId").setValue((Object)info.getId().toString());
            row.getCell("orgNum").setValue((Object)info.getNumber());
            row.getCell("orgName").setValue((Object)info.getName());
            row.getCell("prop").setValue((Object)prop);
        }
        this.setGroupManager(table);
    }

    private void setGroupManager(KDTable table) {
        String total = EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLResource", (String)"Total");
        table.getGroupManager().setTotalize(true);
        IRow row = table.getGroupManager().getStatRowTemplate(-1);
        row.getStyleAttributes().setLocked(true);
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        int index = table.getRowCount();
        row.getCell(0).setValue((Object)"Total");
        row.getCell(2).setValue((Object)total);
        row.getCell(3).setExpressions("=sum(D1:D" + index + ")");
        row.getCell(3).getStyleAttributes().setNumberFormat("%-.2n");
        row.getCell(3).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getGroupManager().group();
        table.getScriptManager().setAutoRun(true);
    }

    private void setTableEditor(KDTable table, String colName, int prec) {
        KDFormattedTextField textField = new KDFormattedTextField();
        textField.setDataType(1);
        textField.setPrecision(prec);
        textField.setRoundingMode(4);
        textField.setMinimumValue((Comparable)FpWizardHelper.minValue);
        textField.setMaximumValue((Comparable)FpWizardHelper.maxValue);
        textField.setRemoveingZeroInDispaly(true);
        table.getColumn(colName).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
    }

    public Icon getImage() {
        return FpOrgDisassembleWizard.getWizardImage();
    }

    private FpOrgDisassembleWizard getMyWizard() {
        return (FpOrgDisassembleWizard)super.getWizard();
    }
}

