/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.fpl.client.AbstractFpPeriodCollSelectorUI;
import com.kingdee.eas.fm.fpl.client.FpWizardHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class FpPeriodCollSelectorUI
extends AbstractFpPeriodCollSelectorUI {
    private static final Logger logger = CoreUIObject.getLogger(FpPeriodCollSelectorUI.class);
    private BgPeriodInfo periodInfo = null;
    private List returnList = new ArrayList();
    private static final int MIN_YEAR = 1900;
    private static final int MAX_YEAR = 2100;

    public void onLoad() throws Exception {
        super.onLoad();
        Map map = this.getUIContext();
        this.periodInfo = (BgPeriodInfo)map.get("periodInfo");
        this.txtDestPeriod.setEnabled(false);
        this.txtDestPeriod.setText(this.periodInfo.getName());
        int year = this.periodInfo.getYear();
        SpinnerNumberModel model = new SpinnerNumberModel(year, 1900, 2100, 1);
        this.spinSrcYear.setModel((SpinnerModel)model);
        FpWizardHelper.fillComboPeriod(this.periodInfo.getPeriodType(), this.comboSrcPeriodType);
    }

    public static IUIWindow showUI(IUIObject ui, BgPeriodInfo info) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"periodInfo", (Object)info);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FpPeriodCollSelectorUI.class.getName(), (Map)uiContext, null, null);
        uiWindow.show();
        return uiWindow;
    }

    protected void spinSrcYear_stateChanged(ChangeEvent e) throws Exception {
        this.fillTablePeriod();
    }

    protected void comboSrcPeriodType_itemStateChanged(ItemEvent e) throws Exception {
        this.fillTablePeriod();
    }

    private void fillTablePeriod() throws EASBizException, BOSException {
        if (this.spinSrcYear.getValue() == null || this.comboSrcPeriodType.getSelectedItem() == null) {
            return;
        }
        int srcYear = (Integer)this.spinSrcYear.getValue();
        BgPeriodEnum periodType = (BgPeriodEnum)this.comboSrcPeriodType.getSelectedItem();
        this.fillTablePeriod(srcYear, periodType, this.tblSubPeriod);
    }

    private void fillTablePeriod(int year, BgPeriodEnum periodType, KDTable table) throws EASBizException, BOSException {
        table.checkParsed();
        table.removeRows();
        KDCheckBox cbx = new KDCheckBox();
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JCheckBox)cbx);
        table.getColumn("isSelected").setEditor((ICellEditor)cellEditor);
        BgPeriodCollection coll = this.getPeriodColl(year, periodType);
        IRow row = null;
        BgPeriodInfo subPeriod = null;
        String periodId = null;
        Boolean isSelected = Boolean.FALSE;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            subPeriod = coll.get(i);
            row = table.addRow();
            periodId = subPeriod.getId().toString();
            row.getCell("periodId").setValue((Object)periodId);
            row.getCell("isSelected").setValue((Object)isSelected);
            row.getCell("periodName").setValue((Object)subPeriod.getName());
        }
    }

    private BgPeriodCollection getPeriodColl(int srcYear, BgPeriodEnum periodType) throws BOSException, EASBizException {
        CalendarHelper helper = new CalendarHelper();
        Date beginDate = helper.getFirstDayOfYear(srcYear);
        Date endDate = helper.getLastDayOfYear(srcYear);
        BgPeriodCollection coll = BgPeriodHelper.getPeriodColInfo((int)periodType.getValue(), (Date)beginDate, (Date)endDate);
        return coll;
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.returnList != null && !this.returnList.isEmpty()) {
            this.returnList.clear();
        } else {
            this.returnList = new ArrayList();
        }
        IRow row = null;
        int count = this.tblSubPeriod.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblSubPeriod.getRow(i);
            boolean isSelected = (Boolean)row.getCell("isSelected").getValue();
            if (!isSelected) continue;
            String periodId = (String)row.getCell("periodId").getValue();
            this.returnList.add(periodId);
        }
        if (this.returnList == null || this.returnList.isEmpty()) {
            this.showInfo("hasNoSelectedPeriod");
        }
        this.getUIWindow().close();
    }

    private void showInfo(String resName) {
        String msg = EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpFormResource", (String)resName);
        MsgBox.showInfo((Component)((Object)this), (String)msg);
        SysUtil.abort();
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.returnList = null;
        this.getUIWindow().close();
    }

    public List getReturnList() {
        return this.returnList;
    }

    protected void btnSelectNone_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tblSubPeriod.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.tblSubPeriod.getRow(i).getCell("isSelected").setValue((Object)false);
        }
    }

    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tblSubPeriod.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.tblSubPeriod.getRow(i).getCell("isSelected").setValue((Object)true);
        }
    }
}

