/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fpl.client.AbstractFpPeriodDisassembleWizardPage1UI;
import com.kingdee.eas.fm.fpl.client.FpPeriodDisassembleWizard;
import com.kingdee.eas.fm.fpl.client.FpWizardHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class FpPeriodDisassembleWizardPage1UI
extends AbstractFpPeriodDisassembleWizardPage1UI {
    private static final Logger logger = CoreUIObject.getLogger(FpPeriodDisassembleWizardPage1UI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtSrcPeriod.setText(this.getMyWizard().getPeriod().getName());
        this.txtSrcPeriod.setEnabled(false);
        FpWizardHelper.fillComboPeriod(this.getMyWizard().getPeriodType(), this.comboDestPeriod);
    }

    public Icon getImage() {
        return FpPeriodDisassembleWizard.getWizardImage();
    }

    protected void comboDestPeriod_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            if (this.comboDestPeriod.getSelectedItem() != null) {
                this.getMyWizard().setPeriodType((BgPeriodEnum)this.comboDestPeriod.getSelectedItem());
            }
            BgPeriodInfo period = this.getMyWizard().getPeriod();
            BgPeriodEnum periodType = this.getMyWizard().getPeriodType();
            this.fillTablePeriod(period, periodType, this.tblPeriod, this.getMyWizard().getHasSelectedPeriodMap());
        }
    }

    private void fillTablePeriod(BgPeriodInfo period, BgPeriodEnum periodType, KDTable table, Map hasSelectedMap) throws EASBizException, BOSException {
        table.checkParsed();
        table.removeRows();
        KDCheckBox cbx = new KDCheckBox();
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JCheckBox)cbx);
        table.getColumn("isSelected").setEditor((ICellEditor)cellEditor);
        BgPeriodCollection coll = FpWizardHelper.getSubPeriodColl(period, periodType);
        IRow row = null;
        BgPeriodInfo subPeriod = null;
        String periodId = null;
        Boolean isSelected = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            subPeriod = coll.get(i);
            row = table.addRow();
            periodId = subPeriod.getId().toString();
            row.getCell("periodId").setValue((Object)periodId);
            isSelected = this.isSelected(hasSelectedMap, periodId);
            row.getCell("isSelected").setValue((Object)isSelected);
            row.getCell("periodName").setValue((Object)subPeriod.getName());
        }
    }

    private Boolean isSelected(Map hasSelectedMap, String periodId) {
        Boolean isSelected = null;
        isSelected = hasSelectedMap.containsKey(periodId) ? (Boolean)hasSelectedMap.get(periodId) : Boolean.FALSE;
        return isSelected;
    }

    private FpPeriodDisassembleWizard getMyWizard() {
        return (FpPeriodDisassembleWizard)super.getWizard();
    }

    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tblPeriod.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.tblPeriod.getRow(i).getCell("isSelected").setValue((Object)true);
        }
    }

    protected void btnSelectNone_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tblPeriod.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.tblPeriod.getRow(i).getCell("isSelected").setValue((Object)false);
        }
    }
}

