/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fpl.client.AbstractFpPeriodDisassembleWizardPage2UI;
import com.kingdee.eas.fm.fpl.client.FpPeriodDisassembleWizard;
import com.kingdee.eas.fm.fpl.client.FpWizardHelper;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FpPeriodDisassembleWizardPage2UI
extends AbstractFpPeriodDisassembleWizardPage2UI {
    private static final Logger logger = CoreUIObject.getLogger(FpPeriodDisassembleWizardPage2UI.class);

    public void loadPage() {
        super.loadPage();
        Map periodInfoMap = this.getMyWizard().getHasSelectedPeriodMap();
        Map periodPropMap = this.getMyWizard().getPeriodPropMap();
        this.fillData(this.tblPeriodProp, periodInfoMap, periodPropMap);
    }

    private void fillData(KDTable table, Map periodInfoMap, Map periodPropMap) {
        table.checkParsed();
        table.removeRows();
        this.setTableEditor(table, "prop", 2);
        IRow row = null;
        String periodId = null;
        String periodName = null;
        BigDecimal prop = null;
        for (Map.Entry entry : periodPropMap.entrySet()) {
            periodId = (String)entry.getKey();
            periodName = (String)periodInfoMap.get(periodId);
            prop = (BigDecimal)entry.getValue();
            row = table.addRow();
            row.getCell("periodId").setValue((Object)periodId);
            row.getCell("periodName").setValue((Object)periodName);
            row.getCell("prop").setValue((Object)prop);
        }
        this.setGroupManager(table);
    }

    private void setGroupManager(KDTable table) {
        String total = EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLResource", (String)"Total");
        table.getGroupManager().setTotalize(true);
        IRow row = table.getGroupManager().getStatRowTemplate(-1);
        row.getStyleAttributes().setLocked(true);
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        int index = table.getRowCount();
        row.getCell(0).setValue((Object)"Total");
        row.getCell(1).setValue((Object)total);
        row.getCell(2).setExpressions("=sum(C1:C" + index + ")");
        row.getCell(2).getStyleAttributes().setNumberFormat("%-.2n");
        row.getCell(2).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getGroupManager().group();
        table.getScriptManager().setAutoRun(true);
    }

    private void setTableEditor(KDTable table, String colName, int prec) {
        KDFormattedTextField textField = new KDFormattedTextField();
        textField.setDataType(1);
        textField.setPrecision(prec);
        textField.setRoundingMode(4);
        textField.setMinimumValue((Comparable)FpWizardHelper.minValue);
        textField.setMaximumValue((Comparable)FpWizardHelper.maxValue);
        textField.setRemoveingZeroInDispaly(true);
        table.getColumn(colName).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
    }

    public Icon getImage() {
        return FpPeriodDisassembleWizard.getWizardImage();
    }

    private FpPeriodDisassembleWizard getMyWizard() {
        return (FpPeriodDisassembleWizard)super.getWizard();
    }
}

