/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fpl.FpRptFilterParam;
import com.kingdee.eas.fm.fpl.client.AbstractFpRptBaseUI;
import com.kingdee.eas.fm.fpl.client.FpQueryOrigUI;
import com.kingdee.eas.fm.fpl.client.FpRptClientHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public abstract class FpRptBaseUI
extends AbstractFpRptBaseUI {
    private static final Logger logger = CoreUIObject.getLogger(FpRptBaseUI.class);
    private FullOrgUnitCollection orgUnits;
    private FullOrgUnitInfo currOrgUnit;

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnQueryOrig.setIcon(EASResource.getIcon((String)"imgTbtn_fromorganize"));
        this.itemQueryOrg.setIcon(EASResource.getIcon((String)"imgTbtn_fromorganize"));
    }

    protected void comboOrgUnit_itemStateChanged(ItemEvent e) throws Exception {
        super.comboOrgUnit_itemStateChanged(e);
        if (e.getStateChange() == 1) {
            this.changeOrgUnit(e);
        }
    }

    private void changeOrgUnit(ItemEvent e) throws BOSException {
        FpRptFilterParam para = (FpRptFilterParam)this.getFilterParam();
        FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)e.getItem();
        String orgUnitId = orgUnit.getId().toString();
        if (!orgUnitId.equals(para.getCurrentOrgUnitId())) {
            para.setCurrentOrgUnitId(orgUnitId);
            this.setCurrentOrgUnitInfo(para);
            String filterOrgIds = FpRptClientHelper.genFilterOrgIds(this.orgUnits.toArray(), this.currOrgUnit);
            String[] orgIds = filterOrgIds.split(",");
            para.setFilterUnitIds(orgIds);
            this.setFilterParam(para);
            this.execQuery();
        }
    }

    public void executeQuery(FilterParam param) throws BOSException {
        this.setFilterParam(param);
        FpRptFilterParam para = (FpRptFilterParam)param;
        String[] orgUnitIds = para.getOrgUnitIds();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])orgUnitIds), CompareType.INCLUDE));
        view.setFilter(filter);
        this.orgUnits = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(view);
        this.setCurrentOrgUnitInfo(para);
        DefaultComboBoxModel<FullOrgUnitInfo> boxModel = new DefaultComboBoxModel<FullOrgUnitInfo>();
        for (FullOrgUnitInfo element : this.orgUnits) {
            boxModel.addElement(element);
        }
        this.comboOrgUnit.setModel(boxModel);
        FMClientHelper.setSelectObject((KDComboBox)this.comboOrgUnit, (Object)this.currOrgUnit);
        this.txtCurrency.setText(para.getCurrencyName());
        this.txtCurrency.setEnabled(false);
        this.btnQueryOrig.setEnabled(para.isSum());
        super.executeQuery(param);
    }

    private void setCurrentOrgUnitInfo(FpRptFilterParam para) {
        for (FullOrgUnitInfo orgUnit : this.orgUnits) {
            if (!orgUnit.getId().toString().equals(para.getCurrentOrgUnitId())) continue;
            this.currOrgUnit = orgUnit;
        }
    }

    protected void execQuery() throws BOSException {
        FpRptFilterParam para = (FpRptFilterParam)this.getFilterParam();
        if (!this.currOrgUnit.isIsLeaf() && para.isSum()) {
            StringBuffer bufTips = new StringBuffer();
            for (FullOrgUnitInfo orgUnit : this.orgUnits) {
                if (!orgUnit.getLongNumber().startsWith(this.currOrgUnit.getLongNumber()) || orgUnit.getLongNumber().equals(this.currOrgUnit.getLongNumber())) continue;
                bufTips.append(orgUnit.getName());
                bufTips.append(", ");
            }
            String tips = bufTips.toString();
            if (tips.length() > 0) {
                tips = tips.substring(0, tips.length() - 2);
            }
            this.txtSumTips.setText(tips);
        } else {
            this.txtSumTips.setText(null);
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        return null;
    }

    public FilterParam getDefalutQueryParam() {
        return null;
    }

    protected KDTable getOrigTableHeader() throws Exception {
        KDTable table = new KDTable();
        FpRptFilterParam myparam = (FpRptFilterParam)this.getFilterParam();
        IRow header = table.addHeadRow();
        BgPeriodCollection periodColl = BgPeriodFactory.getRemoteInstance().getPeriodCollection(BOSUuid.read((String)myparam.getBeginPeriodId()), BOSUuid.read((String)myparam.getEndPeriodId()));
        int i = 1;
        table.addColumn().setKey("item");
        for (BgPeriodInfo periodInfo : periodColl) {
            String number = periodInfo.getNumber();
            table.addColumn().setKey(number);
            header.getCell(i++).setValue((Object)periodInfo.getName());
        }
        table.addColumn().setKey("total");
        header.getCell("total").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"total"));
        return table;
    }

    protected IRowSet getOrigTableData(String number) throws Exception {
        return null;
    }

    public void actionQueryOrig_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"tableheader", (Object)this.getOrigTableHeader());
        int rowIndex = this.getMainTable().getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        Object itemObj = this.getMainTable().getRow(rowIndex).getUserObject();
        if (!(itemObj instanceof FpItemInfo)) {
            return;
        }
        FpItemInfo itemInfo = (FpItemInfo)itemObj;
        uiContext.put((Object)"tabledata", (Object)this.getOrigTableData(itemInfo.getNumber()));
        uiContext.put((Object)"param", (Object)this.getFilterParam());
        this.dealWith(uiContext);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FpQueryOrigUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    protected void dealWith(UIContext uiContext) {
    }
}

