/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.ORGF7TreeNodeCheckBoxChangeListener;
import com.kingdee.eas.basedata.org.client.f7.OrgViewF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fpl.FpRptFilterParam;
import com.kingdee.eas.fm.fpl.client.AbstractFpRptFilterBaseUI;
import com.kingdee.eas.fm.fpl.client.FpOrgF7TreeNodeCheckBoxChangeListener;
import com.kingdee.eas.fm.fpl.client.FpRptClientHelper;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.util.Set;
import org.apache.log4j.Logger;

public class FpRptFilterBaseUI
extends AbstractFpRptFilterBaseUI {
    private static final Logger logger = CoreUIObject.getLogger(FpRptFilterBaseUI.class);
    public static final String resourcePath = "com.kingdee.eas.fm.fpl.client.FpRptResource";
    private BgPeriodDialog periodF7 = new BgPeriodDialog();
    OrgViewF7 orgF7 = new OrgViewF7((IUIObject)this);
    ORGF7TreeNodeCheckBoxChangeListener listener = new FpOrgF7TreeNodeCheckBoxChangeListener();

    public void clear() {
        super.clear();
        this.prmtOrgUnit.setData(null);
        this.comboPeriodType.setSelectedIndex(0);
        try {
            this.initCurrency();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.prmtBeginPeriod.setData(null);
        this.prmtEndPeriod.setData(null);
        this.chkIsSum.setSelected(false);
    }

    protected void comboPeriodType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            this.prmtBeginPeriod.setData(null);
            this.prmtEndPeriod.setData(null);
            if (e.getItem() == null) {
                return;
            }
            this.periodF7.setBgPeriodEnum((BgPeriodEnum)e.getItem());
        }
    }

    protected FpRptFilterParam getANewParam() {
        return new FpRptFilterParam();
    }

    public Object getParam() {
        BgPeriodInfo endPeriod;
        FpRptFilterParam param = this.getANewParam();
        Object[] orgUnitIds = AccessHelper.getF7Ids((KDBizPromptBox)this.prmtOrgUnit);
        Object[] orgUnits = AccessHelper.getF7Data((KDBizPromptBox)this.prmtOrgUnit);
        FullOrgUnitInfo topNode = null;
        if (FMHelper.isEmpty((Object[])orgUnitIds)) {
            topNode = ContextHelperFactory.getRemoteInstance().getCurrentCompany().castToFullOrgUnitInfo();
            orgUnitIds = new String[]{topNode.getId().toString()};
            orgUnits = new Object[]{topNode};
        } else {
            topNode = FpRptClientHelper.getTopNode(AccessHelper.getF7Data((KDBizPromptBox)this.prmtOrgUnit));
        }
        String filterOrgIds = FpRptClientHelper.genFilterOrgIds(orgUnits, topNode);
        String[] orgIds = filterOrgIds.split(",");
        param.setFilterUnitIds(orgIds);
        param.setOrgUnitIds((String[])orgUnitIds);
        param.setCurrentOrgUnitId(topNode.getId().toString());
        param.setPeriodType(AccessHelper.getCboInt((KDComboBox)this.comboPeriodType));
        param.setCurrencyId(AccessHelper.getCboId((KDComboBox)this.comboCurrency));
        param.setCurrencyName((String)AccessHelper.getCboAttribute((KDComboBox)this.comboCurrency, (String)"name"));
        BgPeriodInfo beginPeriod = (BgPeriodInfo)this.prmtBeginPeriod.getData();
        if (beginPeriod != null) {
            param.setBeginPeriodId(beginPeriod.getId().toString());
            param.setBeginPeriodName(beginPeriod.getName());
            param.setBeginPeriodNumber(beginPeriod.getNumber());
        }
        if ((endPeriod = (BgPeriodInfo)this.prmtEndPeriod.getData()) != null) {
            param.setEndPeriodId(endPeriod.getId().toString());
            param.setEndPeriodName(endPeriod.getName());
            param.setEndPeriodNumber(endPeriod.getNumber());
        }
        param.setSum(this.chkIsSum.isSelected());
        param.setShowZeroRec(this.chkIsShowZeroRec.isSelected());
        return param;
    }

    public void init() throws Exception {
        this.initCompanyState();
        this.initOrg();
        this.initCurrency();
        this.initBgPeriod();
    }

    private void initBgPeriod() throws Exception {
        if (this.comboPeriodType.getSelectedItem() != null) {
            this.periodF7.setBgPeriodEnum((BgPeriodEnum)this.comboPeriodType.getSelectedItem());
        }
        this.prmtBeginPeriod.setSelector((KDPromptSelector)this.periodF7);
        this.prmtEndPeriod.setSelector((KDPromptSelector)this.periodF7);
    }

    protected void initCompanyState() {
    }

    private void initCurrency() throws Exception {
        this.comboCurrency.removeAllItems();
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency, (boolean)true);
    }

    public void initOrg() throws Exception {
        this.orgF7.setCuID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        this.orgF7.setMultiSelect(true);
        this.orgF7.setOrgViewTypes(new OrgViewType[]{OrgViewType.COMPANY, OrgViewType.COSTCENTER});
        this.orgF7.setIsShowSub(true);
        this.orgF7.setTitle(EASResource.getString((String)resourcePath, (String)"SelectOrgUnit"));
        this.orgF7.setUIActionPK(this.getMetaDataPK(), (IMetaDataPK)new MetaDataPK("ActionOnLoad"));
        this.orgF7.addORGF7TreeNodeCheckBoxChangeListener(this.listener);
        this.orgF7.setRootUnitID(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString());
        this.prmtOrgUnit.setSelector((KDPromptSelector)this.orgF7);
        this.prmtOrgUnit.setEditFormat("$number$");
        this.prmtOrgUnit.setDisplayFormat("$name$");
        this.prmtOrgUnit.setCommitFormat("$id$");
        this.prmtOrgUnit.setEnabledMultiSelection(true);
    }

    public void setParam(Object param) {
        FpRptFilterParam para = (FpRptFilterParam)param;
        Set orgUnitIdSet = FMHelper.asSet((String[])para.getOrgUnitIds());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgUnitIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        FullOrgUnitCollection orgUnits = null;
        try {
            orgUnits = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(view);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.prmtOrgUnit.setData((Object)orgUnits.toArray());
        this.orgF7.setCheckedOrgIDs(FMHelper.asSet((String[])para.getOrgUnitIds()));
        this.comboPeriodType.setSelectedItem((Object)BgPeriodEnum.getEnum((int)para.getPeriodType()));
        if (para.getCurrencyId() != null) {
            CurrencyInfo currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)para.getCurrencyId()));
            currency.setName(para.getCurrencyName());
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
        }
        if (para.getBeginPeriodId() != null) {
            BgPeriodInfo beginPeriod = new BgPeriodInfo();
            beginPeriod.setId(BOSUuid.read((String)para.getBeginPeriodId()));
            beginPeriod.setName(para.getBeginPeriodName());
            beginPeriod.setNumber(para.getBeginPeriodNumber());
            this.prmtBeginPeriod.setData((Object)beginPeriod);
        }
        if (para.getEndPeriodId() != null) {
            BgPeriodInfo endPeriod = new BgPeriodInfo();
            endPeriod.setId(BOSUuid.read((String)para.getEndPeriodId()));
            endPeriod.setName(para.getEndPeriodName());
            endPeriod.setNumber(para.getEndPeriodNumber());
            this.prmtEndPeriod.setData((Object)endPeriod);
        }
        this.chkIsSum.setSelected(para.isSum());
        this.chkIsShowZeroRec.setSelected(para.isShowZeroRec());
    }

    public boolean verify() {
        BgPeriodInfo endPeriod;
        if (this.comboPeriodType.getSelectedItem() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"msgSelectPeriodType"));
            return false;
        }
        if (this.prmtBeginPeriod.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"msgSelectBeginPeriod"));
            return false;
        }
        if (this.prmtEndPeriod.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"msgSelectEndPeriod"));
            return false;
        }
        BgPeriodInfo beginPeriod = (BgPeriodInfo)this.prmtBeginPeriod.getData();
        boolean bln = BgHelper.compareBgPeriodBegin2End((BgPeriodInfo)beginPeriod, (BgPeriodInfo)(endPeriod = (BgPeriodInfo)this.prmtEndPeriod.getData()));
        if (!bln) {
            this.prmtBeginPeriod.requestFocus(true);
            String msg = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"endDateLessThanBeginDate"), ((KDLabelContainer)this.prmtEndPeriod.getParent()).getBoundLabelText(), ((KDLabelContainer)this.prmtBeginPeriod.getParent()).getBoundLabelText());
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
        return super.verify();
    }
}

