/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fpl.client.AbstractFpSubOrgUnitSelectUIForForm;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class FpSubOrgUnitSelectUIForForm
extends AbstractFpSubOrgUnitSelectUIForForm {
    public static final String DIRECT = "direct";
    public static final String INDIRECT = "inDirect";
    private boolean isOk = false;
    private ArrayList returnValue = null;
    private String selectType = "inDirect";

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.treeViewOrgUnit.setShowButton(false);
        this.setIcons();
        this.initComBoxOrgType();
        this.treeOrgUnit.setModel(null);
        this.treeOrgUnit.setShowCheckBox(true);
        this.refreshOrgUnitTree();
        this.initTable();
    }

    public String getSelectType() {
        return this.selectType;
    }

    public void setSelectType(String selectType) {
        this.selectType = selectType;
    }

    public void initTable() {
        this.table.checkParsed();
        this.table.getSelectManager().setSelectMode(2);
        OrgUnitCollection orgUnitCollectionSub = (OrgUnitCollection)this.getUIContext().get("EditOrg");
        for (int i = 0; i < orgUnitCollectionSub.size(); ++i) {
            IRow row = this.table.addRow();
            row.setUserObject((Object)orgUnitCollectionSub.get(i));
            row.getCell("select").setValue((Object)Boolean.FALSE);
            row.getCell("select").getStyleAttributes().setLocked(false);
            row.getCell("number").setValue((Object)orgUnitCollectionSub.get(i).getNumber());
            row.getCell("number").getStyleAttributes().setLocked(true);
            row.getCell("name").setValue((Object)orgUnitCollectionSub.get(i).getName());
            row.getCell("name").getStyleAttributes().setLocked(true);
        }
    }

    private void setIcons() {
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    private void initComBoxOrgType() {
        this.comBoxOrgType.addItem((Object)OrgViewType.COSTCENTER);
        this.comBoxOrgType.setSelectedItem((Object)OrgViewType.COSTCENTER);
        this.comBoxOrgType.setEditable(false);
        this.comBoxOrgType.setEnabled(false);
    }

    private void refreshOrgUnitTree() throws EASBizException, BOSException, SQLException {
        this.treeOrgUnit.setModel(null);
        OrgViewType orgViewType = (OrgViewType)this.comBoxOrgType.getSelectedItem();
        if (orgViewType == null) {
            return;
        }
        TreeModel treeModel = null;
        try {
            String rootUnitID = (String)this.getUIContext().get("CUID");
            treeModel = NewOrgUtils.getTreeModel((OrgViewType)orgViewType, null, (boolean)false, (boolean)false, (boolean)false, (String)rootUnitID, (boolean)false, null, (int)0, null, null);
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
            root.setCheckBoxVisible(false);
            this.treeOrgUnit.setModel(treeModel);
        }
        catch (Exception err) {
            this.handUIException(err);
        }
        if (this.treeOrgUnit.getModel() != null) {
            this.treeOrgUnit.expandAllNodes(true, (TreeNode)this.treeOrgUnit.getModel().getRoot());
        }
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        if (this.returnValue == null) {
            this.returnValue = new ArrayList();
        } else {
            this.returnValue.clear();
        }
        if (this.raIndirect.isSelected()) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
            this.traceNode(root, this.returnValue);
        } else if (this.raDirect.isSelected()) {
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                if (!((Boolean)this.table.getRow(i).getCell("select").getValue()).booleanValue()) continue;
                this.returnValue.add(this.table.getRow(i).getUserObject());
            }
        }
        if (this.returnValue.size() == 0) {
            return;
        }
        this.getUIWindow().close();
    }

    private void traceNode(DefaultKingdeeTreeNode root, ArrayList list) throws Exception {
        if (root.isChecked()) {
            OrgStructureInfo oui = (OrgStructureInfo)root.getUserObject();
            FullOrgUnitInfo info = oui.getUnit();
            info.setLongNumber(oui.getLongNumber());
            list.add(info);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.traceNode(node, list);
        }
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.returnValue = null;
        this.getUIWindow().close();
    }

    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectAll_actionPerformed(e);
        if (this.raIndirect.isSelected()) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
            root.setChecked(true);
            root.syncChecked();
            this.treeOrgUnit.repaint();
            root.setChecked(false);
        } else if (this.raDirect.isSelected()) {
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                this.table.getRow(i).getCell("select").setValue((Object)Boolean.TRUE);
            }
        }
    }

    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.raIndirect.isSelected()) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
            root.setChecked(false);
            root.syncChecked();
            this.treeOrgUnit.repaint();
        } else if (this.raDirect.isSelected()) {
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                this.table.getRow(i).getCell("select").setValue((Object)Boolean.FALSE);
            }
        }
    }

    protected void raDirect_actionPerformed(ActionEvent e) throws Exception {
        super.raDirect_actionPerformed(e);
        this.selectType = DIRECT;
        this.table.setVisible(true);
        this.treeViewOrgUnit.setVisible(false);
    }

    protected void raIndirect_actionPerformed(ActionEvent e) throws Exception {
        super.raIndirect_actionPerformed(e);
        this.selectType = INDIRECT;
        this.table.setVisible(false);
        this.treeViewOrgUnit.setVisible(true);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public boolean isOk() {
        return this.isOk;
    }

    public void setOk(boolean isOk) {
        this.isOk = isOk;
    }

    public ArrayList getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(ArrayList returnValue) {
        this.returnValue = returnValue;
    }
}

