/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.rpt.CellReference;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fm.fpl.Coordinate;
import com.kingdee.eas.fm.fpl.FPDataFormulaFormat;
import com.kingdee.eas.fm.fpl.FPFormulaFormat;
import com.kingdee.eas.fm.fpl.FPItemFormulaFormat;
import com.kingdee.eas.fm.fpl.FpAssistItemInfo;
import com.kingdee.eas.fm.fpl.FpDataTypeEnum;
import com.kingdee.eas.fm.fpl.FpFormulaInfo;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fpl.FpItemShowTypeEnum;
import com.kingdee.eas.fm.fpl.FpTemFormatImportInfo;
import com.kingdee.eas.fm.fpl.FpTemplateException;
import com.kingdee.eas.fm.fpl.FpValueTypeEnum;
import com.kingdee.eas.fm.fpl.GradeShowIndentEnum;
import com.kingdee.eas.fm.fpl.TempValueObject;
import com.kingdee.eas.fm.fpl.client.AbstractFpTemFormatImportUI;
import com.kingdee.eas.fm.fpl.client.FpAssistItemGroupF7UI;
import com.kingdee.eas.fm.fpl.client.FpItemGroupF7UI;
import com.kingdee.eas.fm.fpl.client.FpTemFormatImportUIHelper;
import com.kingdee.eas.fm.fpl.client.FpTemplateProcessUI;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.client.BgOrgDialog;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FpTemFormatImportUI
extends AbstractFpTemFormatImportUI {
    private static final Logger logger = CoreUIObject.getLogger(FpTemFormatImportUI.class);
    private static final String RESOURCE = "com.kingdee.eas.fm.fpl.client.FpTemFormatResource";
    private FpTemplateProcessUI fpTemProcessUI = null;
    private KDTable currentTable;
    private int fillRowIndex;
    private int fillColIndex;
    int itemColCount = 0;
    FpTemFormatImportInfo importInfo = new FpTemFormatImportInfo();
    private Map itemMap = new HashMap();
    private Map assistItemMap = new HashMap();
    private String fillType = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.fpTemProcessUI = (FpTemplateProcessUI)((Object)this.getUIContext().get("Owner"));
        this.initDataStatus();
        if (this.getUIContext().get("fillType") != null) {
            this.fillType = (String)this.getUIContext().get("fillType");
        }
        if (this.fillType.equals("itemFormula")) {
            this.setUITitle(EASResource.getString((String)RESOURCE, (String)"itemBatchBillUITitle"));
            this.contOrgUnit.setVisible(false);
            this.contValueType.setVisible(false);
        }
        this.cbxFpData.setSelected(true);
        this.cbxFpData.setVisible(false);
        this.cbxFpActual.setVisible(false);
        this.contDataType.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddItem.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveItem.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnAddAssistItem.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveAssistItem.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnAntiSelect.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnAntiSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
    }

    protected void initDataStatus() {
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        this.comboCurrency.setSelectedIndex(-1);
        this.itemTable.checkParsed();
        this.assistItemTable.checkParsed();
        this.selectedItemTable.checkParsed();
        this.itemTable.getSelectManager().setSelectMode(10);
        this.assistItemTable.getSelectManager().setSelectMode(10);
        this.selectedItemTable.getSelectManager().setSelectMode(10);
        KDTSelectManager selectManager = this.fpTemProcessUI.getPnlTables().getCurrentPage().getSelectManager();
        int currRowIndex = selectManager.getActiveRowIndex();
        int currColIndex = selectManager.getActiveColumnIndex();
        if (currRowIndex >= 0 && currColIndex >= 0) {
            this.txtPosition.setText(TableToolkit.xy2range((int)currColIndex, (int)currRowIndex));
        } else {
            this.txtPosition.setText("A1");
        }
        BgPeriodDialog beginF7 = new BgPeriodDialog((CoreUIObject)this);
        this.prmtBeginPeriod.setSelector((KDPromptSelector)beginF7);
        BgPeriodDialog endF7 = new BgPeriodDialog((CoreUIObject)this);
        this.prmtEndPeriod.setSelector((KDPromptSelector)endF7);
        BgOrgDialog orgF7 = new BgOrgDialog();
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgF7);
    }

    public static void showUI(IUIObject ui, String fillType) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"fillType", (Object)fillType);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FpTemFormatImportUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    protected void btnAddItem_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"isBatchFill", (Object)true);
        uiContext.put((Object)"Owner", (Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FpItemGroupF7UI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    public void fillItemTable(List itemList) {
        if (itemList == null || itemList.size() <= 0) {
            return;
        }
        FpItemInfo info = null;
        String id = null;
        IRow row = null;
        int size = itemList.size();
        for (int i = 0; i < size; ++i) {
            info = (FpItemInfo)itemList.get(i);
            id = info.getId().toString();
            if (this.itemMap.containsKey(id)) continue;
            this.itemMap.put(id, id);
            row = this.itemTable.addRow();
            row.setUserObject((Object)info);
            row.getCell("number").setValue((Object)info.getNumber());
            row.getCell("name").setValue((Object)info.getName());
        }
    }

    protected void btnRemoveItem_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        int rowIndex = this.itemTable.getSelectManager().getActiveRowIndex();
        if (rowIndex != -1 && (row = this.itemTable.getRow(rowIndex)) != null && row.getUserObject() != null && row.getUserObject() instanceof FpItemInfo) {
            this.itemMap.remove(((FpItemInfo)row.getUserObject()).getId().toString());
            this.itemTable.removeRow(rowIndex);
        }
    }

    protected void btnAddAssistItem_actionPerformed(ActionEvent e) throws Exception {
        FpAssistItemGroupF7UI.showF7UI((IUIObject)this, true);
    }

    public void fillAssistItemTable(List itemList) {
        if (itemList == null || itemList.size() <= 0) {
            return;
        }
        FpAssistItemInfo info = null;
        String id = null;
        IRow row = null;
        int size = itemList.size();
        for (int i = 0; i < size; ++i) {
            info = (FpAssistItemInfo)itemList.get(i);
            id = info.getId().toString();
            if (this.assistItemMap.containsKey(id)) continue;
            this.assistItemMap.put(id, id);
            row = this.assistItemTable.addRow();
            row.setUserObject((Object)info);
            row.getCell("number").setValue((Object)info.getNumber());
            row.getCell("name").setValue((Object)info.getName());
            row.getCell("groupNumber").setValue((Object)info.getGroup().getNumber());
            row.getCell("groupName").setValue((Object)info.getGroup());
        }
    }

    protected void btnRemoveAssistItem_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        int rowIndex = this.assistItemTable.getSelectManager().getActiveRowIndex();
        if (rowIndex != -1 && (row = this.assistItemTable.getRow(rowIndex)) != null && row.getUserObject() != null && row.getUserObject() instanceof FpAssistItemInfo) {
            this.assistItemMap.remove(((FpAssistItemInfo)row.getUserObject()).getId().toString());
            this.assistItemTable.removeRow(rowIndex);
        }
    }

    protected void btnAntiSelect_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock kdtSb = this.selectedItemTable.getSelectManager().get();
        if (kdtSb == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"selectRightItem"));
            return;
        }
        int beginIndex = kdtSb.getBeginRow();
        int endIndex = kdtSb.getEndRow();
        if (beginIndex != -1) {
            for (int i = endIndex; i >= beginIndex; --i) {
                this.selectedItemTable.removeRow(i);
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"selectRightItem"));
            return;
        }
    }

    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.itemTable == null || this.itemTable.getRowCount() <= 0) {
            throw new FpTemplateException(FpTemplateException.PLANITEM_ISNULL);
        }
        boolean isAssistGroup = this.cbxAssistGroup.isSelected();
        int temp = FpTemFormatImportUIHelper.fillSelectedTable(this.itemTable, this.assistItemTable, this.selectedItemTable, isAssistGroup);
        if (temp > this.itemColCount) {
            this.itemColCount = temp;
        }
    }

    protected void btnAntiSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.selectedItemTable.removeRows();
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        System.out.println("******beforeFillTemplate start time = " + new Timestamp(System.currentTimeMillis()));
        this.beforeFillTemplate();
        System.out.println("******beforeFillTemplate end time and fillTempLate start time = " + new Timestamp(System.currentTimeMillis()));
        this.fillTemplate();
        System.out.println("******fillTempLate start time = " + new Timestamp(System.currentTimeMillis()));
        this.disposeUIWindow();
    }

    private void verifyInput() throws Exception {
        if (this.selectedItemTable == null || this.selectedItemTable.getRowCount() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"genItemIsNull"));
            SysUtil.abort();
        }
        if (this.txtPosition.getText() == null || this.txtPosition.getText().trim().equals("")) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"inputPosition"));
            SysUtil.abort();
        }
        FpTemFormatImportUIHelper.isValidPeriod((Component)((Object)this), this.prmtBeginPeriod, this.prmtEndPeriod);
        if (!this.cbxFpActual.isSelected() && !this.cbxFpData.isSelected()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"fpActualOrDataIsSelected"));
            SysUtil.abort();
        }
    }

    protected void beforeFillTemplate() throws EASBizException, BOSException {
        this.currentTable = this.fpTemProcessUI.getPnlTables().getCurrentPage();
        if (this.currentTable.getStyleAttributes().isLocked()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.BatchFill_Lock_NoFill"));
            SysUtil.abort();
        }
        CellReference cellReference = TableToolkit.parsePosition((String)this.txtPosition.getText());
        this.fillRowIndex = cellReference.region.y1;
        this.fillColIndex = cellReference.region.x1;
        BgPeriodCollection periodColl = FpTemFormatImportUIHelper.getPeriodColl(this.prmtBeginPeriod, this.prmtEndPeriod);
        List dataTypeList = FpTemFormatImportUIHelper.getDataTypeList(this.cbxFpData.isSelected(), this.cbxFpActual.isSelected());
        CurrencyInfo currency = null;
        if (this.comboCurrency.getSelectedItem() != null && this.comboCurrency.getSelectedItem() instanceof CurrencyInfo) {
            currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        }
        OrgUnitInfo ouInfo = null;
        if (this.prmtOrgUnit.getValue() != null && this.prmtOrgUnit.getValue() instanceof OrgUnitInfo) {
            ouInfo = (OrgUnitInfo)this.prmtOrgUnit.getValue();
        }
        FpValueTypeEnum valueType = null;
        if (this.comboValueType.getSelectedItem() != null && this.comboValueType.getSelectedItem() instanceof FpValueTypeEnum) {
            valueType = (FpValueTypeEnum)((Object)this.comboValueType.getSelectedItem());
        }
        List itemList = FpTemFormatImportUIHelper.getItemList(this.selectedItemTable);
        Map itemFormulaMap = null;
        if (this.fillType.equals("dataFormula")) {
            BgPeriodInfo beginPeriod = (BgPeriodInfo)this.prmtBeginPeriod.getValue();
            BgPeriodInfo endPeriod = (BgPeriodInfo)this.prmtEndPeriod.getValue();
            itemFormulaMap = FpTemFormatImportUIHelper.getDataFormulaList(this.selectedItemTable, beginPeriod, endPeriod, dataTypeList, currency, ouInfo, valueType);
        } else {
            itemFormulaMap = FpTemFormatImportUIHelper.getItemFormulaList(this.selectedItemTable, periodColl, dataTypeList, currency);
        }
        this.importInfo.setPeriodList(periodColl);
        this.importInfo.setDataTypeList(dataTypeList);
        this.importInfo.setItemList(itemList);
        this.importInfo.setFormulaMap(itemFormulaMap);
    }

    private void fillTemplate() throws EASBizException, BOSException {
        BgPeriodCollection periodColl = this.importInfo.getPeriodList();
        List dataTypeList = this.importInfo.getDataTypeList();
        List itemList = this.importInfo.getItemList();
        int headRowCount = 1;
        int headColCount = FpTemFormatImportUIHelper.getHeadColCount(this.fillType, periodColl, dataTypeList);
        int itemRowCount = itemList.size();
        int itemColCount1 = this.itemColCount;
        this.dynaManageTable(headRowCount, itemRowCount, headColCount, itemColCount1);
        this.clearFillArea(headRowCount, headColCount, itemRowCount, itemColCount1);
        this.fillHeadRow(periodColl, dataTypeList, itemColCount1);
        this.fillItemCombine(itemList, headRowCount);
        this.fillFormula(headRowCount, headColCount, itemRowCount, itemColCount1);
    }

    private void dynaManageTable(int headRowCount, int itemRowCount, int headColCount, int itemColCount) {
        int colTotalCount = this.currentTable.getColumnCount();
        if (this.fillColIndex + itemColCount + headColCount > colTotalCount) {
            for (int i = 0; i < itemColCount + headColCount; ++i) {
                this.currentTable.addColumn();
            }
        }
    }

    private void clearFillArea(int headRowCount, int headColCount, int itemRowCount, int itemColCount) throws FpTemplateException {
        int clearRowIndex = this.fillRowIndex + headRowCount + itemRowCount - 1;
        int clearColIndex = this.fillColIndex + headColCount + itemColCount - 1;
        if (clearRowIndex > this.currentTable.getRowCount1() || clearColIndex > this.currentTable.getColumnCount()) {
            String clearRange = "(" + clearRowIndex + ", " + clearColIndex + ")";
            String tableRange = "(" + this.currentTable.getRowCount1() + ", " + this.currentTable.getColumnCount() + ")";
            throw new FpTemplateException(FpTemplateException.CLEARRANGE_ISTOOLARGE, new String[]{clearRange, tableRange});
        }
        Coordinate beginCod = new Coordinate(this.fillRowIndex, this.fillColIndex);
        Coordinate endCod = new Coordinate(clearRowIndex, clearColIndex);
        FpTemFormatImportUIHelper.clearFillArea(this.currentTable, beginCod, endCod);
    }

    private void fillHeadRow(BgPeriodCollection fpPeriodColl, List dataTypeList, int itemColCount) {
        System.out.println("******fillHeadRow start time = " + new Timestamp(System.currentTimeMillis()));
        int colIndex = this.fillColIndex + itemColCount;
        String headTitle = "";
        if (this.fillType.equals("dataFormula") || fpPeriodColl == null || fpPeriodColl.size() == 0) {
            int size = dataTypeList.size();
            for (int i = 0; i < size; ++i) {
                headTitle = ((FpDataTypeEnum)((Object)dataTypeList.get(i))).getAlias();
                FpTemFormatImportUIHelper.setCellValue(this.currentTable.getRow(this.fillRowIndex).getCell(colIndex++), headTitle, false);
            }
        } else {
            String temp = null;
            for (int i = 0; i < fpPeriodColl.size(); ++i) {
                temp = headTitle = fpPeriodColl.get(i).getName();
                int size = dataTypeList.size();
                for (int j = 0; j < size; ++j) {
                    headTitle = temp + ((FpDataTypeEnum)((Object)dataTypeList.get(j))).getAlias();
                    FpTemFormatImportUIHelper.setCellValue(this.currentTable.getRow(this.fillRowIndex).getCell(colIndex++), headTitle, false);
                }
            }
        }
        System.out.println("******fillHeadRow end time = " + new Timestamp(System.currentTimeMillis()));
    }

    private void fillItemCombine(List itemList, int headRowCount) {
        System.out.println("******fillItemCombine start time = " + new Timestamp(System.currentTimeMillis()));
        int itemFillRowIndex = this.fillRowIndex + headRowCount;
        int itemFillColIndex = this.fillColIndex;
        TempValueObject tempVO = null;
        TempValueObject tempVO2 = null;
        FpItemInfo itemInfo = null;
        FpAssistItemInfo asstItemInfo = null;
        int tempColIndex = this.fillColIndex;
        int itemRowCount = itemList.size();
        int itemColCount1 = this.itemColCount;
        FpItemShowTypeEnum showType = (FpItemShowTypeEnum)this.comboTemDisplay.getSelectedItem();
        int size = itemList.size();
        for (int i = 0; i < size; ++i) {
            tempVO = (TempValueObject)itemList.get(i);
            tempVO.setShowType(showType);
            itemInfo = tempVO.getItemInfo();
            itemInfo.setShowType(showType);
            itemFillColIndex = tempColIndex;
            FpTemFormatImportUIHelper.setCellUserObject(this.currentTable.getCell(itemFillRowIndex, itemFillColIndex), tempVO.getItemNum(), false);
            FpTemFormatImportUIHelper.setCellValue(this.currentTable.getCell(itemFillRowIndex, itemFillColIndex), tempVO.getItem(), false);
            if (tempVO.getAsstItemName() != null && tempVO.getAsstItemName().trim().length() > 0) {
                String[] asstItemNumbers = tempVO.getAsstItemNum().split("\\|");
                String[] asstItemNames = tempVO.getAsstItemName().split("\\|");
                for (int j = 0; j < asstItemNames.length; ++j) {
                    tempVO2 = new TempValueObject();
                    tempVO2.setShowType(showType);
                    tempVO2.setAsstItemNum(asstItemNumbers[j]);
                    tempVO2.setAsstItemName(asstItemNames[j]);
                    asstItemInfo = new FpAssistItemInfo();
                    asstItemInfo.setShowType(showType);
                    asstItemInfo.setNumber(asstItemNumbers[j]);
                    asstItemInfo.setName(asstItemNames[j]);
                    int temp = ++itemFillColIndex;
                    FpTemFormatImportUIHelper.setCellUserObject(this.currentTable.getCell(itemFillRowIndex, temp), tempVO2.getAsstItemNum(), false);
                    FpTemFormatImportUIHelper.setCellValue(this.currentTable.getCell(itemFillRowIndex, temp), tempVO2.getAsstItem(), false);
                }
            }
            ++itemFillRowIndex;
        }
        this.handleLevelIndent(itemList, headRowCount);
        itemFillRowIndex = this.fillRowIndex + headRowCount;
        itemFillColIndex = this.fillColIndex;
        this.currentTable.getMergeManager().mergeBlock(itemFillRowIndex, itemFillColIndex, itemFillRowIndex + itemRowCount - 1, itemFillColIndex + itemColCount1 - 1, 3);
        System.out.println("******fillItemCombine end time = " + new Timestamp(System.currentTimeMillis()));
    }

    private void handleLevelIndent(List itemList, int headRowCount) {
        int j;
        int i;
        int indent = ((GradeShowIndentEnum)((Object)this.comboIndent.getSelectedItem())).getValue();
        ICell cell = null;
        Object obj1 = null;
        Object obj2 = null;
        boolean len = false;
        for (i = 0; i < this.itemColCount; ++i) {
            block1: for (j = 0; j < itemList.size() - 1; ++j) {
                cell = this.currentTable.getRow(this.fillRowIndex + headRowCount + j).getCell(this.fillColIndex + i);
                if (cell.getUserObject() == null || !(cell.getUserObject() instanceof String) || ((String)cell.getUserObject()).equals("")) continue;
                String number = (String)cell.getUserObject();
                obj1 = cell.getValue();
                for (int k = j + 1; k < itemList.size(); ++k) {
                    cell = this.currentTable.getRow(this.fillRowIndex + headRowCount + k).getCell(this.fillColIndex + i);
                    if (cell.getUserObject() == null || !(cell.getUserObject() instanceof String) || ((String)cell.getUserObject()).equals("")) continue;
                    String tempNumber = (String)cell.getUserObject();
                    String value = cell.getValue().toString();
                    obj2 = cell.getValue();
                    if (tempNumber.startsWith(number + ".")) {
                        FpTemFormatImportUIHelper.setCellValue(cell, FpTemFormatImportUIHelper.getBlank(indent) + value, false);
                        continue;
                    }
                    len = false;
                    continue block1;
                }
            }
        }
        for (i = 0; i < itemList.size(); ++i) {
            for (j = 0; j < this.itemColCount; ++j) {
                FpTemFormatImportUIHelper.setCellUserObject(this.currentTable.getRow(this.fillRowIndex + headRowCount + i).getCell(this.fillColIndex + j), null, false);
            }
        }
    }

    private void fillFormula(int headRowCount, int headColCount, int itemRowCount, int itemColCount) {
        System.out.println("******fillItemFormula start time = " + new Timestamp(System.currentTimeMillis()));
        int formulaRowIndex = this.fillRowIndex + headRowCount;
        int formulaColIndex = this.fillColIndex + itemColCount;
        Map formulaMap = this.importInfo.getFormulaMap();
        FpFormulaInfo formulaInfo = null;
        Coordinate coordinate = null;
        int tempColIndex = formulaColIndex;
        RptCell eptCell = null;
        ICell cell = null;
        IRow row = null;
        boolean isDataFormulaFill = this.fillType.equals("dataFormula");
        FPFormulaFormat formulaFmt = null;
        formulaFmt = isDataFormulaFill ? FPDataFormulaFormat.getInstance() : FPItemFormulaFormat.getInstance();
        for (int i = 0; i < itemRowCount; ++i) {
            formulaColIndex = tempColIndex;
            row = this.currentTable.getRow(formulaRowIndex);
            for (int j = 0; j < headColCount; ++j) {
                cell = row.getCell(formulaColIndex);
                eptCell = new RptCell(cell);
                coordinate = new Coordinate(i, j);
                formulaInfo = (FpFormulaInfo)formulaMap.get(coordinate);
                formulaMap.remove(coordinate);
                if (isDataFormulaFill) {
                    cell.setExpressions(formulaFmt.format(formulaInfo));
                } else {
                    eptCell.setItemFormula(formulaFmt.format(formulaInfo));
                    cell.setUserObject((Object)eptCell);
                }
                ++formulaColIndex;
            }
            ++formulaRowIndex;
        }
        System.out.println("******fillItemFormula end time = " + new Timestamp(System.currentTimeMillis()));
    }
}

