/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fpl.Coordinate;
import com.kingdee.eas.fm.fpl.FpAssistItemGroupInfo;
import com.kingdee.eas.fm.fpl.FpAssistItemInfo;
import com.kingdee.eas.fm.fpl.FpDataFormulaInfo;
import com.kingdee.eas.fm.fpl.FpDataTypeEnum;
import com.kingdee.eas.fm.fpl.FpHelper;
import com.kingdee.eas.fm.fpl.FpItemFormulaInfo;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fpl.FpValueTypeEnum;
import com.kingdee.eas.fm.fpl.TempValueObject;
import com.kingdee.eas.fm.fpl.client.FpClientHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FpTemFormatImportUIHelper {
    public static final int COL_TYPE = 1;
    public static final int ROW_TYPE = 2;
    private static final String RESOURCE = "com.kingdee.eas.fm.fpl.client.FpTemFormatResource";

    public static void isValidPeriod(Component ui, KDBizPromptBox prmtBeginPeriod, KDBizPromptBox prmtEndPeriod) {
        if (prmtBeginPeriod.getData() == null && prmtEndPeriod.getData() != null) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RESOURCE, (String)"inputBeginPeriod"));
            SysUtil.abort();
        }
        if (prmtBeginPeriod.getData() != null && prmtEndPeriod.getData() == null) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RESOURCE, (String)"inputEndPeriod"));
            SysUtil.abort();
        }
        if (prmtBeginPeriod.getData() != null && prmtEndPeriod.getData() != null) {
            boolean isBeginLargerEnd;
            BgPeriodInfo endPeriod;
            BgPeriodInfo beginPeriod = (BgPeriodInfo)prmtBeginPeriod.getData();
            if (!FpHelper.isSamePeriodType(beginPeriod, endPeriod = (BgPeriodInfo)prmtEndPeriod.getData())) {
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RESOURCE, (String)"inputSameTypePeriod"));
                SysUtil.abort();
            }
            if (isBeginLargerEnd = FpHelper.isBeginLargerEnd(beginPeriod, endPeriod)) {
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RESOURCE, (String)"beginBiggerEnd"));
                SysUtil.abort();
            }
        }
    }

    public static BgPeriodCollection getPeriodColl(KDBizPromptBox prmtBeginPeriod, KDBizPromptBox prmtEndPeriod) throws BOSException, EASBizException {
        BgPeriodCollection periodColl = new BgPeriodCollection();
        if (prmtBeginPeriod.getValue() == null && prmtBeginPeriod.getValue() == null) {
            return periodColl;
        }
        if (prmtBeginPeriod.getValue() == null || prmtEndPeriod.getValue() == null) {
            throw new NullPointerException("BeginPeriod or endPeriod is Null!");
        }
        BgPeriodInfo begin = (BgPeriodInfo)prmtBeginPeriod.getValue();
        BgPeriodInfo end = (BgPeriodInfo)prmtEndPeriod.getValue();
        return FpHelper.getPeriodColl(begin, end);
    }

    public static List getDataTypeList(boolean isFpData, boolean isFpActual) {
        ArrayList<FpDataTypeEnum> dataTypeList = new ArrayList<FpDataTypeEnum>();
        if (isFpData) {
            dataTypeList.add(FpDataTypeEnum.P);
        }
        if (isFpActual) {
            dataTypeList.add(FpDataTypeEnum.A);
        }
        return dataTypeList;
    }

    public static HashMap getGroupMap(KDTable assistItemTable) {
        List assistItemList = FpClientHelper.kdt2List(assistItemTable);
        return FpTemFormatImportUIHelper.getGroupMap(assistItemList);
    }

    public static HashMap getGroupMap(List assistItemList) {
        HashMap<String, String> groupIDMap = new HashMap<String, String>();
        FpAssistItemInfo assistItem = null;
        FpAssistItemGroupInfo group = null;
        int count = assistItemList.size();
        for (int i = 0; i < count; ++i) {
            assistItem = (FpAssistItemInfo)assistItemList.get(i);
            group = assistItem.getGroup();
            if (groupIDMap.containsKey(group.getId().toString())) continue;
            groupIDMap.put(group.getId().toString(), group.getId().toString());
        }
        return groupIDMap;
    }

    public static Map getGroupAndItemMap(KDTable assistItemTable) {
        List assistItemList = FpClientHelper.kdt2List(assistItemTable);
        return FpTemFormatImportUIHelper.getGroupAndItemMap(assistItemList);
    }

    public static Map getGroupAndItemMap(List assistItemList) {
        String[] sortArray = new String[]{"group.longNumber", "longNumber"};
        assistItemList = (List)FpHelper.sortCollection(assistItemList, sortArray, true);
        LinkedHashMap<String, ArrayList> groupAndItemMap = new LinkedHashMap<String, ArrayList>();
        int count = assistItemList.size();
        for (int i = 0; i < count; ++i) {
            ArrayList itemList;
            FpAssistItemInfo assistItem = (FpAssistItemInfo)assistItemList.get(i);
            FpAssistItemGroupInfo group = assistItem.getGroup();
            if (groupAndItemMap.containsKey(group.getLongNumber())) {
                itemList = (ArrayList)groupAndItemMap.get(group.getLongNumber());
                if (itemList.contains(assistItem)) continue;
                itemList.add(assistItem);
                continue;
            }
            itemList = new ArrayList();
            itemList.add(assistItem);
            groupAndItemMap.put(group.getLongNumber(), itemList);
        }
        return groupAndItemMap;
    }

    public static List getItemList(KDTable table) {
        ArrayList<TempValueObject> itemList = new ArrayList<TempValueObject>();
        TempValueObject tempVO = null;
        FpItemInfo itemInfo = null;
        IRow row = null;
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = table.getRow(i);
            tempVO = new TempValueObject();
            itemInfo = new FpItemInfo();
            itemInfo.setNumber(row.getCell(0).getValue().toString());
            itemInfo.setName(row.getCell(1).getValue().toString());
            tempVO.setItemInfo(itemInfo);
            tempVO.setItemNum(row.getCell(0).getValue().toString());
            tempVO.setItemName(row.getCell(1).getValue().toString());
            if (row.getCell(2) != null && row.getCell(2).getValue() != null) {
                tempVO.setAsstGroupItemNum(row.getCell(2).getValue().toString());
            }
            if (row.getCell(3) != null && row.getCell(3).getValue() != null) {
                tempVO.setAsstGroupItemName(row.getCell(3).getValue().toString());
            }
            if (row.getCell(4) != null && row.getCell(4).getValue() != null) {
                tempVO.setAsstItemNum(row.getCell(4).getValue().toString());
            }
            if (row.getCell(5) != null && row.getCell(5).getValue() != null) {
                tempVO.setAsstItemName(row.getCell(5).getValue().toString());
            }
            itemList.add(tempVO);
        }
        return itemList;
    }

    public static Map getItemFormulaList(KDTable selectedItemTable, BgPeriodCollection periodColl, List dataTypeList, CurrencyInfo currency) {
        int rowCount = selectedItemTable.getRowCount();
        HashMap<Coordinate, FpItemFormulaInfo> formulaMap = new HashMap<Coordinate, FpItemFormulaInfo>();
        FpItemFormulaInfo formula = null;
        for (int i = 0; i < rowCount; ++i) {
            if (periodColl.size() <= 0) {
                for (int j = 0; j < dataTypeList.size(); ++j) {
                    Coordinate ordinate = new Coordinate(i, j);
                    formula = FpTemFormatImportUIHelper.getFpItemFormulaInfo(selectedItemTable, i, null, (FpDataTypeEnum)((Object)dataTypeList.get(j)), currency);
                    formulaMap.put(ordinate, formula);
                }
                continue;
            }
            int y = 0;
            for (int j = 0; j < periodColl.size(); ++j) {
                for (int k = 0; k < dataTypeList.size(); ++k) {
                    Coordinate ordinate = new Coordinate(i, y++);
                    formula = FpTemFormatImportUIHelper.getFpItemFormulaInfo(selectedItemTable, i, periodColl.get(j), (FpDataTypeEnum)((Object)dataTypeList.get(k)), currency);
                    formulaMap.put(ordinate, formula);
                }
            }
        }
        return formulaMap;
    }

    private static FpItemFormulaInfo getFpItemFormulaInfo(KDTable selectedItemTable, int rowIndex, BgPeriodInfo period, FpDataTypeEnum dataType, CurrencyInfo currency) {
        FpItemFormulaInfo formula = new FpItemFormulaInfo();
        formula.setItemNum((String)selectedItemTable.getCell(rowIndex, 0).getValue());
        formula.setAsstItemCombine((String)selectedItemTable.getCell(rowIndex, 2).getValue());
        if (period != null) {
            formula.setPeriodNum(period.getNumber());
        }
        formula.setDataType(dataType);
        if (currency != null) {
            formula.setCurrencyNum(currency.getNumber());
        }
        return formula;
    }

    public static Map getDataFormulaList(KDTable selectedItemTable, BgPeriodInfo beginPeriod, BgPeriodInfo endPeriod, List dataTypeList, CurrencyInfo currency, OrgUnitInfo ouInfo, FpValueTypeEnum valueType) {
        int rowCount = selectedItemTable.getRowCount();
        HashMap<Coordinate, FpDataFormulaInfo> formulaMap = new HashMap<Coordinate, FpDataFormulaInfo>();
        FpDataFormulaInfo formula = null;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < dataTypeList.size(); ++j) {
                Coordinate ordinate = new Coordinate(i, j);
                formula = FpTemFormatImportUIHelper.getFpDataFormulaInfo(ouInfo, selectedItemTable, i, beginPeriod, endPeriod, valueType, (FpDataTypeEnum)((Object)dataTypeList.get(j)), currency);
                formulaMap.put(ordinate, formula);
            }
        }
        return formulaMap;
    }

    private static FpDataFormulaInfo getFpDataFormulaInfo(OrgUnitInfo ouInfo, KDTable selectedItemTable, int rowIndex, BgPeriodInfo beginPeriod, BgPeriodInfo endPeriod, FpValueTypeEnum valueType, FpDataTypeEnum dataType, CurrencyInfo currency) {
        FpDataFormulaInfo formula = new FpDataFormulaInfo();
        if (ouInfo != null) {
            formula.setOrgUnitNum(ouInfo.getNumber());
        }
        formula.setItemNum(((FpItemInfo)selectedItemTable.getCell(rowIndex, 0).getUserObject()).getNumber());
        formula.setAsstItemCombine((String)selectedItemTable.getCell(rowIndex, 2).getValue());
        if (beginPeriod != null) {
            formula.setBPeriodNum(beginPeriod.getNumber());
        }
        if (endPeriod != null) {
            formula.setEPeriodNum(endPeriod.getNumber());
        }
        formula.setValueType(valueType);
        formula.setDataType(dataType);
        if (currency != null) {
            formula.setCurrencyNum(currency.getNumber());
        }
        return formula;
    }

    public static int getHeadColCount(String fillType, BgPeriodCollection periodColl, List dataTypeList) {
        if (fillType.equals("dataFormula") || periodColl == null || periodColl.size() <= 0) {
            return dataTypeList.size();
        }
        return periodColl.size() * dataTypeList.size();
    }

    public static void clearFillArea(KDTable table, Coordinate beginCod, Coordinate endCod) {
        for (int i = beginCod.getX(); i <= endCod.getX(); ++i) {
            for (int j = beginCod.getY(); j <= endCod.getY(); ++j) {
                table.getCell(i, j).getStyleAttributes().setLocked(false);
            }
        }
        table.getMergeManager().splitBlock(beginCod.getX(), beginCod.getY(), endCod.getX(), endCod.getY());
    }

    public static void setCellUserObject(ICell cell, Object content, boolean isLock) {
        if (cell == null || cell.getStyleAttributes().isLocked()) {
            return;
        }
        cell.setUserObject(content);
        cell.setExpressions(null);
        cell.getStyleAttributes().setLocked(isLock);
    }

    public static void setCellValue(ICell cell, Object content, boolean isLock) {
        if (cell == null || cell.getStyleAttributes().isLocked()) {
            return;
        }
        cell.setValue(content);
        cell.setExpressions(null);
        cell.getStyleAttributes().setLocked(isLock);
    }

    public static String getBlank(int len) {
        String result = "";
        for (int i = 0; i < len; ++i) {
            result = result + " ";
        }
        return result;
    }

    public static int fillSelectedTable(KDTable itemTable, KDTable assistItemTable, KDTable selectedItemTable, boolean isAssistGroup) {
        int asstItemCount = assistItemTable.getRowCount();
        if (asstItemCount <= 0) {
            return FpTemFormatImportUIHelper.fillSelectedTableWithOnlyItem(itemTable, selectedItemTable);
        }
        if (!isAssistGroup) {
            return FpTemFormatImportUIHelper.fillSelectedTableWithNoGroup(itemTable, assistItemTable, selectedItemTable);
        }
        return FpTemFormatImportUIHelper.fillSelectedTableWithGroup(itemTable, assistItemTable, selectedItemTable);
    }

    private static int fillSelectedTableWithOnlyItem(KDTable itemTable, KDTable selectedItemTable) {
        int itemCount = itemTable.getRowCount();
        IRow row = null;
        for (int i = 0; i < itemCount; ++i) {
            if (itemTable.getRow(i) == null) continue;
            row = selectedItemTable.addRow();
            row.getCell(0).setUserObject(itemTable.getRow(i).getUserObject());
            row.getCell(0).setValue(itemTable.getRow(i).getCell(0).getValue());
            row.getCell(1).setValue(itemTable.getRow(i).getCell(1).getValue());
        }
        return 1;
    }

    private static int fillSelectedTableWithNoGroup(KDTable itemTable, KDTable assistItemTable, KDTable selectedItemTable) {
        int itemCount = itemTable.getRowCount();
        int asstItemCount = assistItemTable.getRowCount();
        IRow row = null;
        FpAssistItemInfo asstItemInfo = null;
        for (int i = 0; i < itemCount; ++i) {
            if (itemTable.getRow(i) == null) continue;
            for (int j = 0; j < asstItemCount; ++j) {
                row = selectedItemTable.addRow();
                row.getCell(0).setUserObject(itemTable.getRow(i).getUserObject());
                row.getCell(0).setValue(itemTable.getCell(i, 0).getValue());
                row.getCell(1).setValue(itemTable.getCell(i, 1).getValue());
                asstItemInfo = (FpAssistItemInfo)assistItemTable.getRow(j).getUserObject();
                row.getCell(2).setValue((Object)(asstItemInfo.getGroup().getNumber() + "|" + asstItemInfo.getNumber()));
                row.getCell(3).setValue((Object)(asstItemInfo.getGroup().getName() + "|" + asstItemInfo.getName()));
                row.getCell(4).setValue((Object)asstItemInfo.getNumber());
                row.getCell(5).setValue((Object)asstItemInfo.getName());
            }
        }
        return 2;
    }

    private static int fillSelectedTableWithGroup(KDTable itemTable, KDTable assistItemTable, KDTable selectedItemTable) {
        int itemCount = itemTable.getRowCount();
        Map groupAndItemMap = FpTemFormatImportUIHelper.getGroupAndItemMap(assistItemTable);
        ArrayList groupAndItemList = new ArrayList(groupAndItemMap.values());
        List combineList = FpHelper.genAssistItemCombine(groupAndItemList);
        TempValueObject tempVO = null;
        IRow row = null;
        for (int i = 0; i < itemCount; ++i) {
            for (int j = 0; j < combineList.size(); ++j) {
                tempVO = (TempValueObject)combineList.get(j);
                row = selectedItemTable.addRow();
                row.getCell(0).setUserObject(itemTable.getRow(i).getUserObject());
                row.getCell(0).setValue(itemTable.getRow(i).getCell(0).getValue());
                row.getCell(1).setValue(itemTable.getRow(i).getCell(1).getValue());
                row.getCell(2).setValue((Object)tempVO.getAsstGroupItemNum());
                row.getCell(3).setValue((Object)tempVO.getAsstGroupItemName());
                row.getCell(4).setValue((Object)tempVO.getAsstItemNum());
                row.getCell(5).setValue((Object)tempVO.getAsstItemName());
            }
        }
        return groupAndItemMap.size() + 1;
    }
}

