/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.client.RptMenuStrategy;
import com.kingdee.eas.fi.rpt.client.RptMuliReportModel;
import com.kingdee.eas.fi.rpt.client.RptStrategyManager;
import com.kingdee.eas.fm.fpl.FpTemplateFactory;
import com.kingdee.eas.fm.fpl.FpTemplateInfo;
import com.kingdee.eas.fm.fpl.FpTemplateSourceEnum;
import com.kingdee.eas.fm.fpl.IFpTemplate;
import com.kingdee.eas.fm.fpl.client.AbstractFpTemplateEditUI;
import com.kingdee.eas.fm.fpl.client.FpClientHelper;
import com.kingdee.eas.fm.fpl.client.FpTemMenuStrategy;
import com.kingdee.eas.fm.fpl.client.FpTemplateProcessUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class FpTemplateEditUI
extends AbstractFpTemplateEditUI {
    private FpTemplateInfo objOld = null;
    private static final Logger logger = CoreUIObject.getLogger(FpTemplateEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.fm.fpl.client.FpTemplateResource";
    private boolean isShowMsgWhenProcessChange = true;
    private String reportID = null;
    private boolean saved = false;
    private boolean openReport = false;
    IUIWindow uiWindow = null;
    RptStrategyManager rptStrategyManager = null;
    RptMuliReportModel rptMuliReportModel = new RptMuliReportModel();
    private CompanyOrgUnitInfo companyInfo = null;
    private FpTemplateInfo copyBackupInfo = null;

    private void initOldEditData() {
        this.objOld = (FpTemplateInfo)this.editData.clone();
    }

    public void onLoad() throws Exception {
        ArrayList selectIds;
        super.onLoad();
        if (this.companyInfo == null) {
            this.companyInfo = ClientUtils.getCurrLoginCompany();
        }
        if (this.getUIContext().get("isShowMsgWhenProcessChange") != null) {
            this.isShowMsgWhenProcessChange = (Boolean)this.getUIContext().get("isShowMsgWhenProcessChange");
        }
        if ("VIEW".equals(this.getOprtState()) && (selectIds = (ArrayList)this.getUIContext().get("selectIds")) != null && selectIds.size() > 1) {
            for (int i = 0; i < selectIds.size(); ++i) {
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)selectIds.get(i).toString()));
                this.rptMuliReportModel.put((Object)selectIds.get(i).toString(), (Object)this.getValue((IObjectPK)pk));
            }
        }
        if (this.getUIContext().get("isOpenReport") != null) {
            this.openReport = (Boolean)this.getUIContext().get("isOpenReport");
        }
        if (this.openReport) {
            String openReportState = this.getUIContext().get("OpenReportState").toString();
            this.reportID = (String)this.getUIContext().get("ID");
            BgClientHelper.applyMutexService((Component)((Object)this), (String)this.reportID, (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            this.openReportUI(openReportState);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("kdtdata"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        return sic;
    }

    protected IObjectValue createNewData() {
        FpTemplateInfo info = null;
        Map context = this.getUIContext();
        FullOrgUnitInfo ouInfo = (FullOrgUnitInfo)context.get("orgUnit");
        String action = (String)context.get("COPY");
        if (action != null && action.equals("COPY")) {
            String id = (String)context.get("ID");
            try {
                IFpTemplate iFpTemplate = FpTemplateFactory.getRemoteInstance();
                info = (FpTemplateInfo)iFpTemplate.copy(BOSUuid.read((String)id));
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
                this.copyBackupInfo = (FpTemplateInfo)info.clone();
                info.setKdtData(null);
                info.setOrgUnit(ouInfo);
                info.setParent(info);
                info.setRoot(info);
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.handUIException(e);
            }
        } else {
            info = new FpTemplateInfo();
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            info.setOrgUnit(ouInfo);
            info.setSource(FpTemplateSourceEnum.LOCAL);
            info.setFpCycle(BgPeriodEnum.YEAR);
            info.setParent(info);
            info.setRoot(info);
        }
        return info;
    }

    public void loadFields() {
        super.loadFields();
        this.objOld = this.editData;
        if (this.getParent() != null && this.getParent() instanceof KDPanel) {
            KDToolBar toolBar = this.getUIToolBar();
            toolBar.setVisible(false);
        }
    }

    public RptStrategyManager getRptStrategyManager() {
        if (this.rptStrategyManager == null) {
            this.rptStrategyManager = new RptStrategyManager();
            FpTemMenuStrategy fpTempMenuStrategy = new FpTemMenuStrategy();
            this.rptStrategyManager.setRptMenuStartegy((RptMenuStrategy)fpTempMenuStrategy);
            this.rptStrategyManager.setRptMuliReportModel(this.rptMuliReportModel);
            this.rptStrategyManager.setCslParamStartegy(false);
        }
        return this.rptStrategyManager;
    }

    public void setData(byte[] data) {
        this.editData.setKdtData(data);
    }

    public byte[] getData() {
        return this.editData.getKdtData();
    }

    private boolean verifyProcessData() throws EASBizException, BOSException, Exception {
        String msg = ((IFpTemplate)this.getBizInterface()).checkFormulaDup(this.editData);
        if (msg != null && msg.trim().length() > 0) {
            String title = EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpItemResource", (String)"msgTitle");
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"Title", (Object)title);
            SimpleNotePad.showMessageByModel((UIContext)ctx, (String)msg);
            SysUtil.abort();
        }
        return true;
    }

    public VirtualSheetParamInfo save() throws Exception {
        if (!this.verifyProcessData()) {
            this.getUIWindow().show();
            if (this.getButtonAction() == 1) {
                this.save();
            } else {
                this.abort();
            }
        }
        IFpTemplate iFpTemplate = (IFpTemplate)this.getBizInterface();
        IObjectPK pk = iFpTemplate.submit((CoreBaseInfo)this.editData);
        this.setDataObject((IObjectValue)iFpTemplate.getFpTemplateInfo(pk, this.getSelectors()));
        this.save = true;
        return this.editData;
    }

    public void actionCancelFpTem_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    public void actionEditFpTem_actionPerformed(ActionEvent e) throws Exception {
        super.actionEditFpTem_actionPerformed(e);
        if (this.getUIWindow() != null) {
            this.getUIWindow().hide();
        }
        this.setButtonAction(1);
        if ("EDIT".equals(this.getOprtState()) || "VIEW".equals(this.getOprtState())) {
            this.openReportUI(OprtState.EDIT);
        }
    }

    public String getProcessUI() {
        return FpTemplateProcessUI.class.getName();
    }

    public boolean destroyWindow() {
        if (this.openReport && BgClientHelper.applyMutexServiceMutiHelp((Component)((Object)this), (String)this.reportID, (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), (IMutexServiceControl)MutexServiceControlFactory.getRemoteInstance())) {
            BgClientHelper.releaseMutexService((String)this.reportID);
        }
        return super.destroyWindow();
    }

    public void checkModified() throws Exception {
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                this.actionSubmit.actionPerformed(event);
                if (this.actionSubmit.isInvokeFailed()) {
                    SysUtil.abort();
                }
            } else if (result == 2) {
                SysUtil.abort();
            }
        }
    }

    protected void openReportUI(String reportState) throws Exception {
        this.setUITitle(EASResource.getString((String)RESOURCE, (String)"fpTemEditFormat"));
        UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
        uiContext.put((Object)"ID", (Object)this.reportID);
        uiContext.put((Object)"self", (Object)this);
        uiContext.put((Object)"saveUI", (Object)this.getMetaDataPK().getFullName());
        uiContext.put((Object)"SYSTEMTIME", (Object)String.valueOf(System.currentTimeMillis()));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getProcessUI(), (Map)uiContext, null, reportState);
        uiWindow.show();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals("ADDNEW")) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            super.actionSubmit_actionPerformed(e);
            this.setDataObject(this.getValue((IObjectPK)pk));
            this.saved = true;
            this.destroyWindow();
            String action = (String)this.getUIContext().get("COPY");
            if (action != null && action.equals("COPY")) {
                this.editData.setKdtData(this.copyBackupInfo.getKdtData());
            }
            this.openReportUI(OprtState.ADDNEW);
        } else {
            this.storeFields();
            this.verifyInput(null);
            IFpTemplate iFpTemplate = FpTemplateFactory.getRemoteInstance();
            iFpTemplate.saveSimpleInfo(this.editData);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"templateSaveSuccess"));
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            this.setDataObject(this.getValue((IObjectPK)pk));
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
        }
        FpClientHelper.refreshFpFormList((CoreUI)this);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        String number = this.txtNumber.getText();
        String name = this.txtName.getText();
        if (number == null || number.trim().equals("") || name == null || name.trim().equals("")) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"isNull"));
            SysUtil.abort();
        }
        if (number.length() > 80) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"tooLongNum"));
            SysUtil.abort();
        }
        if (name.length() > 80) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"tooLongName"));
            SysUtil.abort();
        }
        if (this.txtDescription != null && this.txtDescription.getText().length() > 80) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"tooLongDescription"));
            SysUtil.abort();
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FpTemplateFactory.getRemoteInstance();
    }

    public boolean checkBeforeWindowClosing() {
        if (this.isModify()) {
            int result = -1;
            if (this.isShowMsgWhenProcessChange) {
                result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            }
            if (result == 0 || !this.isShowMsgWhenProcessChange) {
                try {
                    this.actionSubmit.setDaemonRun(false);
                    ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                    this.actionSubmit.actionPerformed(event);
                    return !this.actionSubmit.isInvokeFailed();
                }
                catch (Exception exc) {
                    return false;
                }
            }
            return result == 1;
        }
        return true;
    }

    public RptSheetParamInfo processCreat(String sheetId) {
        RptSheetParamInfo newSheetParam = new RptSheetParamInfo();
        newSheetParam.setReport((VirtualSheetParamInfo)this.editData);
        newSheetParam.setSheetID(sheetId);
        newSheetParam.setRelaType(ReportTypeEnum.TEMPLATE);
        newSheetParam.setStartYear(0);
        newSheetParam.setEndYear(0);
        newSheetParam.setStartPeriod(0);
        newSheetParam.setEndPeriod(0);
        newSheetParam.setStatus(1);
        return newSheetParam;
    }

    public boolean isModify() {
        if (this.saved) {
            return false;
        }
        boolean success = super.isModify();
        return success;
    }
}

