/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fm.fpl.FpTemplateCollection;
import com.kingdee.eas.fm.fpl.FpTemplateFactory;
import com.kingdee.eas.fm.fpl.FpTemplateInfo;
import com.kingdee.eas.fm.fpl.IFpTemplate;
import com.kingdee.eas.fm.fpl.client.AbstractFpTemplateImportUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class FpTemplateImportUI
extends AbstractFpTemplateImportUI {
    private static final Logger logger = CoreUIObject.getLogger(FpTemplateImportUI.class);
    private FullOrgUnitInfo orgUnitInfo = null;
    private Hashtable selectedTemplates = new Hashtable();
    private boolean isConfirm = true;

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDLabelTemplate.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.btnAll_actionPerformed(null);
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.setConfirm(false);
        this.getUIWindow().close();
        SysUtil.abort();
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        this.selectedTemplates = (Hashtable)this.getUIContext().get("templates");
        this.setConfirm(true);
        int rowCount = this.tblMain.getRowCount();
        Hashtable<String, FpTemplateInfo> selectedBefore = new Hashtable<String, FpTemplateInfo>();
        String selectedTemplatesName = "";
        for (int i = 0; i < rowCount; ++i) {
            IRow iRow = this.tblMain.getRow(i);
            if (!iRow.getCell("select").getValue().equals(Boolean.TRUE)) continue;
            FpTemplateInfo fpTemplateInfo = (FpTemplateInfo)iRow.getUserObject();
            String fpTempID = iRow.getCell("id").getValue().toString();
            if (this.selectedTemplates.containsKey(fpTempID)) {
                selectedBefore.put(fpTempID, fpTemplateInfo);
                iRow.getCell("select").setValue((Object)Boolean.FALSE);
                continue;
            }
            this.selectedTemplates.put(fpTempID, fpTemplateInfo);
        }
        if (!selectedBefore.isEmpty()) {
            Iterator iter = selectedBefore.keySet().iterator();
            while (iter.hasNext()) {
                FpTemplateInfo template = (FpTemplateInfo)selectedBefore.get(iter.next());
                selectedTemplatesName = selectedTemplatesName + " " + template.getName();
            }
            MsgBox.showWarning((Component)((Object)this), (String)(selectedTemplatesName + EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpSchemeResource", (String)"TemplateNotReselected")));
        }
        this.getUIWindow().close();
    }

    protected void btnAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnAll_actionPerformed(e);
        this.orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("EditOrg");
        String orgUnitID = this.orgUnitInfo.getId().toString();
        IFpTemplate iFpTemplate = FpTemplateFactory.getRemoteInstance();
        FpTemplateCollection fpTempColl = iFpTemplate.getCollctionByOrgUnit(orgUnitID);
        Hashtable hashColl = this.translateToHashtable(fpTempColl);
        this.loadTemplates(hashColl);
    }

    protected void btnNotSelected_actionPerformed(ActionEvent e) throws Exception {
        super.btnNotSelected_actionPerformed(e);
        this.orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("EditOrg");
        String orgUnitID = this.orgUnitInfo.getId().toString();
        IFpTemplate iFpTemplate = FpTemplateFactory.getRemoteInstance();
        FpTemplateCollection fpTempColls = iFpTemplate.getCollctionByOrgUnit(orgUnitID);
        Hashtable hashCollsAll = new Hashtable();
        Hashtable selectedTemplates = (Hashtable)this.getUIContext().get("templates");
        if (fpTempColls != null && fpTempColls.size() > 0) {
            hashCollsAll = this.translateToHashtable(fpTempColls);
            Hashtable hash = new Hashtable();
            for (Object key : hashCollsAll.keySet()) {
                if (!selectedTemplates.containsKey(key)) continue;
                hash.put(key, key);
            }
            Iterator it = hash.keySet().iterator();
            while (it.hasNext()) {
                hashCollsAll.remove(it.next());
            }
        }
        this.loadTemplates(hashCollsAll);
    }

    private Hashtable translateToHashtable(FpTemplateCollection fpTempColls) {
        Hashtable<String, FpTemplateInfo> hashColls = new Hashtable<String, FpTemplateInfo>();
        if (fpTempColls == null) {
            hashColls = null;
        }
        Iterator iter = fpTempColls.iterator();
        while (iter.hasNext()) {
            FpTemplateInfo template = (FpTemplateInfo)iter.next();
            hashColls.put(template.getId().toString(), template);
        }
        return hashColls;
    }

    protected void btnSeleted_actionPerformed(ActionEvent e) throws Exception {
        super.btnSeleted_actionPerformed(e);
        if ((Hashtable)this.getUIContext().get("templates") != null) {
            Hashtable selectedTemplates = (Hashtable)this.getUIContext().get("templates");
            this.loadTemplates(selectedTemplates);
        }
    }

    private void loadTemplates(Hashtable coll) {
        this.tblMain.removeRows();
        if (coll != null && coll.size() > 0) {
            Iterator iterator = coll.keySet().iterator();
            while (iterator.hasNext()) {
                FpTemplateInfo fpTemplateInfo = (FpTemplateInfo)coll.get(iterator.next());
                IRow iRow = this.tblMain.addRow();
                iRow.setUserObject((Object)fpTemplateInfo);
                iRow.getCell("select").setValue((Object)Boolean.FALSE);
                iRow.getCell("number").setValue((Object)fpTemplateInfo.getNumber());
                iRow.getCell("name").setValue((Object)fpTemplateInfo.getName());
                iRow.getCell("creator").setValue((Object)fpTemplateInfo.getCreator().getName());
                iRow.getCell("createTime").setValue((Object)fpTemplateInfo.getCreateTime());
                iRow.getCell("id").setValue((Object)fpTemplateInfo.getId().toString());
            }
        }
    }

    public Hashtable getSelectedTemplates() {
        return this.selectedTemplates;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 2) {
            int row = this.tblMain.getSelectManager().getActiveRowIndex();
            IRow irow = this.tblMain.getRow(row);
            irow.getCell("select").setValue((Object)Boolean.TRUE);
            this.btnConfirm_actionPerformed(null);
        }
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }

    public void setConfirm(boolean isConfirm) {
        this.isConfirm = isConfirm;
    }
}

