/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.client.RptTablePane;
import com.kingdee.eas.fm.common.client.MutexUtils;
import com.kingdee.eas.fm.fpl.FpFormulaObject;
import com.kingdee.eas.fm.fpl.client.AbstractFpTemplateProcessUI;
import com.kingdee.eas.fm.fpl.client.FpTemFormatImportUI;
import com.kingdee.eas.fm.fpl.client.TemplateTableBeforeAction;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class FpTemplateProcessUI
extends AbstractFpTemplateProcessUI {
    private static final Logger logger = CoreUIObject.getLogger(FpTemplateProcessUI.class);
    public static final String FPDATA = "fpData";
    public static final String FPACTUAL = "fpActual";
    private String formulaType = null;
    private static final String RESOURCE = "com.kingdee.eas.fm.fpl.client.FpTemplateProcessUIResource";
    String reportState = null;
    boolean isNeedMutex = false;

    public void onLoad() throws Exception {
        super.onLoad();
        String templateState = (String)this.getUIContext().get("OpenReportState");
        this.isNeedMutex = OprtState.EDIT.equals(templateState);
        if (this.isNeedMutex) {
            String id = (String)this.getUIContext().get("ID");
            MutexUtils.requestMutex((CoreUI)this, (String)id);
        }
        this.formulaType = FPDATA;
        this.initDataStatus();
        int n = this.pnlTables.getTabCount();
        for (int i = 0; i < n; ++i) {
            this.pnlTables.getPageAt(i).setBeforeAction((BeforeActionListener)new TemplateTableBeforeAction());
            this.pnlTables.getPageAt(i).setAfterAction(null);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.kDButtonGroupFpFormula.add((AbstractButton)this.itemEditFpActualFormula);
        this.kDButtonGroupFpFormula.add((AbstractButton)this.itemEditFpDataFormula);
        this.kDButtonGroupFpFormula.add((AbstractButton)this.itemdata);
        this.kDButtonGroupFpFormula.add((AbstractButton)this.itemItemFormula);
        this.btnFpFormulaFill.setIcon(EASResource.getIcon((String)"imgTbtn_getnumberformula"));
        this.btnFpItemFill.setIcon(EASResource.getIcon((String)"imgTbtn_itemformula"));
        this.btnFpItemFill.setText(EASResource.getString((String)RESOURCE, (String)"batchFill"));
        this.itemViewParameters.setText(EASResource.getString((String)RESOURCE, (String)"fpTemParam"));
    }

    private void initDataStatus() {
        this.reportState = this.getOprtState();
        if (this.reportState.equals(OprtState.VIEW)) {
            this.actionFileSave.setVisible(false);
            this.actionFileSaveAs.setVisible(false);
        } else {
            this.actionFileSave.setVisible(true);
            this.actionFileSaveAs.setVisible(true);
        }
        this.itemEditFpDataFormula.setSelected(false);
        this.itemEditFpDataFormula.setSelected(true);
        try {
            this.actionViewFormula_actionPerformed(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected boolean checkBeforeWindowClosing() {
        if (this.reportState.equals(OprtState.VIEW)) {
            return true;
        }
        return super.checkBeforeWindowClosing();
    }

    public RptTablePane loadReportContent(KDF kdf, boolean isView) throws Exception {
        super.loadReportContent(kdf, isView);
        this.formulaType = FPDATA;
        this.editFpFormula();
        return this.pnlTables;
    }

    public void actionFpForumalFill_actionPerformed(ActionEvent e) throws Exception {
        this.getModifyingManager().incModifiedCount();
        FpTemFormatImportUI.showUI((IUIObject)this, "dataFormula");
    }

    public void actionInsertItem_actionPerformed(ActionEvent e) throws Exception {
        this.barFormula.pickItemFormula("FpItem", (CoreUIObject)this);
    }

    public void actionFpItemFill_actionPerformed(ActionEvent e) throws Exception {
        this.getModifyingManager().incModifiedCount();
        FpTemFormatImportUI.showUI((IUIObject)this, "itemFormula");
    }

    public void actionViewEditFpActualFormula_actionPerformed(ActionEvent e) throws Exception {
        this.saveFpFormula();
        this.formulaType = FPACTUAL;
        this.editFpFormula();
    }

    public void actionViewEditFpDataFormula_actionPerformed(ActionEvent e) throws Exception {
        this.saveFpFormula();
        this.formulaType = FPDATA;
        this.editFpFormula();
    }

    public void actionViewItemFormula_actionPerformed(ActionEvent e) throws Exception {
        this.pnlTables.repaint();
    }

    protected Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object value) {
        if (this.itemItemFormula.isSelected()) {
            Object o = cell.getUserObject();
            if (o != null && o instanceof RptCell && ((RptCell)o).getItemFormula() != null && ((RptCell)o).getItemFormula().getFormula() != null) {
                return ((RptCell)o).getItemFormula().getFormula();
            }
            return cell.getValue();
        }
        return super.formatCellDisplay(rowIndex, colIndex, cell, value);
    }

    public void editFpFormula() {
        int count = this.pnlTables.getSheets().size();
        for (int i = 0; i < count; ++i) {
            KDTable table = this.pnlTables.getSheet(i).getTable();
            if (this.formulaType.equals(FPDATA)) {
                this.getFormula_fpData(table);
                continue;
            }
            if (!this.formulaType.equals(FPACTUAL)) continue;
            this.getFormula_fpActual(table);
        }
    }

    private void getFormula_fpData(KDTable table) {
        int rowCount = table.getBody().size();
        int colCount = table.getColumnCount();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                ICell cell = table.getCell(i, j);
                if (cell.getExpressions() == null || cell.getValue() == null || !(cell.getValue() instanceof FpFormulaObject)) continue;
                FpFormulaObject fpFormula = (FpFormulaObject)cell.getValue();
                cell.setExpressions(fpFormula.getFpDataFormula());
            }
        }
    }

    private void getFormula_fpActual(KDTable table) {
        int rowCount = table.getBody().size();
        int colCount = table.getColumnCount();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                ICell cell = table.getCell(i, j);
                if (cell.getExpressions() == null || cell.getValue() == null || !(cell.getValue() instanceof FpFormulaObject)) continue;
                FpFormulaObject fpFormula = (FpFormulaObject)cell.getValue();
                cell.setExpressions(fpFormula.getFpActualFormula());
            }
        }
    }

    public void saveFpFormula() {
        int count = this.pnlTables.getSheets().size();
        for (int i = 0; i < count; ++i) {
            KDTable table = this.pnlTables.getSheet(i).getTable();
            if (this.formulaType.equals(FPDATA)) {
                this.setFormula_fpData(table);
                continue;
            }
            if (!this.formulaType.equals(FPACTUAL)) continue;
            this.setFormula_fpActual(table);
        }
    }

    private void setFormula_fpData(KDTable table) {
        int rowCount = table.getBody().size();
        int colCount = table.getColumnCount();
        ICell cell = null;
        FpFormulaObject fpFormula = null;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                cell = table.getCell(i, j);
                if (cell.getExpressions() == null) continue;
                if (cell.getValue() != null) {
                    Object obj = cell.getValue();
                    if (obj instanceof FpFormulaObject) {
                        fpFormula = (FpFormulaObject)obj;
                        fpFormula.setFpDataFormula(cell.getExpressions());
                        cell.setValue((Object)fpFormula);
                        continue;
                    }
                    fpFormula = new FpFormulaObject();
                    fpFormula.setFpDataFormula(cell.getExpressions());
                    cell.setValue((Object)fpFormula);
                    continue;
                }
                fpFormula = new FpFormulaObject();
                fpFormula.setFpDataFormula(cell.getExpressions());
                cell.setValue((Object)fpFormula);
            }
        }
    }

    private void setFormula_fpActual(KDTable table) {
        int rowCount = table.getBody().size();
        int colCount = table.getColumnCount();
        ICell cell = null;
        FpFormulaObject fpFormula = null;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                cell = table.getCell(i, j);
                if (cell.getExpressions() == null) continue;
                if (cell.getValue() != null) {
                    Object obj = cell.getValue();
                    if (obj instanceof FpFormulaObject) {
                        fpFormula = (FpFormulaObject)obj;
                        fpFormula.setFpActualFormula(cell.getExpressions());
                        cell.setValue((Object)fpFormula);
                        continue;
                    }
                    fpFormula = new FpFormulaObject();
                    fpFormula.setFpActualFormula(cell.getExpressions());
                    cell.setValue((Object)fpFormula);
                    continue;
                }
                fpFormula = new FpFormulaObject();
                fpFormula.setFpActualFormula(cell.getExpressions());
                cell.setValue((Object)fpFormula);
            }
        }
    }

    public void actionFileSave_actionPerformed(ActionEvent e) throws Exception {
        this.saveFpFormula();
        super.actionFileSave_actionPerformed(e);
    }

    public void actionFileSaveAs_actionPerformed(ActionEvent e) throws Exception {
        super.actionFileSaveAs_actionPerformed(e);
    }

    public void actionFormatSheetName_actionPerformed(ActionEvent e) throws Exception {
        int index = this.pnlTables.getSelectedSheetIndex();
        if (index == -1) {
            return;
        }
        String oldName = this.pnlTables.getSheetTitleAt(index);
        String newName = this.pnlTables.renamePage(index, null);
        this.getSchemaComp().notifyRenameSheet(oldName, newName);
        this.getModifyingManager().incModifiedCount();
    }

    public boolean destroyWindow() {
        if (this.isNeedMutex) {
            String id = (String)this.getUIContext().get("ID");
            MutexUtils.releaseMutex((String)id);
        }
        return super.destroyWindow();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.FINANCEPLAN;
    }

    public void actionToolsFormulaFill_actionPerformed(ActionEvent e) throws Exception {
    }
}

