/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.MutexUtils;
import com.kingdee.eas.fm.fpl.FpTemplateException;
import com.kingdee.eas.fm.fpl.FpTemplateFactory;
import com.kingdee.eas.fm.fpl.FpTemplateInfo;
import com.kingdee.eas.fm.fpl.FpTemplateSourceEnum;
import com.kingdee.eas.fm.fpl.IFpTemplate;
import com.kingdee.eas.fm.fpl.client.AbstractFpTemplateTreeListUI;
import com.kingdee.eas.fm.fpl.client.FpAssignWizardUI;
import com.kingdee.eas.fm.fpl.client.FpClientHelper;
import com.kingdee.eas.fm.fpl.client.FpTemplateEditUI;
import com.kingdee.eas.fm.fpl.client.FpTemplateHandler;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class FpTemplateTreeListUI
extends AbstractFpTemplateTreeListUI {
    private static final Logger logger = CoreUIObject.getLogger(FpTemplateTreeListUI.class);
    private static final String RESOURCE = "com.kingdee.eas.fm.fpl.client.FpTemplateResource";
    private CtrlUnitInfo currCuInfo = null;

    public void onLoad() throws Exception {
        if (this.currCuInfo == null) {
            this.currCuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        super.onLoad();
        this.initDataStatus();
        this.menuItemExitCurrent.setIcon(EASResource.getIcon((String)"imgTbtn_quit"));
        this.menuItemFormatEdit.setIcon(EASResource.getIcon((String)"imgTbtn_modifyformat"));
        this.menuItemClone.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.menuItemAssign.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnDataAccredit.setIcon(EASResource.getIcon((String)"imgTbtn_dataaccredit"));
        this.btnEditFormat.setIcon(EASResource.getIcon((String)"imgTbtn_modifyformat"));
        this.btnClone.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.btnAssign.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.menuItemExitCurrent.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
    }

    private void initDataStatus() {
        this.menuWorkFlow.setVisible(false);
        this.actionDataAccredit.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionExportData.setVisible(false);
    }

    protected String getEditUIName() {
        return FpTemplateEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FpTemplateFactory.getRemoteInstance();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getOuId()));
        viewInfo.setFilter(filter);
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        return filter;
    }

    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeOrgUnit_valueChanged(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        this.openReport(e, OprtState.VIEW);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        String id = this.getSelectedKeyValue();
        this.checkIsCanEditOrRemove(id);
        super.actionEdit_actionPerformed(e);
    }

    public void actionEditFormat_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        this.checkIsCanEdit(id);
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        this.checkIsCanEditOrRemove(id);
        this.openReport(e, OprtState.EDIT);
    }

    private void checkIsCanEdit(String id) throws EASBizException, BOSException, Exception {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        FpTemplateInfo info = ((IFpTemplate)this.getBizInterface()).getFpTemplateInfo((IObjectPK)pk);
        if (info.getSource().equals((Object)FpTemplateSourceEnum.ASSIGN) && !info.isIsModify()) {
            throw new FpTemplateException(FpTemplateException.ASSIGNNOTMODIFY);
        }
    }

    private void openReport(ActionEvent e, String reportState) throws UIException {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"isOpenReport", (Object)Boolean.TRUE);
        uiContext.put((Object)"OpenReportState", (Object)reportState);
        uiContext.put((Object)"isShowMsgWhenProcessChange", (Object)false);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.hide();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"orgUnit", (Object)this.getFullOuInfo());
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        FpClientHelper.checkIsOnCU((CoreUI)this, this.getFullOuInfo(), this.currCuInfo);
        String id = this.getSelectedKeyValue();
        this.checkIsCanEditOrRemove(id);
        super.actionRemove_actionPerformed(e);
    }

    private void checkIsCanEditOrRemove(String id) throws Exception {
        IFpTemplate iFpTemplate = (IFpTemplate)this.getBizInterface();
        iFpTemplate.checkIsAssigned(id);
        iFpTemplate.checkIsRefByForm(id);
    }

    public void actionClone_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"COPY", (Object)"COPY");
        uiContext.put((Object)"orgUnit", (Object)this.getFullOuInfo());
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"IDList", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionAssign_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        List selectIds = FpTemplateHandler.getSelectedTemplateIds(this.tblMain);
        MutexUtils.requestMutex((CoreUI)this, (List)selectIds);
        try {
            FullOrgUnitInfo ouInfo = this.getFullOuInfo();
            FpClientHelper.checkIsOnCU((CoreUI)this, ouInfo, this.currCuInfo);
            OrgUnitCollection subOuColl = FpTemplateHandler.getAllSubOuInfo(ouInfo);
            String cuId = ouInfo.getId().toString();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"CUID", (Object)cuId);
            uiContext.put((Object)"EditOrg", (Object)subOuColl);
            IUIWindow subOuSelectUI = FpAssignWizardUI.showUI((IUIObject)this, cuId, (IObjectCollection)subOuColl);
            Map orgIdMap = ((FpAssignWizardUI)subOuSelectUI.getUIObject()).getReturnMap();
            if (orgIdMap != null && !orgIdMap.isEmpty()) {
                IFpTemplate iFpTemplate = FpTemplateFactory.getRemoteInstance();
                iFpTemplate.assign(selectIds, orgIdMap);
                this.setMessageText(EASResource.getString((String)RESOURCE, (String)"temAssigned"));
                this.showMessage();
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        finally {
            MutexUtils.releaseMutex((List)selectIds);
        }
    }
}

