/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.Zero2EmptyStrCellDisplayParser;
import com.kingdee.eas.fm.fpl.FPItemDirectionEnum;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fpl.FpRptFacadeFactory;
import com.kingdee.eas.fm.fpl.FpRptFilterParam;
import com.kingdee.eas.fm.fpl.FpRptItemFilterParam;
import com.kingdee.eas.fm.fpl.IFpRptFacade;
import com.kingdee.eas.fm.fpl.client.FpAnalyseUIHander;
import com.kingdee.eas.fm.fpl.client.FpRptClientHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FpTraceUIHandler
extends FpAnalyseUIHander {
    private static final String RESOURCE_PATH = "com.kingdee.eas.fm.fpl.client.FpRptResource";
    private static final String PE = "pe";
    public static final String DI = "di";
    public static final String AC = "ac";
    public static final String FP = "fp";
    private static final String resFp = EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpRptResource", (String)"fp");
    private static final String resAc = EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpRptResource", (String)"ac");
    private static final String resDi = EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpRptResource", (String)"di");
    private static final String resPe = EASResource.getString((String)"com.kingdee.eas.fm.fpl.client.FpRptResource", (String)"pe");
    private static final String ITEM = "item";
    public static final String TOTAL = "total";
    public static final String QUERYFIELD = "queryField";
    public static final String FPVALUE = "ffpvalue";
    public static final String FBIZACTUAL = "fbizactual";
    public static final String FDIFF = "fdiff";
    private static FpTraceUIHandler instance;

    private FpTraceUIHandler() throws Exception {
    }

    public static FpTraceUIHandler getInstatnce() throws Exception {
        if (instance == null) {
            instance = new FpTraceUIHandler();
        }
        return instance;
    }

    public void initTable(KDTable table, FpRptFilterParam param) throws Exception {
        FMClientHelper.clearTable((KDTable)table);
        table.checkParsed(true);
        table.getScriptManager().setDiv0DefaultValue("");
        IRow header0 = table.getHeadRow(0);
        IRow header1 = table.getHeadRow(1);
        BgPeriodCollection periodColl = BgPeriodFactory.getRemoteInstance().getPeriodCollection(BOSUuid.read((String)param.getBeginPeriodId()), BOSUuid.read((String)param.getEndPeriodId()));
        for (BgPeriodInfo periodInfo : periodColl) {
            String number = periodInfo.getNumber();
            String name = periodInfo.getName();
            this.initTableHeader(table, header0, header1, number, name);
        }
        this.initTableHeader(table, header0, header1, TOTAL, EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)TOTAL));
        table.setUserCellDisplayParser((IUserCellDisplayParser)new Zero2EmptyStrCellDisplayParser());
        table.getViewManager().setFreezeView(-1, table.getColumn(ITEM).getColumnIndex());
    }

    private void initTableHeader(KDTable table, IRow header0, IRow header1, String key, String name) {
        String fp = key + FP;
        table.addColumn().setKey(fp);
        header0.getCell(fp).setValue((Object)name);
        header1.getCell(fp).setValue((Object)resFp);
        String ac = key + AC;
        table.addColumn().setKey(ac);
        header0.getCell(ac).setValue((Object)name);
        header1.getCell(ac).setValue((Object)resAc);
        String di = key + DI;
        table.addColumn().setKey(di);
        header0.getCell(di).setValue((Object)name);
        header1.getCell(di).setValue((Object)resDi);
        String pe = key + PE;
        table.addColumn().setKey(pe);
        header0.getCell(pe).setValue((Object)name);
        header1.getCell(pe).setValue((Object)resPe);
        table.getHeadMergeManager().mergeBlock(0, header0.getCell(fp).getColumnIndex(), 0, header0.getCell(pe).getColumnIndex());
    }

    public Map fillFpItems(KDTable table, FilterParam param) throws Exception {
        HashMap map = new HashMap();
        this.fillFpItemByDirect(table, FPItemDirectionEnum.INWARD_MOVEMENT, map, param);
        this.fillFpItemByDirect(table, FPItemDirectionEnum.OUTWARD_MOVEMENT, map, param);
        this.fillFpItemByDirect(table, FPItemDirectionEnum.OTHER, map, param);
        IRow netRow = table.addRow();
        netRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        netRow.getCell(ITEM).setValue((Object)EASResource.getString((String)RESOURCE_PATH, (String)"netValue"));
        int colCount = table.getColumnCount();
        int inRowIndex = this.getInOutRowIndex(map, FPItemDirectionEnum.INWARD_MOVEMENT);
        int outRowIndex = this.getInOutRowIndex(map, FPItemDirectionEnum.OUTWARD_MOVEMENT);
        int netRowIndex = netRow.getRowIndex();
        for (int i = 1; i < colCount - 1; i += 4) {
            netRow.getCell(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            netRow.getCell(i).setExpressions("=" + this.getR(inRowIndex, i) + "-" + this.getR(outRowIndex, i));
            netRow.getCell(i + 1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            netRow.getCell(i + 1).setExpressions("=" + this.getR(inRowIndex, i + 1) + "-" + this.getR(outRowIndex, i + 1));
            netRow.getCell(i + 2).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            netRow.getCell(i + 2).setExpressions("=" + this.getR(netRowIndex, i) + "-" + this.getR(netRowIndex, i + 1));
            netRow.getCell(i + 3).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            netRow.getCell(i + 3).setExpressions("=" + this.getR(netRowIndex, i + 1) + "/" + this.getR(netRowIndex, i));
        }
        return map;
    }

    private String getR(int rowIndex, int colIndex) {
        return TableToolkit.xy2range((int)colIndex, (int)rowIndex);
    }

    private int getInOutRowIndex(Map map, FPItemDirectionEnum direct) {
        String key = direct.getValue() + "RowIndex";
        int rowIndex = (Integer)map.get(key);
        map.remove(key);
        return rowIndex;
    }

    private void setPeriodSumExp(int colCount, IRow row, int rowIndex) {
        for (int i = 1; i < colCount - 4; i += 4) {
            this.setDiPeExp(row, rowIndex, i);
            String expFp = row.getCell("totalfp").getExpressions();
            if (FMHelper.isEmpty((String)expFp)) {
                row.getCell("totalfp").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell("totalfp").setExpressions("=" + this.getR(rowIndex, i));
            } else {
                row.getCell("totalfp").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell("totalfp").setExpressions(expFp + "+" + this.getR(rowIndex, i));
            }
            String expAc = row.getCell("totalac").getExpressions();
            if (FMHelper.isEmpty((String)expFp)) {
                row.getCell("totalac").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell("totalac").setExpressions("=" + this.getR(rowIndex, i + 1));
                continue;
            }
            row.getCell("totalac").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("totalac").setExpressions(expAc + "+" + this.getR(rowIndex, i + 1));
        }
    }

    private void setLevelSumExp(KDTable table, int colCount, int rowIndex, int r, int offset) {
        for (int i = 1; i < colCount - offset; i += 4) {
            String oriExpFp = table.getCell(r, i).getExpressions();
            String oriExpAc = table.getCell(r, i + 1).getExpressions();
            String expFp = this.getR(rowIndex, i);
            String expAc = this.getR(rowIndex, i + 1);
            if (FMHelper.isEmpty((String)oriExpFp)) {
                table.getCell(r, i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                table.getCell(r, i).setExpressions("=" + expFp);
            } else {
                table.getCell(r, i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                table.getCell(r, i).setExpressions(oriExpFp + "+" + expFp);
            }
            if (FMHelper.isEmpty((String)oriExpAc)) {
                table.getCell(r, i + 1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                table.getCell(r, i + 1).setExpressions("=" + expAc);
                continue;
            }
            table.getCell(r, i + 1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            table.getCell(r, i + 1).setExpressions(oriExpAc + "+" + expAc);
        }
    }

    private void setDiPeExp(IRow row, int rowIndex, int i) {
        row.getCell(i + 2).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(i + 2).setExpressions("=" + this.getR(rowIndex, i) + "-" + this.getR(rowIndex, i + 1));
        row.getCell(i + 3).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(i + 3).setExpressions("=" + this.getR(rowIndex, i + 1) + "/" + this.getR(rowIndex, i));
    }

    public void fillData(KDTable table, FilterParam param, Map map) throws Exception {
        IRowSet rs = FpRptFacadeFactory.getRemoteInstance().getFpFormExecTrace(param);
        if (rs == null) {
            return;
        }
        this.fillDataByMap(table, rs, map);
    }

    public void setNumberFormat(KDTable table, String currencyId) {
        int colCount = table.getColumnCount();
        BOSUuid currencyUuid = BOSUuid.read((String)currencyId);
        for (int i = 1; i < colCount; ++i) {
            IColumn column = table.getColumn(i);
            if (column.getKey().endsWith(PE)) {
                column.getStyleAttributes().setNumberFormat("0.00%");
                column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                continue;
            }
            FMClientHelper.currencyFormat((BOSUuid)currencyUuid, (IColumn)column);
        }
    }

    public String[] getBillByItem(KDTable table, FilterParam param) throws Exception {
        IRowSet rs;
        int rowIndex = table.getSelectManager().getActiveRowIndex();
        int colIndex = table.getSelectManager().getActiveColumnIndex();
        if (rowIndex == -1) {
            return null;
        }
        IRow row = table.getRow(rowIndex);
        IColumn col = table.getColumn(colIndex);
        FpItemInfo itemInfo = (FpItemInfo)row.getUserObject();
        if (itemInfo == null) {
            return null;
        }
        String itemNumber = itemInfo.getNumber();
        if (!col.getKey().endsWith(AC)) {
            return null;
        }
        if (!col.getKey().endsWith("totalac")) {
            String periodNumber = col.getKey().substring(0, col.getKey().length() - 2);
            FpRptFilterParam myParam = (FpRptFilterParam)param;
            myParam.setBeginPeriodNumber(periodNumber);
            myParam.setEndPeriodNumber(periodNumber);
        }
        if ((rs = FpRptFacadeFactory.getRemoteInstance().getBillByItem(param, itemNumber)) == null || rs.size() == 0) {
            Object obj = row.getCell(col.getKey()).getValue();
            if (obj != null && !obj.equals("") && !obj.toString().equals("0")) {
                MsgBox.showWarning((String)EASResource.getString((String)RESOURCE_PATH, (String)"msgNoBill"));
            }
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        while (rs.next()) {
            list.add(new String(rs.getString("billid")));
        }
        return list.toArray(new String[0]);
    }

    private void fillTableWithRs(KDTable table, Map map, IRow currRow, IRowSet rs) throws SQLException {
        HashMap expMap = new HashMap();
        int colCount = table.getColumnCount();
        int groupRowIndex = currRow.getRowIndex();
        int start = groupRowIndex + 1;
        while (rs.next()) {
            String name = rs.getString("fname");
            String number = rs.getString("fnumber");
            String fid = rs.getString("fid");
            String parentId = rs.getString("fparentid");
            int level = rs.getInt("flevel");
            name = FpRptClientHelper.getGoodFormatName(name, level);
            IRow row = table.addRow(start++);
            int rowIndex = row.getRowIndex();
            row.getCell(ITEM).setValue((Object)name);
            FpItemInfo iteminfo = new FpItemInfo();
            iteminfo.setNumber(number);
            iteminfo.setIsLeaf(rs.getBoolean("fisleaf"));
            iteminfo.setLevel(level);
            iteminfo.setId(BOSUuid.read((String)fid));
            iteminfo.setString("parent", parentId);
            row.setUserObject((Object)iteminfo);
            map.put(number, new Integer(rowIndex));
            if (level == 1) {
                this.setLevelSumExp(table, colCount, rowIndex, groupRowIndex, 0);
                for (int i = 1; i < colCount; i += 4) {
                    this.setDiPeExp(row, rowIndex, table.getColumn("totalfp").getColumnIndex());
                    this.setDiPeExp(currRow, groupRowIndex, i);
                }
            }
            this.setPeriodSumExp(colCount, row, rowIndex);
            this.setDiPeExp(row, rowIndex, table.getColumn("totalfp").getColumnIndex());
        }
        expMap.clear();
    }

    public void fillTableWithItem(KDTable table, Map map, List lstItem) throws SQLException {
        int colCount = table.getColumnCount();
        for (int i = 0; i < lstItem.size(); ++i) {
            FpItemInfo iteminfo = this.getFpItemInfo((List)lstItem.get(i));
            if (iteminfo == null) continue;
            String name = FpRptClientHelper.getGoodFormatName(iteminfo.getName(), this.getLevelByNumber(iteminfo.getNumber()));
            IRow row = table.addRow();
            int rowIndex = row.getRowIndex();
            row.getCell(ITEM).setValue((Object)name);
            iteminfo.setNumber(iteminfo.getNumber());
            row.setUserObject((Object)iteminfo);
            map.put(iteminfo.getNumber(), new Integer(rowIndex));
            this.setPeriodSumExp(colCount, row, rowIndex);
            this.setDiPeExp(row, rowIndex, table.getColumn("totalfp").getColumnIndex());
        }
    }

    private void fillDataByMap(KDTable table, IRowSet rs, Map map) throws Exception {
        ICell cell = null;
        while (rs.next()) {
            String item = rs.getString("itemnumber");
            String periodNumber = rs.getString("periodnumber");
            BigDecimal fpValue = rs.getBigDecimal("FFpValue");
            BigDecimal acValue = rs.getBigDecimal("FBizActual");
            if (map.get(item) == null) continue;
            int itemRowIndex = (Integer)map.get(item);
            if (!FMHelper.isZERO((BigDecimal)fpValue)) {
                cell = table.getCell(itemRowIndex, periodNumber + FP);
                cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                cell.setValue((Object)fpValue);
            }
            if (FMHelper.isZERO((BigDecimal)acValue)) continue;
            cell = table.getCell(itemRowIndex, periodNumber + AC);
            cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            cell.setValue((Object)acValue);
        }
    }

    public void fillFpItemByDirect(KDTable table, FPItemDirectionEnum direction, Map map, FilterParam param) throws BOSException, EASBizException, SQLException {
        String inGroupName = this.getItemGroupName(direction.getValue());
        IRow groupRow = table.addRow();
        groupRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        int groupRowIndex = groupRow.getRowIndex();
        groupRow.getCell(ITEM).setValue((Object)inGroupName);
        IRowSet rs = FpRptFacadeFactory.getRemoteInstance().getFpItems(direction);
        this.fillTableWithRs(table, map, groupRow, rs);
        map.put(direction.getValue() + "RowIndex", new Integer(groupRowIndex));
    }

    public void fillExpendData(KDTable table, IRow currRow, FilterParam param, String parentID) throws Exception {
        FpRptItemFilterParam myParam = (FpRptItemFilterParam)param;
        myParam.setItemID(parentID);
        IFpRptFacade fpRptFacade = FpRptFacadeFactory.getRemoteInstance();
        IRowSet rsItem = fpRptFacade.getFpItemsByParent(parentID);
        IRowSet rsData = fpRptFacade.getFpFormExecTraceByParent(myParam, parentID);
        HashMap map = new HashMap();
        this.fillTableWithRs(table, map, currRow, rsItem);
        this.fillDataByMap(table, rsData, map);
        this.setExpendDisplayStyle(table);
    }
}

