/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class FpWizardHelper {
    public static final BigDecimal minValue = new BigDecimal("0.00");
    public static final BigDecimal maxValue = new BigDecimal("100.00");
    public static final String PERIOD_INFO = "periodInfo";
    public static final String TOTAL = "Total";

    public static void refreshOrgUnitTree(KDTree treeOrgUnit, String rootUnitID) throws Exception {
        treeOrgUnit.setModel(null);
        OrgViewType orgViewType = OrgViewType.COSTCENTER;
        TreeModel treeModel = NewOrgUtils.getTreeModel((OrgViewType)orgViewType, null, (boolean)false, (boolean)false, (boolean)false, (String)rootUnitID, (boolean)false, null, (int)0, null, null);
        treeOrgUnit.setModel(treeModel);
        if (treeOrgUnit.getModel() != null) {
            treeOrgUnit.expandAllNodes(true, (TreeNode)treeOrgUnit.getModel().getRoot());
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeOrgUnit.getModel().getRoot();
        root.setCheckBoxEnabled(false);
    }

    public static void traceNode(DefaultKingdeeTreeNode root, Map orgIdMap, Map orgInfoMap) {
        OrgStructureInfo oui = (OrgStructureInfo)root.getUserObject();
        FullOrgUnitInfo info = oui.getUnit();
        String orgId = info.getId().toString();
        if (root.isChecked()) {
            if (!orgIdMap.containsKey(orgId)) {
                orgIdMap.put(orgId, Boolean.FALSE);
                orgInfoMap.put(orgId, info);
            }
        } else {
            orgIdMap.remove(orgId);
            orgInfoMap.remove(orgId);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            FpWizardHelper.traceNode(node, orgIdMap, orgInfoMap);
        }
    }

    public static void showNoSubOrg(Component comp) {
        String resPath = "com.kingdee.eas.fm.fpl.FPLResource";
        String msg = EASResource.getString((String)resPath, (String)"subOrgIsNull");
        MsgBox.showInfo((Component)comp, (String)msg);
        SysUtil.abort();
    }

    public static void fillComboPeriod(BgPeriodEnum periodType, KDComboBox combo) {
        List subPeriodTypeList = FpWizardHelper.getSubPeriodType(periodType);
        combo.removeAllItems();
        combo.addItems(subPeriodTypeList.toArray());
    }

    public static List getSubPeriodType(BgPeriodEnum periodType) {
        ArrayList<BgPeriodEnum> list = new ArrayList<BgPeriodEnum>();
        if (periodType == null) {
            return null;
        }
        int period = periodType.getValue();
        switch (period) {
            case 1: {
                list.add(BgPeriodEnum.HALFYEAR);
                list.add(BgPeriodEnum.QUARTER);
                list.add(BgPeriodEnum.MONTH);
                list.add(BgPeriodEnum.YWEEK);
                list.add(BgPeriodEnum.MWEEK);
                list.add(BgPeriodEnum.DAY);
                break;
            }
            case 2: {
                list.add(BgPeriodEnum.QUARTER);
                list.add(BgPeriodEnum.MONTH);
                list.add(BgPeriodEnum.YWEEK);
                list.add(BgPeriodEnum.MWEEK);
                list.add(BgPeriodEnum.DAY);
                break;
            }
            case 3: {
                list.add(BgPeriodEnum.MONTH);
                list.add(BgPeriodEnum.YWEEK);
                list.add(BgPeriodEnum.MWEEK);
                list.add(BgPeriodEnum.DAY);
                break;
            }
            case 4: {
                list.add(BgPeriodEnum.MWEEK);
                list.add(BgPeriodEnum.DAY);
                break;
            }
            case 5: {
                list.add(BgPeriodEnum.DAY);
                break;
            }
            case 6: {
                list.add(BgPeriodEnum.DAY);
            }
        }
        return list;
    }

    public static BgPeriodCollection getSubPeriodColl(BgPeriodInfo period, BgPeriodEnum periodType) throws EASBizException, BOSException {
        if (period == null || periodType == null) {
            return new BgPeriodCollection();
        }
        Date beginDate = period.getBeginDate();
        Date endDate = period.getEndDate();
        BgPeriodCollection coll = BgPeriodHelper.getPeriodColInfo((int)periodType.getValue(), (Date)beginDate, (Date)endDate);
        return coll;
    }
}

