/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.client;

import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fpl.FpHelper;
import com.kingdee.eas.fm.fpl.TreesModelCalc;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class OrgChooseCalc
implements TreesModelCalc {
    private static final String PLUS_SIGN = ",";
    private SortedMap itemCellMap = new TreeMap();

    public OrgChooseCalc(Map keyValueMap) {
        this.itemCellMap.put("", null);
        this.itemCellMap.putAll(keyValueMap);
    }

    public Map getResult() {
        return this.itemCellMap;
    }

    public static void main(String[] args) {
        TreeMap<String, String> itemCellMap = new TreeMap<String, String>();
        itemCellMap.put("001", "001");
        itemCellMap.put("001!002", "002");
        itemCellMap.put("001!334", "334");
        itemCellMap.put("001!334!333!444!44", "44");
        itemCellMap.put("001!334!333!444!43", "43");
        itemCellMap.put("001!334!333", "333");
        itemCellMap.put("001!334!323!444!4223", "4223");
        itemCellMap.put("001!334!323", "1");
        OrgChooseCalc calc = new OrgChooseCalc(itemCellMap);
        calc.run();
        calc.run();
        Map rst = calc.getResult();
        for (Map.Entry keyset : rst.entrySet()) {
            System.out.println(keyset);
        }
    }

    public void run() {
        if (this.itemCellMap == null) {
            throw new IllegalArgumentException("itemCellMap not init!");
        }
        TreeModel model = this.buildTree(this.itemCellMap);
        if (model == null) {
            throw new RuntimeException("can not build a tree");
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        this.calc(root);
    }

    public void calc(DefaultMutableTreeNode model) {
        if (model.isLeaf()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < model.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)model.getChildAt(i);
            Map.Entry entry = (Map.Entry)childNode.getUserObject();
            this.calc(childNode);
            Object nodeValue = entry.getValue();
            if (i > 0) {
                sb.append(PLUS_SIGN);
            }
            sb.append(nodeValue);
        }
        Map.Entry entry = (Map.Entry)model.getUserObject();
        entry.setValue(sb.toString());
    }

    private TreeModel buildTree(SortedMap itemCellMap) {
        DefaultTreeModel model = null;
        HashMap<String, DefaultMutableTreeNode> nodes = new HashMap<String, DefaultMutableTreeNode>();
        for (Map.Entry entry : itemCellMap.entrySet()) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(entry);
            nodes.put(entry.getKey().toString().toLowerCase(), node);
            if (model == null) {
                model = new DefaultTreeModel(node);
                continue;
            }
            String key = (String)entry.getKey();
            DefaultMutableTreeNode parentNode = this.getParentNode(nodes, key);
            parentNode.add(node);
        }
        return model;
    }

    private DefaultMutableTreeNode getParentNode(Map nodes, String key) {
        String parentKey = this.getParentKey(key);
        if (parentKey == null) {
            throw new RuntimeException(key + " has not parentKey");
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)nodes.get(parentKey.toLowerCase());
        if (parentNode == null) {
            parentNode = this.getParentNode(nodes, parentKey);
        }
        return parentNode;
    }

    protected String getParentKey(String key) {
        String parentKey = FpHelper.getOrgParentNumber(key);
        if (FMHelper.isEmpty((String)parentKey)) {
            return "";
        }
        return parentKey;
    }
}

