/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.BackRecAcctSendAcctBuilder;
import com.kingdee.eas.fm.fs.ClearingHouseHelper;
import com.kingdee.eas.fm.fs.IReceiveAccount;
import com.kingdee.eas.fm.fs.ISendAcctBuilder;
import com.kingdee.eas.fm.fs.NormalRecAcctSendAcctBuilder;
import com.kingdee.eas.fm.fs.ReceiveAccountFactory;
import com.kingdee.eas.fm.fs.ReceiveAccountInfo;
import com.kingdee.eas.fm.fs.ReckoningAccountInfo;
import com.kingdee.eas.fm.fs.SendAccountInfo;
import com.kingdee.eas.fm.fs.SendAcctSourceEnum;
import com.kingdee.eas.fm.fs.SendAcctStatusEnum;
import com.kingdee.eas.framework.BillBaseInfo;

public abstract class AbstractRecAcctSendAcctBuilder
implements ISendAcctBuilder {
    @Override
    public BillBaseInfo getBillBaseInfo(Context ctx, String billId) throws BOSException, EASBizException {
        return this.getSendAccountInfo(ctx, billId);
    }

    public static AbstractRecAcctSendAcctBuilder getInstance(boolean isBackBill) {
        AbstractRecAcctSendAcctBuilder builder = null;
        builder = isBackBill ? new BackRecAcctSendAcctBuilder() : new NormalRecAcctSendAcctBuilder();
        return builder;
    }

    @Override
    public SendAccountInfo getSendAccountInfo(Context ctx, String billId) throws EASBizException, BOSException {
        ReceiveAccountInfo recInfo = this.getBizInterface(ctx).getReceiveAccountInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return this.buildSendAcctInfo(ctx, recInfo);
    }

    private SendAccountInfo buildSendAcctInfo(Context ctx, ReceiveAccountInfo recInfo) throws EASBizException, BOSException {
        SendAccountInfo sendInfo = new SendAccountInfo();
        sendInfo.setId(BOSUuid.create((BOSObjectType)sendInfo.getBOSType()));
        sendInfo.setCompany(recInfo.getCompany());
        sendInfo.setIsBackBill(recInfo.isIsBackBill());
        sendInfo.setSource(SendAcctSourceEnum.RECEIVEACCOUNT);
        sendInfo.setSrcSettlementBill(recInfo.getSrcSettlementBill());
        sendInfo.setBizDate(recInfo.getBizDate());
        sendInfo.setType(recInfo.getType());
        sendInfo.setDoForRecPay(recInfo.getDoForRecPay());
        sendInfo.setReckoningAcct(this.getReckoningAccount(recInfo));
        sendInfo.setCurrency(recInfo.getCurrency());
        sendInfo.setAmount(recInfo.getAmount());
        sendInfo.setDescription(recInfo.getDescription());
        sendInfo.setSettleAcceptCH(recInfo.getSettleAcceptCH());
        String companyId = recInfo.getCompany().getId().toString();
        BankInfo submitCh = ClearingHouseHelper.getClearingHouse(ctx, companyId);
        sendInfo.setSubmitCH(submitCh);
        sendInfo.setReceiveCH(this.getReceiveCH(recInfo));
        sendInfo.setSettleConfirmCH(recInfo.getSettleConfirmCH());
        sendInfo.setCreator(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        sendInfo.setStatus(SendAcctStatusEnum.UNDEALED);
        sendInfo.setUpBillId(recInfo.getId().toString());
        return sendInfo;
    }

    private IReceiveAccount getBizInterface(Context ctx) throws BOSException {
        if (ctx == null) {
            return ReceiveAccountFactory.getRemoteInstance();
        }
        return ReceiveAccountFactory.getLocalInstance(ctx);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("settleAcceptCH.*");
        sic.add("settleConfirmCH.*");
        sic.add("submitCH.*");
        sic.add("upReckoningAcct.*");
        sic.add("downReckoningAcct.*");
        return sic;
    }

    protected abstract ReckoningAccountInfo getReckoningAccount(ReceiveAccountInfo var1);

    protected abstract BankInfo getReceiveCH(ReceiveAccountInfo var1);
}

