/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.ISettlementBillBuilder;
import com.kingdee.eas.fm.fs.InnerBackRecAcctSettleBillBuilder;
import com.kingdee.eas.fm.fs.InnerNormalRecAcctSettleBillBuilder;
import com.kingdee.eas.fm.fs.OuterBackRecAcctSettleBillBuilder;
import com.kingdee.eas.fm.fs.OuterNormalRecAcctSettleBillBuilder;
import com.kingdee.eas.fm.fs.ReceiveAccountFactory;
import com.kingdee.eas.fm.fs.ReceiveAccountInfo;
import com.kingdee.eas.fm.fs.SendRecAcctTypeEnum;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.SettlementBillSourceEnum;
import com.kingdee.eas.framework.BillBaseInfo;
import java.math.BigDecimal;

public abstract class AbstractRecAcctSettleBillBuilder
implements ISettlementBillBuilder {
    public static AbstractRecAcctSettleBillBuilder getInstance(SendRecAcctTypeEnum type, boolean isBackBill) {
        AbstractRecAcctSettleBillBuilder builder = null;
        if (type == SendRecAcctTypeEnum.INNERSETTLE && !isBackBill) {
            builder = new InnerNormalRecAcctSettleBillBuilder();
        } else if (type == SendRecAcctTypeEnum.INNERSETTLE && isBackBill) {
            builder = new InnerBackRecAcctSettleBillBuilder();
        } else if (type == SendRecAcctTypeEnum.OUTERSETTLE && !isBackBill) {
            builder = new OuterNormalRecAcctSettleBillBuilder();
        } else if (type == SendRecAcctTypeEnum.OUTERSETTLE && isBackBill) {
            builder = new OuterBackRecAcctSettleBillBuilder();
        }
        return builder;
    }

    @Override
    public BillBaseInfo getBillBaseInfo(Context ctx, String billId) throws BOSException, EASBizException {
        return this.getSettlementBillInfo(ctx, billId);
    }

    @Override
    public SettlementBillInfo getSettlementBillInfo(Context ctx, String billId) throws EASBizException, BOSException {
        ReceiveAccountInfo recAcctInfo = ReceiveAccountFactory.getLocalInstance(ctx).getReceiveAccountInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        SettlementBillInfo srcSettleInfo = recAcctInfo.getSrcSettlementBill();
        SettlementBillInfo settleInfo = this.cloneInfo(srcSettleInfo);
        settleInfo.setId(BOSUuid.create((BOSObjectType)settleInfo.getBOSType()));
        settleInfo.setSource(SettlementBillSourceEnum.RECEIVEACCOUNT);
        settleInfo.setReckoningAcct(recAcctInfo.getUpReckoningAcct());
        settleInfo.setCompany(this.getCompany(recAcctInfo));
        BigDecimal amount = recAcctInfo.getAmount();
        settleInfo.setAmount(amount);
        settleInfo.setLocalAmt(amount.multiply(settleInfo.getExchange()));
        return settleInfo;
    }

    private SettlementBillInfo cloneInfo(SettlementBillInfo srcSettleInfo) {
        SettlementBillInfo settleInfo = new SettlementBillInfo();
        settleInfo.setType(srcSettleInfo.getType());
        settleInfo.setBizDate(srcSettleInfo.getBizDate());
        settleInfo.setSettleDate(srcSettleInfo.getSettleDate());
        settleInfo.setPayeeBankAcctNum(srcSettleInfo.getPayeeBankAcctNum());
        settleInfo.setPayerBankAcctNum(srcSettleInfo.getPayerBankAcctNum());
        settleInfo.setPayeePlanItem(srcSettleInfo.getPayeePlanItem());
        settleInfo.setPayerPlanItem(srcSettleInfo.getPayerPlanItem());
        settleInfo.setExchange(srcSettleInfo.getExchange());
        settleInfo.setPayeeBankAcct(srcSettleInfo.getPayeeBankAcct());
        settleInfo.setPayerBankAcct(srcSettleInfo.getPayerBankAcct());
        settleInfo.setPayeeInnerAcct(srcSettleInfo.getPayeeInnerAcct());
        settleInfo.setPayerInnerAcct(srcSettleInfo.getPayerInnerAcct());
        settleInfo.setApplyUnit(srcSettleInfo.getApplyUnit());
        settleInfo.setPayeeFullName(srcSettleInfo.getPayeeFullName());
        settleInfo.setPayerFullName(srcSettleInfo.getPayerFullName());
        settleInfo.setIsGenPaymentBill(false);
        settleInfo.setIsGenReceivingBill(false);
        settleInfo.setAppendix(srcSettleInfo.getAppendix());
        settleInfo.setIsRelateNT(srcSettleInfo.isIsRelateNT());
        settleInfo.setIsTransfer(srcSettleInfo.isIsTransfer());
        settleInfo.setCheque(srcSettleInfo.getCheque());
        settleInfo.setBizType(srcSettleInfo.getBizType());
        settleInfo.setPayeeBank(srcSettleInfo.getPayeeBank());
        settleInfo.setPayerBank(srcSettleInfo.getPayerBank());
        settleInfo.setCurrency(srcSettleInfo.getCurrency());
        settleInfo.setSettleType(srcSettleInfo.getSettleType());
        settleInfo.setOuterSettleNumber(srcSettleInfo.getOuterSettleNumber());
        settleInfo.setInnerSettleNumber(srcSettleInfo.getInnerSettleNumber());
        settleInfo.setIsUrgent(srcSettleInfo.getIsUrgent());
        settleInfo.setSettleAcceptCH(srcSettleInfo.getSettleAcceptCH());
        settleInfo.setSettleConfirmCH(srcSettleInfo.getSettleConfirmCH());
        settleInfo.setSrcSettlementBill(srcSettleInfo);
        settleInfo.setDescription(srcSettleInfo.getDescription());
        settleInfo.setHasEffected(true);
        settleInfo.setFiVouchered(false);
        return settleInfo;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("settleAcceptCH.*");
        sic.add("settleConfirmCH.*");
        sic.add("srcSettlementBill.*");
        return sic;
    }

    protected abstract CompanyOrgUnitInfo getCompany(ReceiveAccountInfo var1);
}

