/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.fs.DoForRecPayEnum;
import com.kingdee.eas.fm.fs.ReceiveAccountFactory;
import com.kingdee.eas.fm.fs.ReceiveAccountInfo;
import com.kingdee.eas.framework.SystemEnum;
import java.util.Date;

public class ReceiveAcctBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        ReceiveAccountInfo recInfo = ReceiveAccountFactory.getLocalInstance(ctx).getReceiveAccountInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        CompanyOrgUnitInfo currCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        JournalCollection journalColl = new JournalCollection();
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setCompany(recInfo.getCompany());
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalInfo.setBillId(recInfo.getId().toString());
        journalInfo.setBillType(BillTypeEnum.ReceiveAccount);
        journalInfo.setBillNumber(recInfo.getNumber());
        journalInfo.setBizDate(recInfo.getBizDate());
        Date bookDate = this.getBookDate(ctx, recInfo.getBizDate(), currCompany);
        journalInfo.setCreateDate(bookDate);
        PeriodInfo bookPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bookDate, (CompanyOrgUnitInfo)currCompany);
        journalInfo.setPeriod(bookPeriodInfo);
        journalInfo.setCurrency(recInfo.getCurrency());
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setAccountBank(recInfo.getAccountBank());
        journalInfo.setAccountView(recInfo.getAccountBank().getAccount());
        journalInfo.setOppAccountView(null);
        journalInfo.setPlanItem(null);
        journalInfo.setSettlementType(recInfo.getSettlementType());
        journalInfo.setSettlementNumber(recInfo.getSettleNumber());
        journalInfo.setDescription(recInfo.getDescription());
        if (recInfo.getDoForRecPay().equals((Object)DoForRecPayEnum.REC)) {
            journalInfo.setCreditAmount(Constants.ZERO);
            journalInfo.setDebitAmount(recInfo.getAmount());
        } else {
            journalInfo.setCreditAmount(recInfo.getAmount());
            journalInfo.setDebitAmount(Constants.ZERO);
        }
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalColl.add(journalInfo);
        return journalColl;
    }

    private Date getBookDate(Context ctx, Date bizDate, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currPeriodInfo == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"current Period"});
        }
        Date bookDate = bizDate;
        if (bookDate.before(currPeriodInfo.getBeginDate())) {
            bookDate = currPeriodInfo.getBeginDate();
        }
        return bookDate;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("accountBank.*");
        sic.add("company.id");
        return sic;
    }
}

