/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.ClearingHouseHelper;
import com.kingdee.eas.fm.fs.IReceiveAcctBuilder;
import com.kingdee.eas.fm.fs.ISendAccount;
import com.kingdee.eas.fm.fs.ReceiveAccountInfo;
import com.kingdee.eas.fm.fs.ReceiveAcctHelper;
import com.kingdee.eas.fm.fs.ReceiveAcctSourceEnum;
import com.kingdee.eas.fm.fs.ReceiveAcctStatusEnum;
import com.kingdee.eas.fm.fs.ReckoningAccountHelper;
import com.kingdee.eas.fm.fs.ReckoningAccountInfo;
import com.kingdee.eas.fm.fs.SendAccountException;
import com.kingdee.eas.fm.fs.SendAccountFactory;
import com.kingdee.eas.fm.fs.SendAccountInfo;

public class SendAcctReceiveAcctBuilder
implements IReceiveAcctBuilder {
    @Override
    public ReceiveAccountInfo getReceiveAcctInfo(Context ctx, String billId) throws BOSException, EASBizException {
        SendAccountInfo sendInfo = this.getBizInterface(ctx).getSendAccountInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return this.buildRecAcctInfo(ctx, sendInfo);
    }

    private ReceiveAccountInfo buildRecAcctInfo(Context ctx, SendAccountInfo sendInfo) throws EASBizException, BOSException {
        BankInfo acceptCh = sendInfo.getSettleAcceptCH();
        BankInfo submitCh = sendInfo.getSubmitCH();
        BankInfo receiveCh = sendInfo.getReceiveCH();
        if (!receiveCh.isUsed()) {
            throw new SendAccountException(SendAccountException.CHISNOTUSED, new String[]{receiveCh.getName()});
        }
        BankInfo confirmCh = sendInfo.getSettleConfirmCH();
        ReceiveAccountInfo recInfo = new ReceiveAccountInfo();
        recInfo.setId(BOSUuid.create((BOSObjectType)recInfo.getBOSType()));
        recInfo.setSubmitCH(submitCh);
        recInfo.setSubmitDate(sendInfo.getSubmitDate());
        recInfo.setCompany(receiveCh.getRelatedCompany());
        recInfo.setIsBackBill(sendInfo.isIsBackBill());
        recInfo.setSource(ReceiveAcctSourceEnum.SENDACCOUNT);
        recInfo.setSrcSettlementBill(sendInfo.getSrcSettlementBill());
        recInfo.setBizDate(sendInfo.getBizDate());
        recInfo.setType(sendInfo.getType());
        recInfo.setDoForRecPay(sendInfo.getDoForRecPay());
        recInfo.setCurrency(sendInfo.getCurrency());
        recInfo.setAmount(sendInfo.getAmount());
        recInfo.setDescription(sendInfo.getDescription());
        recInfo.setUpReckoningAcct(this.getUpReckoningAcct(ctx, submitCh, receiveCh));
        recInfo.setDownReckoningAcct(this.getDownReckoningAcct(ctx, receiveCh, confirmCh));
        recInfo.setSettleAcceptCH(acceptCh);
        recInfo.setSettleConfirmCH(confirmCh);
        recInfo.setCreator(sendInfo.getChecker());
        recInfo.setStatus(ReceiveAcctStatusEnum.UNDEALED);
        recInfo.setFivouchered(false);
        recInfo.setUpBillId(sendInfo.getId().toString());
        String companyId = recInfo.getCompany().getId().toString();
        String confirmCompanyId = recInfo.getSettleConfirmCH().getRelatedCompany().getId().toString();
        String acceptCompanyId = recInfo.getSettleAcceptCH().getRelatedCompany().getId().toString();
        recInfo.setVoucherEnum(ReceiveAcctHelper.getRecAcctVoucherEnum(companyId, confirmCompanyId, acceptCompanyId));
        return recInfo;
    }

    private ReckoningAccountInfo getUpReckoningAcct(Context ctx, BankInfo submitCh, BankInfo receiveCh) throws EASBizException, BOSException {
        String receiveChId;
        String submitChId = submitCh.getId().toString();
        if (submitChId.equals(receiveChId = receiveCh.getId().toString())) {
            return null;
        }
        boolean isLowerCh = ClearingHouseHelper.isLowerCh(ctx, submitChId, receiveChId);
        if (isLowerCh) {
            return ReckoningAccountHelper.getDirectLowerAndUpperReckoningAcct(ctx, receiveChId, submitChId);
        }
        return ReckoningAccountHelper.getDirectUpperReckoningAcct(ctx, receiveCh);
    }

    private ReckoningAccountInfo getDownReckoningAcct(Context ctx, BankInfo receiveCh, BankInfo confirmCh) throws EASBizException, BOSException {
        String confirmChId;
        String receiveChId = receiveCh.getId().toString();
        if (receiveChId.equals(confirmChId = confirmCh.getId().toString())) {
            return null;
        }
        boolean isLowerCh = ClearingHouseHelper.isLowerCh(ctx, receiveChId, confirmChId);
        boolean isUpperCh = ClearingHouseHelper.isUpperCh(ctx, receiveChId, confirmChId);
        if (isLowerCh || !isLowerCh && !isUpperCh) {
            return ReckoningAccountHelper.getDirectUpperReckoningAcct(ctx, receiveCh);
        }
        return ReckoningAccountHelper.getDirectLowerAndUpperReckoningAcct(ctx, receiveChId, confirmChId);
    }

    private ISendAccount getBizInterface(Context ctx) throws BOSException {
        if (ctx == null) {
            return SendAccountFactory.getRemoteInstance();
        }
        return SendAccountFactory.getLocalInstance(ctx);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("settleAcceptCH.*");
        sic.add("settleConfirmCH.*");
        sic.add("submitCH.*");
        sic.add("receiveCH.*");
        return sic;
    }
}

