/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.DifPlaceEnum;
import com.kingdee.eas.fi.cas.IsMergencyEnum;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankPayingBillInfo;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BillTypeEnum;
import com.kingdee.eas.fm.be.DifBankEnum;
import com.kingdee.eas.fm.be.IBankPayBillBuilder;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.util.client.EASResource;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class SettleBill2BankPayBillBuilder
implements IBankPayBillBuilder {
    private static final Logger logger = CoreUIObject.getLogger(SettleBill2BankPayBillBuilder.class);

    public BankPayingBillInfo getBankPayBillInfo(Context ctx, SettlementBillInfo info) throws BOSException, EASBizException {
        SettBizTypeEnum type = info.getType();
        AccountBankCollection banks = new AccountBankCollection();
        if (type.getValue() == 10) {
            EntityViewInfo ev = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("isOnlyRead"));
            sic.add(new SelectorItemInfo("maxPayAmount"));
            sic.add(new SelectorItemInfo("bankAccountNumber"));
            ev.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            ev.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)info.getSubAccount().trim()));
            try {
                banks = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(ev);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        BankPayingBillInfo bankPayInfo = new BankPayingBillInfo();
        bankPayInfo.setSrcBillNumber(info.getNumber());
        bankPayInfo.setSourceBillId(info.getId().toString());
        bankPayInfo.setSrcBillType(BillTypeEnum.SETTLEMENT_BILL);
        bankPayInfo.setCompany(info.getPayerBankAcct().getCompany());
        bankPayInfo.setUnitCompany(info.getCompany());
        Timestamp time = new Timestamp(Calendar.getInstance().getTimeInMillis());
        if (info.getExpectDealTime() != null) {
            bankPayInfo.setExpectTransTime((Date)info.getExpectDealTime());
        } else {
            bankPayInfo.setExpectTransTime((Date)time);
        }
        if (FMHelper.isEmpty((Object)((Object)info.getSettleFeeMode()))) {
            bankPayInfo.setSettleFeeMode(null);
        } else {
            bankPayInfo.setSettleFeeMode(info.getSettleFeeMode().getAlias());
        }
        bankPayInfo.setCreateTime(time);
        bankPayInfo.setBizDate(info.getBizDate());
        if (type.getValue() == 10) {
            bankPayInfo.setPayAccountBank(banks.get(0));
            bankPayInfo.setParentAccount(info.getPayerBankAcctNum());
            bankPayInfo.setIsLinkPay(true);
        } else {
            bankPayInfo.setPayAccountBank(info.getPayerBankAcct());
            bankPayInfo.setIsLinkPay(false);
        }
        bankPayInfo.setPayApplicationUnit(info.getPayerFullName());
        if (info.getCurrency() == null || info.getCurrency().getIsoCode() == null || info.getCurrency().getIsoCode() == "") {
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"179_SettleBill2BankPayBillBuilder");
            throw new BEException(BEException.COMMON, new Object[]{msg});
        }
        bankPayInfo.setCurrency(info.getCurrency());
        bankPayInfo.setPayAmount(info.getAmount());
        bankPayInfo.setRecAccountBank(info.getPayeeBankAcctNum());
        String recBank = info.getPayeeBank();
        bankPayInfo.setRecBank(recBank);
        bankPayInfo.setFRecCountry(info.getFRecCountry());
        bankPayInfo.setRecProvinceStr(info.getRecProvinceStr());
        bankPayInfo.setRecCityStr(info.getRecCityStr());
        if (type != null && info.getPayeeBankAcct() != null && type.getValue() == 4) {
            bankPayInfo.setRecCompany(info.getPayeeBankAcct().getCompany().getName());
        } else if (EmptyUtil.isEmpty((String)info.getBankAcctName())) {
            bankPayInfo.setRecCompany(info.getPayeeFullName());
        } else {
            bankPayInfo.setRecCompany(info.getBankAcctName());
        }
        bankPayInfo.setBankNumber(info.getBankNumber());
        Object bankInterfaceType = null;
        bankPayInfo.setRecBankNo(info.getBankNumber());
        bankPayInfo.setUsage(info.getUsage());
        if (info.getSettleType() != null) {
            bankPayInfo.setIsPersonPay(info.getSettleType().isIsPersonPay());
            bankPayInfo.setIsAgencyPersonPay(info.getSettleType().isIsAgencyPersonPay());
            if (info.getSettleType().isIsAgentPay()) {
                bankPayInfo.setRemitAccountBank(info.getRemitAccountBank());
            }
        }
        if (IsMergencyEnum.mergercy == info.getIsUrgent()) {
            bankPayInfo.setIsEmergency(true);
        } else {
            bankPayInfo.setIsEmergency(false);
        }
        bankPayInfo.setIsForceManual(info.isIsForceManual());
        bankPayInfo.setSwiftCode(info.getSwiftCode());
        String strValue = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("TM018", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (strValue == null || "0".equals(strValue)) {
            bankPayInfo.setState(BankPayingBillStateEnum.OS);
            bankPayInfo.setSubmitTime(time);
            if (info.getIsSmart() != null && info.getIsSmart().getValue() == 5) {
                bankPayInfo.setPriorityPay(false);
            } else {
                bankPayInfo.setPriorityPay(true);
            }
        } else {
            bankPayInfo.setState(BankPayingBillStateEnum.OP);
            bankPayInfo.setPriorityPay(true);
        }
        bankPayInfo.setDescription(info.getUsage());
        int descriptionMaxLength = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("BE007", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (descriptionMaxLength > 0 && bankPayInfo.getDescription() != null && bankPayInfo.getDescription().length() > descriptionMaxLength) {
            bankPayInfo.setDescription(bankPayInfo.getDescription().substring(0, descriptionMaxLength));
        }
        if (DifPlaceEnum.difPlace == info.getIsDifferPlace()) {
            bankPayInfo.setIsDifferPlace(true);
        } else {
            bankPayInfo.setIsDifferPlace(false);
        }
        if (bankPayInfo.getPayAccountBank() != null && bankPayInfo.getPayAccountBank().getAgencyCompany() != null) {
            bankPayInfo.setAgencCompany(bankPayInfo.getPayAccountBank().getAgencyCompany());
        } else {
            bankPayInfo.setAgencCompany(bankPayInfo.getCompany());
        }
        bankPayInfo.setRecOpenArea(info.getPayeeArea());
        bankPayInfo.setIsDifBank(DifBankEnum.getEnum((int)info.getIsDifBank().getValue()));
        String[] serialNumbers = beServiceHelper.getSerialNumber((int)1);
        bankPayInfo.setSerialNumber(serialNumbers[0]);
        bankPayInfo.setHandler(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        return bankPayInfo;
    }

    public BankPayingBillInfo getBankPayBillInfo(Context ctx, String billId) throws BOSException, EASBizException {
        ISettlementBill iSettlementBill = SettlementBillFactory.getLocalInstance(ctx);
        SettlementBillInfo info = iSettlementBill.getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return this.getBankPayBillInfo(ctx, info);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("payeeBankAcct.id"));
        sic.add(new SelectorItemInfo("payeeBankAcct.bank"));
        sic.add(new SelectorItemInfo("payeeBankAcct.company"));
        sic.add(new SelectorItemInfo("payerBankAcct.bankInterfaceType"));
        sic.add(new SelectorItemInfo("payerBankAcct.openArea"));
        sic.add(new SelectorItemInfo("payerBankAcct.*"));
        sic.add(new SelectorItemInfo("settleType.*"));
        sic.add(new SelectorItemInfo("payerBankAcct.company"));
        sic.add(new SelectorItemInfo("settleFeeMode.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        return sic;
    }
}

