/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.fs.TransBillBaseEntryCollection;
import com.kingdee.eas.fm.fs.TransBillBaseEntryInfo;
import com.kingdee.eas.fm.fs.TransBillBaseInfo;
import com.kingdee.eas.fm.fs.TransDownBillEntryFactory;
import com.kingdee.eas.fm.fs.TransDownBillEntryInfo;
import com.kingdee.eas.fm.fs.TransUpDownBillHelper;
import java.math.BigDecimal;
import java.util.Date;

public abstract class TransBaseBillBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        TransBillBaseInfo info = this.getInfo(ctx, billId);
        TransBillBaseEntryCollection entryColl = this.getEntryColl(info);
        return this.genJournalColl(ctx, info, entryColl);
    }

    private JournalCollection genJournalColl(Context ctx, TransBillBaseInfo info, TransBillBaseEntryCollection entryColl) throws EASBizException, BOSException {
        boolean TM106;
        JournalCollection journalColl = new JournalCollection();
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        int val = localInstance.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(localInstance.getCurrentCompany().getId()));
        int CS104 = localInstance.getIntParam("CS104", (IObjectPK)new ObjectUuidPK(localInstance.getCurrentCompany().getId()));
        if (val == 0 && (TM106 = localInstance.getBooleanParam("TM106", (IObjectPK)new ObjectUuidPK(localInstance.getCurrentCompany().getId())))) {
            CompanyOrgUnitInfo company = info.getCompany();
            Date bizDate = info.getBizDate();
            Date bookDate = TransUpDownBillHelper.getBookDate(ctx, bizDate, company, CS104, info);
            PeriodInfo bookPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bookDate, (CompanyOrgUnitInfo)company);
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            for (int i = 0; i < entryColl.size(); ++i) {
                JournalInfo journalInfo = new JournalInfo();
                if (!entryColl.get(i).isHasChange() || !entryColl.get(i).isIsSuccessed()) continue;
                journalInfo.setCompany(company);
                journalInfo.setSource(JournalSourceEnum.BYBILL);
                journalInfo.setBillId(entryColl.get(i).getId().toString());
                journalInfo.setBillType(this.getBillType());
                journalInfo.setBillNumber(info.getNumber());
                journalInfo.setBizDate(bizDate);
                journalInfo.setCreateDate(bookDate);
                journalInfo.setPeriod(bookPeriodInfo);
                journalInfo.setCurrency(info.getCurrency());
                journalInfo.setType(JournalTypeEnum.BANK);
                journalInfo.setAccountBank(info.getMotherAcctBank());
                journalInfo.setAccountView(info.getMotherAcctBank().getAccount());
                journalInfo.setSettlementType(info.getSettleType());
                journalInfo.setSettlementNumber(info.getSettleNumber());
                journalInfo.setDescription(entryColl.get(i).getDescription());
                journalInfo.setIsDebit(this.isDebit());
                journalInfo.setDebitAmount(this.getDebitAmtEntry(entryColl.get(i)));
                journalInfo.setCreditAmount(this.getCreditAmtEntry(entryColl.get(i)));
                journalInfo.setOppUnit(entryColl.get(i).getUnit().getName());
                journalInfo.setOppAcctNumber(entryColl.get(i).getUnitAcctBank().getBankAccountNumber());
                if (!EmptyUtil.isEmpty((String)entryColl.get(i).getBankCheckFlag())) {
                    journalInfo.setBankCheckFlag(entryColl.get(i).getBankCheckFlag());
                }
                if (entryColl.get(i).getBOSType().equals((Object)new TransDownBillEntryInfo().getBOSType())) {
                    TransDownBillEntryInfo entryInfo = TransDownBillEntryFactory.getLocalInstance(ctx).getTransDownBillEntryInfo((IObjectPK)new ObjectUuidPK(entryColl.get(i).getId().toString()));
                    journalInfo.setOppBank(entryInfo.getRecBank());
                } else {
                    journalInfo.setOppBank(entryColl.get(i).getUnitAcctBank().getBank().getName());
                }
                journalInfo.setCashier(userInfo);
                journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
                journalColl.add(journalInfo);
            }
            return journalColl;
        }
        JournalInfo journalInfo = new JournalInfo();
        CompanyOrgUnitInfo company = info.getCompany();
        journalInfo.setCompany(company);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalInfo.setBillId(info.getId().toString());
        journalInfo.setBillType(this.getBillType());
        journalInfo.setBillNumber(info.getNumber());
        Date bizDate = info.getBizDate();
        journalInfo.setBizDate(bizDate);
        Date bookDate = TransUpDownBillHelper.getBookDate(ctx, bizDate, company);
        journalInfo.setCreateDate(bookDate);
        PeriodInfo bookPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bookDate, (CompanyOrgUnitInfo)company);
        journalInfo.setPeriod(bookPeriodInfo);
        journalInfo.setCurrency(info.getCurrency());
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setAccountBank(info.getMotherAcctBank());
        journalInfo.setAccountView(info.getMotherAcctBank().getAccount());
        journalInfo.setSettlementType(info.getSettleType());
        journalInfo.setSettlementNumber(info.getSettleNumber());
        journalInfo.setDescription(info.getDescription());
        journalInfo.setIsDebit(this.isDebit());
        journalInfo.setDebitAmount(this.getDebitAmt(info));
        journalInfo.setCreditAmount(this.getCreditAmt(info));
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        journalInfo.setCashier(userInfo);
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalColl.add(journalInfo);
        return journalColl;
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("motherAcctBank.*");
        sic.add("motherAcctBank.account.*");
        sic.add("entrys.*");
        sic.add("entrys.unit.name");
        sic.add("entrys.unitAcctBank.bankAccountNumber");
        sic.add("entrys.unitAcctBank.bank.name");
        return sic;
    }

    protected abstract boolean isDebit();

    protected abstract BillTypeEnum getBillType();

    protected abstract BigDecimal getDebitAmt(TransBillBaseInfo var1);

    protected abstract BigDecimal getCreditAmt(TransBillBaseInfo var1);

    protected abstract BigDecimal getDebitAmtEntry(TransBillBaseEntryInfo var1);

    protected abstract BigDecimal getCreditAmtEntry(TransBillBaseEntryInfo var1);

    protected abstract TransBillBaseInfo getInfo(Context var1, String var2) throws EASBizException, BOSException;

    protected abstract TransBillBaseEntryCollection getEntryColl(TransBillBaseInfo var1) throws EASBizException, BOSException;
}

