/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankTransDownBillFactory;
import com.kingdee.eas.fm.be.BankTransDownBillInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.util.FMARAPUtil;
import com.kingdee.eas.fm.fs.AutoTransCollection;
import com.kingdee.eas.fm.fs.AutoTransCommitTypeEnum;
import com.kingdee.eas.fm.fs.AutoTransEntryInfo;
import com.kingdee.eas.fm.fs.AutoTransHistoryCollection;
import com.kingdee.eas.fm.fs.AutoTransHistoryFactory;
import com.kingdee.eas.fm.fs.AutoTransHistoryInfo;
import com.kingdee.eas.fm.fs.AutoTransInfo;
import com.kingdee.eas.fm.fs.ITransDownBill;
import com.kingdee.eas.fm.fs.ITransDownBillFacade;
import com.kingdee.eas.fm.fs.LaunchModeEnum;
import com.kingdee.eas.fm.fs.TransAmtInfo;
import com.kingdee.eas.fm.fs.TransDownBillCollection;
import com.kingdee.eas.fm.fs.TransDownBillEntryInfo;
import com.kingdee.eas.fm.fs.TransDownBillFacadeFactory;
import com.kingdee.eas.fm.fs.TransDownBillFactory;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.fm.fs.TransDownBillOverdraftChecker;
import com.kingdee.eas.fm.fs.TransDownBillStateEnum;
import com.kingdee.eas.fm.fs.TransUpDownBillHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TransDownBillHelper
extends TransUpDownBillHelper {
    private static Logger logger = Logger.getLogger((String)TransDownBillHelper.class.getName());

    @Override
    protected Map getTransAcctBankAmt(String motherAcctBankId, String currencyId) throws BOSException, EASBizException {
        ITransDownBillFacade facade = TransDownBillFacadeFactory.getRemoteInstance();
        return facade.getTransDownAcctBankAmt(motherAcctBankId, currencyId);
    }

    public static AccountBankCollection getTransDownAcctBankColl(Context ctx, String motherAcctBankId, Date date) throws EASBizException, BOSException {
        IAccountBank iacctBank = TransDownBillHelper.getAccountBankInterface(ctx);
        EntityViewInfo view = TransDownBillHelper.getEntityViewInfo(motherAcctBankId);
        AccountBankCollection unitAcctBankColl = iacctBank.getAccountBankCollection(view);
        AccountBankCollection transDownAcctBankColl = new AccountBankCollection();
        AccountBankInfo info = null;
        for (int i = 0; i < unitAcctBankColl.size(); ++i) {
            info = unitAcctBankColl.get(i);
            if (info.getCtrlStrategy() == null || !info.getAccountType().equals((Object)AccountType.PAYOUT) && !info.getAccountType().equals((Object)AccountType.PAYINOUT)) continue;
            transDownAcctBankColl.add(info);
        }
        return transDownAcctBankColl;
    }

    private static EntityViewInfo getEntityViewInfo(String montherAcctId) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("subAccount", (Object)montherAcctId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE, CompareType.EQUALS));
        evi.setFilter(filter);
        SelectorItemCollection sic = TransDownBillHelper.getBankAcntSelector();
        evi.setSelector(sic);
        return evi;
    }

    private static SelectorItemCollection getBankAcntSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("ID"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("accountType"));
        sic.add(new SelectorItemInfo("openDate"));
        sic.add(new SelectorItemInfo("closeDate"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("property.id"));
        sic.add(new SelectorItemInfo("property.name"));
        sic.add(new SelectorItemInfo("isMotherAccount"));
        sic.add(new SelectorItemInfo("isSetBankInterface"));
        sic.add(new SelectorItemInfo("ctrlStrategy.id"));
        sic.add(new SelectorItemInfo("ctrlStrategy.name"));
        sic.add(new SelectorItemInfo("InnerAcct.id"));
        sic.add(new SelectorItemInfo("InnerAcct.name"));
        sic.add(new SelectorItemInfo("InnerAcct.number"));
        sic.add(new SelectorItemInfo("InnerAcct.clearingHouse.relatedCompany"));
        sic.add(new SelectorItemInfo("InnerAcct.company.id"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("subAccount.id"));
        sic.add(new SelectorItemInfo("subAccount.name"));
        sic.add(new SelectorItemInfo("subAccount.number"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("bank.number"));
        sic.add(new SelectorItemInfo("openArea.*"));
        sic.add(new SelectorItemInfo("CtrlStrategy.*"));
        return sic;
    }

    @Override
    public Set getUnitAcctBankIdSet(String motherAcctBankId) throws EASBizException, BOSException {
        return super.getUnitAcctBankIdSet(motherAcctBankId);
    }

    public Set getPayValidIdSetByAction(Context ctx, Set idSet, int action) throws BOSException, EASBizException {
        TransDownBillCollection coll = TransDownBillHelper.getTransDownBillColl(ctx, idSet);
        Set validSet = null;
        switch (action) {
            case 41: {
                validSet = this.getTransDownValidIdSetByCommitBE(ctx, coll);
            }
        }
        if (validSet == null || validSet.isEmpty()) {
            throw new RecPayException(RecPayException.HASNOT_VALID_LISTS);
        }
        return validSet;
    }

    private Set getTransDownValidIdSetByCommitBE(Context ctx, TransDownBillCollection coll) throws EASBizException {
        HashSet<String> set = new HashSet<String>();
        TransDownBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (info.getMotherAcctBank().isIsOnlyRead()) {
                throw new BEException(BEException.ACCOUNTBANKONLYREAD, new Object[]{info.getMotherAcctBank().getName()});
            }
            if (info.getState().equals((Object)TransDownBillStateEnum.AUDITED) && info.getMotherAcctBank() != null && !info.getMotherAcctBank().isIsOnlyRead()) {
                set.add(info.getId().toString());
            }
            for (int index = 0; index < info.getEntrys().size(); ++index) {
                if (!FMHelper.isEmpty((String)info.getEntrys().get(index).getRecProvince()) && !FMHelper.isEmpty((String)info.getEntrys().get(index).getRecCity()) && !FMHelper.isEmpty((String)info.getEntrys().get(index).getRecBank())) continue;
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"181_TransDownBillHelper"));
                SysUtil.abort();
            }
        }
        return set;
    }

    public static TransDownBillCollection getTransDownBillColl(Context ctx, Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        evi.getSelector().add("entrys.*");
        evi.getSelector().add("entrys.unitAcctBank.name");
        evi.getSelector().add("entrys.unitAcctBank.acctName");
        evi.getSelector().add("motherAcctBank.*");
        ITransDownBill iTransDownBill = null;
        iTransDownBill = ctx == null ? TransDownBillFactory.getRemoteInstance() : TransDownBillFactory.getLocalInstance(ctx);
        return iTransDownBill.getTransDownBillCollection(evi);
    }

    public Map genTransDownBills(Context ctx, AutoTransCollection colls) throws BOSException, EASBizException {
        HashMap<String, AutoTransHistoryCollection> idSet = new HashMap<String, AutoTransHistoryCollection>();
        for (int i = 0; i < colls.size(); ++i) {
            TransDownBillInfo info;
            AutoTransInfo autoInfo;
            block14: {
                autoInfo = colls.get(i);
                if (TransDownBillHelper.checkIsAutoRun(ctx, autoInfo.getId().toString())) {
                    logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"301_TransDownBillHelper") + autoInfo.getName() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"302_TransDownBillHelper")));
                    continue;
                }
                info = new TransDownBillInfo();
                info.setId(BOSUuid.create((BOSObjectType)new TransDownBillInfo().getBOSType()));
                info.setCompany(autoInfo.getCompany());
                info.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
                info.setLaunchMode(LaunchModeEnum.CH_LAUNCH);
                info.setCurrency(autoInfo.getCompany().getBaseCurrency());
                info.setExchangeRate(Constants.ONE);
                info.setTotalAmt(Constants.ZERO);
                info.setConfirmedAmt(Constants.ZERO);
                info.setCreator(autoInfo.getCreator());
                info.setState(TransDownBillStateEnum.SAVED);
                info.setAccessories(0);
                info.setSettleType(autoInfo.getSettleType());
                info.setUsage(autoInfo.getRemark());
                info.setCurrency(autoInfo.getCurrent());
                info.setFpItem(autoInfo.getFpItem());
                info.setOutBgItemId(autoInfo.getOutBgItemId());
                info.setOutBgItemName(autoInfo.getOutBgItemName());
                info.setOutBgItemNumber(autoInfo.getOutBgItemNumber());
                info.setMotherAcctBank(autoInfo.getParentAcct());
                String companyId = autoInfo.getCompany().getId().toString();
                ExchangeRateInfo exRateInfo = FMARAPUtil.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)autoInfo.getCompany(), (CurrencyInfo)autoInfo.getCurrent(), (Date)info.getBizDate());
                if (exRateInfo != null) {
                    info.setExchangeRate(exRateInfo.getConvertRate());
                }
                info.setIsUrgent(autoInfo.isIsUrgent());
                info.setDescription(autoInfo.getRemark());
                boolean rst = FMHelper.hasNumber((Context)ctx, (CoreBaseInfo)info, (String)companyId);
                if (rst) {
                    try {
                        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                        String number = codingRuleManager.getNumber((IObjectValue)info, companyId);
                        info.setNumber(number);
                        break block14;
                    }
                    catch (EASBizException e) {
                        logger.info((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"303_TransDownBillHelper"));
                        TransDownBillHelper.addErrorTransLog(ctx, autoInfo, e.getMessage());
                        continue;
                    }
                }
                logger.info((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"304_TransDownBillHelper"));
                TransDownBillHelper.addErrorTransLog(ctx, autoInfo, EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"isNeedTransDownNumber"));
                continue;
            }
            try {
                logger.info((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"305_TransDownBillHelper"));
                this.genAutoTransBillEntry(ctx, info, autoInfo);
                info.setTotalCounts(info.getEntrys().size());
                if (info.getEntrys().size() > 0) {
                    StringBuffer sb = new StringBuffer();
                    logger.info((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"306_TransDownBillHelper"));
                    if (TransDownBillHelper.checkOverdraft(ctx, info, sb)) {
                        IObjectPK pk = TransDownBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
                        if (autoInfo.getIsCommitBe().equals((Object)AutoTransCommitTypeEnum.COMMITBE)) {
                            HashSet<String> idsSet = new HashSet<String>();
                            idsSet.add(pk.toString());
                            TransDownBillFacadeFactory.getLocalInstance(ctx).audit(idsSet);
                        }
                        logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"307_TransDownBillHelper") + info.getEntrys().size() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"308_TransDownBillHelper")));
                        AutoTransHistoryCollection hisColls = new AutoTransHistoryCollection();
                        for (int index = 0; index < info.getEntrys().size(); ++index) {
                            AutoTransHistoryInfo hisInfo = new AutoTransHistoryInfo();
                            hisInfo.setBizDate(new Date());
                            hisInfo.setTransDownBill(info);
                            hisInfo.setMotherAcct(info.getMotherAcctBank());
                            hisInfo.setTransUnit(info.getEntrys().get(index).getUnit());
                            hisInfo.setUnitAccount(info.getEntrys().get(index).getUnitAcctBank());
                            hisInfo.setSourceBillId(info.getEntrys().get(index).getId().toString());
                            hisInfo.setAutoTrans(autoInfo);
                            hisInfo.setCreator(autoInfo.getCreator());
                            AutoTransHistoryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)hisInfo);
                            hisColls.add(hisInfo);
                        }
                        if (autoInfo.getIsCommitBe().equals((Object)AutoTransCommitTypeEnum.COMMITBE)) {
                            idSet.put(pk.toString(), hisColls);
                            String logName = EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"autoTransDown") + EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"titleSet") + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"309_TransDownBillHelper");
                            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)logName, (BOSObjectType)new AutoTransInfo().getBOSType(), null, (String)autoInfo.getNumber(), (String)"fs_autoTrans_submitBe");
                            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
                        } else {
                            TransDownBillHelper.sendTransBillMessage(ctx, true, hisColls, false, false);
                        }
                        logger.info((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"310_TransDownBillHelper"));
                        continue;
                    }
                    logger.info((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"311_TransDownBillHelper"));
                    TransDownBillHelper.addErrorTransLog(ctx, autoInfo, sb.toString());
                    continue;
                }
                logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"312_TransDownBillHelper") + autoInfo.getName() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"313_TransDownBillHelper")));
                TransDownBillHelper.addErrorTransLog(ctx, autoInfo, EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"notRecordDownSize"));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                TransDownBillHelper.addErrorTransLog(ctx, autoInfo, e.getMessage());
            }
        }
        return idSet;
    }

    public Map genTransDownBillsNew(Context ctx, AutoTransCollection colls) throws BOSException, EASBizException {
        HashMap<String, AutoTransHistoryCollection> idSet = new HashMap<String, AutoTransHistoryCollection>();
        for (int i = 0; i < colls.size(); ++i) {
            TransDownBillInfo info;
            AutoTransInfo autoInfo;
            block16: {
                autoInfo = colls.get(i);
                info = new TransDownBillInfo();
                info.setId(BOSUuid.create((BOSObjectType)new TransDownBillInfo().getBOSType()));
                info.setCompany(autoInfo.getCompany());
                info.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
                info.setLaunchMode(LaunchModeEnum.CH_LAUNCH);
                info.setCurrency(autoInfo.getCompany().getBaseCurrency());
                info.setExchangeRate(Constants.ONE);
                info.setTotalAmt(Constants.ZERO);
                info.setConfirmedAmt(Constants.ZERO);
                info.setCreator(autoInfo.getCreator());
                info.setState(TransDownBillStateEnum.SAVED);
                info.setAccessories(0);
                info.setSettleType(autoInfo.getSettleType());
                info.setUsage(autoInfo.getRemark());
                info.setCurrency(autoInfo.getCurrent());
                info.setFpItem(autoInfo.getFpItem());
                if (!EmptyUtil.isEmpty((String)autoInfo.getOutBgItemId())) {
                    info.setOutBgItemId(autoInfo.getOutBgItemId());
                    info.setOutBgItemName(autoInfo.getOutBgItemName());
                    info.setOutBgItemNumber(autoInfo.getOutBgItemNumber());
                } else {
                    info.setFundFlowItem(autoInfo.getFundFlowItem());
                }
                info.setMotherAcctBank(autoInfo.getParentAcct());
                String companyId = autoInfo.getCompany().getId().toString();
                ExchangeRateInfo exRateInfo = FMARAPUtil.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)autoInfo.getCompany(), (CurrencyInfo)autoInfo.getCurrent(), (Date)info.getBizDate());
                if (exRateInfo != null) {
                    info.setExchangeRate(exRateInfo.getConvertRate());
                }
                info.setIsUrgent(autoInfo.isIsUrgent());
                info.setDescription(autoInfo.getRemark());
                boolean rst = FMHelper.hasNumber((Context)ctx, (CoreBaseInfo)info, (String)companyId);
                if (rst) {
                    try {
                        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                        String number = codingRuleManager.getNumber((IObjectValue)info, companyId);
                        info.setNumber(number);
                        break block16;
                    }
                    catch (EASBizException e) {
                        logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"303_TransDownBillHelper"));
                        TransDownBillHelper.addErrorTransLog(ctx, autoInfo, e.getMessage());
                        continue;
                    }
                }
                logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"304_TransDownBillHelper"));
                TransDownBillHelper.addErrorTransLog(ctx, autoInfo, EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"isNeedTransDownNumber"));
                continue;
            }
            try {
                logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"305_TransDownBillHelper"));
                this.genAutoTransBillEntryNew(ctx, info, autoInfo);
                info.setTotalCounts(info.getEntrys().size());
                if (info.getEntrys().size() > 0) {
                    IObjectPK pk;
                    StringBuffer sb = new StringBuffer();
                    logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"306_TransDownBillHelper"));
                    if (!autoInfo.getIsCommitBe().equals((Object)AutoTransCommitTypeEnum.COMMITBE)) {
                        pk = TransDownBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
                        logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"307_TransDownBillHelper") + info.getEntrys().size() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"308_TransDownBillHelper")));
                        AutoTransHistoryCollection hisColls = new AutoTransHistoryCollection();
                        for (int index = 0; index < info.getEntrys().size(); ++index) {
                            AutoTransHistoryInfo hisInfo = new AutoTransHistoryInfo();
                            hisInfo.setBizDate(new Date());
                            hisInfo.setTransDownBill(info);
                            hisInfo.setMotherAcct(info.getMotherAcctBank());
                            hisInfo.setTransUnit(info.getEntrys().get(index).getUnit());
                            hisInfo.setUnitAccount(info.getEntrys().get(index).getUnitAcctBank());
                            hisInfo.setSourceBillId(info.getEntrys().get(index).getId().toString());
                            hisInfo.setAutoTrans(autoInfo);
                            hisInfo.setCreator(autoInfo.getCreator());
                            AutoTransHistoryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)hisInfo);
                            hisColls.add(hisInfo);
                        }
                        TransDownBillHelper.sendTransBillMessage(ctx, true, hisColls, false, false);
                        continue;
                    }
                    if (TransDownBillHelper.checkOverdraft(ctx, info, sb)) {
                        pk = TransDownBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
                        HashSet<String> idsSet = new HashSet<String>();
                        idsSet.add(pk.toString());
                        TransDownBillFacadeFactory.getLocalInstance(ctx).audit(idsSet);
                        logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"307_TransDownBillHelper") + info.getEntrys().size() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"308_TransDownBillHelper")));
                        AutoTransHistoryCollection hisColls = new AutoTransHistoryCollection();
                        for (int index = 0; index < info.getEntrys().size(); ++index) {
                            AutoTransHistoryInfo hisInfo = new AutoTransHistoryInfo();
                            hisInfo.setBizDate(new Date());
                            hisInfo.setTransDownBill(info);
                            hisInfo.setMotherAcct(info.getMotherAcctBank());
                            hisInfo.setTransUnit(info.getEntrys().get(index).getUnit());
                            hisInfo.setUnitAccount(info.getEntrys().get(index).getUnitAcctBank());
                            hisInfo.setSourceBillId(info.getEntrys().get(index).getId().toString());
                            hisInfo.setAutoTrans(autoInfo);
                            hisInfo.setCreator(autoInfo.getCreator());
                            AutoTransHistoryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)hisInfo);
                            hisColls.add(hisInfo);
                        }
                        if (autoInfo.getIsCommitBe().equals((Object)AutoTransCommitTypeEnum.COMMITBE)) {
                            idSet.put(pk.toString(), hisColls);
                            String logName = EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"autoTransDown") + EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"titleSet") + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"309_TransDownBillHelper");
                            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)logName, (BOSObjectType)new AutoTransInfo().getBOSType(), null, (String)autoInfo.getNumber(), (String)"fs_autoTrans_submitBe");
                            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
                        } else {
                            TransDownBillHelper.sendTransBillMessage(ctx, true, hisColls, false, false);
                        }
                        logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"310_TransDownBillHelper"));
                        continue;
                    }
                    logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"311_TransDownBillHelper"));
                    TransDownBillHelper.addErrorTransLog(ctx, autoInfo, sb.toString());
                    continue;
                }
                logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"312_TransDownBillHelper") + autoInfo.getName() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"313_TransDownBillHelper")));
                TransDownBillHelper.addErrorTransLog(ctx, autoInfo, EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"notRecordDownSize"));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                TransDownBillHelper.addErrorTransLog(ctx, autoInfo, e.getMessage());
            }
        }
        return idSet;
    }

    private static boolean checkOverdraft(Context ctx, TransDownBillInfo info, StringBuffer sb) throws EASBizException, BOSException {
        TransDownBillOverdraftChecker checker = new TransDownBillOverdraftChecker();
        List transAmtList = TransDownBillFacadeFactory.getLocalInstance(ctx).getOverdraftTransAmtList(info);
        TransAmtInfo transAmtInfo = null;
        int size = transAmtList.size();
        for (int i = 0; i < size; ++i) {
            transAmtInfo = (TransAmtInfo)transAmtList.get(i);
            checker.checkOverdraft(checker.buildSubAcctInfo(transAmtInfo), transAmtInfo.getAmount(), transAmtInfo.getBalance(), transAmtInfo.getAcctMgrInfo(), transAmtInfo.getType());
        }
        if (checker.getResult() == -1) {
            sb.append(checker.getNoPassMsg());
            return false;
        }
        return true;
    }

    public void genAutoTransBillEntry(Context ctx, TransDownBillInfo info, AutoTransInfo autoInfo) throws EASBizException, BOSException {
        int seq = 1;
        String accountId = autoInfo.getParentAcct().getId().toString();
        String currentId = autoInfo.getCurrent().getId().toString();
        ITransDownBillFacade facade = TransDownBillFacadeFactory.getLocalInstance(ctx);
        List list = this.getAmtSortedList(facade.getTransDownAcctBankAmt(accountId, currentId));
        logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"314_TransDownBillHelper") + autoInfo.getEntrys().size() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"315_TransDownBillHelper")));
        for (int i = 0; i < autoInfo.getEntrys().size(); ++i) {
            AutoTransEntryInfo autoEntry = autoInfo.getEntrys().get(i);
            TransDownBillEntryInfo entryInfo = new TransDownBillEntryInfo();
            entryInfo.setSeq(seq++);
            entryInfo.setUnit(autoEntry.getTransDownUnit());
            entryInfo.setUnitAcctBank(autoEntry.getUnitAccount());
            if (autoEntry.getUnitAccount() != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("acctName"));
                sic.add(new SelectorItemInfo("InnerAcct.id"));
                sic.add(new SelectorItemInfo("InnerAcct.name"));
                sic.add(new SelectorItemInfo("InnerAcct.number"));
                sic.add(new SelectorItemInfo("InnerAcct.acctNumber"));
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)autoEntry.getUnitAccount().getId().toString(), CompareType.EQUALS));
                view.setSelector(sic);
                AccountBankCollection accountBankCollection = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
                if (accountBankCollection.size() > 0) {
                    entryInfo.setUnitInnerAcct(accountBankCollection.get(0).getInnerAcct());
                }
            }
            entryInfo.setIsSuccessed(false);
            entryInfo.setDescription(autoInfo.getRemark());
            entryInfo.setPayeeArea(autoEntry.getOpenArea());
            entryInfo.setRecProvince(autoEntry.getProvince());
            entryInfo.setRecCity(autoEntry.getCity());
            entryInfo.setRecBank(autoEntry.getRecBank());
            entryInfo.setProject(autoEntry.getProject());
            entryInfo.setFpItem(autoEntry.getFpItem());
            entryInfo.setOutBgItemId(autoEntry.getOutBgItemId());
            entryInfo.setOutBgItemName(autoEntry.getOutBgItemName());
            entryInfo.setOutBgItemNumber(autoEntry.getOutBgItemNumber());
            entryInfo.setIsDifferPlace(autoEntry.getDifPlace());
            entryInfo.setIsDifBank(autoEntry.getDifBank());
            entryInfo.setAmount(Constants.ZERO);
            if (autoEntry.getRecBank() != null) {
                String bankCode = BEBankFactory.getLocalInstance((Context)ctx).getBankNo(autoEntry.getRecBank());
                entryInfo.setPayeeBankCode(bankCode);
            }
            for (int index = 0; index < list.size(); ++index) {
                TransAmtInfo amtInfo = (TransAmtInfo)list.get(index);
                if (!amtInfo.getUnit().getId().equals((Object)entryInfo.getUnit().getId()) || !amtInfo.getAcctBank().getId().equals((Object)entryInfo.getUnitAcctBank().getId())) continue;
                entryInfo.setAmount(amtInfo.getAmount());
                break;
            }
            if (entryInfo.getAmount().equals(Constants.ZERO)) continue;
            info.getEntrys().add(entryInfo);
        }
        logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"316_TransDownBillHelper") + autoInfo.getEntrys().size() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"315_TransDownBillHelper")));
        BigDecimal sumAmt = Constants.ZERO;
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            sumAmt = sumAmt.add(info.getEntrys().get(i).getAmount());
        }
        info.setTotalAmt(sumAmt);
    }

    public void genAutoTransBillEntryNew(Context ctx, TransDownBillInfo info, AutoTransInfo autoInfo) throws EASBizException, BOSException {
        int seq = 1;
        String accountId = autoInfo.getParentAcct().getId().toString();
        String currentId = autoInfo.getCurrent().getId().toString();
        ITransDownBillFacade facade = TransDownBillFacadeFactory.getLocalInstance(ctx);
        int size = 1 + autoInfo.getEntrys().size();
        String[] idSet = new String[size];
        for (int i = 0; i < autoInfo.getEntrys().size(); ++i) {
            if (EmptyUtil.isEmpty((CoreBaseInfo)autoInfo.getEntrys().get(i).getUnitAccount())) continue;
            idSet[i] = autoInfo.getEntrys().get(i).getUnitAccount().getId().toString();
        }
        idSet[size - 1] = accountId;
        BankFacadeFactory.getLocalInstance((Context)ctx).getBalance(currentId, idSet, new Date(), new Date());
        List list = this.getAmtSortedList(facade.getTransDownAcctBankAmt(accountId, currentId));
        logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"314_TransDownBillHelper") + autoInfo.getEntrys().size() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"315_TransDownBillHelper")));
        for (int i = 0; i < autoInfo.getEntrys().size(); ++i) {
            AutoTransEntryInfo autoEntry = autoInfo.getEntrys().get(i);
            TransDownBillEntryInfo entryInfo = new TransDownBillEntryInfo();
            entryInfo.setSeq(seq++);
            entryInfo.setUnit(autoEntry.getTransDownUnit());
            entryInfo.setUnitAcctBank(autoEntry.getUnitAccount());
            if (autoEntry.getUnitAccount() != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("acctName"));
                sic.add(new SelectorItemInfo("InnerAcct.id"));
                sic.add(new SelectorItemInfo("InnerAcct.name"));
                sic.add(new SelectorItemInfo("InnerAcct.number"));
                sic.add(new SelectorItemInfo("InnerAcct.acctNumber"));
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)autoEntry.getUnitAccount().getId().toString(), CompareType.EQUALS));
                view.setSelector(sic);
                AccountBankCollection accountBankCollection = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
                if (accountBankCollection.size() > 0) {
                    entryInfo.setUnitInnerAcct(accountBankCollection.get(0).getInnerAcct());
                }
            }
            entryInfo.setIsSuccessed(false);
            entryInfo.setDescription(autoInfo.getRemark());
            entryInfo.setPayeeArea(autoEntry.getOpenArea());
            entryInfo.setRecProvince(autoEntry.getProvince());
            entryInfo.setRecCity(autoEntry.getCity());
            entryInfo.setRecBank(autoEntry.getRecBank());
            entryInfo.setProject(autoEntry.getProject());
            entryInfo.setFpItem(autoEntry.getFpItem());
            entryInfo.setOutBgItemId(autoEntry.getOutBgItemId());
            entryInfo.setOutBgItemName(autoEntry.getOutBgItemName());
            entryInfo.setOutBgItemNumber(autoEntry.getOutBgItemNumber());
            entryInfo.setIsDifferPlace(autoEntry.getDifPlace());
            entryInfo.setIsDifBank(autoEntry.getDifBank());
            entryInfo.setAmount(Constants.ZERO);
            if (autoEntry.getRecBank() != null) {
                String bankCode = BEBankFactory.getLocalInstance((Context)ctx).getBankNo(autoEntry.getRecBank());
                entryInfo.setPayeeBankCode(bankCode);
            }
            for (int index = 0; index < list.size(); ++index) {
                TransAmtInfo amtInfo = (TransAmtInfo)list.get(index);
                if (!amtInfo.getUnit().getId().equals((Object)entryInfo.getUnit().getId()) || !amtInfo.getAcctBank().getId().equals((Object)entryInfo.getUnitAcctBank().getId())) continue;
                entryInfo.setAmount(amtInfo.getAmount());
                break;
            }
            if (entryInfo.getAmount().equals(Constants.ZERO)) continue;
            info.getEntrys().add(entryInfo);
        }
        logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"316_TransDownBillHelper") + autoInfo.getEntrys().size() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"315_TransDownBillHelper")));
        BigDecimal sumAmt = Constants.ZERO;
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            sumAmt = sumAmt.add(info.getEntrys().get(i).getAmount());
        }
        info.setTotalAmt(sumAmt);
    }

    public void synBankTransDownBillState(Context ctx, Map idMap) throws EASBizException, BOSException {
        Set idSet = idMap.keySet();
        for (String id : idSet) {
            AutoTransHistoryCollection colls = (AutoTransHistoryCollection)((Object)idMap.get(id));
            Set bankTransSet = FMHelper.getDestBillIdSet((Context)ctx, (String)id);
            if (bankTransSet.size() <= 0) continue;
            List idList = FMHelper.set2List((Set)bankTransSet);
            BankTransDownBillInfo bankInfo = BankTransDownBillFactory.getLocalInstance((Context)ctx).getBankTransDownBillInfo((IObjectPK)new ObjectUuidPK((String)idList.get(0)));
            for (int i = 0; i < colls.size(); ++i) {
                AutoTransHistoryInfo autoInfo = colls.get(i);
                for (int k = 0; k < bankInfo.getEntrys().size(); ++k) {
                    if (!bankInfo.getEntrys().get(k).getSrcBillNumber().equals(autoInfo.getSourceBillId())) continue;
                    autoInfo.setIsSuccess(bankInfo.getEntrys().get(k).getState());
                    autoInfo.setDescription(bankInfo.getEntrys().get(k).getBankReturnInfo());
                    AutoTransHistoryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(autoInfo.getId()), (CoreBaseInfo)autoInfo);
                }
            }
        }
    }

    public Map getPayValidIdMapByAction(Context ctx, Set idSet, int action) throws BOSException, EASBizException {
        TransDownBillCollection coll = TransDownBillHelper.getTransDownBillColl(ctx, idSet);
        Map map = new HashMap();
        switch (action) {
            case 41: {
                map = this.getTransDownValidIdMapByCommitBE(ctx, coll);
            }
        }
        return map;
    }

    private Map getTransDownValidIdMapByCommitBE(Context ctx, TransDownBillCollection coll) throws EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashSet<String> set = new HashSet<String>();
        String errorDetail = "";
        TransDownBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            try {
                if (info.getMotherAcctBank().isIsOnlyRead()) {
                    throw new BEException(BEException.ACCOUNTBANKONLYREAD, new Object[]{info.getMotherAcctBank().getName()});
                }
            }
            catch (Exception e) {
                errorDetail = errorDetail + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"234_TransDownBillControllerBean") + info.getNumber() + "\uff1a" + e.getMessage();
                continue;
            }
            if (!info.getState().equals((Object)TransDownBillStateEnum.AUDITED) || info.getMotherAcctBank() == null || !info.getMotherAcctBank().isIsSetBankInterface() || info.getMotherAcctBank().isIsOnlyRead() || info.isIsCommittoBe()) {
                errorDetail = errorDetail + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"234_TransDownBillControllerBean") + info.getNumber() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"317_TransDownBillHelper");
                continue;
            }
            set.add(info.getId().toString());
            String tmpMsg = "";
            for (int index = 0; index < info.getEntrys().size(); ++index) {
                if (!EmptyUtil.isEmpty((String)info.getEntrys().get(index).getRecProvince()) && !EmptyUtil.isEmpty((String)info.getEntrys().get(index).getRecCity()) && !EmptyUtil.isEmpty((String)info.getEntrys().get(index).getRecBank())) continue;
                String msg = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"181_TransDownBillHelper");
                tmpMsg = tmpMsg + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"318_TransDownBillHelper") + msg;
            }
            if (tmpMsg.length() <= 1) continue;
            errorDetail = errorDetail + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"234_TransDownBillControllerBean") + info.getNumber() + "\uff1a" + tmpMsg + "\n";
        }
        map.put("errorDetail", errorDetail);
        map.put("validSet", set);
        return map;
    }

    @Override
    public Map getTransAcctBankAmt(Set acctBankUnitSet, String currencyId) throws BOSException, EASBizException {
        return null;
    }
}

