/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.MessageUtil;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.OverdraftCtrlEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.subacct.SubAccountInfo;
import com.kingdee.eas.fi.cas.utils.PerfLogRecorder;
import com.kingdee.eas.fm.common.client.SimpleNotePadUI;
import com.kingdee.eas.fm.fs.ApplyTransDownInfo;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.TransAmtInfo;
import com.kingdee.eas.fm.fs.TransDownBillFacadeFactory;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class TransDownBillOverdraftChecker {
    private static Logger logger = Logger.getLogger((String)TransDownBillOverdraftChecker.class.getName());
    private static final String resClassName = "com.kingdee.eas.fm.fs.TransBillResource";
    private StringBuffer msgUserConfirm = new StringBuffer();
    private StringBuffer msgNoPass = new StringBuffer();
    private int result = 1;
    private static final int NOPASS = -1;
    private static final int REMIND = 0;
    private static final int PASS = 1;

    public void checkOverdraft(CoreUIObject ui, TransDownBillInfo info) throws EASBizException, BOSException {
        List transAmtList = TransDownBillFacadeFactory.getRemoteInstance().getOverdraftTransAmtList(info);
        TransAmtInfo transAmtInfo = null;
        int size = transAmtList.size();
        for (int i = 0; i < size; ++i) {
            transAmtInfo = (TransAmtInfo)transAmtList.get(i);
            if (this.result == -1) break;
            this.checkOverdraft(this.buildSubAcctInfo(transAmtInfo), transAmtInfo.getAmount(), transAmtInfo.getBalance(), transAmtInfo.getAcctMgrInfo(), transAmtInfo.getType());
        }
        logger.error((Object)this.getUserConfirmMsg());
        logger.error((Object)this.getNoPassMsg());
        String title = this.getResString("checkOverdraftTitle");
        UIContext ctx = new UIContext((Object)ui);
        ctx.put((Object)"Title", (Object)title);
        if (this.result == -1) {
            MessageUtil.showMessageByModel((UIContext)ctx, (String)this.getNoPassMsg());
            SysUtil.abort();
        } else if (this.result == 0) {
            IUIWindow uiWin = MessageUtil.showMessageByModel((UIContext)ctx, (String)this.getUserConfirmMsg());
            SimpleNotePadUI padUI = (SimpleNotePadUI)uiWin.getUIObject();
            if (padUI.getResult() == 0) {
                return;
            }
            SysUtil.abort();
        }
    }

    public Map checkApplyOverdraft(CoreUIObject ui, ApplyTransDownInfo info) throws EASBizException, BOSException {
        List transAmtList = TransDownBillFacadeFactory.getRemoteInstance().getOverdraftApplyTransAmtList(info);
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean hasPass = true;
        TransAmtInfo transAmtInfo = null;
        int size = transAmtList.size();
        for (int i = 0; i < size; ++i) {
            transAmtInfo = (TransAmtInfo)transAmtList.get(i);
            if (this.result == -1) break;
            this.checkOverdraft(this.buildSubAcctInfo(transAmtInfo), transAmtInfo.getAmount(), transAmtInfo.getBalance(), transAmtInfo.getAcctMgrInfo(), transAmtInfo.getType());
        }
        String title = this.getResString("checkOverdraftTitle");
        UIContext ctx = new UIContext((Object)ui);
        ctx.put((Object)"Title", (Object)title);
        String message = "";
        if (this.result == -1) {
            message = this.getNoPassMsg();
            hasPass = false;
        } else if (this.result == 0) {
            message = this.getUserConfirmMsg();
            hasPass = false;
        }
        map.put("pass", hasPass);
        map.put("message", message);
        return map;
    }

    public int getResult() {
        return this.result;
    }

    public String getUserConfirmMsg() {
        String isContinue = this.getResString("isContinue");
        return this.msgUserConfirm.toString() + isContinue;
    }

    public String getNoPassMsg(Context ctx) {
        String noPass = this.getResString(ctx, "noPass");
        return this.msgNoPass.toString() + noPass;
    }

    public String getNoPassMsg() {
        String noPass = this.getResString("noPass");
        return this.msgNoPass.toString() + noPass;
    }

    private String getResString(Context ctx, String resName) {
        if (ctx != null) {
            return EASCommonResource.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
        }
        return EASResource.getString((String)resClassName, (String)resName);
    }

    private String getResString(String resName) {
        return EASResource.getString((String)resClassName, (String)resName);
    }

    public void checkOverdraft(String acctNumber, BigDecimal amount, BigDecimal balance, AccountMgrStrategyInfo acctMgrInfo, int type) {
        if (acctMgrInfo == null) {
            return;
        }
        OverdraftCtrlEnum ctrlEnum = acctMgrInfo.getOverdraftCtrl();
        switch (ctrlEnum.getValue()) {
            case 1: {
                this.checkNotControl(null, acctNumber, amount, balance, acctMgrInfo, type);
                break;
            }
            case 2: {
                this.checkAllowOverdraft(null, acctNumber, amount, balance, acctMgrInfo, type);
                break;
            }
            case 3: {
                this.checkNotAllowOverdraft(null, acctNumber, amount, balance, acctMgrInfo, type);
                break;
            }
            case 4: {
                this.checkLowestDeposit(null, acctNumber, amount, balance, acctMgrInfo, type);
                break;
            }
            default: {
                logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"182_TransDownBillOverdraftChecker"));
            }
        }
    }

    public void checkOverdraft(Context ctx, String acctNumber, BigDecimal amount, BigDecimal balance, AccountMgrStrategyInfo acctMgrInfo, int type) {
        if (acctMgrInfo == null) {
            return;
        }
        OverdraftCtrlEnum ctrlEnum = acctMgrInfo.getOverdraftCtrl();
        switch (ctrlEnum.getValue()) {
            case 1: {
                this.checkNotControl(ctx, acctNumber, amount, balance, acctMgrInfo, type);
                break;
            }
            case 2: {
                this.checkAllowOverdraft(ctx, acctNumber, amount, balance, acctMgrInfo, type);
                break;
            }
            case 3: {
                this.checkNotAllowOverdraft(ctx, acctNumber, amount, balance, acctMgrInfo, type);
                break;
            }
            case 4: {
                this.checkLowestDeposit(ctx, acctNumber, amount, balance, acctMgrInfo, type);
                break;
            }
            default: {
                logger.error((Object)EASCommonResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"182_TransDownBillOverdraftChecker", (Locale)ctx.getLocale()));
            }
        }
    }

    private BigDecimal getOverdraftAmt(BigDecimal amount, BigDecimal balance) {
        BigDecimal preCalAmt = this.getPreCalAmt(amount, balance);
        BigDecimal overdraftAmt = preCalAmt.min(Constants.ZERO);
        return overdraftAmt.abs();
    }

    private BigDecimal getPreCalAmt(BigDecimal amount, BigDecimal balance) {
        return balance.subtract(amount);
    }

    private void checkNotControl(Context ctx, String acctNumber, BigDecimal amount, BigDecimal balance, AccountMgrStrategyInfo acctMgrInfo, int type) {
        boolean isRemind = acctMgrInfo.isRemind();
        if (!isRemind) {
            return;
        }
        BigDecimal overdraftAmt = this.getOverdraftAmt(amount, balance);
        if (overdraftAmt.signum() > 0) {
            String pattern = "";
            if (type == 1) {
                pattern = this.getResString(ctx, "motherABOverDraft1") + "\n";
            } else if (type == 2) {
                pattern = this.getResString(ctx, "subAcctOverDraft1") + "\n";
            } else if (type == 4) {
                pattern = this.getResString(ctx, "unitInnerAcctOverDraft1") + "\n";
            }
            DecimalFormat fmt = new DecimalFormat();
            ((NumberFormat)fmt).setMaximumFractionDigits(10);
            String balanceStr = fmt.format(balance);
            String overdraftLimitAmtStr = fmt.format(overdraftAmt);
            Object[] arguments = new Object[]{acctNumber, balanceStr, overdraftLimitAmtStr};
            String msg = MessageFormat.format(pattern, arguments);
            this.msgUserConfirm.append(msg);
            this.result = 0;
        }
    }

    private void checkNotControlApply(String acctNumber, BigDecimal amount, BigDecimal balance, AccountMgrStrategyInfo acctMgrInfo, int type) {
        boolean isRemind = acctMgrInfo.isRemind();
        if (!isRemind) {
            return;
        }
        BigDecimal overdraftAmt = this.getOverdraftAmt(amount, balance);
        if (overdraftAmt.signum() > 0) {
            String pattern = "";
            if (type == 1) {
                pattern = this.getResString("motherABOverDraft1") + "\n";
            } else if (type == 2) {
                pattern = this.getResString("subAcctOverDraft1") + "\n";
            } else if (type == 4) {
                pattern = this.getResString("unitInnerAcctOverDraft1") + "\n";
            }
            DecimalFormat fmt = new DecimalFormat();
            ((NumberFormat)fmt).setMaximumFractionDigits(10);
            String balanceStr = fmt.format(balance);
            String overdraftLimitAmtStr = fmt.format(overdraftAmt);
            Object[] arguments = new Object[]{acctNumber, balanceStr, overdraftLimitAmtStr};
            String msg = MessageFormat.format(pattern, arguments);
            this.msgUserConfirm.append(msg);
            this.result = 0;
        }
    }

    private void checkAllowOverdraft(Context ctx, String acctNumber, BigDecimal amount, BigDecimal balance, AccountMgrStrategyInfo acctMgrInfo, int type) {
        BigDecimal overdraftLimitAmt;
        BigDecimal overdraftAmt = this.getOverdraftAmt(amount, balance);
        BigDecimal subtractAmt = overdraftAmt.subtract(overdraftLimitAmt = acctMgrInfo.getOverDraftAmount());
        if (subtractAmt.signum() > 0) {
            String pattern = "";
            if (type == 1) {
                pattern = this.getResString(ctx, "motherABOverDraft2") + "\n";
            } else if (type == 2) {
                pattern = this.getResString(ctx, "subAcctOverDraft2") + "\n";
            } else if (type == 4) {
                pattern = this.getResString(ctx, "unitInnerAcctOverDraft2") + "\n";
            }
            DecimalFormat fmt = new DecimalFormat();
            ((NumberFormat)fmt).setMaximumFractionDigits(10);
            String balanceStr = fmt.format(balance);
            String overdraftLimitAmtStr = fmt.format(overdraftLimitAmt);
            String subtractAmtStr = fmt.format(subtractAmt);
            Object[] arguments = new Object[]{acctNumber, balanceStr, overdraftLimitAmtStr, subtractAmtStr};
            String msg = MessageFormat.format(pattern, arguments);
            this.msgNoPass.append(msg);
            this.result = -1;
        }
    }

    private void checkNotAllowOverdraft(Context ctx, String acctNumber, BigDecimal amount, BigDecimal balance, AccountMgrStrategyInfo acctMgrInfo, int type) {
        BigDecimal overdraftAmt = this.getOverdraftAmt(amount, balance);
        if (overdraftAmt.signum() > 0) {
            String pattern = "";
            if (type == 1) {
                pattern = this.getResString(ctx, "motherABOverDraft3") + "\n";
            } else if (type == 2) {
                pattern = this.getResString(ctx, "subAcctOverDraft3") + "\n";
            } else if (type == 4) {
                pattern = this.getResString(ctx, "unitInnerAcctOverDraft3") + "\n";
            }
            DecimalFormat fmt = new DecimalFormat();
            ((NumberFormat)fmt).setMaximumFractionDigits(10);
            String balanceStr = fmt.format(balance);
            String overdraftLimitAmtStr = fmt.format(overdraftAmt);
            Object[] arguments = new Object[]{acctNumber, balanceStr, overdraftLimitAmtStr};
            String msg = MessageFormat.format(pattern, arguments);
            this.msgNoPass.append(msg);
            this.result = -1;
        }
    }

    private void checkLowestDeposit(Context ctx, String acctNumber, BigDecimal amount, BigDecimal balance, AccountMgrStrategyInfo acctMgrInfo, int type) {
        BigDecimal preCalAmt = this.getPreCalAmt(amount, balance);
        if (preCalAmt.compareTo(acctMgrInfo.getLowestBalance()) < 0) {
            String pattern = "";
            if (type == 1) {
                pattern = this.getResString(ctx, "motherABOverDraft4") + "\n";
            } else if (type == 2) {
                pattern = this.getResString(ctx, "subAcctOverDraft4") + "\n";
            } else if (type == 4) {
                pattern = this.getResString(ctx, "unitInnerAcctOverDraft4") + "\n";
            }
            BigDecimal overLowestAmt = acctMgrInfo.getLowestBalance().subtract(preCalAmt);
            DecimalFormat fmt = new DecimalFormat();
            ((NumberFormat)fmt).setMaximumFractionDigits(10);
            String balanceStr = fmt.format(balance);
            String overLowestAmtStr = fmt.format(overLowestAmt);
            Object[] arguments = new Object[]{acctNumber, balanceStr, overLowestAmtStr};
            String msg = MessageFormat.format(pattern, arguments);
            this.msgNoPass.append(msg);
            this.result = -1;
        }
    }

    public String buildSubAcctInfo(TransAmtInfo transAmtInfo) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"183_TransDownBillOverdraftChecker"));
        strBuf.append(transAmtInfo.getAcctNumber());
        SubAccountInfo subAccountInfo = transAmtInfo.getSubAcct();
        if (null != subAccountInfo) {
            strBuf.append("\uff0c");
            strBuf.append(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"184_TransDownBillOverdraftChecker"));
            strBuf.append(subAccountInfo.getName());
            strBuf.append("\uff0c");
            strBuf.append(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"185_TransDownBillOverdraftChecker"));
            strBuf.append(subAccountInfo.getAccountNumber());
        }
        return strBuf.toString();
    }

    public String buildSubAcctInfo(Context ctx, TransAmtInfo transAmtInfo) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(EASCommonResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"183_TransDownBillOverdraftChecker", (Locale)ctx.getLocale()));
        strBuf.append(transAmtInfo.getAcctNumber());
        SubAccountInfo subAccountInfo = transAmtInfo.getSubAcct();
        if (null != subAccountInfo) {
            strBuf.append("\uff0c");
            strBuf.append(EASCommonResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"184_TransDownBillOverdraftChecker", (Locale)ctx.getLocale()));
            strBuf.append(subAccountInfo.getName());
            strBuf.append("\uff0c");
            strBuf.append(EASCommonResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"185_TransDownBillOverdraftChecker", (Locale)ctx.getLocale()));
            strBuf.append(subAccountInfo.getAccountNumber());
        }
        return strBuf.toString();
    }

    public void batchCheckOverdraft(Context ctx, TransDownBillInfo info) throws EASBizException, BOSException {
        this.result = 1;
        this.msgNoPass = new StringBuffer();
        this.msgUserConfirm = new StringBuffer();
        List transAmtList = new ArrayList();
        if (ctx == null) {
            transAmtList = TransDownBillFacadeFactory.getRemoteInstance().getOverdraftTransAmtList(info);
        } else {
            String getOverdraftTransAmtListLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillOverdraftChecker.batchCheckOverdraft-getOverdraftTransAmtListLogId");
            transAmtList = TransDownBillFacadeFactory.getLocalInstance(ctx).getOverdraftTransAmtList(info);
            PerfLogRecorder.endRecord((String)getOverdraftTransAmtListLogId);
        }
        TransAmtInfo transAmtInfo = null;
        int size = transAmtList.size();
        for (int i = 0; i < size; ++i) {
            transAmtInfo = (TransAmtInfo)transAmtList.get(i);
            String checkOverdraftLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillOverdraftChecker.batchCheckOverdraft-checkOverdraftLogId");
            this.checkOverdraft(ctx, this.buildSubAcctInfo(ctx, transAmtInfo), transAmtInfo.getAmount(), transAmtInfo.getBalance(), transAmtInfo.getAcctMgrInfo(), transAmtInfo.getType());
            PerfLogRecorder.endRecord((String)checkOverdraftLogId);
        }
        logger.error((Object)this.getUserConfirmMsg());
        logger.error((Object)this.getNoPassMsg());
        if (this.result == -1) {
            throw new FSException(FSException.COMMON, new String[]{this.getNoPassMsg(ctx)});
        }
        if (this.result == 0) {
            throw new FSException(FSException.COMMON, new String[]{this.msgUserConfirm.toString()});
        }
    }
}

