/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyFacadeFactory;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.IAccountMgrStrategyFacade;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.subacct.ISubAccount;
import com.kingdee.eas.fi.cas.subacct.SubAccountCollection;
import com.kingdee.eas.fi.cas.subacct.SubAccountFactory;
import com.kingdee.eas.fi.cas.subacct.SubAcctCurrencyBalance;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.IBankFacade;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.AutoTransHistoryCollection;
import com.kingdee.eas.fm.fs.AutoTransHistoryFactory;
import com.kingdee.eas.fm.fs.AutoTransHistoryInfo;
import com.kingdee.eas.fm.fs.AutoTransInfo;
import com.kingdee.eas.fm.fs.TransAmtInfo;
import com.kingdee.eas.fm.fs.TransBillBaseInfo;
import com.kingdee.eas.fm.fs.TransDownBillEntryFactory;
import com.kingdee.eas.fm.fs.TransDownBillEntryInfo;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.fm.fs.TransUpBillEntryFactory;
import com.kingdee.eas.fm.fs.TransUpBillEntryInfo;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class TransUpDownBillHelper {
    private static Logger logger = Logger.getLogger((String)TransUpDownBillHelper.class.getName());
    private Map motherAmtMap = new HashMap();
    private Map motherAmtListMap = new HashMap();
    private Map unitAmtMap = new HashMap();
    protected Map unitAcctBankMap = new HashMap();
    protected static final String resClassName = "com.kingdee.eas.fm.fs.TransBillResource";

    public Map getTransAmtMap(String motherAcctBankId, String currencyId) throws BOSException, EASBizException {
        Map amtMap = new HashMap();
        if (EmptyUtil.isEmpty((String)motherAcctBankId) || EmptyUtil.isEmpty((String)currencyId)) {
            return amtMap;
        }
        String key = motherAcctBankId + "_" + currencyId;
        if (this.motherAmtMap.containsKey(key)) {
            amtMap.putAll((Map)this.motherAmtMap.get(key));
        } else {
            amtMap = this.getTransAcctBankAmt(motherAcctBankId, currencyId);
            this.syncAmtMap(key, amtMap);
        }
        return amtMap;
    }

    public List getTransAmtList(String motherAcctBankId, String currencyId) throws BOSException, EASBizException {
        ArrayList amtList = new ArrayList();
        if (EmptyUtil.isEmpty((String)motherAcctBankId) || EmptyUtil.isEmpty((String)currencyId)) {
            return amtList;
        }
        Map amtMap = new HashMap();
        String key = motherAcctBankId + "_" + currencyId;
        if (this.motherAmtListMap.containsKey(key)) {
            amtList.addAll((List)this.motherAmtListMap.get(key));
        } else {
            amtMap = this.getTransAcctBankAmt(motherAcctBankId, currencyId);
            amtList.addAll(this.getAmtSortedList(amtMap));
            this.syncAmtMap(key, amtMap, amtList);
        }
        return amtList;
    }

    protected List getAmtSortedList(Map amtMap) {
        ArrayList<TransAmtInfo> list = new ArrayList<TransAmtInfo>();
        TransAmtInfo amtInfo = null;
        for (Map.Entry entry : amtMap.entrySet()) {
            amtInfo = (TransAmtInfo)entry.getValue();
            list.add(amtInfo);
        }
        VOComparator c = new VOComparator();
        Collections.sort(list, c);
        return list;
    }

    protected abstract Map getTransAcctBankAmt(String var1, String var2) throws BOSException, EASBizException;

    public abstract Map getTransAcctBankAmt(Set var1, String var2) throws BOSException, EASBizException;

    public TransAmtInfo getTransAmtInfo(String unitAcctBankId, String currencyId) throws EASBizException, BOSException {
        if (EmptyUtil.isEmpty((String)unitAcctBankId) || EmptyUtil.isEmpty((String)currencyId)) {
            return null;
        }
        String key = unitAcctBankId + "_" + currencyId;
        if (this.unitAmtMap.containsKey(key)) {
            return (TransAmtInfo)this.unitAmtMap.get(key);
        }
        TransAmtInfo amtInfo = this.buildDefaultAmtInfo(unitAcctBankId);
        this.unitAmtMap.put(key, amtInfo);
        return amtInfo;
    }

    private TransAmtInfo buildDefaultAmtInfo(String acctBankId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("InnerAcct.*");
        sic.add("company.*");
        sic.add("InnerAcct.clearingHouse.relatedCompany");
        sic.add("bank.*");
        IAccountBank iAcctBank = AccountBankFactory.getRemoteInstance();
        AccountBankInfo info = iAcctBank.getAccountBankInfo((IObjectPK)new ObjectUuidPK(acctBankId), sic);
        TransAmtInfo amtInfo = new TransAmtInfo();
        amtInfo.setAcctBank(info);
        amtInfo.setUnitInnerAcct(info.getInnerAcct());
        amtInfo.setUnit(info.getCompany());
        amtInfo.setAmount(Constants.ZERO);
        return amtInfo;
    }

    private void syncAmtMap(String key, Map amtMap) {
        this.motherAmtMap.put(key, amtMap);
        this.unitAmtMap.putAll(amtMap);
    }

    private void syncAmtMap(String key, Map amtMap, List amtList) {
        this.motherAmtMap.put(key, amtMap);
        this.unitAmtMap.putAll(amtMap);
        this.motherAmtListMap.put(key, amtList);
    }

    protected Set transColl2IdSet(IObjectCollection coll) {
        HashSet<String> idSet = new HashSet<String>();
        IObjectValue info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.getObject(i);
            idSet.add(info.get("id").toString());
        }
        return idSet;
    }

    protected static IAccountBank getAccountBankInterface(Context ctx) throws BOSException {
        IAccountBank iAcctBank = null;
        iAcctBank = ctx == null ? AccountBankFactory.getRemoteInstance() : AccountBankFactory.getLocalInstance((Context)ctx);
        return iAcctBank;
    }

    protected static IAccountMgrStrategyFacade getAcctMgrFacadeInterface(Context ctx) throws BOSException {
        IAccountMgrStrategyFacade iAcctMgrFacade = null;
        iAcctMgrFacade = ctx == null ? AccountMgrStrategyFacadeFactory.getRemoteInstance() : AccountMgrStrategyFacadeFactory.getLocalInstance((Context)ctx);
        return iAcctMgrFacade;
    }

    public static Map getAcctBankBalance(Context ctx, AccountBankCollection acctBankColl, String currencyId, Date date) throws BOSException, EASBizException {
        int i;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        AccountBankCollection acctBankBCColl = new AccountBankCollection();
        AccountBankCollection acctBankBCAvColl = new AccountBankCollection();
        AccountBankCollection acctBankColls = new AccountBankCollection();
        IBankFacade iBankFacade = BankFacadeFactory.getLocalInstance((Context)ctx);
        ArrayList bcAcctIdList = new ArrayList();
        for (int i2 = 0; i2 < acctBankColl.size(); ++i2) {
            String[] idSet;
            boolean isSuccess;
            AccountBankInfo acctBankInfo = acctBankColl.get(i2);
            AccountMgrStrategyInfo acctMgrInfo = acctBankInfo.getCtrlStrategy();
            if (acctMgrInfo != null && acctMgrInfo.isIsFromBCCur()) {
                isSuccess = false;
                idSet = new String[]{acctBankInfo.getId().toString()};
                try {
                    iBankFacade.getBalance(currencyId, idSet, new Date(), new Date());
                    isSuccess = true;
                }
                catch (Exception e) {
                    logger.error((Object)"\u81ea\u52a8\u5212\u62e8\uff0c\u66f4\u65b0\u94f6\u4f01\u4f59\u989d\u62a5\u9519\uff1a", (Throwable)e);
                }
                if (!isSuccess) continue;
                acctBankBCColl.add(acctBankInfo);
                continue;
            }
            if (acctMgrInfo != null && acctMgrInfo.isIsFromBCAv()) {
                isSuccess = false;
                idSet = new String[]{acctBankInfo.getId().toString()};
                try {
                    iBankFacade.getBalance(currencyId, idSet, new Date(), new Date());
                    isSuccess = true;
                }
                catch (Exception e) {
                    logger.error((Object)"\u81ea\u52a8\u5212\u62e8\uff0c\u66f4\u65b0\u94f6\u4f01\u4f59\u989d\u62a5\u9519\uff1a", (Throwable)e);
                }
                if (!isSuccess) continue;
                acctBankBCAvColl.add(acctBankInfo);
                continue;
            }
            acctBankColls.add(acctBankInfo);
        }
        List acctBankBalanceList = TransUpDownBillHelper.getAcctBankBalanceList(ctx, acctBankColls, currencyId, date);
        List acctBankBalanceBCList = TransUpDownBillHelper.getAcctBankBalanceListFromBC(ctx, acctBankBCColl, currencyId, date, "fbalance");
        List acctBankBalanceBCAvList = TransUpDownBillHelper.getAcctBankBalanceListFromBC(ctx, acctBankBCAvColl, currencyId, date, "fvalibalance");
        String key = null;
        SubAcctCurrencyBalance balanceInfo = null;
        int size = acctBankBalanceList.size();
        for (i = 0; i < size; ++i) {
            balanceInfo = (SubAcctCurrencyBalance)acctBankBalanceList.get(i);
            key = balanceInfo.getSubAcctId() + "_" + currencyId;
            map.put(key, balanceInfo.getBalance());
        }
        size = acctBankBalanceBCAvList.size();
        for (i = 0; i < size; ++i) {
            balanceInfo = (SubAcctCurrencyBalance)acctBankBalanceBCAvList.get(i);
            key = balanceInfo.getSubAcctId() + "_" + currencyId;
            map.put(key, balanceInfo.getBalance());
        }
        size = acctBankBalanceBCList.size();
        for (int j = 0; j < size; ++j) {
            balanceInfo = (SubAcctCurrencyBalance)acctBankBalanceBCList.get(j);
            key = balanceInfo.getSubAcctId() + "_" + currencyId;
            map.put(key, balanceInfo.getBalance());
        }
        return map;
    }

    private static List getAcctBankBalanceListFromBC(Context ctx, AccountBankCollection acctBankColl, String currencyId, Date date, String name) throws EASBizException, BOSException {
        ArrayList<SubAcctCurrencyBalance> acctCurrencyList = new ArrayList<SubAcctCurrencyBalance>();
        SubAcctCurrencyBalance info = null;
        int size = acctBankColl.size();
        for (int i = 0; i < size; ++i) {
            info = new SubAcctCurrencyBalance();
            BigDecimal balance = null;
            String acctId = acctBankColl.get(i).getId().toString();
            balance = TransUpDownBillHelper.getAcctBankBalanceFromBC(ctx, acctId, currencyId, date, name);
            info.setSubAcctId(acctId);
            info.setCurrencyId(currencyId);
            info.setBalance(balance);
            acctCurrencyList.add(info);
        }
        return acctCurrencyList;
    }

    private static BigDecimal getAcctBankBalanceFromBC(Context ctx, String acctId, String currencyId, Date date, String name) throws BOSException, EASBizException {
        BigDecimal balance = Constants.ZERO;
        SimpleDateFormat FORMAT_FSDATE = new SimpleDateFormat("yyyy-MM-dd");
        String bizDate = "{ts'" + FORMAT_FSDATE.format(DateUtil.getNextDay((Date)date)) + "'}";
        String sql = "select fbalance,fvalibalance,fbizdate from t_be_AccountBankBalance where faccountbankid=? and fcurrencyid=? and fbizdate >= {ts '" + DateUtil.getSQLBegin((Date)date) + "'} and fbizdate < " + bizDate + "order by fbizdate desc";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{acctId, currencyId});
        try {
            if (rs.next()) {
                balance = rs.getBigDecimal(name);
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return balance;
    }

    public Set getUnitAcctBankIdSet(String motherAcctBankId) throws EASBizException, BOSException {
        if (this.unitAcctBankMap.containsKey(motherAcctBankId)) {
            return (Set)this.unitAcctBankMap.get(motherAcctBankId);
        }
        IAccountBank iacctBank = TransUpDownBillHelper.getAccountBankInterface(null);
        EntityViewInfo view = TransUpDownBillHelper.getEntityViewInfo(motherAcctBankId);
        AccountBankCollection coll = iacctBank.getAccountBankCollection(view);
        Set idSet = this.transColl2IdSet((IObjectCollection)coll);
        this.unitAcctBankMap.put(motherAcctBankId, idSet);
        return idSet;
    }

    private static EntityViewInfo getEntityViewInfo(String montherAcctId) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("subAccount", (Object)montherAcctId, CompareType.EQUALS));
        evi.setFilter(filter);
        SelectorItemCollection sic = TransUpDownBillHelper.getBankAcntSelector();
        evi.setSelector(sic);
        return evi;
    }

    private static SelectorItemCollection getBankAcntSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("ID"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("openDate"));
        sic.add(new SelectorItemInfo("closeDate"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("property.id"));
        sic.add(new SelectorItemInfo("property.name"));
        sic.add(new SelectorItemInfo("isMotherAccount"));
        sic.add(new SelectorItemInfo("isSetBankInterface"));
        sic.add(new SelectorItemInfo("ctrlStrategy.id"));
        sic.add(new SelectorItemInfo("ctrlStrategy.name"));
        sic.add(new SelectorItemInfo("InnerAcct.id"));
        sic.add(new SelectorItemInfo("InnerAcct.name"));
        sic.add(new SelectorItemInfo("InnerAcct.number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("subAccount.id"));
        sic.add(new SelectorItemInfo("subAccount.name"));
        sic.add(new SelectorItemInfo("subAccount.number"));
        return sic;
    }

    private static List getAcctBankBalanceList(Context ctx, AccountBankCollection acctBankColl, String currencyId, Date date) throws EASBizException, BOSException {
        ArrayList<SubAcctCurrencyBalance> acctCurrencyList = new ArrayList<SubAcctCurrencyBalance>();
        SubAcctCurrencyBalance info = null;
        int size = acctBankColl.size();
        for (int i = 0; i < size; ++i) {
            info = new SubAcctCurrencyBalance();
            info.setSubAcctId(acctBankColl.get(i).getId().toString());
            info.setCurrencyId(currencyId);
            acctCurrencyList.add(info);
        }
        IAccountBank iAcctBank = AccountBankFactory.getLocalInstance((Context)ctx);
        return iAcctBank.getInstantBalance(acctCurrencyList, date);
    }

    public static Map getSubAcctBalance(Context ctx, SubAccountCollection subAcctColl, String currencyId, Date date) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        List subAcctBalanceList = TransUpDownBillHelper.getSubAcctBalanceList(ctx, subAcctColl, currencyId, date);
        String key = null;
        SubAcctCurrencyBalance balanceInfo = null;
        int size = subAcctBalanceList.size();
        for (int i = 0; i < size; ++i) {
            balanceInfo = (SubAcctCurrencyBalance)subAcctBalanceList.get(i);
            key = balanceInfo.getSubAcctId();
            map.put(key, balanceInfo.getBalance());
        }
        return map;
    }

    public static Map getUnitInnerAcctBalance(Context ctx, SubAccountCollection subAcctColl, String currencyId, Date date) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        return map;
    }

    private static List getSubAcctBalanceList(Context ctx, SubAccountCollection subAcctColl, String currencyId, Date date) throws EASBizException, BOSException {
        ArrayList<SubAcctCurrencyBalance> acctCurrencyList = new ArrayList<SubAcctCurrencyBalance>();
        SubAcctCurrencyBalance info = null;
        int size = subAcctColl.size();
        for (int i = 0; i < size; ++i) {
            info = new SubAcctCurrencyBalance();
            info.setSubAcctId(subAcctColl.get(i).getId().toString());
            info.setCurrencyId(currencyId);
            acctCurrencyList.add(info);
        }
        ISubAccount iSubBank = SubAccountFactory.getLocalInstance((Context)ctx);
        return iSubBank.getInstantBalance(acctCurrencyList, date);
    }

    public static Date getBookDate(Context ctx, Date bizDate, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currPeriodInfo == null) {
            return bizDate;
        }
        Date bookDate = bizDate;
        if (bookDate.before(currPeriodInfo.getBeginDate())) {
            bookDate = currPeriodInfo.getBeginDate();
        }
        return bookDate;
    }

    public static Date getBookDate(Context ctx, Date bizDate, CompanyOrgUnitInfo companyInfo, int cs104) throws BOSException, EASBizException {
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currPeriodInfo == null) {
            return bizDate;
        }
        Date bookDate = bizDate;
        if (cs104 == 1) {
            bookDate = new Date();
        }
        if (bookDate.before(currPeriodInfo.getBeginDate())) {
            bookDate = currPeriodInfo.getBeginDate();
        }
        return bookDate;
    }

    public static Date getBookDate(Context ctx, Date bizDate, CompanyOrgUnitInfo companyInfo, int cs104, TransBillBaseInfo info) throws BOSException, EASBizException {
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currPeriodInfo == null) {
            return bizDate;
        }
        boolean iscommitbe = info.isIsCommittoBe();
        Date bookDate = bizDate;
        if (cs104 == 1) {
            bookDate = new Date();
        } else if (cs104 == 2 && iscommitbe) {
            TransDownBillInfo transDownBillInfo;
            String bosType = BOSUuid.read((String)info.getId().toString()).getType().toString();
            if (new TransUpBillInfo().getBOSType().toString().equals(bosType)) {
                TransUpBillInfo transUpBillInfo = (TransUpBillInfo)info;
                if (transUpBillInfo.getCommitBeTime() != null) {
                    bookDate = transUpBillInfo.getCommitBeTime();
                }
            } else if (new TransDownBillInfo().getBOSType().toString().equals(bosType) && (transDownBillInfo = (TransDownBillInfo)info).getCommitBeTime() != null) {
                bookDate = transDownBillInfo.getCommitBeTime();
            }
        }
        if (bookDate.before(currPeriodInfo.getBeginDate())) {
            bookDate = currPeriodInfo.getBeginDate();
        }
        return bookDate;
    }

    public static boolean checkIsAutoRun(Context ctx, String id) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("autoTrans.id", (Object)id));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)DateTimeUtils.truncateDate((Date)new Date()), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)DateUtil.getAfterDay((Date)DateTimeUtils.truncateDate((Date)new Date())), CompareType.LESS));
        AutoTransHistoryCollection colls = AutoTransHistoryFactory.getLocalInstance(ctx).getAutoTransHistoryCollection(view);
        return colls.size() > 0;
    }

    public static void addErrorTransLog(Context ctx, AutoTransInfo autoInfo, String errMessage) throws EASBizException, BOSException {
        String billStr = "";
        billStr = autoInfo.isIsTransDown() ? EASResource.getString((String)resClassName, (String)"transDown") : EASResource.getString((String)resClassName, (String)"transUp");
        logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"333_TransUpDownBillHelper") + billStr + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"334_TransUpDownBillHelper") + billStr + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"335_TransUpDownBillHelper")));
        AutoTransHistoryInfo hisInfo = new AutoTransHistoryInfo();
        hisInfo.setBizDate(new Date());
        hisInfo.setAutoTrans(autoInfo);
        hisInfo.setDescription(errMessage);
        AutoTransHistoryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)hisInfo);
        String bizDate = DateUtil.getSQLBegin((Date)new Date()).toString();
        String msgTitle = bizDate.substring(0, 4) + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"336_TransUpDownBillHelper") + bizDate.substring(5, 7) + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"337_TransUpDownBillHelper") + bizDate.substring(8, 10) + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"338_TransUpDownBillHelper") + new Date().getHours() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"339_TransUpDownBillHelper") + autoInfo.getParentAcct().getName() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"340_TransUpDownBillHelper") + billStr + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"341_TransUpDownBillHelper");
        String msgSender = autoInfo.getCreator().getName();
        StringBuffer msgBody = new StringBuffer();
        msgBody.append(bizDate.substring(0, 4) + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"336_TransUpDownBillHelper") + bizDate.substring(5, 7) + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"337_TransUpDownBillHelper") + bizDate.substring(8, 10) + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"338_TransUpDownBillHelper") + new Date().getHours() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"339_TransUpDownBillHelper") + autoInfo.getParentAcct().getName() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"340_TransUpDownBillHelper") + billStr + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"342_TransUpDownBillHelper"));
        msgBody.append(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"343_TransUpDownBillHelper") + errMessage);
        logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"344_TransUpDownBillHelper") + billStr + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"345_TransUpDownBillHelper") + msgBody.toString() + "-------"));
        TransUpDownBillHelper.sendByMessage(ctx, msgTitle, msgSender, msgBody.toString(), autoInfo.getCreator().getId().toString());
        logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"344_TransUpDownBillHelper") + billStr + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"346_TransUpDownBillHelper")));
    }

    public static void sendTransBillMessage(Context ctx, boolean isTransDown, AutoTransHistoryCollection hisColl, boolean isCommitBe, boolean BeSuccess) throws BOSException, EASBizException {
        logger.info((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"347_TransUpDownBillHelper"));
        String bizDate = DateUtil.getSQLBegin((Date)new Date()).toString();
        String msgSender = hisColl.get(0).getCreator().getName();
        StringBuffer msgBody = new StringBuffer();
        String company = "";
        String number = "";
        String creator = "";
        String billStr = "";
        if (isTransDown) {
            billStr = EASResource.getString((String)resClassName, (String)"transDown");
            company = hisColl.get(0).getTransDownBill().getCompany().getName();
            number = hisColl.get(0).getTransDownBill().getNumber();
            creator = hisColl.get(0).getTransDownBill().getCreator().getId().toString();
        } else {
            billStr = EASResource.getString((String)resClassName, (String)"transUp");
            company = hisColl.get(0).getTransUpBill().getCompany().getName();
            number = hisColl.get(0).getTransUpBill().getNumber();
            creator = hisColl.get(0).getTransUpBill().getCreator().getId().toString();
        }
        String msgTitle = bizDate.substring(0, 4) + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"336_TransUpDownBillHelper") + bizDate.substring(5, 7) + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"337_TransUpDownBillHelper") + bizDate.substring(8, 10) + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"338_TransUpDownBillHelper") + new Date().getHours() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"339_TransUpDownBillHelper") + hisColl.get(0).getMotherAcct().getName() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"340_TransUpDownBillHelper") + billStr + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"341_TransUpDownBillHelper");
        if (isCommitBe) {
            if (BeSuccess) {
                msgBody.append(company + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"348_TransUpDownBillHelper") + hisColl.get(0).getMotherAcct().getName() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"349_TransUpDownBillHelper") + billStr + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"350_TransUpDownBillHelper") + number + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"351_TransUpDownBillHelper"));
                for (int i = 0; i < hisColl.size(); ++i) {
                    String acctName = hisColl.get(i).getUnitAccount().getName();
                    hisColl.get(i).getSourceBillId();
                    msgBody.append(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"352_TransUpDownBillHelper") + acctName + ":" + hisColl.get(i).getIsSuccess().getAlias());
                    if (hisColl.get(i).getIsSuccess().equals((Object)BankPayingBillStateEnum.TS) || FMHelper.isEmpty((String)hisColl.get(i).getDescription())) continue;
                    msgBody.append(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"353_TransUpDownBillHelper") + hisColl.get(i).getDescription());
                }
            } else {
                msgBody.append(company + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"348_TransUpDownBillHelper") + hisColl.get(0).getMotherAcct().getName() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"349_TransUpDownBillHelper") + billStr + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"350_TransUpDownBillHelper") + number + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"354_TransUpDownBillHelper"));
                for (int i = 0; i < hisColl.size(); ++i) {
                    String acctName = hisColl.get(i).getUnitAccount().getName();
                    String errMessage = hisColl.get(i).getDescription();
                    msgBody.append(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"352_TransUpDownBillHelper") + acctName + ":" + errMessage);
                }
            }
        } else {
            msgBody.append(company + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"348_TransUpDownBillHelper") + hisColl.get(0).getMotherAcct().getName() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"349_TransUpDownBillHelper") + billStr + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"350_TransUpDownBillHelper") + number);
        }
        logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"344_TransUpDownBillHelper") + billStr + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"345_TransUpDownBillHelper") + msgBody.toString() + "-------"));
        TransUpDownBillHelper.sendByMessage(ctx, msgTitle, msgSender, msgBody.toString(), creator);
        logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"344_TransUpDownBillHelper") + billStr + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"346_TransUpDownBillHelper")));
    }

    private static void sendByMessage(Context ctx, String msgTitle, String msgSender, String msgBody, String msgReceiver) {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = TransUpDownBillHelper.getContextLocales(ctx);
        Locale locale2 = null;
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        for (Locale locale2 : lcla) {
            message.setLocaleStringHeader("title", msgTitle, locale2);
            message.setLocaleStringHeader("sender", msgSender, locale2);
            message.setLocaleStringHeader("body", msgBody, locale2);
        }
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 50);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("receiver", msgReceiver);
        senderAgent.sendMessage(message);
    }

    private static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    public static String changeTransBillId(String id) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("parent.id"));
        if (!EmptyUtil.isEmpty((String)id)) {
            if (BOSUuid.read((String)id).getType().equals((Object)new TransUpBillEntryInfo().getBOSType())) {
                TransUpBillEntryInfo info = TransUpBillEntryFactory.getRemoteInstance().getTransUpBillEntryInfo((IObjectPK)new ObjectUuidPK(id), sic);
                id = info.getParent().getId().toString();
            } else if (BOSUuid.read((String)id).getType().equals((Object)new TransDownBillEntryInfo().getBOSType())) {
                TransDownBillEntryInfo info = TransDownBillEntryFactory.getRemoteInstance().getTransDownBillEntryInfo((IObjectPK)new ObjectUuidPK(id), sic);
                id = info.getParent().getId().toString();
            }
        }
        return id;
    }

    private class VOComparator
    implements Comparator {
        private VOComparator() {
        }

        public int compare(Object o1, Object o2) {
            TransAmtInfo info1 = (TransAmtInfo)o1;
            TransAmtInfo info2 = (TransAmtInfo)o2;
            int result = info1.getUnit().getNumber().compareTo(info2.getUnit().getNumber());
            if (result == 0) {
                result = info1.getAcctBank().getNumber().compareTo(info2.getAcctBank().getNumber());
            }
            return result;
        }
    }
}

