/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.ISettleFacade;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettBizTypeInfo;
import com.kingdee.eas.fm.fs.SettleFacadeFactory;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.client.AbstractAcceptBatchUI;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SettlementBillHandler;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public class AcceptBatchUI
extends AbstractAcceptBatchUI {
    private static final String ID_SET = "idSet";
    private SettlementBillCollection coll = null;
    private SettlementBillHandler handler = SettlementBillHandler.create();
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
    private boolean isPayee = false;
    SettBizTypeInfo bizType = null;
    CurrencyInfo currency = null;
    BigDecimal amount = null;

    public void onLoad() throws Exception {
        CurrencyUtil.fillCombCurrency(this.cboCurrency);
        super.onLoad();
        Set idSet = (Set)this.getUIContext().get(ID_SET);
        this.coll = this.getColl(idSet);
        this.amount = Constants.ZERO;
        for (int i = 0; i < this.coll.size(); ++i) {
            SettlementBillInfo info = this.coll.get(i);
            FMVerifyHelper.checkBlank(null, (IObjectValue)info, (String)"bizType");
            FMVerifyHelper.checkBlank(null, (IObjectValue)info, (String)"currency");
            if (this.bizType != null && !this.bizType.getId().equals((Object)info.getBizType().getId())) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"71_AcceptBatchUI"));
                SysUtil.abort();
            }
            if (this.currency != null && !this.currency.getId().equals((Object)info.getCurrency().getId())) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"72_AcceptBatchUI"));
                SysUtil.abort();
            }
            if (info.getAcceptor() != null) {
                String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"355_AcceptBatchUI"), info.getNumber());
                MsgBox.showError((Component)((Object)this), (String)msgStr);
                SysUtil.abort();
            }
            this.bizType = info.getBizType();
            this.currency = info.getCurrency();
            this.amount = FMHelper.add((BigDecimal)this.amount, (BigDecimal)info.getAmount());
        }
        this.isPayee = this.bizType.isPayee();
        this.bizType.setDisplayFormat("$name$");
        this.f7BizType.setData((Object)this.bizType);
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.currency);
        this.f7InnerAccount.setValue(null);
        this.lblCHBankAccountName.setText(null);
        this.initUIProp();
    }

    public void onShow() throws Exception {
        super.onShow();
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.f7InnerAccount});
    }

    private String getResString(boolean isPayee) {
        String resName = null;
        resName = isPayee ? "Rec" : "Pay";
        String resClassName = "com.kingdee.eas.fm.fs.SettlementBillUI";
        String resString = EASResource.getString((String)resClassName, (String)"WriteCHBankAcctAndSettle");
        return MessageFormat.format(resString, EASResource.getString((String)resClassName, (String)resName));
    }

    private void initUIProp() throws EASBizException, BOSException {
        String iconName = null;
        iconName = this.isPayee ? "imgTbtn_gathering" : "imgTbtn_payment";
        this.btnSubmit.setIcon(EASResource.getIcon((String)iconName));
        this.btnSubmit.getActionMap();
        this.txtAmount.setPrecision(FMClientHelper.getPrecOfCurrency((BOSUuid)this.currency.getId()));
        this.txtAmount.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtAmount.setSelectAllOnFocus(true);
        this.txtAmount.setHorizontalAlignment(4);
        this.txtAmount.setRemoveingZeroInDispaly(false);
        this.initKeyStroke();
    }

    protected void initKeyStroke() {
        InputMap ip = this.btnSubmit.getInputMap(2);
        ActionMap am = this.btnSubmit.getActionMap();
        KeyStroke ks2 = KeyStroke.getKeyStroke("ctrl S");
        ip.put(ks2, "ActionSave2");
        am.put("ActionSave2", new ActionSubmit());
    }

    public void setInnerAcctF7(KDBizPromptBox f7BankAcct) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("applyUnit.*"));
        f7BankAcct.setSelectorCollection(sic);
        BankInfo clearingHouse = FSClientHelper.getClearingHouse();
        String chId = clearingHouse.getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("clearingHouse.id", (Object)chId));
        StringBuffer sql = new StringBuffer();
        sql.append(" select a.FInnerAcctId from t_bd_accountbanks a  ").append(" join t_bd_bank b on a.FBank=b.fid ").append(" where b.FIsInGroup =0 and a.FInnerAcctId is not null ");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.NOTINNER));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        f7BankAcct.setEntityViewInfo(evi);
        f7BankAcct.getQueryAgent().resetRuntimeEntityView();
    }

    private SettlementBillCollection getColl(Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("currency.*"));
        evi.getSelector().add(new SelectorItemInfo("settleType.*"));
        evi.getSelector().add(new SelectorItemInfo("bizType.*"));
        evi.getSelector().add(new SelectorItemInfo("payeeBankAcct.*"));
        evi.getSelector().add(new SelectorItemInfo("payerBankAcct.*"));
        evi.getSelector().add(new SelectorItemInfo("payeeAcct.*"));
        evi.getSelector().add(new SelectorItemInfo("payerAcct.*"));
        ISettlementBill iSettle = SettlementBillFactory.getRemoteInstance();
        return iSettle.getSettlementBillCollection(evi);
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        this.coll = this.buildSettleColl();
        ISettleFacade facade = SettleFacadeFactory.getRemoteInstance();
        facade.batchAccept(this.coll);
        MsgBox.showInfo((Component)((Object)this), (String)this.getSuccessString(e));
        this.disposeUIWindow();
    }

    private String getSuccessString(ActionEvent e) {
        Component component = (Component)e.getSource();
        if (!(component instanceof KDWorkButton)) {
            return null;
        }
        String text = ((KDWorkButton)component).getText();
        if (FMHelper.isEmpty((String)text)) {
            text = ((KDWorkButton)component).getToolTipText();
        }
        return text + EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"SUCCESS");
    }

    public SettlementBillCollection getResultColl() {
        return this.coll;
    }

    private void verify() throws EASBizException {
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        BigDecimal settAmount = this.txtAmount.getBigDecimalValue();
        String numberFmt = FMClientHelper.getNumberFtm((BOSUuid)this.currency.getId());
        DecimalFormat df = new DecimalFormat(numberFmt);
        String formatedValue = df.format(this.amount);
        if (!EqualsUtil.equals((Object)this.amount, (Object)settAmount)) {
            String error = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"74_AcceptBatchUI"), formatedValue);
            MsgBox.showError((Component)((Object)this), (String)error);
            this.abort();
        }
    }

    private SettlementBillCollection buildSettleColl() {
        SettlementBillInfo info = null;
        int count = this.coll.size();
        for (int i = 0; i < count; ++i) {
            InnerAccountInfo data;
            info = this.coll.get(i);
            if (info.getType() == SettBizTypeEnum.PAYINSIDE) {
                info.setPayerInnerAcct(null);
                data = (InnerAccountInfo)this.f7InnerAccount.getData();
                info.setPayeeInnerAcct(data);
            } else if (info.getType() == SettBizTypeEnum.RECINSIDE) {
                info.setPayerBankAcct(null);
                data = (InnerAccountInfo)this.f7InnerAccount.getData();
                info.setPayerInnerAcct(data);
            }
            this.coll.add(info);
        }
        return this.coll;
    }

    public static IUIWindow showDialogWindows(IUIObject ui, Set idSet) throws UIException {
        if (idSet == null || idSet.isEmpty()) {
            return null;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)ID_SET, (Object)idSet);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AcceptBatchUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        return uiWindow;
    }

    @Override
    protected void f7InnerAccount_dataChanged(DataChangeEvent e) throws Exception {
        super.f7InnerAccount_dataChanged(e);
        InnerAccountInfo accbank = (InnerAccountInfo)this.f7InnerAccount.getData();
        if (accbank != null) {
            this.lblCHBankAccountName.setText(accbank.getAcctNumber());
        } else {
            this.lblCHBankAccountName.setText(null);
        }
    }

    @Override
    protected void f7InnerAccount_willCommit(CommitEvent e) throws Exception {
        super.f7InnerAccount_willCommit(e);
        this.setInnerAcctF7(this.f7InnerAccount);
    }

    @Override
    protected void f7InnerAccount_willShow(SelectorEvent e) throws Exception {
        super.f7InnerAccount_willShow(e);
        this.setInnerAcctF7(this.f7InnerAccount);
    }

    private final class ActionSubmit
    extends AbstractAction {
        private ActionSubmit() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                AcceptBatchUI.this.btnSubmit_actionPerformed(e);
            }
            catch (Exception e1) {
                SysUtil.abort((Throwable)e1);
            }
        }
    }
}

