/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.SourceTypeEnum;
import com.kingdee.eas.fm.fs.TransDownBillFacadeFactory;
import com.kingdee.eas.fm.fs.TransDownBillFactory;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.fm.fs.TransDownBillStateEnum;
import com.kingdee.eas.fm.fs.TransUpBillFacadeFactory;
import com.kingdee.eas.fm.fs.client.AbstractApplyTransBillRejectedUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ApplyTransBillRejectedUI
extends AbstractApplyTransBillRejectedUI {
    private static final Logger logger = CoreUIObject.getLogger(ApplyTransBillRejectedUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void CoreUI_keyReleased(KeyEvent e) throws Exception {
        super.CoreUI_keyReleased(e);
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.checkConfirm();
        SourceTypeEnum sourceType = (SourceTypeEnum)((Object)this.getUIContext().get("sourceType"));
        String errorDetail = "";
        Set ids = new HashSet();
        IObjectPK pk = null;
        if (SourceTypeEnum.APPTRANSUP.equals((Object)sourceType)) {
            pk = (IObjectPK)this.getUIContext().get("TransBillID");
        } else {
            ids = (Set)this.getUIContext().get("TransBillIds");
        }
        int total = ids.size();
        Map<String, String> resultMsg = this.checkRejected(ids);
        for (String string : resultMsg.keySet()) {
            if (!ids.contains(string)) continue;
            errorDetail = errorDetail + resultMsg.get(string);
            ids.remove(string);
        }
        if (ids.size() > 0 || null != pk) {
            if (SourceTypeEnum.APPTRANSUP.equals((Object)sourceType)) {
                ArrayList idsList = new ArrayList(ids);
                TransUpBillFacadeFactory.getRemoteInstance().rejectedApplyTransUp(pk, this.txtRejectRemark.getText());
            } else {
                Map errorMap = TransDownBillFacadeFactory.getRemoteInstance().batchRejectedApplyTransDown(ids, this.txtRejectRemark.getText());
                for (String id : errorMap.keySet()) {
                    if (!ids.contains(id)) continue;
                    errorDetail = errorDetail + resultMsg.get(id);
                    ids.remove(id);
                }
            }
        }
        this.disposeUIWindow();
        if (errorDetail.length() > 1) {
            String error = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"419_Message", (Object[])new Object[]{ids.size(), total - ids.size()});
            Component component = (Component)e.getSource();
            MsgBox.showDetailAndOK((Component)component, (String)error, (String)errorDetail, (int)1);
        } else {
            Component component = (Component)e.getSource();
            FMClientHelper.showSuccessMessageBox((CoreUI)this, (Component)component);
        }
        SysUtil.abort();
    }

    private Map<String, String> checkRejected(Set ids) throws EASBizException, BOSException {
        HashMap<String, String> resultMsg = new HashMap<String, String>();
        ArrayList idsList = new ArrayList(ids);
        for (String id : idsList) {
            TransDownBillInfo info = TransDownBillFactory.getRemoteInstance().getTransDownBillInfo((IObjectPK)new ObjectUuidPK(id));
            if (!TransDownBillStateEnum.SAVED.equals((Object)info.getState()) && !TransDownBillStateEnum.SUBMITED.equals((Object)info.getState())) {
                resultMsg.put(id, EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"418_billNumber") + info.getNumber() + ": " + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"286_TransDownBillListUI") + "\n");
                continue;
            }
            if (SourceTypeEnum.APPTRANSDOWN.equals((Object)info.getSourceType())) continue;
            resultMsg.put(id, EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"418_billNumber") + info.getNumber() + ": " + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"286_TransDownBillListUI") + "\n");
        }
        return resultMsg;
    }

    private void checkConfirm() {
        if (FMHelper.isEmpty((String)this.txtRejectRemark.getText())) {
            MsgBox.showWarning((Component)((Object)this), (String)ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"262_ApplyTransBillRejectedUI", (Locale)SysContext.getSysContext().getLocale()));
            SysUtil.abort();
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.disposeUIWindow();
    }

    private boolean getSuccessFlag() {
        return false;
    }

    public static void show(CoreUIObject ui, IObjectPK pk, SourceTypeEnum sourceType) throws EASBizException, UIException {
        if (pk == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"TransBillID", (Object)pk);
        uiContext.put((Object)"sourceType", (Object)sourceType);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ApplyTransBillRejectedUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        boolean flag = ((ApplyTransBillRejectedUI)uiWindow.getUIObject()).getSuccessFlag();
        if (flag) {
            uiWindow.close();
        }
    }

    public static void show(CoreUIObject ui, Set ids, SourceTypeEnum sourceType) throws EASBizException, UIException {
        if (ids == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"TransBillIds", (Object)ids);
        uiContext.put((Object)"sourceType", (Object)sourceType);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ApplyTransBillRejectedUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        boolean flag = ((ApplyTransBillRejectedUI)uiWindow.getUIObject()).getSuccessFlag();
        if (flag) {
            uiWindow.close();
        }
    }
}

